/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import proguard.io.DataEntry;
import proguard.io.DataEntryFilter;
import proguard.io.DataEntryWriter;

public class FilteredDataEntryWriter
implements DataEntryWriter {
    private final DataEntryFilter dataEntryFilter;
    private DataEntryWriter acceptedDataEntryWriter;
    private DataEntryWriter rejectedDataEntryWriter;

    public FilteredDataEntryWriter(DataEntryFilter dataEntryFilter, DataEntryWriter dataEntryWriter) {
        this(dataEntryFilter, dataEntryWriter, null);
    }

    public FilteredDataEntryWriter(DataEntryFilter dataEntryFilter, DataEntryWriter dataEntryWriter, DataEntryWriter dataEntryWriter2) {
        this.dataEntryFilter = dataEntryFilter;
        this.acceptedDataEntryWriter = dataEntryWriter;
        this.rejectedDataEntryWriter = dataEntryWriter2;
    }

    @Override
    public boolean createDirectory(DataEntry dataEntry) throws IOException {
        DataEntryWriter dataEntryWriter = this.dataEntryFilter.accepts(dataEntry) ? this.acceptedDataEntryWriter : this.rejectedDataEntryWriter;
        return dataEntryWriter != null && dataEntryWriter.createDirectory(dataEntry);
    }

    @Override
    public boolean sameOutputStream(DataEntry dataEntry, DataEntry dataEntry2) throws IOException {
        boolean bl = this.dataEntryFilter.accepts(dataEntry);
        boolean bl2 = this.dataEntryFilter.accepts(dataEntry2);
        return bl ? !bl2 || this.acceptedDataEntryWriter == null || this.acceptedDataEntryWriter.sameOutputStream(dataEntry, dataEntry2) : bl2 || this.rejectedDataEntryWriter == null || this.rejectedDataEntryWriter.sameOutputStream(dataEntry, dataEntry2);
    }

    @Override
    public OutputStream createOutputStream(DataEntry dataEntry) throws IOException {
        DataEntryWriter dataEntryWriter = this.dataEntryFilter.accepts(dataEntry) ? this.acceptedDataEntryWriter : this.rejectedDataEntryWriter;
        return dataEntryWriter != null ? dataEntryWriter.createOutputStream(dataEntry) : null;
    }

    @Override
    public void close() throws IOException {
        if (this.acceptedDataEntryWriter != null) {
            this.acceptedDataEntryWriter.close();
            this.acceptedDataEntryWriter = null;
        }
        if (this.rejectedDataEntryWriter != null) {
            this.rejectedDataEntryWriter.close();
            this.rejectedDataEntryWriter = null;
        }
    }

    @Override
    public void println(PrintWriter printWriter, String string) {
        printWriter.println(string + "FilteredDataEntryWriter (filter = " + this.dataEntryFilter + ")");
        if (this.acceptedDataEntryWriter != null) {
            this.acceptedDataEntryWriter.println(printWriter, string + "  ");
        }
        if (this.rejectedDataEntryWriter != null) {
            this.rejectedDataEntryWriter.println(printWriter, string + "  ");
        }
    }
}

