/*
 *  Jajuk
 *  Copyright (C) 2003-2011 The Jajuk Team
 *  http://jajuk.info
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *  $Revision$
 */
package org.jajuk.util;

import org.jajuk.JajukTestCase;
import org.junit.Test;

/**
 * DOCUMENT_ME.
 */
public class TestUtilString extends JajukTestCase {

  /*
   * (non-Javadoc)
   *
   * @see junit.framework.TestCase#setUp()
   */
  @Override
  protected void setUp() throws Exception {
    super.setUp();
  }

  /**
   * Test method for {@link org.jajuk.util.UtilString#applyPattern(org.jajuk.base.File, java.lang.String, boolean, boolean)}.
   */
  @Test
  public void testApplyPattern() {
    //TODO to be implemented
  }

  /**
   * Test method for {@link org.jajuk.util.UtilString#containsNonDigitOrLetters(java.lang.String)}.
   */
  @Test
  public void testContainsNonDigitOrLetters() {
    //TODO to be implemented
  }

  /**
   * Test method for {@link org.jajuk.util.UtilString#encodeURL(java.lang.String)}.
   */
  @Test
  public void testEncodeURL() {
    //TODO to be implemented
  }

  /**
   * Test method for {@link org.jajuk.util.UtilString#escapeString(java.lang.String)}.
   */
  @Test
  public void testEscapeString() {
    //TODO to be implemented
  }

  /**
   * Test method for {@link org.jajuk.util.UtilString#format(java.lang.Object, org.jajuk.base.PropertyMetaInformation, boolean)}.
   */
  @Test
  public void testFormat() {
    //TODO to be implemented
  }

  /**
   * Test method for {@link org.jajuk.util.UtilString#getLocaleDateFormatter()}.
   */
  @Test
  public void testGetLocaleDateFormatter() {
    //TODO to be implemented
  }

  /**
   * Test method for {@link org.jajuk.util.UtilString#formatPropertyDesc(java.lang.String)}.
   */
  @Test
  public void testFormatPropertyDesc() {
    //TODO to be implemented
  }

  /**
   * Test method for {@link org.jajuk.util.UtilString#formatGenre(java.lang.String)}.
   */
  @Test
  public void testFormatGenre() {
    //TODO to be implemented
  }

  /**
   * Test method for {@link org.jajuk.util.UtilString#formatTag(java.lang.String)}.
   */
  @Test
  public void testFormatTag() {
    //TODO to be implemented
  }

  /**
   * Test method for {@link org.jajuk.util.UtilString#formatTimeBySec(long)}.
   */
  @Test
  public void testFormatTimeBySec() {
    //TODO to be implemented
  }

  /**
   * Test method for {@link org.jajuk.util.UtilString#formatXML(java.lang.String)}.
   */
  @Test
  public void testFormatXML() {
    //TODO to be implemented
  }

  /**
   * Test method for {@link org.jajuk.util.UtilString#getAdditionDateFormatter()}.
   */
  @Test
  public void testGetAdditionDateFormatter() {
    //TODO to be implemented
  }

  /**
   * Test method for {@link org.jajuk.util.UtilString#getAnonymizedJajukProperties()}.
   */
  @Test
  public void testGetAnonymizedJajukProperties() {
    //TODO to be implemented
  }

  /**
   * Test method for {@link org.jajuk.util.UtilString#getAnonymizedSystemProperties()}.
   */
  @Test
  public void testGetAnonymizedSystemProperties() {
    //TODO to be implemented
  }

  /**
   * Test method for {@link org.jajuk.util.UtilString#getLimitedString(java.lang.String, int)}.
   */
  @Test
  public void testGetLimitedString() {
    //TODO to be implemented
  }

  /**
   * Test method for {@link org.jajuk.util.UtilString#isChar(int)}.
   */
  @Test
  public void testIsChar() {
    //TODO to be implemented
  }

  /**
   * Test method for {@link org.jajuk.util.UtilString#isXMLValid(java.lang.String)}.
   */
  @Test
  public void testIsXMLValid() {
    //TODO to be implemented
  }

  /**
   * Test method for {@link org.jajuk.util.UtilString#padNumber(long, int)}.
   */
  @Test
  public void testPadNumber() {
    //TODO to be implemented
  }

  /**
   * Test method for {@link org.jajuk.util.UtilString#parse(java.lang.String, java.lang.Class)}.
   */
  @Test
  public void testParse() {
    //TODO to be implemented
  }

  /**
   * Test method for {@link org.jajuk.util.UtilString#fastLongParser(java.lang.String)}.
   */
  @Test
  public void testFastLongParser() {
    //TODO to be implemented
  }

  /**
   * Test method for {@link org.jajuk.util.UtilString#fastBooleanParser(java.lang.String)}.
   */
  @Test
  public void testFastBooleanParser() {
    //TODO to be implemented
  }

  /**
   * Test method for {@link org.jajuk.util.UtilString#rot13(java.lang.String)}.
   */
  @Test
  public void testRot13() {
    //TODO to be implemented
  }

  /**
   * Test method for {@link org.jajuk.util.UtilString#matchesIgnoreCaseAndOrder(java.lang.String, java.lang.String)}.
   */
  @Test
  public void testMatchesIgnoreCaseAndOrder() {
    //TODO to be implemented
  }

  /**
   * Test method for {@link org.jajuk.util.UtilString#encodeToUnicode(java.lang.String)}.
   */
  @Test
  public void testEncodeToUnicode() {
    //TODO to be implemented
  }

  /**
   * Test method for {@link org.jajuk.util.UtilString#byteToHex(byte)}.
   */
  @Test
  public void testByteToHex() {
    //TODO to be implemented
  }

  /**
   * Test method for {@link org.jajuk.util.UtilString#concat(java.lang.Object[])}.
   */
  @Test
  public void testConcat() {
    //TODO to be implemented
  }

  /**
   * Test method for {@link org.jajuk.util.UtilString#getTextBetweenChars(java.lang.String, char, char)}.
   */
  @Test
  public void testGetTextBetweenChars() {
    //TODO to be implemented
  }

  /**
   * Test method for {@link org.jajuk.util.UtilString#normalizeFilename(java.lang.String)}.
   */
  @Test
  public void testNormalizeFilename() {
    // Regular string check 
    String fileName = "foo.txt";
    String normFileName = UtilString.normalizeFilename(fileName);
    assertTrue("foo.txt".equals(normFileName));

    // Contains a Windows forbidden chars : ?
    fileName = "?-e.txt";
    normFileName = UtilString.normalizeFilename(fileName);
    assertTrue("_-e.txt".equals(normFileName));

    // Contains an accent
    fileName = '\u00E0' + "" + '\u00E9' + "!?-e.txt";
    normFileName = UtilString.normalizeFilename(fileName);
    assertTrue("ae!_-e.txt".equals(normFileName));
  }

}
