from __future__ import absolute_import, division, print_function
import time
import mmtbx.refinement.real_space.fit_residues
import mmtbx.refinement.real_space

pdb_answer="""\n
CRYST1   41.392   28.519   38.664  90.00  90.00  90.00 P 1
ATOM      1  N   TRP A   2      28.561  21.020  25.897  1.00 20.00           N
ATOM      2  CA  TRP A   2      27.109  21.152  25.866  1.00 20.00           C
ATOM      3  C   TRP A   2      26.681  22.283  24.936  1.00 20.00           C
ATOM      4  O   TRP A   2      26.767  23.458  25.292  1.00 20.00           O
ATOM      5  CB  TRP A   2      26.562  21.393  27.275  1.00 20.00           C
ATOM      6  CG  TRP A   2      26.879  20.291  28.238  1.00 20.00           C
ATOM      7  CD1 TRP A   2      27.978  20.196  29.042  1.00 20.00           C
ATOM      8  CD2 TRP A   2      26.089  19.125  28.499  1.00 20.00           C
ATOM      9  NE1 TRP A   2      27.921  19.043  29.787  1.00 20.00           N
ATOM     10  CE2 TRP A   2      26.771  18.368  29.473  1.00 20.00           C
ATOM     11  CE3 TRP A   2      24.871  18.647  28.005  1.00 20.00           C
ATOM     12  CZ2 TRP A   2      26.276  17.160  29.961  1.00 20.00           C
ATOM     13  CZ3 TRP A   2      24.382  17.448  28.491  1.00 20.00           C
ATOM     14  CH2 TRP A   2      25.083  16.718  29.459  1.00 20.00           C
ATOM     15  N   ILE A   3      26.220  21.919  23.741  1.00 20.00           N
ATOM     16  CA  ILE A   3      25.778  22.897  22.753  1.00 20.00           C
ATOM     17  C   ILE A   3      24.305  22.667  22.441  1.00 20.00           C
ATOM     18  O   ILE A   3      23.689  21.727  22.955  1.00 20.00           O
ATOM     19  CB  ILE A   3      26.631  22.824  21.474  1.00 20.00           C
ATOM     20  CG1 ILE A   3      26.539  21.430  20.850  1.00 20.00           C
ATOM     21  CG2 ILE A   3      28.078  23.184  21.778  1.00 20.00           C
ATOM     22  CD1 ILE A   3      27.346  21.275  19.579  1.00 20.00           C
ATOM     23  N   SER A   4      23.735  23.522  21.599  1.00 20.00           N
ATOM     24  CA  SER A   4      22.336  23.413  21.217  1.00 20.00           C
ATOM     25  C   SER A   4      22.177  22.477  20.026  1.00 20.00           C
ATOM     26  O   SER A   4      23.065  22.362  19.176  1.00 20.00           O
ATOM     27  CB  SER A   4      21.759  24.789  20.879  1.00 20.00           C
ATOM     28  OG  SER A   4      22.461  25.386  19.803  1.00 20.00           O
ATOM     29  N   LYS A   5      21.031  21.804  19.973  1.00 20.00           N
ATOM     30  CA  LYS A   5      20.745  20.875  18.891  1.00 20.00           C
ATOM     31  C   LYS A   5      20.404  21.632  17.614  1.00 20.00           C
ATOM     32  O   LYS A   5      19.781  22.697  17.652  1.00 20.00           O
ATOM     33  CB  LYS A   5      19.593  19.946  19.274  1.00 20.00           C
ATOM     34  CG  LYS A   5      19.857  19.109  20.514  1.00 20.00           C
ATOM     35  CD  LYS A   5      18.672  18.214  20.839  1.00 20.00           C
ATOM     36  CE  LYS A   5      18.935  17.380  22.082  1.00 20.00           C
ATOM     37  NZ  LYS A   5      17.783  16.497  22.414  1.00 20.00           N
ATOM     38  N   GLY A   6      20.814  21.076  16.486  1.00 20.00           N
ATOM     39  CA  GLY A   6      20.555  21.699  15.205  1.00 20.00           C
ATOM     40  C   GLY A   6      21.422  21.090  14.124  1.00 20.00           C
ATOM     41  O   GLY A   6      22.201  20.167  14.360  1.00 20.00           O
ATOM     42  N   CYS A   7      21.264  21.635  12.923  1.00 20.00           N
ATOM     43  CA  CYS A   7      22.015  21.181  11.764  1.00 20.00           C
ATOM     44  C   CYS A   7      23.359  21.897  11.681  1.00 20.00           C
ATOM     45  O   CYS A   7      23.549  22.987  12.227  1.00 20.00           O
ATOM     46  CB  CYS A   7      21.217  21.411  10.480  1.00 20.00           C
ATOM     47  SG  CYS A   7      19.627  20.551  10.424  1.00 20.00           S
ATOM     48  N   GLY A   8      24.298  21.265  10.986  1.00 20.00           N
ATOM     49  CA  GLY A   8      25.623  21.837  10.839  1.00 20.00           C
ATOM     50  C   GLY A   8      26.555  20.862  10.147  1.00 20.00           C
ATOM     51  O   GLY A   8      26.113  19.908   9.506  1.00 20.00           O
ATOM     52  N   TYR A   9      27.853  21.123  10.292  1.00 20.00           N
ATOM     53  CA  TYR A   9      28.890  20.293   9.688  1.00 20.00           C
ATOM     54  C   TYR A   9      30.005  20.098  10.701  1.00 20.00           C
ATOM     55  O   TYR A   9      30.589  21.076  11.178  1.00 20.00           O
ATOM     56  CB  TYR A   9      29.434  20.929   8.404  1.00 20.00           C
ATOM     57  CG  TYR A   9      28.387  21.152   7.336  1.00 20.00           C
ATOM     58  CD1 TYR A   9      28.077  20.154   6.421  1.00 20.00           C
ATOM     59  CD2 TYR A   9      27.710  22.361   7.241  1.00 20.00           C
ATOM     60  CE1 TYR A   9      27.122  20.353   5.443  1.00 20.00           C
ATOM     61  CE2 TYR A   9      26.753  22.569   6.266  1.00 20.00           C
ATOM     62  CZ  TYR A   9      26.463  21.562   5.370  1.00 20.00           C
ATOM     63  OH  TYR A   9      25.510  21.765   4.398  1.00 20.00           O
ATOM     64  N   CYS A  10      30.299  18.841  11.028  1.00 20.00           N
ATOM     65  CA  CYS A  10      31.338  18.510  11.993  1.00 20.00           C
ATOM     66  C   CYS A  10      32.148  17.335  11.472  1.00 20.00           C
ATOM     67  O   CYS A  10      31.579  16.308  11.091  1.00 20.00           O
ATOM     68  CB  CYS A  10      30.738  18.174  13.364  1.00 20.00           C
ATOM     69  SG  CYS A  10      29.802  19.521  14.124  1.00 20.00           S
ATOM     70  N   SER A  11      33.474  17.495  11.457  1.00 20.00           N
ATOM     71  CA  SER A  11      34.405  16.462  10.995  1.00 20.00           C
ATOM     72  C   SER A  11      34.109  16.024   9.562  1.00 20.00           C
ATOM     73  O   SER A  11      34.378  14.882   9.184  1.00 20.00           O
ATOM     74  CB  SER A  11      34.408  15.250  11.933  1.00 20.00           C
ATOM     75  OG  SER A  11      33.179  14.548  11.876  1.00 20.00           O
ATOM     76  N   GLY A  12      33.557  16.928   8.756  1.00 20.00           N
ATOM     77  CA  GLY A  12      33.254  16.622   7.372  1.00 20.00           C
ATOM     78  C   GLY A  12      32.140  15.608   7.208  1.00 20.00           C
ATOM     79  O   GLY A  12      32.256  14.673   6.410  1.00 20.00           O
ATOM     80  N   SER A  13      31.055  15.782   7.959  1.00 20.00           N
ATOM     81  CA  SER A  13      29.927  14.866   7.895  1.00 20.00           C
ATOM     82  C   SER A  13      28.639  15.642   8.128  1.00 20.00           C
ATOM     83  O   SER A  13      28.621  16.640   8.853  1.00 20.00           O
ATOM     84  CB  SER A  13      30.059  13.735   8.922  1.00 20.00           C
ATOM     85  OG  SER A  13      30.118  14.248  10.242  1.00 20.00           O
ATOM     86  N   TRP A  14      27.564  15.171   7.503  1.00 20.00           N
ATOM     87  CA  TRP A  14      26.268  15.816   7.649  1.00 20.00           C
ATOM     88  C   TRP A  14      25.696  15.568   9.040  1.00 20.00           C
ATOM     89  O   TRP A  14      25.884  14.503   9.636  1.00 20.00           O
ATOM     90  CB  TRP A  14      25.295  15.308   6.585  1.00 20.00           C
ATOM     91  CG  TRP A  14      25.753  15.564   5.182  1.00 20.00           C
ATOM     92  CD1 TRP A  14      26.555  14.764   4.422  1.00 20.00           C
ATOM     93  CD2 TRP A  14      25.432  16.699   4.367  1.00 20.00           C
ATOM     94  NE1 TRP A  14      26.756  15.330   3.187  1.00 20.00           N
ATOM     95  CE2 TRP A  14      26.077  16.518   3.128  1.00 20.00           C
ATOM     96  CE3 TRP A  14      24.664  17.850   4.567  1.00 20.00           C
ATOM     97  CZ2 TRP A  14      25.976  17.445   2.092  1.00 20.00           C
ATOM     98  CZ3 TRP A  14      24.565  18.769   3.537  1.00 20.00           C
ATOM     99  CH2 TRP A  14      25.218  18.561   2.316  1.00 20.00           C
ATOM    100  N   CYS A  15      24.987  16.569   9.557  1.00 20.00           N
ATOM    101  CA  CYS A  15      24.369  16.490  10.872  1.00 20.00           C
ATOM    102  C   CYS A  15      23.009  17.168  10.830  1.00 20.00           C
ATOM    103  O   CYS A  15      22.864  18.252  10.258  1.00 20.00           O
ATOM    104  CB  CYS A  15      25.247  17.143  11.948  1.00 20.00           C
ATOM    105  SG  CYS A  15      26.863  16.364  12.178  1.00 20.00           S
ATOM    106  N   SER A  16      22.015  16.523  11.439  1.00 20.00           N
ATOM    107  CA  SER A  16      20.662  17.062  11.475  1.00 20.00           C
ATOM    108  C   SER A  16      19.937  16.482  12.679  1.00 20.00           C
ATOM    109  O   SER A  16      19.988  15.270  12.909  1.00 20.00           O
ATOM    110  CB  SER A  16      19.902  16.738  10.184  1.00 20.00           C
ATOM    111  OG  SER A  16      18.587  17.263  10.220  1.00 20.00           O
ATOM    112  N   TRP A  17      19.268  17.345  13.441  1.00 20.00           N
ATOM    113  CA  TRP A  17      18.528  16.928  14.621  1.00 20.00           C
ATOM    114  C   TRP A  17      17.167  17.606  14.628  1.00 20.00           C
ATOM    115  O   TRP A  17      17.012  18.729  14.143  1.00 20.00           O
ATOM    116  CB  TRP A  17      19.289  17.260  15.913  1.00 20.00           C
ATOM    117  CG  TRP A  17      20.636  16.611  15.999  1.00 20.00           C
ATOM    118  CD1 TRP A  17      21.824  17.129  15.573  1.00 20.00           C
ATOM    119  CD2 TRP A  17      20.935  15.321  16.547  1.00 20.00           C
ATOM    120  NE1 TRP A  17      22.844  16.242  15.821  1.00 20.00           N
ATOM    121  CE2 TRP A  17      22.324  15.124  16.418  1.00 20.00           C
ATOM    122  CE3 TRP A  17      20.162  14.314  17.134  1.00 20.00           C
ATOM    123  CZ2 TRP A  17      22.957  13.962  16.854  1.00 20.00           C
ATOM    124  CZ3 TRP A  17      20.792  13.161  17.566  1.00 20.00           C
ATOM    125  CH2 TRP A  17      22.176  12.994  17.424  1.00 20.00           C
ATOM    126  N   TRP A  18      16.180  16.908  15.186  1.00 20.00           N
ATOM    127  CA  TRP A  18      14.819  17.435  15.265  1.00 20.00           C
ATOM    128  C   TRP A  18      14.110  16.759  16.426  1.00 20.00           C
ATOM    129  O   TRP A  18      13.974  15.531  16.436  1.00 20.00           O
ATOM    130  CB  TRP A  18      14.066  17.203  13.955  1.00 20.00           C
ATOM    131  CG  TRP A  18      12.661  17.723  13.967  1.00 20.00           C
ATOM    132  CD1 TRP A  18      12.265  19.017  13.792  1.00 20.00           C
ATOM    133  CD2 TRP A  18      11.464  16.960  14.159  1.00 20.00           C
ATOM    134  NE1 TRP A  18      10.896  19.107  13.866  1.00 20.00           N
ATOM    135  CE2 TRP A  18      10.381  17.857  14.090  1.00 20.00           C
ATOM    136  CE3 TRP A  18      11.204  15.604  14.383  1.00 20.00           C
ATOM    137  CZ2 TRP A  18       9.058  17.444  14.238  1.00 20.00           C
ATOM    138  CZ3 TRP A  18       9.891  15.196  14.529  1.00 20.00           C
ATOM    139  CH2 TRP A  18       8.835  16.113  14.456  1.00 20.00           C
ATOM    140  N   MET A  19      13.662  17.550  17.395  1.00 20.00           N
ATOM    141  CA  MET A  19      12.988  17.043  18.577  1.00 20.00           C
ATOM    142  C   MET A  19      11.475  17.191  18.417  1.00 20.00           C
ATOM    143  O   MET A  19      10.971  17.571  17.355  1.00 20.00           O
ATOM    144  CB  MET A  19      13.502  17.768  19.822  1.00 20.00           C
ATOM    145  CG  MET A  19      14.996  17.614  20.056  1.00 20.00           C
ATOM    146  SD  MET A  19      15.494  15.895  20.270  1.00 20.00           S
ATOM    147  CE  MET A  19      14.530  15.439  21.708  1.00 20.00           C
ATOM    148  N   MSE A  20      10.739  16.887  19.481  1.00 20.00           N
ATOM    149  CA  MSE A  20       9.285  16.988  19.464  1.00 20.00           C
ATOM    150  C   MSE A  20       8.814  18.257  20.165  1.00 20.00           C
ATOM    151  O   MSE A  20       7.665  18.671  20.014  1.00 20.00           O
ATOM    152  CB  MSE A  20       8.654  15.759  20.123  1.00 20.00           C
ATOM    153  CG  MSE A  20       8.981  14.445  19.432  1.00 20.00           C
ATOM    154 SE   MSE A  20       8.296  14.363  17.609  1.00 20.00          Se
ATOM    155  CE  MSE A  20       6.397  14.585  17.988  1.00 20.00           C
ATOM    156  N   GLY A  21       9.710  18.870  20.932  1.00 20.00           N
ATOM    157  CA  GLY A  21       9.413  20.089  21.662  1.00 20.00           C
ATOM    158  C   GLY A  21       9.486  19.963  23.169  1.00 20.00           C
ATOM    159  O   GLY A  21       9.470  20.991  23.861  1.00 20.00           O
ATOM    160  N   MSE A  22       9.567  18.753  23.713  1.00 20.00           N
ATOM    161  CA  MSE A  22       9.646  18.565  25.157  1.00 20.00           C
ATOM    162  C   MSE A  22      11.081  18.708  25.652  1.00 20.00           C
ATOM    163  O   MSE A  22      11.996  18.961  24.869  1.00 20.00           O
ATOM    164  CB  MSE A  22       9.087  17.197  25.551  1.00 20.00           C
ATOM    165  CG  MSE A  22       7.631  16.988  25.168  1.00 20.00           C
ATOM    166 SE   MSE A  22       6.439  18.289  25.998  1.00 20.00          Se
ATOM    167  CE  MSE A  22       6.809  17.888  27.869  1.00 20.00           C
ATOM    168  N   GLY A  23      11.271  18.543  26.959  1.00 20.00           N
ATOM    169  CA  GLY A  23      12.591  18.646  27.548  1.00 20.00           C
ATOM    170  C   GLY A  23      13.001  17.407  28.316  1.00 20.00           C
ATOM    171  O   GLY A  23      12.308  16.386  28.277  1.00 20.00           O
ATOM    172  N   GLY A  24      14.128  17.485  29.019  1.00 20.00           N
ATOM    173  CA  GLY A  24      14.607  16.358  29.793  1.00 20.00           C
ATOM    174  C   GLY A  24      15.404  15.340  29.013  1.00 20.00           C
ATOM    175  O   GLY A  24      15.538  14.198  29.465  1.00 20.00           O
ATOM    176  N   ILE A  25      15.939  15.714  27.854  1.00 20.00           N
ATOM    177  CA  ILE A  25      16.727  14.817  27.016  1.00 20.00           C
ATOM    178  C   ILE A  25      18.052  15.500  26.713  1.00 20.00           C
ATOM    179  O   ILE A  25      18.072  16.598  26.143  1.00 20.00           O
ATOM    180  CB  ILE A  25      15.997  14.449  25.713  1.00 20.00           C
ATOM    181  CG1 ILE A  25      14.693  13.711  26.021  1.00 20.00           C
ATOM    182  CG2 ILE A  25      16.894  13.606  24.819  1.00 20.00           C
ATOM    183  CD1 ILE A  25      13.909  13.315  24.788  1.00 20.00           C
ATOM    184  N   LYS A  26      19.152  14.856  27.090  1.00 20.00           N
ATOM    185  CA  LYS A  26      20.491  15.381  26.868  1.00 20.00           C
ATOM    186  C   LYS A  26      21.243  14.486  25.893  1.00 20.00           C
ATOM    187  O   LYS A  26      21.134  13.257  25.952  1.00 20.00           O
ATOM    188  CB  LYS A  26      21.266  15.488  28.184  1.00 20.00           C
ATOM    189  CG  LYS A  26      20.617  16.399  29.214  1.00 20.00           C
ATOM    190  CD  LYS A  26      21.436  16.458  30.493  1.00 20.00           C
ATOM    191  CE  LYS A  26      20.788  17.368  31.523  1.00 20.00           C
ATOM    192  NZ  LYS A  26      21.579  17.436  32.782  1.00 20.00           N
ATOM    193  N   LYS A  27      22.006  15.109  24.997  1.00 20.00           N
ATOM    194  CA  LYS A  27      22.785  14.396  23.997  1.00 20.00           C
ATOM    195  C   LYS A  27      24.190  14.976  23.935  1.00 20.00           C
ATOM    196  O   LYS A  27      24.401  16.165  24.188  1.00 20.00           O
ATOM    197  CB  LYS A  27      22.128  14.470  22.610  1.00 20.00           C
ATOM    198  CG  LYS A  27      20.754  13.824  22.534  1.00 20.00           C
ATOM    199  CD  LYS A  27      20.167  13.936  21.136  1.00 20.00           C
ATOM    200  CE  LYS A  27      18.792  13.293  21.062  1.00 20.00           C
ATOM    201  NZ  LYS A  27      18.202  13.397  19.699  1.00 20.00           N
ATOM    202  N   MET A  28      25.151  14.120  23.594  1.00 20.00           N
ATOM    203  CA  MET A  28      26.549  14.507  23.488  1.00 20.00           C
ATOM    204  C   MET A  28      27.105  14.035  22.151  1.00 20.00           C
ATOM    205  O   MET A  28      26.448  13.313  21.396  1.00 20.00           O
ATOM    206  CB  MET A  28      27.380  13.932  24.645  1.00 20.00           C
ATOM    207  CG  MET A  28      26.945  14.409  26.021  1.00 20.00           C
ATOM    208  SD  MET A  28      27.060  16.199  26.206  1.00 20.00           S
ATOM    209  CE  MET A  28      28.809  16.457  25.918  1.00 20.00           C
ATOM    210  N   LYS A  29      28.336  14.456  21.863  1.00 20.00           N
ATOM    211  CA  LYS A  29      29.027  14.107  20.622  1.00 20.00           C
ATOM    212  C   LYS A  29      30.446  13.675  20.979  1.00 20.00           C
ATOM    213  O   LYS A  29      31.329  14.516  21.167  1.00 20.00           O
ATOM    214  CB  LYS A  29      29.033  15.278  19.644  1.00 20.00           C
ATOM    215  CG  LYS A  29      27.651  15.715  19.182  1.00 20.00           C
ATOM    216  CD  LYS A  29      27.737  16.882  18.212  1.00 20.00           C
ATOM    217  CE  LYS A  29      26.356  17.319  17.751  1.00 20.00           C
ATOM    218  NZ  LYS A  29      26.423  18.462  16.800  1.00 20.00           N
ATOM    219  N   GLY A  30      30.661  12.366  21.070  1.00 20.00           N
ATOM    220  CA  GLY A  30      31.969  11.848  21.405  1.00 20.00           C
ATOM    221  C   GLY A  30      32.947  11.947  20.249  1.00 20.00           C
ATOM    222  O   GLY A  30      32.606  12.298  19.119  1.00 20.00           O
ATOM    223  N   TRP A  31      34.202  11.626  20.552  1.00 20.00           N
ATOM    224  CA  TRP A  31      35.261  11.681  19.556  1.00 20.00           C
ATOM    225  C   TRP A  31      35.163  10.496  18.603  1.00 20.00           C
ATOM    226  O   TRP A  31      34.931   9.359  19.022  1.00 20.00           O
ATOM    227  CB  TRP A  31      36.631  11.695  20.234  1.00 20.00           C
ATOM    228  CG  TRP A  31      36.837  12.864  21.147  1.00 20.00           C
ATOM    229  CD1 TRP A  31      36.546  12.925  22.478  1.00 20.00           C
ATOM    230  CD2 TRP A  31      37.379  14.143  20.795  1.00 20.00           C
ATOM    231  NE1 TRP A  31      36.873  14.163  22.978  1.00 20.00           N
ATOM    232  CE2 TRP A  31      37.386  14.929  21.965  1.00 20.00           C
ATOM    233  CE3 TRP A  31      37.858  14.700  19.606  1.00 20.00           C
ATOM    234  CZ2 TRP A  31      37.854  16.242  21.980  1.00 20.00           C
ATOM    235  CZ3 TRP A  31      38.322  16.003  19.622  1.00 20.00           C
ATOM    236  CH2 TRP A  31      38.316  16.759  20.801  1.00 20.00           C
ATOM    237  N   GLY A  32      35.340  10.772  17.317  1.00 20.00           N
ATOM    238  CA  GLY A  32      35.284   9.712  16.321  1.00 20.00           C
ATOM    239  C   GLY A  32      33.856   9.311  16.034  1.00 20.00           C
ATOM    240  O   GLY A  32      32.990  10.162  15.813  1.00 20.00           O
ATOM    241  N   GLY A  33      33.602   8.005  16.037  1.00 20.00           N
ATOM    242  CA  GLY A  33      32.275   7.491  15.765  1.00 20.00           C
ATOM    243  C   GLY A  33      31.508   7.117  17.016  1.00 20.00           C
ATOM    244  O   GLY A  33      30.567   6.319  16.960  1.00 20.00           O
ATOM    245  N   MSE A  34      31.900   7.685  18.151  1.00 20.00           N
ATOM    246  CA  MSE A  34      31.243   7.394  19.419  1.00 20.00           C
ATOM    247  C   MSE A  34      30.089   8.356  19.677  1.00 20.00           C
ATOM    248  O   MSE A  34      30.269   9.574  19.668  1.00 20.00           O
ATOM    249  CB  MSE A  34      32.248   7.458  20.571  1.00 20.00           C
ATOM    250  CG  MSE A  34      33.401   6.476  20.444  1.00 20.00           C
ATOM    251 SE   MSE A  34      32.805   4.620  20.385  1.00 20.00          Se
ATOM    252  CE  MSE A  34      31.905   4.536  22.113  1.00 20.00           C
ATOM    253  N   ILE A  35      28.901   7.800  19.906  1.00 20.00           N
ATOM    254  CA  ILE A  35      27.697   8.578  20.172  1.00 20.00           C
ATOM    255  C   ILE A  35      27.039   8.025  21.427  1.00 20.00           C
ATOM    256  O   ILE A  35      26.804   6.816  21.528  1.00 20.00           O
ATOM    257  CB  ILE A  35      26.715   8.541  18.985  1.00 20.00           C
ATOM    258  CG1 ILE A  35      27.362   9.136  17.733  1.00 20.00           C
ATOM    259  CG2 ILE A  35      25.433   9.285  19.328  1.00 20.00           C
ATOM    260  CD1 ILE A  35      26.462   9.128  16.517  1.00 20.00           C
ATOM    261  N   SER A  36      26.745   8.906  22.378  1.00 20.00           N
ATOM    262  CA  SER A  36      26.119   8.524  23.634  1.00 20.00           C
ATOM    263  C   SER A  36      24.636   8.872  23.616  1.00 20.00           C
ATOM    264  O   SER A  36      24.201   9.791  22.916  1.00 20.00           O
ATOM    265  CB  SER A  36      26.802   9.215  24.816  1.00 20.00           C
ATOM    266  OG  SER A  36      26.719  10.625  24.700  1.00 20.00           O
ATOM    267  N   TRP A  37      23.860   8.125  24.398  1.00 20.00           N
ATOM    268  CA  TRP A  37      22.422   8.327  24.493  1.00 20.00           C
ATOM    269  C   TRP A  37      21.991   8.204  25.946  1.00 20.00           C
ATOM    270  O   TRP A  37      22.500   7.353  26.682  1.00 20.00           O
ATOM    271  CB  TRP A  37      21.655   7.317  23.630  1.00 20.00           C
ATOM    272  CG  TRP A  37      21.984   7.400  22.171  1.00 20.00           C
ATOM    273  CD1 TRP A  37      22.958   6.709  21.510  1.00 20.00           C
ATOM    274  CD2 TRP A  37      21.339   8.220  21.190  1.00 20.00           C
ATOM    275  NE1 TRP A  37      22.959   7.048  20.179  1.00 20.00           N
ATOM    276  CE2 TRP A  37      21.975   7.975  19.956  1.00 20.00           C
ATOM    277  CE3 TRP A  37      20.286   9.139  21.234  1.00 20.00           C
ATOM    278  CZ2 TRP A  37      21.592   8.614  18.779  1.00 20.00           C
ATOM    279  CZ3 TRP A  37      19.908   9.772  20.064  1.00 20.00           C
ATOM    280  CH2 TRP A  37      20.559   9.507  18.853  1.00 20.00           C
ATOM    281  N   SER A  38      21.052   9.056  26.352  1.00 20.00           N
ATOM    282  CA  SER A  38      20.557   9.048  27.727  1.00 20.00           C
ATOM    283  C   SER A  38      19.151   9.631  27.725  1.00 20.00           C
ATOM    284  O   SER A  38      18.982  10.833  27.499  1.00 20.00           O
ATOM    285  CB  SER A  38      21.483   9.840  28.642  1.00 20.00           C
ATOM    286  OG  SER A  38      21.582  11.190  28.223  1.00 20.00           O
ATOM    287  N   TRP A  39      18.154   8.785  27.975  1.00 20.00           N
ATOM    288  CA  TRP A  39      16.762   9.204  28.004  1.00 20.00           C
ATOM    289  C   TRP A  39      16.080   8.624  29.234  1.00 20.00           C
ATOM    290  O   TRP A  39      16.558   7.663  29.843  1.00 20.00           O
ATOM    291  CB  TRP A  39      16.015   8.771  26.733  1.00 20.00           C
ATOM    292  CG  TRP A  39      15.907   7.284  26.576  1.00 20.00           C
ATOM    293  CD1 TRP A  39      14.876   6.489  26.987  1.00 20.00           C
ATOM    294  CD2 TRP A  39      16.866   6.412  25.965  1.00 20.00           C
ATOM    295  NE1 TRP A  39      15.134   5.178  26.669  1.00 20.00           N
ATOM    296  CE2 TRP A  39      16.349   5.104  26.041  1.00 20.00           C
ATOM    297  CE3 TRP A  39      18.111   6.612  25.360  1.00 20.00           C
ATOM    298  CZ2 TRP A  39      17.033   4.000  25.535  1.00 20.00           C
ATOM    299  CZ3 TRP A  39      18.789   5.514  24.860  1.00 20.00           C
ATOM    300  CH2 TRP A  39      18.249   4.226  24.950  1.00 20.00           C
ATOM    301  N   SER A  40      14.947   9.223  29.594  1.00 20.00           N
ATOM    302  CA  SER A  40      14.174   8.782  30.751  1.00 20.00           C
ATOM    303  C   SER A  40      12.720   9.167  30.536  1.00 20.00           C
ATOM    304  O   SER A  40      12.403  10.358  30.453  1.00 20.00           O
ATOM    305  CB  SER A  40      14.711   9.400  32.044  1.00 20.00           C
ATOM    306  OG  SER A  40      16.047   8.996  32.290  1.00 20.00           O
ATOM    307  N   SER A  41      11.847   8.162  30.451  1.00 20.00           N
ATOM    308  CA  SER A  41      10.412   8.355  30.237  1.00 20.00           C
ATOM    309  C   SER A  41      10.152   9.173  28.969  1.00 20.00           C
ATOM    310  O   SER A  41       9.568  10.258  28.999  1.00 20.00           O
ATOM    311  CB  SER A  41       9.753   9.003  31.461  1.00 20.00           C
ATOM    312  OG  SER A  41      10.188  10.340  31.635  1.00 20.00           O
ATOM    313  N   SER A  42      10.603   8.626  27.847  1.00 20.00           N
ATOM    314  CA  SER A  42      10.455   9.248  26.539  1.00 20.00           C
ATOM    315  C   SER A  42       9.555   8.384  25.659  1.00 20.00           C
ATOM    316  O   SER A  42       9.051   7.340  26.078  1.00 20.00           O
ATOM    317  CB  SER A  42      11.821   9.465  25.881  1.00 20.00           C
ATOM    318  OG  SER A  42      12.503   8.235  25.705  1.00 20.00           O
ATOM    319  N   GLY A  43       9.358   8.835  24.423  1.00 20.00           N
ATOM    320  CA  GLY A  43       8.527   8.114  23.479  1.00 20.00           C
ATOM    321  C   GLY A  43       9.300   7.587  22.288  1.00 20.00           C
ATOM    322  O   GLY A  43      10.473   7.222  22.413  1.00 20.00           O
ATOM    323  N   LYS A  44       8.651   7.540  21.127  1.00 20.00           N
ATOM    324  CA  LYS A  44       9.301   7.055  19.916  1.00 20.00           C
ATOM    325  C   LYS A  44      10.326   8.074  19.433  1.00 20.00           C
ATOM    326  O   LYS A  44       9.995   9.244  19.217  1.00 20.00           O
ATOM    327  CB  LYS A  44       8.261   6.782  18.833  1.00 20.00           C
ATOM    328  CG  LYS A  44       7.222   5.741  19.217  1.00 20.00           C
ATOM    329  CD  LYS A  44       6.221   5.519  18.095  1.00 20.00           C
ATOM    330  CE  LYS A  44       5.182   4.478  18.480  1.00 20.00           C
ATOM    331  NZ  LYS A  44       4.194   4.250  17.390  1.00 20.00           N
ATOM    332  N   MSE A  45      11.568   7.630  19.264  1.00 20.00           N
ATOM    333  CA  MSE A  45      12.641   8.506  18.808  1.00 20.00           C
ATOM    334  C   MSE A  45      13.400   7.886  17.640  1.00 20.00           C
ATOM    335  O   MSE A  45      13.705   6.693  17.649  1.00 20.00           O
ATOM    336  CB  MSE A  45      13.605   8.816  19.955  1.00 20.00           C
ATOM    337  CG  MSE A  45      12.973   9.561  21.120  1.00 20.00           C
ATOM    338 SE   MSE A  45      12.242  11.292  20.597  1.00 20.00          Se
ATOM    339  CE  MSE A  45      13.877  12.123  19.937  1.00 20.00           C
ATOM    340  N   TRP A  46      13.702   8.704  16.635  1.00 20.00           N
ATOM    341  CA  TRP A  46      14.425   8.252  15.456  1.00 20.00           C
ATOM    342  C   TRP A  46      15.388   9.343  15.010  1.00 20.00           C
ATOM    343  O   TRP A  46      15.245  10.514  15.371  1.00 20.00           O
ATOM    344  CB  TRP A  46      13.472   7.885  14.310  1.00 20.00           C
ATOM    345  CG  TRP A  46      12.536   6.763  14.642  1.00 20.00           C
ATOM    346  CD1 TRP A  46      11.289   6.869  15.185  1.00 20.00           C
ATOM    347  CD2 TRP A  46      12.773   5.362  14.452  1.00 20.00           C
ATOM    348  NE1 TRP A  46      10.734   5.622  15.345  1.00 20.00           N
ATOM    349  CE2 TRP A  46      11.625   4.680  14.902  1.00 20.00           C
ATOM    350  CE3 TRP A  46      13.843   4.620  13.945  1.00 20.00           C
ATOM    351  CZ2 TRP A  46      11.517   3.291  14.861  1.00 20.00           C
ATOM    352  CZ3 TRP A  46      13.735   3.241  13.904  1.00 20.00           C
ATOM    353  CH2 TRP A  46      12.580   2.592  14.360  1.00 20.00           C
ATOM    354  N   GLY A  47      16.376   8.942  14.215  1.00 20.00           N
ATOM    355  CA  GLY A  47      17.368   9.873  13.714  1.00 20.00           C
ATOM    356  C   GLY A  47      18.767   9.294  13.683  1.00 20.00           C
ATOM    357  O   GLY A  47      19.033   8.259  14.302  1.00 20.00           O
ATOM    358  N   GLY A  48      19.670   9.954  12.966  1.00 20.00           N
ATOM    359  CA  GLY A  48      21.037   9.478  12.877  1.00 20.00           C
ATOM    360  C   GLY A  48      21.826  10.297  11.875  1.00 20.00           C
ATOM    361  O   GLY A  48      21.420  11.396  11.493  1.00 20.00           O
ATOM    362  N   LYS A  49      22.960   9.741  11.459  1.00 20.00           N
ATOM    363  CA  LYS A  49      23.846  10.380  10.501  1.00 20.00           C
ATOM    364  C   LYS A  49      23.979   9.513   9.256  1.00 20.00           C
ATOM    365  O   LYS A  49      23.689   8.313   9.272  1.00 20.00           O
ATOM    366  CB  LYS A  49      25.231  10.641  11.109  1.00 20.00           C
ATOM    367  CG  LYS A  49      25.212  11.543  12.332  1.00 20.00           C
ATOM    368  CD  LYS A  49      26.613  11.758  12.881  1.00 20.00           C
ATOM    369  CE  LYS A  49      26.594  12.661  14.104  1.00 20.00           C
ATOM    370  NZ  LYS A  49      27.960  12.880  14.654  1.00 20.00           N
ATOM    371  N   GLY A  50      24.423  10.138   8.170  1.00 20.00           N
ATOM    372  CA  GLY A  50      24.601   9.443   6.909  1.00 20.00           C
ATOM    373  C   GLY A  50      25.997   9.590   6.335  1.00 20.00           C
ATOM    374  O   GLY A  50      26.809  10.362   6.844  1.00 20.00           O
TER
END
"""

pdb_poor="""\n
CRYST1   41.392   28.519   38.664  90.00  90.00  90.00 P 1
SCALE1      0.024159  0.000000  0.000000        0.00000
SCALE2      0.000000  0.035064  0.000000        0.00000
SCALE3      0.000000  0.000000  0.025864        0.00000
ATOM      1  N   TRP A   2      28.561  21.020  25.897  1.00 20.00           N
ATOM      2  CA  TRP A   2      27.109  21.152  25.866  1.00 20.00           C
ATOM      3  C   TRP A   2      26.681  22.283  24.936  1.00 20.00           C
ATOM      4  O   TRP A   2      26.767  23.458  25.292  1.00 20.00           O
ATOM      5  CB  TRP A   2      26.562  21.393  27.275  1.00 20.00           C
ATOM      6  CG  TRP A   2      27.062  22.656  27.905  1.00 20.00           C
ATOM      7  CD1 TRP A   2      28.188  22.805  28.662  1.00 20.00           C
ATOM      8  CD2 TRP A   2      26.453  23.951  27.833  1.00 20.00           C
ATOM      9  NE1 TRP A   2      28.318  24.111  29.066  1.00 20.00           N
ATOM     10  CE2 TRP A   2      27.266  24.836  28.570  1.00 20.00           C
ATOM     11  CE3 TRP A   2      25.301  24.449  27.217  1.00 20.00           C
ATOM     12  CZ2 TRP A   2      26.962  26.189  28.708  1.00 20.00           C
ATOM     13  CZ3 TRP A   2      25.002  25.792  27.355  1.00 20.00           C
ATOM     14  CH2 TRP A   2      25.829  26.647  28.094  1.00 20.00           C
ATOM     15  N   ILE A   3      26.220  21.919  23.741  1.00 20.00           N
ATOM     16  CA  ILE A   3      25.778  22.897  22.753  1.00 20.00           C
ATOM     17  C   ILE A   3      24.305  22.667  22.441  1.00 20.00           C
ATOM     18  O   ILE A   3      23.689  21.727  22.955  1.00 20.00           O
ATOM     19  CB  ILE A   3      26.631  22.824  21.474  1.00 20.00           C
ATOM     20  CG1 ILE A   3      26.369  24.043  20.588  1.00 20.00           C
ATOM     21  CG2 ILE A   3      26.345  21.536  20.716  1.00 20.00           C
ATOM     22  CD1 ILE A   3      26.822  25.352  21.199  1.00 20.00           C
ATOM     23  N   SER A   4      23.735  23.522  21.599  1.00 20.00           N
ATOM     24  CA  SER A   4      22.336  23.413  21.217  1.00 20.00           C
ATOM     25  C   SER A   4      22.177  22.477  20.026  1.00 20.00           C
ATOM     26  O   SER A   4      23.065  22.362  19.176  1.00 20.00           O
ATOM     27  CB  SER A   4      21.759  24.789  20.879  1.00 20.00           C
ATOM     28  OG  SER A   4      21.759  25.635  22.015  1.00 20.00           O
ATOM     29  N   LYS A   5      21.031  21.804  19.973  1.00 20.00           N
ATOM     30  CA  LYS A   5      20.745  20.875  18.891  1.00 20.00           C
ATOM     31  C   LYS A   5      20.404  21.632  17.614  1.00 20.00           C
ATOM     32  O   LYS A   5      19.781  22.697  17.652  1.00 20.00           O
ATOM     33  CB  LYS A   5      19.593  19.946  19.274  1.00 20.00           C
ATOM     34  CG  LYS A   5      18.266  20.656  19.483  1.00 20.00           C
ATOM     35  CD  LYS A   5      17.474  20.738  18.188  1.00 20.00           C
ATOM     36  CE  LYS A   5      16.103  21.352  18.419  1.00 20.00           C
ATOM     37  NZ  LYS A   5      15.321  21.459  17.156  1.00 20.00           N
ATOM     38  N   GLY A   6      20.814  21.076  16.486  1.00 20.00           N
ATOM     39  CA  GLY A   6      20.555  21.699  15.205  1.00 20.00           C
ATOM     40  C   GLY A   6      21.422  21.090  14.124  1.00 20.00           C
ATOM     41  O   GLY A   6      22.201  20.167  14.360  1.00 20.00           O
ATOM     42  N   CYS A   7      21.264  21.635  12.923  1.00 20.00           N
ATOM     43  CA  CYS A   7      22.015  21.181  11.764  1.00 20.00           C
ATOM     44  C   CYS A   7      23.359  21.897  11.681  1.00 20.00           C
ATOM     45  O   CYS A   7      23.549  22.987  12.227  1.00 20.00           O
ATOM     46  CB  CYS A   7      21.217  21.411  10.480  1.00 20.00           C
ATOM     47  SG  CYS A   7      20.903  23.150  10.097  1.00 20.00           S
ATOM     48  N   GLY A   8      24.298  21.265  10.986  1.00 20.00           N
ATOM     49  CA  GLY A   8      25.623  21.837  10.839  1.00 20.00           C
ATOM     50  C   GLY A   8      26.555  20.862  10.147  1.00 20.00           C
ATOM     51  O   GLY A   8      26.113  19.908   9.506  1.00 20.00           O
ATOM     52  N   TYR A   9      27.853  21.123  10.292  1.00 20.00           N
ATOM     53  CA  TYR A   9      28.890  20.293   9.688  1.00 20.00           C
ATOM     54  C   TYR A   9      30.005  20.098  10.701  1.00 20.00           C
ATOM     55  O   TYR A   9      30.589  21.076  11.178  1.00 20.00           O
ATOM     56  CB  TYR A   9      29.434  20.929   8.404  1.00 20.00           C
ATOM     57  CG  TYR A   9      30.130  22.254   8.620  1.00 20.00           C
ATOM     58  CD1 TYR A   9      29.422  23.448   8.572  1.00 20.00           C
ATOM     59  CD2 TYR A   9      31.495  22.311   8.871  1.00 20.00           C
ATOM     60  CE1 TYR A   9      30.053  24.661   8.768  1.00 20.00           C
ATOM     61  CE2 TYR A   9      32.134  23.520   9.068  1.00 20.00           C
ATOM     62  CZ  TYR A   9      31.409  24.692   9.016  1.00 20.00           C
ATOM     63  OH  TYR A   9      32.042  25.898   9.213  1.00 20.00           O
ATOM     64  N   CYS A  10      30.299  18.841  11.028  1.00 20.00           N
ATOM     65  CA  CYS A  10      31.338  18.510  11.993  1.00 20.00           C
ATOM     66  C   CYS A  10      32.148  17.335  11.472  1.00 20.00           C
ATOM     67  O   CYS A  10      31.579  16.308  11.091  1.00 20.00           O
ATOM     68  CB  CYS A  10      30.738  18.174  13.364  1.00 20.00           C
ATOM     69  SG  CYS A  10      29.702  16.693  13.387  1.00 20.00           S
ATOM     70  N   SER A  11      33.474  17.495  11.457  1.00 20.00           N
ATOM     71  CA  SER A  11      34.405  16.462  10.995  1.00 20.00           C
ATOM     72  C   SER A  11      34.109  16.024   9.562  1.00 20.00           C
ATOM     73  O   SER A  11      34.378  14.882   9.184  1.00 20.00           O
ATOM     74  CB  SER A  11      34.408  15.250  11.933  1.00 20.00           C
ATOM     75  OG  SER A  11      34.882  15.594  13.223  1.00 20.00           O
ATOM     76  N   GLY A  12      33.557  16.928   8.756  1.00 20.00           N
ATOM     77  CA  GLY A  12      33.254  16.622   7.372  1.00 20.00           C
ATOM     78  C   GLY A  12      32.140  15.608   7.208  1.00 20.00           C
ATOM     79  O   GLY A  12      32.256  14.673   6.410  1.00 20.00           O
ATOM     80  N   SER A  13      31.055  15.782   7.959  1.00 20.00           N
ATOM     81  CA  SER A  13      29.927  14.866   7.895  1.00 20.00           C
ATOM     82  C   SER A  13      28.639  15.642   8.128  1.00 20.00           C
ATOM     83  O   SER A  13      28.621  16.640   8.853  1.00 20.00           O
ATOM     84  CB  SER A  13      30.059  13.735   8.922  1.00 20.00           C
ATOM     85  OG  SER A  13      31.187  12.922   8.645  1.00 20.00           O
ATOM     86  N   TRP A  14      27.564  15.171   7.503  1.00 20.00           N
ATOM     87  CA  TRP A  14      26.268  15.816   7.649  1.00 20.00           C
ATOM     88  C   TRP A  14      25.696  15.568   9.040  1.00 20.00           C
ATOM     89  O   TRP A  14      25.884  14.503   9.636  1.00 20.00           O
ATOM     90  CB  TRP A  14      25.295  15.308   6.585  1.00 20.00           C
ATOM     91  CG  TRP A  14      25.020  13.838   6.676  1.00 20.00           C
ATOM     92  CD1 TRP A  14      25.713  12.835   6.064  1.00 20.00           C
ATOM     93  CD2 TRP A  14      23.977  13.204   7.428  1.00 20.00           C
ATOM     94  NE1 TRP A  14      25.166  11.617   6.385  1.00 20.00           N
ATOM     95  CE2 TRP A  14      24.100  11.816   7.221  1.00 20.00           C
ATOM     96  CE3 TRP A  14      22.952  13.676   8.253  1.00 20.00           C
ATOM     97  CZ2 TRP A  14      23.236  10.895   7.811  1.00 20.00           C
ATOM     98  CZ3 TRP A  14      22.096  12.760   8.838  1.00 20.00           C
ATOM     99  CH2 TRP A  14      22.243  11.386   8.613  1.00 20.00           C
ATOM    100  N   CYS A  15      24.987  16.569   9.557  1.00 20.00           N
ATOM    101  CA  CYS A  15      24.369  16.490  10.872  1.00 20.00           C
ATOM    102  C   CYS A  15      23.009  17.168  10.830  1.00 20.00           C
ATOM    103  O   CYS A  15      22.864  18.252  10.258  1.00 20.00           O
ATOM    104  CB  CYS A  15      25.247  17.143  11.948  1.00 20.00           C
ATOM    105  SG  CYS A  15      25.488  18.924  11.747  1.00 20.00           S
ATOM    106  N   SER A  16      22.015  16.523  11.439  1.00 20.00           N
ATOM    107  CA  SER A  16      20.662  17.062  11.475  1.00 20.00           C
ATOM    108  C   SER A  16      19.937  16.482  12.679  1.00 20.00           C
ATOM    109  O   SER A  16      19.988  15.270  12.909  1.00 20.00           O
ATOM    110  CB  SER A  16      19.902  16.738  10.184  1.00 20.00           C
ATOM    111  OG  SER A  16      20.504  17.365   9.066  1.00 20.00           O
ATOM    112  N   TRP A  17      19.268  17.345  13.441  1.00 20.00           N
ATOM    113  CA  TRP A  17      18.528  16.928  14.621  1.00 20.00           C
ATOM    114  C   TRP A  17      17.167  17.606  14.628  1.00 20.00           C
ATOM    115  O   TRP A  17      17.012  18.729  14.143  1.00 20.00           O
ATOM    116  CB  TRP A  17      19.289  17.260  15.913  1.00 20.00           C
ATOM    117  CG  TRP A  17      19.526  18.726  16.109  1.00 20.00           C
ATOM    118  CD1 TRP A  17      20.597  19.448  15.670  1.00 20.00           C
ATOM    119  CD2 TRP A  17      18.673  19.650  16.795  1.00 20.00           C
ATOM    120  NE1 TRP A  17      20.464  20.765  16.040  1.00 20.00           N
ATOM    121  CE2 TRP A  17      19.291  20.915  16.732  1.00 20.00           C
ATOM    122  CE3 TRP A  17      17.446  19.530  17.456  1.00 20.00           C
ATOM    123  CZ2 TRP A  17      18.724  22.052  17.305  1.00 20.00           C
ATOM    124  CZ3 TRP A  17      16.885  20.660  18.024  1.00 20.00           C
ATOM    125  CH2 TRP A  17      17.524  21.905  17.945  1.00 20.00           C
ATOM    126  N   TRP A  18      16.180  16.908  15.186  1.00 20.00           N
ATOM    127  CA  TRP A  18      14.819  17.435  15.265  1.00 20.00           C
ATOM    128  C   TRP A  18      14.110  16.759  16.426  1.00 20.00           C
ATOM    129  O   TRP A  18      13.974  15.531  16.436  1.00 20.00           O
ATOM    130  CB  TRP A  18      14.066  17.203  13.955  1.00 20.00           C
ATOM    131  CG  TRP A  18      14.597  18.003  12.805  1.00 20.00           C
ATOM    132  CD1 TRP A  18      14.213  19.258  12.433  1.00 20.00           C
ATOM    133  CD2 TRP A  18      15.614  17.604  11.878  1.00 20.00           C
ATOM    134  NE1 TRP A  18      14.925  19.664  11.331  1.00 20.00           N
ATOM    135  CE2 TRP A  18      15.793  18.666  10.972  1.00 20.00           C
ATOM    136  CE3 TRP A  18      16.391  16.450  11.728  1.00 20.00           C
ATOM    137  CZ2 TRP A  18      16.715  18.611   9.928  1.00 20.00           C
ATOM    138  CZ3 TRP A  18      17.306  16.397  10.692  1.00 20.00           C
ATOM    139  CH2 TRP A  18      17.460  17.471   9.806  1.00 20.00           C
ATOM    140  N   MET A  19      13.662  17.550  17.395  1.00 20.00           N
ATOM    141  CA  MET A  19      12.988  17.043  18.577  1.00 20.00           C
ATOM    142  C   MET A  19      11.475  17.191  18.417  1.00 20.00           C
ATOM    143  O   MET A  19      10.971  17.571  17.355  1.00 20.00           O
ATOM    144  CB  MET A  19      13.502  17.768  19.822  1.00 20.00           C
ATOM    145  CG  MET A  19      13.189  19.255  19.846  1.00 20.00           C
ATOM    146  SD  MET A  19      11.520  19.607  20.429  1.00 20.00           S
ATOM    147  CE  MET A  19      11.207  21.180  19.633  1.00 20.00           C
ATOM    148  N   MSE A  20      10.739  16.887  19.481  1.00 20.00           N
ATOM    149  CA  MSE A  20       9.285  16.988  19.464  1.00 20.00           C
ATOM    150  C   MSE A  20       8.814  18.257  20.165  1.00 20.00           C
ATOM    151  O   MSE A  20       7.665  18.671  20.014  1.00 20.00           O
ATOM    152  CB  MSE A  20       8.654  15.759  20.123  1.00 20.00           C
ATOM    153  CG  MSE A  20       8.899  15.661  21.620  1.00 20.00           C
ATOM    154 SE   MSE A  20       8.439  13.910  22.344  1.00 20.00          Se
ATOM    155  CE  MSE A  20      10.144  13.008  22.062  1.00 20.00           C
ATOM    156  N   GLY A  21       9.710  18.870  20.932  1.00 20.00           N
ATOM    157  CA  GLY A  21       9.413  20.089  21.662  1.00 20.00           C
ATOM    158  C   GLY A  21       9.486  19.963  23.169  1.00 20.00           C
ATOM    159  O   GLY A  21       9.470  20.991  23.861  1.00 20.00           O
ATOM    160  N   MSE A  22       9.567  18.753  23.713  1.00 20.00           N
ATOM    161  CA  MSE A  22       9.646  18.565  25.157  1.00 20.00           C
ATOM    162  C   MSE A  22      11.081  18.708  25.652  1.00 20.00           C
ATOM    163  O   MSE A  22      11.996  18.961  24.869  1.00 20.00           O
ATOM    164  CB  MSE A  22       9.087  17.197  25.551  1.00 20.00           C
ATOM    165  CG  MSE A  22       9.930  16.023  25.080  1.00 20.00           C
ATOM    166 SE   MSE A  22       9.001  14.316  25.239  1.00 20.00          Se
ATOM    167  CE  MSE A  22       8.106  14.297  23.508  1.00 20.00           C
ATOM    168  N   GLY A  23      11.271  18.543  26.959  1.00 20.00           N
ATOM    169  CA  GLY A  23      12.591  18.646  27.548  1.00 20.00           C
ATOM    170  C   GLY A  23      13.001  17.407  28.316  1.00 20.00           C
ATOM    171  O   GLY A  23      12.308  16.386  28.277  1.00 20.00           O
ATOM    172  N   GLY A  24      14.128  17.485  29.019  1.00 20.00           N
ATOM    173  CA  GLY A  24      14.607  16.358  29.793  1.00 20.00           C
ATOM    174  C   GLY A  24      15.404  15.340  29.013  1.00 20.00           C
ATOM    175  O   GLY A  24      15.538  14.198  29.465  1.00 20.00           O
ATOM    176  N   ILE A  25      15.939  15.714  27.854  1.00 20.00           N
ATOM    177  CA  ILE A  25      16.727  14.817  27.016  1.00 20.00           C
ATOM    178  C   ILE A  25      18.052  15.500  26.713  1.00 20.00           C
ATOM    179  O   ILE A  25      18.072  16.598  26.143  1.00 20.00           O
ATOM    180  CB  ILE A  25      15.997  14.449  25.713  1.00 20.00           C
ATOM    181  CG1 ILE A  25      15.655  15.710  24.918  1.00 20.00           C
ATOM    182  CG2 ILE A  25      14.741  13.645  26.014  1.00 20.00           C
ATOM    183  CD1 ILE A  25      16.786  16.207  24.043  1.00 20.00           C
ATOM    184  N   LYS A  26      19.152  14.856  27.090  1.00 20.00           N
ATOM    185  CA  LYS A  26      20.491  15.381  26.868  1.00 20.00           C
ATOM    186  C   LYS A  26      21.243  14.486  25.893  1.00 20.00           C
ATOM    187  O   LYS A  26      21.134  13.257  25.952  1.00 20.00           O
ATOM    188  CB  LYS A  26      21.266  15.488  28.184  1.00 20.00           C
ATOM    189  CG  LYS A  26      21.532  14.151  28.858  1.00 20.00           C
ATOM    190  CD  LYS A  26      22.848  13.550  28.392  1.00 20.00           C
ATOM    191  CE  LYS A  26      23.167  12.268  29.143  1.00 20.00           C
ATOM    192  NZ  LYS A  26      24.442  11.655  28.682  1.00 20.00           N
ATOM    193  N   LYS A  27      22.006  15.109  24.997  1.00 20.00           N
ATOM    194  CA  LYS A  27      22.785  14.396  23.997  1.00 20.00           C
ATOM    195  C   LYS A  27      24.190  14.976  23.935  1.00 20.00           C
ATOM    196  O   LYS A  27      24.401  16.165  24.188  1.00 20.00           O
ATOM    197  CB  LYS A  27      22.128  14.470  22.610  1.00 20.00           C
ATOM    198  CG  LYS A  27      22.049  15.873  22.030  1.00 20.00           C
ATOM    199  CD  LYS A  27      23.288  16.203  21.211  1.00 20.00           C
ATOM    200  CE  LYS A  27      23.161  17.562  20.544  1.00 20.00           C
ATOM    201  NZ  LYS A  27      24.376  17.909  19.755  1.00 20.00           N
ATOM    202  N   MET A  28      25.151  14.120  23.594  1.00 20.00           N
ATOM    203  CA  MET A  28      26.549  14.507  23.488  1.00 20.00           C
ATOM    204  C   MET A  28      27.105  14.035  22.151  1.00 20.00           C
ATOM    205  O   MET A  28      26.448  13.313  21.396  1.00 20.00           O
ATOM    206  CB  MET A  28      27.380  13.932  24.645  1.00 20.00           C
ATOM    207  CG  MET A  28      27.456  12.414  24.663  1.00 20.00           C
ATOM    208  SD  MET A  28      28.715  11.767  23.546  1.00 20.00           S
ATOM    209  CE  MET A  28      28.057  10.136  23.203  1.00 20.00           C
ATOM    210  N   LYS A  29      28.336  14.456  21.863  1.00 20.00           N
ATOM    211  CA  LYS A  29      29.027  14.107  20.622  1.00 20.00           C
ATOM    212  C   LYS A  29      30.446  13.675  20.979  1.00 20.00           C
ATOM    213  O   LYS A  29      31.329  14.516  21.167  1.00 20.00           O
ATOM    214  CB  LYS A  29      29.033  15.278  19.644  1.00 20.00           C
ATOM    215  CG  LYS A  29      29.808  16.494  20.128  1.00 20.00           C
ATOM    216  CD  LYS A  29      31.265  16.425  19.704  1.00 20.00           C
ATOM    217  CE  LYS A  29      32.014  17.689  20.094  1.00 20.00           C
ATOM    218  NZ  LYS A  29      33.449  17.628  19.704  1.00 20.00           N
ATOM    219  N   GLY A  30      30.661  12.366  21.070  1.00 20.00           N
ATOM    220  CA  GLY A  30      31.969  11.848  21.405  1.00 20.00           C
ATOM    221  C   GLY A  30      32.947  11.947  20.249  1.00 20.00           C
ATOM    222  O   GLY A  30      32.606  12.298  19.119  1.00 20.00           O
ATOM    223  N   TRP A  31      34.202  11.626  20.552  1.00 20.00           N
ATOM    224  CA  TRP A  31      35.261  11.681  19.556  1.00 20.00           C
ATOM    225  C   TRP A  31      35.163  10.496  18.603  1.00 20.00           C
ATOM    226  O   TRP A  31      34.931   9.359  19.022  1.00 20.00           O
ATOM    227  CB  TRP A  31      36.631  11.695  20.234  1.00 20.00           C
ATOM    228  CG  TRP A  31      36.912  10.468  21.046  1.00 20.00           C
ATOM    229  CD1 TRP A  31      36.616  10.273  22.363  1.00 20.00           C
ATOM    230  CD2 TRP A  31      37.545   9.266  20.593  1.00 20.00           C
ATOM    231  NE1 TRP A  31      37.027   9.022  22.759  1.00 20.00           N
ATOM    232  CE2 TRP A  31      37.600   8.384  21.691  1.00 20.00           C
ATOM    233  CE3 TRP A  31      38.071   8.848  19.367  1.00 20.00           C
ATOM    234  CZ2 TRP A  31      38.160   7.111  21.600  1.00 20.00           C
ATOM    235  CZ3 TRP A  31      38.627   7.585  19.278  1.00 20.00           C
ATOM    236  CH2 TRP A  31      38.667   6.731  20.388  1.00 20.00           C
ATOM    237  N   GLY A  32      35.340  10.772  17.317  1.00 20.00           N
ATOM    238  CA  GLY A  32      35.284   9.712  16.321  1.00 20.00           C
ATOM    239  C   GLY A  32      33.856   9.311  16.034  1.00 20.00           C
ATOM    240  O   GLY A  32      32.990  10.162  15.813  1.00 20.00           O
ATOM    241  N   GLY A  33      33.602   8.005  16.037  1.00 20.00           N
ATOM    242  CA  GLY A  33      32.275   7.491  15.765  1.00 20.00           C
ATOM    243  C   GLY A  33      31.508   7.117  17.016  1.00 20.00           C
ATOM    244  O   GLY A  33      30.567   6.319  16.960  1.00 20.00           O
ATOM    245  N   MSE A  34      31.900   7.685  18.151  1.00 20.00           N
ATOM    246  CA  MSE A  34      31.243   7.394  19.419  1.00 20.00           C
ATOM    247  C   MSE A  34      30.089   8.356  19.677  1.00 20.00           C
ATOM    248  O   MSE A  34      30.269   9.574  19.668  1.00 20.00           O
ATOM    249  CB  MSE A  34      32.248   7.458  20.571  1.00 20.00           C
ATOM    250  CG  MSE A  34      32.777   8.854  20.856  1.00 20.00           C
ATOM    251 SE   MSE A  34      34.331   8.843  22.035  1.00 20.00          Se
ATOM    252  CE  MSE A  34      35.730   8.647  20.691  1.00 20.00           C
ATOM    253  N   ILE A  35      28.901   7.800  19.906  1.00 20.00           N
ATOM    254  CA  ILE A  35      27.697   8.578  20.172  1.00 20.00           C
ATOM    255  C   ILE A  35      27.039   8.025  21.427  1.00 20.00           C
ATOM    256  O   ILE A  35      26.804   6.816  21.528  1.00 20.00           O
ATOM    257  CB  ILE A  35      26.715   8.541  18.985  1.00 20.00           C
ATOM    258  CG1 ILE A  35      26.323   7.099  18.656  1.00 20.00           C
ATOM    259  CG2 ILE A  35      27.323   9.220  17.767  1.00 20.00           C
ATOM    260  CD1 ILE A  35      25.187   6.567  19.501  1.00 20.00           C
ATOM    261  N   SER A  36      26.745   8.906  22.378  1.00 20.00           N
ATOM    262  CA  SER A  36      26.119   8.524  23.634  1.00 20.00           C
ATOM    263  C   SER A  36      24.636   8.872  23.616  1.00 20.00           C
ATOM    264  O   SER A  36      24.201   9.791  22.916  1.00 20.00           O
ATOM    265  CB  SER A  36      26.802   9.215  24.816  1.00 20.00           C
ATOM    266  OG  SER A  36      28.150   8.795  24.943  1.00 20.00           O
ATOM    267  N   TRP A  37      23.860   8.125  24.398  1.00 20.00           N
ATOM    268  CA  TRP A  37      22.422   8.327  24.493  1.00 20.00           C
ATOM    269  C   TRP A  37      21.991   8.204  25.946  1.00 20.00           C
ATOM    270  O   TRP A  37      22.500   7.353  26.682  1.00 20.00           O
ATOM    271  CB  TRP A  37      21.655   7.317  23.630  1.00 20.00           C
ATOM    272  CG  TRP A  37      21.869   5.892  24.038  1.00 20.00           C
ATOM    273  CD1 TRP A  37      22.845   5.049  23.590  1.00 20.00           C
ATOM    274  CD2 TRP A  37      21.092   5.140  24.977  1.00 20.00           C
ATOM    275  NE1 TRP A  37      22.723   3.821  24.192  1.00 20.00           N
ATOM    276  CE2 TRP A  37      21.653   3.849  25.047  1.00 20.00           C
ATOM    277  CE3 TRP A  37      19.974   5.432  25.764  1.00 20.00           C
ATOM    278  CZ2 TRP A  37      21.136   2.854  25.874  1.00 20.00           C
ATOM    279  CZ3 TRP A  37      19.462   4.443  26.584  1.00 20.00           C
ATOM    280  CH2 TRP A  37      20.043   3.169  26.633  1.00 20.00           C
ATOM    281  N   SER A  38      21.052   9.056  26.352  1.00 20.00           N
ATOM    282  CA  SER A  38      20.557   9.048  27.727  1.00 20.00           C
ATOM    283  C   SER A  38      19.151   9.631  27.725  1.00 20.00           C
ATOM    284  O   SER A  38      18.982  10.833  27.499  1.00 20.00           O
ATOM    285  CB  SER A  38      21.483   9.840  28.642  1.00 20.00           C
ATOM    286  OG  SER A  38      22.763   9.238  28.717  1.00 20.00           O
ATOM    287  N   TRP A  39      18.154   8.785  27.975  1.00 20.00           N
ATOM    288  CA  TRP A  39      16.762   9.204  28.004  1.00 20.00           C
ATOM    289  C   TRP A  39      16.080   8.624  29.234  1.00 20.00           C
ATOM    290  O   TRP A  39      16.558   7.663  29.843  1.00 20.00           O
ATOM    291  CB  TRP A  39      16.015   8.771  26.733  1.00 20.00           C
ATOM    292  CG  TRP A  39      14.592   9.239  26.683  1.00 20.00           C
ATOM    293  CD1 TRP A  39      13.475   8.495  26.932  1.00 20.00           C
ATOM    294  CD2 TRP A  39      14.131  10.558  26.363  1.00 20.00           C
ATOM    295  NE1 TRP A  39      12.349   9.269  26.788  1.00 20.00           N
ATOM    296  CE2 TRP A  39      12.725  10.539  26.439  1.00 20.00           C
ATOM    297  CE3 TRP A  39      14.773  11.753  26.022  1.00 20.00           C
ATOM    298  CZ2 TRP A  39      11.948  11.668  26.186  1.00 20.00           C
ATOM    299  CZ3 TRP A  39      13.999  12.872  25.769  1.00 20.00           C
ATOM    300  CH2 TRP A  39      12.603  12.822  25.853  1.00 20.00           C
ATOM    301  N   SER A  40      14.947   9.223  29.594  1.00 20.00           N
ATOM    302  CA  SER A  40      14.174   8.782  30.751  1.00 20.00           C
ATOM    303  C   SER A  40      12.720   9.167  30.536  1.00 20.00           C
ATOM    304  O   SER A  40      12.403  10.358  30.453  1.00 20.00           O
ATOM    305  CB  SER A  40      14.711   9.400  32.044  1.00 20.00           C
ATOM    306  OG  SER A  40      14.527  10.805  32.057  1.00 20.00           O
ATOM    307  N   SER A  41      11.847   8.162  30.451  1.00 20.00           N
ATOM    308  CA  SER A  41      10.412   8.355  30.237  1.00 20.00           C
ATOM    309  C   SER A  41      10.152   9.173  28.969  1.00 20.00           C
ATOM    310  O   SER A  41       9.568  10.258  28.999  1.00 20.00           O
ATOM    311  CB  SER A  41       9.753   9.003  31.461  1.00 20.00           C
ATOM    312  OG  SER A  41       9.830   8.160  32.597  1.00 20.00           O
ATOM    313  N   SER A  42      10.603   8.626  27.847  1.00 20.00           N
ATOM    314  CA  SER A  42      10.455   9.248  26.539  1.00 20.00           C
ATOM    315  C   SER A  42       9.555   8.384  25.659  1.00 20.00           C
ATOM    316  O   SER A  42       9.051   7.340  26.078  1.00 20.00           O
ATOM    317  CB  SER A  42      11.821   9.465  25.881  1.00 20.00           C
ATOM    318  OG  SER A  42      12.607  10.378  26.628  1.00 20.00           O
ATOM    319  N   GLY A  43       9.358   8.835  24.423  1.00 20.00           N
ATOM    320  CA  GLY A  43       8.527   8.114  23.479  1.00 20.00           C
ATOM    321  C   GLY A  43       9.300   7.587  22.288  1.00 20.00           C
ATOM    322  O   GLY A  43      10.473   7.222  22.413  1.00 20.00           O
ATOM    323  N   LYS A  44       8.651   7.540  21.127  1.00 20.00           N
ATOM    324  CA  LYS A  44       9.301   7.055  19.916  1.00 20.00           C
ATOM    325  C   LYS A  44      10.326   8.074  19.433  1.00 20.00           C
ATOM    326  O   LYS A  44       9.995   9.244  19.217  1.00 20.00           O
ATOM    327  CB  LYS A  44       8.261   6.782  18.833  1.00 20.00           C
ATOM    328  CG  LYS A  44       7.516   8.020  18.361  1.00 20.00           C
ATOM    329  CD  LYS A  44       8.228   8.683  17.194  1.00 20.00           C
ATOM    330  CE  LYS A  44       7.428   9.857  16.652  1.00 20.00           C
ATOM    331  NZ  LYS A  44       8.125  10.530  15.522  1.00 20.00           N
ATOM    332  N   MSE A  45      11.568   7.630  19.264  1.00 20.00           N
ATOM    333  CA  MSE A  45      12.641   8.506  18.808  1.00 20.00           C
ATOM    334  C   MSE A  45      13.400   7.886  17.640  1.00 20.00           C
ATOM    335  O   MSE A  45      13.705   6.693  17.649  1.00 20.00           O
ATOM    336  CB  MSE A  45      13.605   8.816  19.955  1.00 20.00           C
ATOM    337  CG  MSE A  45      14.419   7.622  20.429  1.00 20.00           C
ATOM    338 SE   MSE A  45      15.320   7.954  22.127  1.00 20.00          Se
ATOM    339  CE  MSE A  45      13.898   7.395  23.337  1.00 20.00           C
ATOM    340  N   TRP A  46      13.702   8.704  16.635  1.00 20.00           N
ATOM    341  CA  TRP A  46      14.425   8.252  15.456  1.00 20.00           C
ATOM    342  C   TRP A  46      15.388   9.343  15.010  1.00 20.00           C
ATOM    343  O   TRP A  46      15.245  10.514  15.371  1.00 20.00           O
ATOM    344  CB  TRP A  46      13.472   7.885  14.310  1.00 20.00           C
ATOM    345  CG  TRP A  46      12.641   9.034  13.828  1.00 20.00           C
ATOM    346  CD1 TRP A  46      11.417   9.415  14.296  1.00 20.00           C
ATOM    347  CD2 TRP A  46      12.973   9.955  12.780  1.00 20.00           C
ATOM    348  NE1 TRP A  46      10.967  10.515  13.606  1.00 20.00           N
ATOM    349  CE2 TRP A  46      11.904  10.866  12.670  1.00 20.00           C
ATOM    350  CE3 TRP A  46      14.070  10.096  11.926  1.00 20.00           C
ATOM    351  CZ2 TRP A  46      11.899  11.904  11.740  1.00 20.00           C
ATOM    352  CZ3 TRP A  46      14.065  11.127  11.003  1.00 20.00           C
ATOM    353  CH2 TRP A  46      12.986  12.017  10.918  1.00 20.00           C
ATOM    354  N   GLY A  47      16.376   8.942  14.215  1.00 20.00           N
ATOM    355  CA  GLY A  47      17.368   9.873  13.714  1.00 20.00           C
ATOM    356  C   GLY A  47      18.767   9.294  13.683  1.00 20.00           C
ATOM    357  O   GLY A  47      19.033   8.259  14.302  1.00 20.00           O
ATOM    358  N   GLY A  48      19.670   9.954  12.966  1.00 20.00           N
ATOM    359  CA  GLY A  48      21.037   9.478  12.877  1.00 20.00           C
ATOM    360  C   GLY A  48      21.826  10.297  11.875  1.00 20.00           C
ATOM    361  O   GLY A  48      21.420  11.396  11.493  1.00 20.00           O
ATOM    362  N   LYS A  49      22.960   9.741  11.459  1.00 20.00           N
ATOM    363  CA  LYS A  49      23.846  10.380  10.501  1.00 20.00           C
ATOM    364  C   LYS A  49      23.979   9.513   9.256  1.00 20.00           C
ATOM    365  O   LYS A  49      23.689   8.313   9.272  1.00 20.00           O
ATOM    366  CB  LYS A  49      25.231  10.641  11.109  1.00 20.00           C
ATOM    367  CG  LYS A  49      25.993   9.380  11.483  1.00 20.00           C
ATOM    368  CD  LYS A  49      26.842   8.884  10.324  1.00 20.00           C
ATOM    369  CE  LYS A  49      27.686   7.687  10.730  1.00 20.00           C
ATOM    370  NZ  LYS A  49      28.507   7.176   9.598  1.00 20.00           N
ATOM    371  N   GLY A  50      24.423  10.138   8.170  1.00 20.00           N
ATOM    372  CA  GLY A  50      24.601   9.443   6.909  1.00 20.00           C
ATOM    373  C   GLY A  50      25.997   9.590   6.335  1.00 20.00           C
ATOM    374  O   GLY A  50      26.809  10.362   6.844  1.00 20.00           O
TER
END
"""

def exercise(i_pdb = 0, d_min=1.0, resolution_factor = 0.25):
  #
  t = mmtbx.refinement.real_space.setup_test(
    pdb_answer        = pdb_answer,
    pdb_poor          = pdb_poor,
    i_pdb             = i_pdb,
    d_min             = d_min,
    resolution_factor = resolution_factor)
  #
  ph = t.ph_poor
  for i in [1,2]:
    result = mmtbx.refinement.real_space.fit_residues.run(
      pdb_hierarchy     = ph,
      vdw_radii         = t.vdw,
      crystal_symmetry  = t.crystal_symmetry,
      map_data          = t.target_map,
      backbone_sample   = True,
      rotatable_hd      = t.rotatable_hd,
      rotamer_manager   = t.rotamer_manager,
      sin_cos_table     = t.sin_cos_table,
      mon_lib_srv       = t.mon_lib_srv)
    ph = result.pdb_hierarchy
  result.pdb_hierarchy.write_pdb_file(file_name = "refined_%s.pdb"%str(i_pdb),
    crystal_symmetry = t.crystal_symmetry)
  #
  mmtbx.refinement.real_space.check_sites_match(
    ph_answer          = t.ph_answer,
    ph_refined         = result.pdb_hierarchy,
    exclude_atom_names = ["CE1","CE2","CD1","CD2"],
    tol                = 0.4)

if(__name__ == "__main__"):
  t0 = time.time()
  exercise()
  print("Time: %6.4f"%(time.time()-t0))
