/*
 * Copyright (C) 2003  Robert Collins  <robertc@squid-cache.org>
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * DO NOT ALTER THE NEXT LINE
 * arch-tag: 41f3bca9-1123-45d3-b2b6-4c79772f7a42
 * 
 */

#include "ConfigEntry.h"

using namespace std;


/* ConfigEntry */
ConfigEntry::ConfigEntry(string const &aPath, ConfigSource *aSource) : thePath(aPath), theSource(aSource)
{}

ConfigEntry::ConfigEntry(ConfigEntry const &rhs) : thePath(rhs.thePath), theSource(rhs.theSource)
{}

ConfigEntry &
ConfigEntry::operator=(ConfigEntry const &rhs)
{
    thePath = rhs.thePath;
    theSource = rhs.theSource;
}


ConfigSource const *
ConfigEntry::source()
{
    return theSource;
}

void
ConfigEntry::path(string const &aPath)
{
    thePath = aPath;
}

string const &
ConfigEntry::path() const
{
    return thePath;
}
