struct cpuinfo_mock_file filesystem[] = {
	{
		.path = "/proc/cpuinfo",
		.size = 551,
		.content =
			"Processor\t: ARMv7 Processor rev 5 (v7l)\n"
			"processor\t: 0\n"
			"BogoMIPS\t: 12.80\n"
			"\n"
			"processor\t: 1\n"
			"BogoMIPS\t: 12.80\n"
			"\n"
			"processor\t: 2\n"
			"BogoMIPS\t: 12.80\n"
			"\n"
			"processor\t: 3\n"
			"BogoMIPS\t: 12.80\n"
			"\n"
			"processor\t: 4\n"
			"BogoMIPS\t: 38.40\n"
			"\n"
			"processor\t: 5\n"
			"BogoMIPS\t: 38.40\n"
			"\n"
			"processor\t: 6\n"
			"BogoMIPS\t: 38.40\n"
			"\n"
			"processor\t: 7\n"
			"BogoMIPS\t: 38.40\n"
			"\n"
			"Features\t: swp half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt \n"
			"CPU implementer\t: 0x41\n"
			"CPU architecture: 7\n"
			"CPU variant\t: 0x0 & 0x3\n"
			"CPU part\t: 0xc07 & 0xc0f\n"
			"CPU revision\t: 5 & 3\n"
			"\n"
			"Hardware\t: Kirin920\n"
			"Revision\t: 0000\n"
			"Serial\t\t: 0000000000000000\n",
	},
	{
		.path = "/system/build.prop",
		.size = 7145,
		.content =
			"# begin build properties\n"
			"# autogenerated by buildinfo.sh\n"
			"ro.build.version.sdk=19\n"
			"ro.build.version.codename=REL\n"
			"ro.build.version.release=4.4.2\n"
			"ro.build.date=Tue May 19 03:15:00 CST 2015\n"
			"ro.build.date.utc=1431976500\n"
			"ro.build.type=user\n"
			"ro.build.user=jenkins\n"
			"ro.build.host=shacidculx1384\n"
			"ro.product.cpu.abi=armeabi-v7a\n"
			"ro.product.cpu.abi2=armeabi\n"
			"ro.product.manufacturer=HUAWEI\n"
			"ro.product.locale.language=zh\n"
			"ro.product.locale.region=CN\n"
			"ro.wifi.channels=\n"
			"ro.board.platform=hi3630\n"
			"# ro.build.product is obsolete; use ro.product.device\n"
			"ro.build.product=hi3630\n"
			"# Do not try to parse ro.build.description or .fingerprint\n"
			"ro.build.description=hi3630-user 4.4.2 KOT49H eng.jenkins.20150519.031301 test-keys\n"
			"ro.build.characteristics=default\n"
			"ro.build.hide=false\n"
			"# end build properties\n"
			"#\n"
			"# from device/hisi/hi3630/system.prop\n"
			"#\n"
			"ro.config.mmu_en=1\n"
			"debug.hwc_dump_en=1\n"
			"ro.config.hw_sensorhub=true\n"
			"ro.opengles.version=196608\n"
			"persist.sys.thermal=false\n"
			"persist.sys.strictmode.disable=true\n"
			"ro.sf.lcd_density=480\n"
			"hw.lcd.density=480\n"
			"hw.lcd.density.scale=500\n"
			"dalvik.vm.checkjni=false\n"
			"af.resampler.quality=3\n"
			"af.resampler.quality=4\n"
			"ro.bt.bdaddr_path=/data/misc/bluedroid/macbt\n"
			"ro.config.keypasstouser=true\n"
			"ro.audio.flinger_standbytime_ms=10000\n"
			"persist.sys.wfd.sound=false\n"
			"ro.hwui.texture_cache_size=72\n"
			"ro.hwui.texture_cache_flushrate=0.4\n"
			"ro.hwui.layer_cache_size=48\n"
			"ro.hwui.path_cache_size=32\n"
			"ro.hwui.shape_cache_size=2\n"
			"ro.hwui.drop_shadow_cache_size=6\n"
			"ro.hwui.gradient_cache_size=1\n"
			"ro.hwui.text_large_cache_height=1024\n"
			"ro.hwui.text_large_cache_width=2048\n"
			"ro.hwui.text_small_cache_height=1024\n"
			"ro.hwui.text_small_cache_width=1024\n"
			"ro.hwui.r_buffer_cache_size=8\n"
			"ro.product.platform.pseudonym=1ARB9CV\n"
			"ro.config.hw_navigationbar=true\n"
			"persist.sys.hdcp_checking=always\n"
			"persist.sys.hispeed_freq=1209600\n"
			"persist.sys.hmp_boost_up=871\n"
			"persist.sys.hmp_boost_down=448\n"
			"persist.sys.hmp_default_up=978\n"
			"persist.sys.hmp_default_down=512\n"
			"ro.config.hw_testingsettings=true\n"
			"ro.config.hw_emerg=on\n"
			"ro.config.showBatteryCharge=true\n"
			"\n"
			"#\n"
			"# ADDITIONAL_BUILD_PROPERTIES\n"
			"#\n"
			"ro.adb.secure=1\n"
			"ro.com.android.dateformat=MM-dd-yyyy\n"
			"ro.config.ringtone=Huawei_Tune.ogg\n"
			"ro.config.notification_sound=Glory.ogg\n"
			"ro.carrier=unknown\n"
			"ro.config.alarm_alert=Pmukkale.ogg\n"
			"ro.setupwizard.mode=OPTIONAL\n"
			"ro.com.google.gmsversion=4.4.2_r5\n"
			"dalvik.vm.heapstartsize=8m\n"
			"dalvik.vm.heapgrowthlimit=192m\n"
			"dalvik.vm.heapsize=512m\n"
			"dalvik.vm.heaptargetutilization=0.75\n"
			"dalvik.vm.heapminfree=2m\n"
			"dalvik.vm.heapmaxfree=8m\n"
			"persist.sys.dalvik.vm.lib=libdvm.so\n"
			"net.bt.name=Android\n"
			"dalvik.vm.stack-trace-file=/data/anr/traces.txt\n"
			"ro.build.tag_id.system=tag_K3V300R001C00B272SP05\n"
			"ro.build.tag_time.system=2014-08-13-0659\n"
			"ro.build.push_time.system=\n"
			"ro.build.update.settings_info=B272SP05_p2957\n"
			"\n"
			"ro.config.hw_dolby=false\n"
			"audioril.lib=libhuawei-audio-ril.so\n"
			"ro.config.fm_type=libbcmfm_if\n"
			"persist.sys.strictmode.visual=false\n"
			"install.frobidden=false\n"
			"ro.config.hspap_hsdpa_open=1\n"
			"ro.camera.sound.forced=1\n"
			"keyguard.no_require_sim=true\n"
			"ro.config.widevine_level3=true\n"
			"ro.cellbroadcast.emergencyids=0-65534\n"
			"ro.config.hw_flashless=true\n"
			"ro.config.modem_hsic=true\n"
			"ro.config.hw_addsettingsdbex=1\n"
			"ro.config.hw_toolbox=true\n"
			"ro.config.fast_dormancy=false\n"
			"ro.config.hwtheme=1\n"
			"ro.config.hw_gcf=false\n"
			"ro.config.hw_proximity=true\n"
			"ro.config.hw_lockscreen=true\n"
			"ro.config.hw_menu_unlockscreen=false\n"
			"ro.config.helix_enable=true\n"
			"ro.config.hwft_PinPukUnlockscr=true\n"
			"ro.config.hw_always_allow_mms=false\n"
			"ro.config.hw_vcardBase64=true\n"
			"ro.config.hw_ecclist_withcard=1+110,6+119,8+118\n"
			"ro.config.hw_ecclist_nocard=1+110,6+119,8+118\n"
			"ro.config.hw_globalEcc=true\n"
			"ro.config.hw_allow_ums_and_mtp=true\n"
			"ro.config.incall_notify_mms=true\n"
			"ro.config.hw_useCtrlSocket=true\n"
			"persist.radio.apm_sim_not_pwdn=1\n"
			"ro.config.AM_PM_STYLE=1\n"
			"ro.config.hw_battery_percent=true\n"
			"persist.sys.powerup_reason=\n"
			"ro.poweroff_alarm=true\n"
			"persist.sys.actualpoweron=true\n"
			"ro.config.hw_show_number=false\n"
			"ro.config.hw_support_ipcall=true\n"
			"ro.config.bg_call_twinking=true\n"
			"ro.config.hw_power_saving=true\n"
			"ro.config.hwft_emerCallDefNum=\"\"\n"
			"ro.config.hw_proximitySensor=true\n"
			"ro.config.always_animation=true\n"
			"ro.config.hw_RemindWifiToPdp=false\n"
			"ro.config.app_big_icon_size=180\n"
			"ro.config.do_sdcard_upgrade=true\n"
			"ro.ril.ecclist=112,911,#911,*911\n"
			"ro.config.disablesmbacklinght=true\n"
			"persist.alarm.enable.uhb=0\n"
			"ro.config.hw_rightsmgr=1\n"
			"persist.sys.phb.enable=1\n"
			"persist.sys.phb.debug.enable=1\n"
			"ro.ads.bootanim=true\n"
			"ro.config.hw.logsystem.send=0\n"
			"ro.config.hw_enable_merge=true\n"
			"ro.config.themecolor=true\n"
			"ro.config.hw_subtitle_support=true\n"
			"ro.config.hide_sipcall=true\n"
			"modify_ram_show=true\n"
			"ro.config.hw_hightLight=true\n"
			"ro.config.hw_hightLightValue=200\n"
			"persist.sys.alarm.enable.uhb=1\n"
			"ro.config.hw_GSensorOptimize=true\n"
			"ro.config.hw_omacp=1\n"
			"ro.config.hw_use_browser_ua=http://wap1.huawei.com/uaprof/HUAWEI_P6_U06_UAProfile.xml\n"
			"ro.com.google.clientidbase=android-huawei\n"
			"ro.config.hw_enable_preset_num=false\n"
			"ro.config.hw_voicerecord=false\n"
			"ro.config.hw_multiscreen=true\n"
			"ro.config.hwscope=true\n"
			"ro.config.hw.VIS=true\n"
			"ro.config.hw_RemindWifiToPdp=false\n"
			"ro.config.hw_glovemode_enabled=1\n"
			"ro.product.only_2Gnetwork=true\n"
			"ro.config.hw_shownavisettings=false\n"
			"ro.config.hw_custverdisplay=true\n"
			"ro.modem.type=6260\n"
			"ro.config.rebootAfterUnlockPUK=true\n"
			"ro.config.protocol_errors=false\n"
			"ro.product.ft.rtspeos=true\n"
			"ro.config.hw_vdf_fastdormancy=true\n"
			"ro.config.hw_ReduceSAR=true\n"
			"ro.config.hw_ReduceSARParam=vdf\n"
			"ro.config.delay_send_signal=true\n"
			"ro.config.hw_delapchannel=true\n"
			"ro.config.hw_dts=true\n"
			"ro.config.switchPrimaryVolume=true\n"
			"ril.modem.timedwait_cpstate=60\n"
			"ro.config.isNeedApList=false\n"
			"ro.config.SupportSdcard=true\n"
			"ro.config.hw_singlehand=2\n"
			"ro.config.enable.telecom_epush=false\n"
			"ro.build.hide.matchers=H60-L01;H60-L02;H60-L03;H60-L11;H60-L12;Huawei;Mali-T624\n"
			"ro.build.hide.replacements=H300;H300;H300;H300;H300;Unknown;Unknown\n"
			"ro.config.hw_show_alert_dialog=true\n"
			"ro.config.hw_wirenetcontrol=true\n"
			"sys.refresh.dirty=1\n"
			"ro.config.hw_nlp=com.baidu.map.location\n"
			"ro.cust.cdrom=/cust/preinstalled/public/cdrom/autorun.iso\n"
			"ro.config.hw_wifitrafc=true\n"
			"ro.config.conn_diagnose=true\n"
			"persist.hw.power.shutdown=1\n"
			"ro.config.hw.security_volume=10\n"
			"ro.config.overlay_path=/vendor/overlay/app/HD4X5/\n"
			"ro.config.gpstype=tlg\n"
			"ro.config.support_ca=false\n"
			"ro.config.cpu_info_display=Hisilicon Kirin 920\n"
			"ro.config.toolbox_port_column=4\n"
			"ro.config.toolbox_port_row=3\n"
			"ro.config.toolbox_land_column=8\n"
			"ro.config.toolbox_land_row=2\n"
			"ro.config.hw_privacymode=true\n"
			"ro.config.ROG=true\n"
			"ro.config.colorTemperature_K3=true\n"
			"ro.config.readBtAddress=true\n"
			"ro.config.wifiManager_k3=true\n"
			"ro.config.hw_noti_expand=true\n"
			"ro.config.hw_touchplus_enabled=true\n"
			"ro.config.huawei_smallwindow=573,260,1069,1337\n"
			"ro.config.disable_tapandpay=true\n"
			"ro.config.norog.mulan_emui3_0=0\n"
			"ro.networkstatus.delaytimer=20\n"
			"\n"
			"ro.confg.hw_systemversion=H60-L02V100R001CHNC00B316_SYSTEM\n"
			"\n"
			"ro.product.board=H60-L02\n"
			"\n"
			"ro.product.brand=Huawei\n"
			"\n"
			"ro.product.name=H60-L02\n"
			"\n"
			"ro.product.device=hwH60\n"
			"\n"
			"ro.product.model=H60-L02\n"
			"\n"
			"ro.build.display.id=H60-L02V100R001CHNC00B316\n"
			"\n"
			"ro.build.tags=ota-rel-keys,release-keys\n"
			"\n"
			"ro.build.id=HDH60-L02\n"
			"\n"
			"ro.build.version.incremental=CHNC00B316\n"
			"\n"
			"ro.build.version.emui=EmotionUI_3.0\n"
			"\n"
			"ro.build.fingerprint=Huawei/H60-L02/hwH60:4.4.2/HDH60-L02/CHNC00B316:user/ota-rel-keys,release-keys\n"
			"\n"
			"ro.hardware.alter=Kirin920\n",
	},
	{
		.path = "/sys/devices/system/cpu/kernel_max",
		.size = 2,
		.content = "7\n",
	},
	{
		.path = "/sys/devices/system/cpu/possible",
		.size = 4,
		.content = "0-7\n",
	},
	{
		.path = "/sys/devices/system/cpu/present",
		.size = 4,
		.content = "0-7\n",
	},
	{
		.path = "/sys/devices/system/cpu/online",
		.size = 4,
		.content = "0-7\n",
	},
	{
		.path = "/sys/devices/system/cpu/offline",
		.size = 1,
		.content = "\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_driver",
		.size = 12,
		.content = "little_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_governor_ro",
		.size = 5,
		.content = "menu\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpuidle/driver/name",
		.size = 12,
		.content = "little_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1305600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "403200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_frequencies",
		.size = 46,
		.content = "403200 604800 806400 1017600 1209600 1305600 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_governors",
		.size = 67,
		.content = "interactive conservative ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "403200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_driver",
		.size = 15,
		.content = "arm-big-little\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_max_freq",
		.size = 8,
		.content = "1209600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "403200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/time_in_state",
		.size = 74,
		.content =
			"403200 33253\n"
			"604800 313\n"
			"806400 307\n"
			"1017600 386\n"
			"1209600 12625\n"
			"1305600 1894\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/total_trans",
		.size = 4,
		.content = "588\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings",
		.size = 3,
		.content = "0f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/physical_package_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings",
		.size = 3,
		.content = "01\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings_list",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpuidle/driver/name",
		.size = 12,
		.content = "little_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1305600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "403200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_frequencies",
		.size = 46,
		.content = "403200 604800 806400 1017600 1209600 1305600 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_governors",
		.size = 67,
		.content = "interactive conservative ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "403200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_driver",
		.size = 15,
		.content = "arm-big-little\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_max_freq",
		.size = 8,
		.content = "1209600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "403200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/time_in_state",
		.size = 74,
		.content =
			"403200 33498\n"
			"604800 315\n"
			"806400 307\n"
			"1017600 386\n"
			"1209600 12635\n"
			"1305600 1894\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/total_trans",
		.size = 4,
		.content = "591\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings",
		.size = 3,
		.content = "0f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/physical_package_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings",
		.size = 3,
		.content = "02\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings_list",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpuidle/driver/name",
		.size = 12,
		.content = "little_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1305600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "403200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_available_frequencies",
		.size = 46,
		.content = "403200 604800 806400 1017600 1209600 1305600 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_available_governors",
		.size = 67,
		.content = "interactive conservative ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "403200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_driver",
		.size = 15,
		.content = "arm-big-little\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_max_freq",
		.size = 8,
		.content = "1209600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "403200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/time_in_state",
		.size = 74,
		.content =
			"403200 33727\n"
			"604800 315\n"
			"806400 307\n"
			"1017600 386\n"
			"1209600 12645\n"
			"1305600 1894\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/total_trans",
		.size = 4,
		.content = "593\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_id",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_siblings",
		.size = 3,
		.content = "0f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/physical_package_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/thread_siblings",
		.size = 3,
		.content = "04\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/thread_siblings_list",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpuidle/driver/name",
		.size = 12,
		.content = "little_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1305600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "403200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_available_frequencies",
		.size = 46,
		.content = "403200 604800 806400 1017600 1209600 1305600 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_available_governors",
		.size = 67,
		.content = "interactive conservative ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "403200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_driver",
		.size = 15,
		.content = "arm-big-little\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_max_freq",
		.size = 8,
		.content = "1209600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "403200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/stats/time_in_state",
		.size = 74,
		.content =
			"403200 33974\n"
			"604800 315\n"
			"806400 307\n"
			"1017600 386\n"
			"1209600 12645\n"
			"1305600 1894\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/stats/total_trans",
		.size = 4,
		.content = "593\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_id",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_siblings",
		.size = 3,
		.content = "0f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/physical_package_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/thread_siblings",
		.size = 3,
		.content = "08\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/thread_siblings_list",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpuidle/driver/name",
		.size = 9,
		.content = "big_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/affected_cpus",
		.size = 8,
		.content = "4 5 6 7\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1708800\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "806400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/related_cpus",
		.size = 8,
		.content = "4 5 6 7\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/scaling_available_frequencies",
		.size = 48,
		.content = "806400 1017600 1209600 1382400 1497600 1708800 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/scaling_available_governors",
		.size = 67,
		.content = "interactive conservative ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "806400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/scaling_driver",
		.size = 15,
		.content = "arm-big-little\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/scaling_governor",
		.size = 9,
		.content = "ondemand\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/scaling_max_freq",
		.size = 7,
		.content = "806400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "806400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/stats/time_in_state",
		.size = 67,
		.content =
			"806400 47983\n"
			"1017600 3\n"
			"1209600 13\n"
			"1382400 8\n"
			"1497600 7\n"
			"1708800 1760\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/stats/total_trans",
		.size = 3,
		.content = "56\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/topology/core_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/topology/core_siblings",
		.size = 3,
		.content = "f0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/topology/core_siblings_list",
		.size = 4,
		.content = "4-7\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/topology/thread_siblings",
		.size = 3,
		.content = "10\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/topology/thread_siblings_list",
		.size = 2,
		.content = "4\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpuidle/driver/name",
		.size = 9,
		.content = "big_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/affected_cpus",
		.size = 8,
		.content = "4 5 6 7\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1708800\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "806400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/related_cpus",
		.size = 8,
		.content = "4 5 6 7\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/scaling_available_frequencies",
		.size = 48,
		.content = "806400 1017600 1209600 1382400 1497600 1708800 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/scaling_available_governors",
		.size = 67,
		.content = "interactive conservative ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "806400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/scaling_driver",
		.size = 15,
		.content = "arm-big-little\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/scaling_governor",
		.size = 9,
		.content = "ondemand\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/scaling_max_freq",
		.size = 7,
		.content = "806400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "806400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/stats/time_in_state",
		.size = 67,
		.content =
			"806400 48237\n"
			"1017600 3\n"
			"1209600 13\n"
			"1382400 8\n"
			"1497600 7\n"
			"1708800 1760\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/stats/total_trans",
		.size = 3,
		.content = "56\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/topology/core_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/topology/core_siblings",
		.size = 3,
		.content = "f0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/topology/core_siblings_list",
		.size = 4,
		.content = "4-7\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/topology/thread_siblings",
		.size = 3,
		.content = "20\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/topology/thread_siblings_list",
		.size = 2,
		.content = "5\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu6/cpuidle/driver/name",
		.size = 9,
		.content = "big_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu6/cpufreq/affected_cpus",
		.size = 8,
		.content = "4 5 6 7\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu6/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1708800\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu6/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "806400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu6/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu6/cpufreq/related_cpus",
		.size = 8,
		.content = "4 5 6 7\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu6/cpufreq/scaling_available_frequencies",
		.size = 48,
		.content = "806400 1017600 1209600 1382400 1497600 1708800 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu6/cpufreq/scaling_available_governors",
		.size = 67,
		.content = "interactive conservative ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu6/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "806400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu6/cpufreq/scaling_driver",
		.size = 15,
		.content = "arm-big-little\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu6/cpufreq/scaling_governor",
		.size = 9,
		.content = "ondemand\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu6/cpufreq/scaling_max_freq",
		.size = 7,
		.content = "806400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu6/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "806400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu6/cpufreq/stats/time_in_state",
		.size = 67,
		.content =
			"806400 48504\n"
			"1017600 3\n"
			"1209600 13\n"
			"1382400 8\n"
			"1497600 7\n"
			"1708800 1760\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu6/cpufreq/stats/total_trans",
		.size = 3,
		.content = "56\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu6/topology/core_id",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu6/topology/core_siblings",
		.size = 3,
		.content = "f0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu6/topology/core_siblings_list",
		.size = 4,
		.content = "4-7\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu6/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu6/topology/thread_siblings",
		.size = 3,
		.content = "40\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu6/topology/thread_siblings_list",
		.size = 2,
		.content = "6\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/cpuidle/driver/name",
		.size = 9,
		.content = "big_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/cpufreq/affected_cpus",
		.size = 8,
		.content = "4 5 6 7\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1708800\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "806400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/cpufreq/related_cpus",
		.size = 8,
		.content = "4 5 6 7\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/cpufreq/scaling_available_frequencies",
		.size = 48,
		.content = "806400 1017600 1209600 1382400 1497600 1708800 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/cpufreq/scaling_available_governors",
		.size = 67,
		.content = "interactive conservative ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "806400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/cpufreq/scaling_driver",
		.size = 15,
		.content = "arm-big-little\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/cpufreq/scaling_governor",
		.size = 9,
		.content = "ondemand\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/cpufreq/scaling_max_freq",
		.size = 7,
		.content = "806400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "806400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/cpufreq/stats/time_in_state",
		.size = 67,
		.content =
			"806400 48759\n"
			"1017600 3\n"
			"1209600 13\n"
			"1382400 8\n"
			"1497600 7\n"
			"1708800 1760\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/cpufreq/stats/total_trans",
		.size = 3,
		.content = "56\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/topology/core_id",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/topology/core_siblings",
		.size = 3,
		.content = "f0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/topology/core_siblings_list",
		.size = 4,
		.content = "4-7\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/topology/thread_siblings",
		.size = 3,
		.content = "80\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/topology/thread_siblings_list",
		.size = 2,
		.content = "7\n",
	},
	{ NULL },
};
#ifdef __ANDROID__
struct cpuinfo_mock_property properties[] = {
	{
		.key = "af.resampler.quality",
		.value = "4",
	},
	{
		.key = "androidboot.longpress",
		.value = "false",
	},
	{
		.key = "audioril.lib",
		.value = "libhuawei-audio-ril.so",
	},
	{
		.key = "dalvik.vm.checkjni",
		.value = "false",
	},
	{
		.key = "dalvik.vm.heapgrowthlimit",
		.value = "192m",
	},
	{
		.key = "dalvik.vm.heapmaxfree",
		.value = "8m",
	},
	{
		.key = "dalvik.vm.heapminfree",
		.value = "2m",
	},
	{
		.key = "dalvik.vm.heapsize",
		.value = "512m",
	},
	{
		.key = "dalvik.vm.heapstartsize",
		.value = "8m",
	},
	{
		.key = "dalvik.vm.heaptargetutilization",
		.value = "0.75",
	},
	{
		.key = "dalvik.vm.stack-trace-file",
		.value = "/data/anr/traces.txt",
	},
	{
		.key = "debug.force_rtl",
		.value = "0",
	},
	{
		.key = "debug.hwc_dump_en",
		.value = "1",
	},
	{
		.key = "dev.bootcomplete",
		.value = "1",
	},
	{
		.key = "gsm.current.phone-type",
		.value = "1,1",
	},
	{
		.key = "gsm.network.type",
		.value = "EDGE,Unknown",
	},
	{
		.key = "gsm.operator.alpha",
		.value = "null,null",
	},
	{
		.key = "gsm.operator.iso-country",
		.value = "",
	},
	{
		.key = "gsm.operator.isroaming",
		.value = "false,false",
	},
	{
		.key = "gsm.operator.numeric",
		.value = "null,null",
	},
	{
		.key = "gsm.sim.hw_atr1",
		.value = "null",
	},
	{
		.key = "gsm.sim.hw_atr",
		.value = "null",
	},
	{
		.key = "gsm.sim.num.simlock",
		.value = "-1,-1,-1",
	},
	{
		.key = "gsm.sim.state",
		.value = "ABSENT,NOT_READY",
	},
	{
		.key = "gsm.temp.defapn.state",
		.value = "true",
	},
	{
		.key = "gsm.version.baseband",
		.value = "21.232.00.00.031,21.232.00.00.031",
	},
	{
		.key = "gsm.version.ril-impl",
		.value = "android infineon balong-ril 1.0",
	},
	{
		.key = "huawei.check_root.hotapermit",
		.value = "safe",
	},
	{
		.key = "huawei.check_root.mount",
		.value = "safe",
	},
	{
		.key = "huawei.check_root.oldstate",
		.value = "safe",
	},
	{
		.key = "huawei.check_root.prop",
		.value = "safe",
	},
	{
		.key = "huawei.check_root.setids",
		.value = "safe",
	},
	{
		.key = "huawei.check_root.su",
		.value = "safe",
	},
	{
		.key = "hw.lcd.density.scale",
		.value = "500",
	},
	{
		.key = "hw.lcd.density",
		.value = "480",
	},
	{
		.key = "init.svc.adbd",
		.value = "running",
	},
	{
		.key = "init.svc.applogcat",
		.value = "stopped",
	},
	{
		.key = "init.svc.bootanim",
		.value = "stopped",
	},
	{
		.key = "init.svc.chargelogcat",
		.value = "stopped",
	},
	{
		.key = "init.svc.check_longpress",
		.value = "stopped",
	},
	{
		.key = "init.svc.check_root",
		.value = "stopped",
	},
	{
		.key = "init.svc.debuggerd",
		.value = "running",
	},
	{
		.key = "init.svc.device-monitor",
		.value = "running",
	},
	{
		.key = "init.svc.diagserver",
		.value = "running",
	},
	{
		.key = "init.svc.drm",
		.value = "running",
	},
	{
		.key = "init.svc.filebackup",
		.value = "running",
	},
	{
		.key = "init.svc.gpsd",
		.value = "running",
	},
	{
		.key = "init.svc.hdmi-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.healthd",
		.value = "running",
	},
	{
		.key = "init.svc.hw_cdma_service",
		.value = "stopped",
	},
	{
		.key = "init.svc.hw_modem_service",
		.value = "stopped",
	},
	{
		.key = "init.svc.hw_pcui_service",
		.value = "stopped",
	},
	{
		.key = "init.svc.hw_ueventd",
		.value = "running",
	},
	{
		.key = "init.svc.hwnffserver",
		.value = "running",
	},
	{
		.key = "init.svc.hwpged",
		.value = "running",
	},
	{
		.key = "init.svc.immvibed",
		.value = "stopped",
	},
	{
		.key = "init.svc.installd",
		.value = "running",
	},
	{
		.key = "init.svc.jankservice",
		.value = "running",
	},
	{
		.key = "init.svc.keystore",
		.value = "running",
	},
	{
		.key = "init.svc.kmsgcat_cp",
		.value = "stopped",
	},
	{
		.key = "init.svc.kmsglogcat",
		.value = "stopped",
	},
	{
		.key = "init.svc.logserver",
		.value = "running",
	},
	{
		.key = "init.svc.macaddr",
		.value = "stopped",
	},
	{
		.key = "init.svc.media",
		.value = "running",
	},
	{
		.key = "init.svc.netd",
		.value = "running",
	},
	{
		.key = "init.svc.oeminfo_nvm",
		.value = "running",
	},
	{
		.key = "init.svc.p2p_supplicant",
		.value = "running",
	},
	{
		.key = "init.svc.ril-daemon1",
		.value = "running",
	},
	{
		.key = "init.svc.ril-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.rillogcat",
		.value = "stopped",
	},
	{
		.key = "init.svc.servicemanager",
		.value = "running",
	},
	{
		.key = "init.svc.sleeplogcat",
		.value = "stopped",
	},
	{
		.key = "init.svc.storedefaultkey",
		.value = "stopped",
	},
	{
		.key = "init.svc.surfaceflinger",
		.value = "running",
	},
	{
		.key = "init.svc.teecd",
		.value = "running",
	},
	{
		.key = "init.svc.thermal-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.ueventd",
		.value = "running",
	},
	{
		.key = "init.svc.usbshell",
		.value = "stopped",
	},
	{
		.key = "init.svc.vold",
		.value = "running",
	},
	{
		.key = "init.svc.zygote",
		.value = "running",
	},
	{
		.key = "install.frobidden",
		.value = "false",
	},
	{
		.key = "keyguard.no_require_sim",
		.value = "true",
	},
	{
		.key = "media.LowPowerPlay",
		.value = "no",
	},
	{
		.key = "modify_ram_show",
		.value = "true",
	},
	{
		.key = "net.bt.name",
		.value = "Android",
	},
	{
		.key = "net.change",
		.value = "net.qtaguid_enabled",
	},
	{
		.key = "net.hostname",
		.value = "android-c6ebf6745991dfe5",
	},
	{
		.key = "net.qtaguid_enabled",
		.value = "1",
	},
	{
		.key = "net.tcp.buffersize.default",
		.value = "4096,87380,110208,4096,16384,110208",
	},
	{
		.key = "net.tcp.buffersize.edge",
		.value = "4093,26280,35040,4096,16384,35040",
	},
	{
		.key = "net.tcp.buffersize.evdo",
		.value = "4094,87380,262144,4096,16384,262144",
	},
	{
		.key = "net.tcp.buffersize.gprs",
		.value = "4092,8760,11680,4096,8760,11680",
	},
	{
		.key = "net.tcp.buffersize.hsdpa",
		.value = "4094,87380,262144,4096,16384,262144",
	},
	{
		.key = "net.tcp.buffersize.hspa",
		.value = "4094,87380,262144,4096,16384,262144",
	},
	{
		.key = "net.tcp.buffersize.hspap",
		.value = "4094,87380,1220608,4096,16384,1220608",
	},
	{
		.key = "net.tcp.buffersize.hsupa",
		.value = "4094,87380,262144,4096,16384,262144",
	},
	{
		.key = "net.tcp.buffersize.lte",
		.value = "524288,4194304,8388608,262144,524288,1048576",
	},
	{
		.key = "net.tcp.buffersize.umts",
		.value = "4094,87380,110208,4096,16384,110208",
	},
	{
		.key = "net.tcp.buffersize.wifi",
		.value = "524288,1048576,2097152,262144,524288,1048576",
	},
	{
		.key = "persist.alarm.enable.uhb",
		.value = "0",
	},
	{
		.key = "persist.config.hw.lca.region",
		.value = "inland",
	},
	{
		.key = "persist.dsds.enabled",
		.value = "true",
	},
	{
		.key = "persist.hw.power.shutdown",
		.value = "0",
	},
	{
		.key = "persist.radio.1sthwlauncher",
		.value = "1",
	},
	{
		.key = "persist.radio.apm_sim_not_pwdn",
		.value = "1",
	},
	{
		.key = "persist.radio.supp.notification",
		.value = "true",
	},
	{
		.key = "persist.service.tm2.tofile",
		.value = "false",
	},
	{
		.key = "persist.sys.actualpoweron",
		.value = "true",
	},
	{
		.key = "persist.sys.alarm.enable.uhb",
		.value = "1",
	},
	{
		.key = "persist.sys.country",
		.value = "US",
	},
	{
		.key = "persist.sys.dalvik.vm.lib",
		.value = "libdvm.so",
	},
	{
		.key = "persist.sys.datacrash",
		.value = "0",
	},
	{
		.key = "persist.sys.default.res.xres",
		.value = "1080",
	},
	{
		.key = "persist.sys.default.res.yres",
		.value = "1920",
	},
	{
		.key = "persist.sys.hdcp_checking",
		.value = "always",
	},
	{
		.key = "persist.sys.hispeed_freq",
		.value = "1209600",
	},
	{
		.key = "persist.sys.hmp_boost_down",
		.value = "448",
	},
	{
		.key = "persist.sys.hmp_boost_up",
		.value = "871",
	},
	{
		.key = "persist.sys.hmp_default_down",
		.value = "512",
	},
	{
		.key = "persist.sys.hmp_default_up",
		.value = "978",
	},
	{
		.key = "persist.sys.huawei.debug.on",
		.value = "0",
	},
	{
		.key = "persist.sys.language",
		.value = "en",
	},
	{
		.key = "persist.sys.localevar",
		.value = "",
	},
	{
		.key = "persist.sys.logsystem.coredump",
		.value = "off",
	},
	{
		.key = "persist.sys.logsystem.modem",
		.value = "0",
	},
	{
		.key = "persist.sys.logsystem.neversend",
		.value = "1",
	},
	{
		.key = "persist.sys.logsystem.protohint",
		.value = "0",
	},
	{
		.key = "persist.sys.phb.debug.enable",
		.value = "1",
	},
	{
		.key = "persist.sys.phb.enable",
		.value = "1",
	},
	{
		.key = "persist.sys.powersystem.enable",
		.value = "1",
	},
	{
		.key = "persist.sys.powerup_reason",
		.value = "NORMAL",
	},
	{
		.key = "persist.sys.profiler_ms",
		.value = "0",
	},
	{
		.key = "persist.sys.smart_power",
		.value = "2",
	},
	{
		.key = "persist.sys.strictmode.disable",
		.value = "true",
	},
	{
		.key = "persist.sys.strictmode.visual",
		.value = "false",
	},
	{
		.key = "persist.sys.thermal",
		.value = "false",
	},
	{
		.key = "persist.sys.timezone",
		.value = "Asia/Shanghai",
	},
	{
		.key = "persist.sys.usb.config",
		.value = "mass_storage,adb",
	},
	{
		.key = "persist.sys.wfd.sound",
		.value = "false",
	},
	{
		.key = "ril.balong_cid",
		.value = "0",
	},
	{
		.key = "ril.ecclist1",
		.value = "112,911,000,08,110,118,119,999,120,122",
	},
	{
		.key = "ril.ecclist",
		.value = "112,911,000,08,110,118,119,999,120,122",
	},
	{
		.key = "ril.hw_modem0.rssi",
		.value = "-80",
	},
	{
		.key = "ril.hw_modem1.rssi",
		.value = "-140",
	},
	{
		.key = "ril.modem.balong_nvm_server",
		.value = "true",
	},
	{
		.key = "ril.modem.timedwait_cpstate",
		.value = "60",
	},
	{
		.key = "ril.operator.numeric",
		.value = "fffff",
	},
	{
		.key = "rild.libargs1",
		.value = "-m modem1",
	},
	{
		.key = "rild.libargs",
		.value = "-m modem0",
	},
	{
		.key = "rild.libpath1",
		.value = "/system/lib/libbalong-ril.so",
	},
	{
		.key = "rild.libpath",
		.value = "/system/lib/libbalong-ril.so",
	},
	{
		.key = "rild.rild1_ready_to_start",
		.value = "true",
	},
	{
		.key = "ro.adb.secure",
		.value = "1",
	},
	{
		.key = "ro.ads.bootanim",
		.value = "true",
	},
	{
		.key = "ro.allow.mock.location",
		.value = "0",
	},
	{
		.key = "ro.audio.flinger_standbytime_ms",
		.value = "10000",
	},
	{
		.key = "ro.baseband",
		.value = "unknown",
	},
	{
		.key = "ro.board.boardid",
		.value = "407",
	},
	{
		.key = "ro.board.boardname",
		.value = "Mogolia_UL+G_V3_noNFC",
	},
	{
		.key = "ro.board.modemid",
		.value = "3fb51000",
	},
	{
		.key = "ro.board.platform",
		.value = "hi3630",
	},
	{
		.key = "ro.boardid.product",
		.value = "71424",
	},
	{
		.key = "ro.boot.serialno",
		.value = "DU2TAN1485001918",
	},
	{
		.key = "ro.bootloader",
		.value = "unknown",
	},
	{
		.key = "ro.bootmode",
		.value = "unknown",
	},
	{
		.key = "ro.bt.bdaddr_path",
		.value = "/data/misc/bluedroid/macbt",
	},
	{
		.key = "ro.build.characteristics",
		.value = "default",
	},
	{
		.key = "ro.build.date.utc",
		.value = "1431976500",
	},
	{
		.key = "ro.build.date",
		.value = "Tue May 19 03:15:00 CST 2015",
	},
	{
		.key = "ro.build.description",
		.value = "hi3630-user 4.4.2 KOT49H eng.jenkins.20150519.031301 test-keys",
	},
	{
		.key = "ro.build.display.id",
		.value = "H60-L02V100R001CHNC00B316",
	},
	{
		.key = "ro.build.fingerprint",
		.value = "Huawei/H60-L02/hwH60:4.4.2/HDH60-L02/CHNC00B316:user/ota-rel-keys,release-keys",
	},
	{
		.key = "ro.build.hide.matchers",
		.value = "H60-L01;H60-L02;H60-L03;H60-L11;H60-L12;Huawei;Mali-T624",
	},
	{
		.key = "ro.build.hide.replacements",
		.value = "H300;H300;H300;H300;H300;Unknown;Unknown",
	},
	{
		.key = "ro.build.hide",
		.value = "false",
	},
	{
		.key = "ro.build.host",
		.value = "shacidculx1384",
	},
	{
		.key = "ro.build.id",
		.value = "HDH60-L02",
	},
	{
		.key = "ro.build.product",
		.value = "hi3630",
	},
	{
		.key = "ro.build.push_time.boot",
		.value = "",
	},
	{
		.key = "ro.build.push_time.system",
		.value = "",
	},
	{
		.key = "ro.build.tag_id.boot",
		.value = "tag_K3V300R001C00B272SP05",
	},
	{
		.key = "ro.build.tag_id.system",
		.value = "tag_K3V300R001C00B272SP05",
	},
	{
		.key = "ro.build.tag_time.boot",
		.value = "2014-08-13-0659",
	},
	{
		.key = "ro.build.tag_time.system",
		.value = "2014-08-13-0659",
	},
	{
		.key = "ro.build.tags",
		.value = "ota-rel-keys,release-keys",
	},
	{
		.key = "ro.build.type",
		.value = "user",
	},
	{
		.key = "ro.build.update.settings_info",
		.value = "B272SP05_p2957",
	},
	{
		.key = "ro.build.user",
		.value = "jenkins",
	},
	{
		.key = "ro.build.version.codename",
		.value = "REL",
	},
	{
		.key = "ro.build.version.emui",
		.value = "EmotionUI_3.0",
	},
	{
		.key = "ro.build.version.incremental",
		.value = "CHNC00B316",
	},
	{
		.key = "ro.build.version.release",
		.value = "4.4.2",
	},
	{
		.key = "ro.build.version.sdk",
		.value = "19",
	},
	{
		.key = "ro.camera.sound.forced",
		.value = "1",
	},
	{
		.key = "ro.carrier",
		.value = "unknown",
	},
	{
		.key = "ro.cellbroadcast.emergencyids",
		.value = "0-65534",
	},
	{
		.key = "ro.com.android.dateformat",
		.value = "MM-dd-yyyy",
	},
	{
		.key = "ro.com.google.clientidbase",
		.value = "android-huawei",
	},
	{
		.key = "ro.com.google.gmsversion",
		.value = "4.4.2_r5",
	},
	{
		.key = "ro.confg.hw_bootversion",
		.value = "H60-L02V100R001CHNC00B316_BOOT",
	},
	{
		.key = "ro.confg.hw_fastbootversion",
		.value = "H60-L02V100R001CHNC00B316_FASTBOOT",
	},
	{
		.key = "ro.confg.hw_systemversion",
		.value = "H60-L02V100R001CHNC00B316_SYSTEM",
	},
	{
		.key = "ro.config.AM_PM_STYLE",
		.value = "1",
	},
	{
		.key = "ro.config.ROG",
		.value = "true",
	},
	{
		.key = "ro.config.RoamingNetwork",
		.value = "true",
	},
	{
		.key = "ro.config.SupportSdcard",
		.value = "true",
	},
	{
		.key = "ro.config.addAct",
		.value = "false",
	},
	{
		.key = "ro.config.alarm_alert",
		.value = "Creamy.ogg",
	},
	{
		.key = "ro.config.always_animation",
		.value = "true",
	},
	{
		.key = "ro.config.app_big_icon_size",
		.value = "180",
	},
	{
		.key = "ro.config.auth.timeout",
		.value = "true",
	},
	{
		.key = "ro.config.autoconnect.swich",
		.value = "true",
	},
	{
		.key = "ro.config.bg_call_twinking",
		.value = "true",
	},
	{
		.key = "ro.config.browser_def_hw_nav",
		.value = "true",
	},
	{
		.key = "ro.config.browser_hw_nav_switch",
		.value = "true",
	},
	{
		.key = "ro.config.calendarsound",
		.value = "Step.ogg",
	},
	{
		.key = "ro.config.callrecord.enabled",
		.value = "1",
	},
	{
		.key = "ro.config.callwait_vibrator",
		.value = "true",
	},
	{
		.key = "ro.config.cmccCustmccmnc",
		.value = "true",
	},
	{
		.key = "ro.config.cmcc_forbidden_net",
		.value = "true",
	},
	{
		.key = "ro.config.cmdm_apn_not_display",
		.value = "true",
	},
	{
		.key = "ro.config.colorTemperature_K3",
		.value = "true",
	},
	{
		.key = "ro.config.compatibility_enable",
		.value = "1",
	},
	{
		.key = "ro.config.conn_diagnose",
		.value = "true",
	},
	{
		.key = "ro.config.cpu_info_display",
		.value = "Hisilicon Kirin 920",
	},
	{
		.key = "ro.config.delay_alarm_in_call",
		.value = "true",
	},
	{
		.key = "ro.config.delay_send_signal",
		.value = "true",
	},
	{
		.key = "ro.config.devicecolor",
		.value = "white",
	},
	{
		.key = "ro.config.disable_tapandpay",
		.value = "true",
	},
	{
		.key = "ro.config.disablesmbacklinght",
		.value = "true",
	},
	{
		.key = "ro.config.do_sdcard_upgrade",
		.value = "true",
	},
	{
		.key = "ro.config.ds_verbose_log_on",
		.value = "true",
	},
	{
		.key = "ro.config.dsds_mode",
		.value = "umts_gsm",
	},
	{
		.key = "ro.config.emailsound",
		.value = "Letter.ogg",
	},
	{
		.key = "ro.config.enable.telecom_epush",
		.value = "false",
	},
	{
		.key = "ro.config.fast_dormancy",
		.value = "false",
	},
	{
		.key = "ro.config.fm_type",
		.value = "libbcmfm_if",
	},
	{
		.key = "ro.config.gpstype",
		.value = "tlg",
	},
	{
		.key = "ro.config.helix_enable",
		.value = "true",
	},
	{
		.key = "ro.config.hide_sipcall",
		.value = "true",
	},
	{
		.key = "ro.config.hspap_hsdpa_open",
		.value = "1",
	},
	{
		.key = "ro.config.huawei_smallwindow",
		.value = "573,260,1069,1337",
	},
	{
		.key = "ro.config.hw.VIS",
		.value = "true",
	},
	{
		.key = "ro.config.hw.logsystem.send",
		.value = "0",
	},
	{
		.key = "ro.config.hw.security_volume",
		.value = "10",
	},
	{
		.key = "ro.config.hw_GSensorOptimize",
		.value = "true",
	},
	{
		.key = "ro.config.hw_ReduceSARParam",
		.value = "vdf",
	},
	{
		.key = "ro.config.hw_ReduceSAR",
		.value = "false",
	},
	{
		.key = "ro.config.hw_RemindWifiToPdp",
		.value = "true",
	},
	{
		.key = "ro.config.hw_accesscontrol",
		.value = "true",
	},
	{
		.key = "ro.config.hw_activity_state",
		.value = "true",
	},
	{
		.key = "ro.config.hw_addsettingsdbex",
		.value = "1",
	},
	{
		.key = "ro.config.hw_allow_rs_mms",
		.value = "true",
	},
	{
		.key = "ro.config.hw_allow_ums_and_mtp",
		.value = "true",
	},
	{
		.key = "ro.config.hw_always_allow_mms",
		.value = "false",
	},
	{
		.key = "ro.config.hw_battery_percent",
		.value = "true",
	},
	{
		.key = "ro.config.hw_blacklist",
		.value = "true",
	},
	{
		.key = "ro.config.hw_browser_operator",
		.value = "4",
	},
	{
		.key = "ro.config.hw_cmcc_emerg_invisi",
		.value = "1",
	},
	{
		.key = "ro.config.hw_custverdisplay",
		.value = "true",
	},
	{
		.key = "ro.config.hw_delapchannel",
		.value = "true",
	},
	{
		.key = "ro.config.hw_dolby",
		.value = "false",
	},
	{
		.key = "ro.config.hw_dsda",
		.value = "true",
	},
	{
		.key = "ro.config.hw_dts",
		.value = "true",
	},
	{
		.key = "ro.config.hw_ecclist_nocard",
		.value = "+120,+122",
	},
	{
		.key = "ro.config.hw_ecclist_withcard",
		.value = "+112",
	},
	{
		.key = "ro.config.hw_emerg",
		.value = "on",
	},
	{
		.key = "ro.config.hw_enable_merge",
		.value = "true",
	},
	{
		.key = "ro.config.hw_enable_preset_num",
		.value = "false",
	},
	{
		.key = "ro.config.hw_fake_ecc_list",
		.value = "110,120,122,999,119",
	},
	{
		.key = "ro.config.hw_flashless",
		.value = "true",
	},
	{
		.key = "ro.config.hw_gcf",
		.value = "false",
	},
	{
		.key = "ro.config.hw_globalEcc",
		.value = "false",
	},
	{
		.key = "ro.config.hw_glovemode_enabled",
		.value = "1",
	},
	{
		.key = "ro.config.hw_hightLightValue",
		.value = "200",
	},
	{
		.key = "ro.config.hw_hightLight",
		.value = "true",
	},
	{
		.key = "ro.config.hw_incall_report_on",
		.value = "true",
	},
	{
		.key = "ro.config.hw_ipv6_support",
		.value = "true",
	},
	{
		.key = "ro.config.hw_lockscreen",
		.value = "true",
	},
	{
		.key = "ro.config.hw_menu_unlockscreen",
		.value = "false",
	},
	{
		.key = "ro.config.hw_multiscreen",
		.value = "true",
	},
	{
		.key = "ro.config.hw_navigationbar",
		.value = "true",
	},
	{
		.key = "ro.config.hw_nlp",
		.value = "com.baidu.map.location",
	},
	{
		.key = "ro.config.hw_noti_expand",
		.value = "true",
	},
	{
		.key = "ro.config.hw_novoicesignal",
		.value = "true",
	},
	{
		.key = "ro.config.hw_omacp",
		.value = "1",
	},
	{
		.key = "ro.config.hw_opta",
		.value = "630",
	},
	{
		.key = "ro.config.hw_optb",
		.value = "156",
	},
	{
		.key = "ro.config.hw_power_saving",
		.value = "true",
	},
	{
		.key = "ro.config.hw_privacymode",
		.value = "true",
	},
	{
		.key = "ro.config.hw_proximitySensor",
		.value = "true",
	},
	{
		.key = "ro.config.hw_proximity",
		.value = "true",
	},
	{
		.key = "ro.config.hw_rightsmgr",
		.value = "1",
	},
	{
		.key = "ro.config.hw_sensorhub",
		.value = "true",
	},
	{
		.key = "ro.config.hw_showTestInfo",
		.value = "false",
	},
	{
		.key = "ro.config.hw_show_alert_dialog",
		.value = "true",
	},
	{
		.key = "ro.config.hw_show_number",
		.value = "false",
	},
	{
		.key = "ro.config.hw_shownavisettings",
		.value = "false",
	},
	{
		.key = "ro.config.hw_sim2airplane",
		.value = "true",
	},
	{
		.key = "ro.config.hw_simpleui_enable",
		.value = "1",
	},
	{
		.key = "ro.config.hw_singlehand",
		.value = "2",
	},
	{
		.key = "ro.config.hw_smartcardservice",
		.value = "true",
	},
	{
		.key = "ro.config.hw_subtitle_support",
		.value = "true",
	},
	{
		.key = "ro.config.hw_support_callbar",
		.value = "true",
	},
	{
		.key = "ro.config.hw_support_ipcall",
		.value = "true",
	},
	{
		.key = "ro.config.hw_testingsettings",
		.value = "true",
	},
	{
		.key = "ro.config.hw_toolbox",
		.value = "true",
	},
	{
		.key = "ro.config.hw_touchplus_enabled",
		.value = "true",
	},
	{
		.key = "ro.config.hw_upload_cp_log",
		.value = "true",
	},
	{
		.key = "ro.config.hw_useCtrlSocket",
		.value = "true",
	},
	{
		.key = "ro.config.hw_use_browser_ua",
		.value = "http://wap1.huawei.com/uaprof/HUAWEI_H60_L02_UAProfile.xml",
	},
	{
		.key = "ro.config.hw_vcardBase64",
		.value = "true",
	},
	{
		.key = "ro.config.hw_vdf_fastdormancy",
		.value = "true",
	},
	{
		.key = "ro.config.hw_virtual_key",
		.value = "true",
	},
	{
		.key = "ro.config.hw_voicerecord",
		.value = "true",
	},
	{
		.key = "ro.config.hw_wifi_frequency",
		.value = "0",
	},
	{
		.key = "ro.config.hw_wifitrafc",
		.value = "true",
	},
	{
		.key = "ro.config.hw_wirenetcontrol",
		.value = "true",
	},
	{
		.key = "ro.config.hwft_PinPukUnlockscr",
		.value = "true",
	},
	{
		.key = "ro.config.hwft_emerCallDefNum",
		.value = "\"\"",
	},
	{
		.key = "ro.config.hwscope",
		.value = "true",
	},
	{
		.key = "ro.config.hwtheme",
		.value = "1",
	},
	{
		.key = "ro.config.incall_notify_mms",
		.value = "true",
	},
	{
		.key = "ro.config.isNeedApList",
		.value = "false",
	},
	{
		.key = "ro.config.keypasstouser",
		.value = "true",
	},
	{
		.key = "ro.config.launcher_matchcard",
		.value = "0",
	},
	{
		.key = "ro.config.messagesound",
		.value = "Whisper.ogg",
	},
	{
		.key = "ro.config.mmu_en",
		.value = "1",
	},
	{
		.key = "ro.config.modem_hsic",
		.value = "true",
	},
	{
		.key = "ro.config.networkmodeset",
		.value = "true",
	},
	{
		.key = "ro.config.norog.mulan_emui3_0",
		.value = "0",
	},
	{
		.key = "ro.config.notification_sound",
		.value = "Bongo.ogg",
	},
	{
		.key = "ro.config.overlay_path",
		.value = "/vendor/overlay/app/HD4X5/",
	},
	{
		.key = "ro.config.protocol_errors",
		.value = "false",
	},
	{
		.key = "ro.config.readBtAddress",
		.value = "true",
	},
	{
		.key = "ro.config.rebootAfterUnlockPUK",
		.value = "true",
	},
	{
		.key = "ro.config.ringtone2",
		.value = "Huawei_Tune.ogg",
	},
	{
		.key = "ro.config.ringtone",
		.value = "Honor.ogg",
	},
	{
		.key = "ro.config.show2846",
		.value = "true",
	},
	{
		.key = "ro.config.showBatteryCharge",
		.value = "true",
	},
	{
		.key = "ro.config.sprd_refresh_rsp",
		.value = "true",
	},
	{
		.key = "ro.config.support_ca",
		.value = "false",
	},
	{
		.key = "ro.config.switchPrimaryVolume",
		.value = "true",
	},
	{
		.key = "ro.config.themecolor",
		.value = "true",
	},
	{
		.key = "ro.config.toolbox_land_column",
		.value = "8",
	},
	{
		.key = "ro.config.toolbox_land_row",
		.value = "2",
	},
	{
		.key = "ro.config.toolbox_port_column",
		.value = "4",
	},
	{
		.key = "ro.config.toolbox_port_row",
		.value = "3",
	},
	{
		.key = "ro.config.updatelocation",
		.value = "true",
	},
	{
		.key = "ro.config.widevine_level3",
		.value = "true",
	},
	{
		.key = "ro.config.wifiManager_k3",
		.value = "true",
	},
	{
		.key = "ro.crypto.fuse_sdcard",
		.value = "true",
	},
	{
		.key = "ro.crypto.state",
		.value = "unsupported",
	},
	{
		.key = "ro.cust.cdrom",
		.value = "/cust/preinstalled/public/cdrom/autorun.iso",
	},
	{
		.key = "ro.debuggable",
		.value = "0",
	},
	{
		.key = "ro.dual.sim.phone",
		.value = "true",
	},
	{
		.key = "ro.factorytest",
		.value = "0",
	},
	{
		.key = "ro.gsm.systemui.carriericon",
		.value = "true",
	},
	{
		.key = "ro.hardware.alter",
		.value = "Kirin920",
	},
	{
		.key = "ro.hardware",
		.value = "hi3630",
	},
	{
		.key = "ro.huawei.cust.toolbox_airwifi",
		.value = "true",
	},
	{
		.key = "ro.hwcamera.sound.muteable",
		.value = "true",
	},
	{
		.key = "ro.hwui.drop_shadow_cache_size",
		.value = "6",
	},
	{
		.key = "ro.hwui.gradient_cache_size",
		.value = "1",
	},
	{
		.key = "ro.hwui.layer_cache_size",
		.value = "48",
	},
	{
		.key = "ro.hwui.path_cache_size",
		.value = "32",
	},
	{
		.key = "ro.hwui.r_buffer_cache_size",
		.value = "8",
	},
	{
		.key = "ro.hwui.shape_cache_size",
		.value = "2",
	},
	{
		.key = "ro.hwui.text_large_cache_height",
		.value = "1024",
	},
	{
		.key = "ro.hwui.text_large_cache_width",
		.value = "2048",
	},
	{
		.key = "ro.hwui.text_small_cache_height",
		.value = "1024",
	},
	{
		.key = "ro.hwui.text_small_cache_width",
		.value = "1024",
	},
	{
		.key = "ro.hwui.texture_cache_flushrate",
		.value = "0.4",
	},
	{
		.key = "ro.hwui.texture_cache_size",
		.value = "72",
	},
	{
		.key = "ro.modem.type",
		.value = "sprd",
	},
	{
		.key = "ro.multi.rild",
		.value = "true",
	},
	{
		.key = "ro.networkstatus.delaytimer",
		.value = "20",
	},
	{
		.key = "ro.opengles.version",
		.value = "196608",
	},
	{
		.key = "ro.poweroff_alarm",
		.value = "true",
	},
	{
		.key = "ro.product.CustCVersion",
		.value = "C00",
	},
	{
		.key = "ro.product.CustDVersion",
		.value = "D316",
	},
	{
		.key = "ro.product.alert_time",
		.value = "true",
	},
	{
		.key = "ro.product.board",
		.value = "H60-L02",
	},
	{
		.key = "ro.product.brand",
		.value = "Huawei",
	},
	{
		.key = "ro.product.canplaypause",
		.value = "true",
	},
	{
		.key = "ro.product.cmcc.rtspcon",
		.value = "true",
	},
	{
		.key = "ro.product.cpu.abi2",
		.value = "armeabi",
	},
	{
		.key = "ro.product.cpu.abi",
		.value = "armeabi-v7a",
	},
	{
		.key = "ro.product.cucc.rtsplive",
		.value = "true",
	},
	{
		.key = "ro.product.device",
		.value = "hwH60",
	},
	{
		.key = "ro.product.ft.rtspeos",
		.value = "true",
	},
	{
		.key = "ro.product.hardwareversion",
		.value = "HL1UH60L02M",
	},
	{
		.key = "ro.product.locale.language",
		.value = "zh",
	},
	{
		.key = "ro.product.locale.region",
		.value = "CN",
	},
	{
		.key = "ro.product.manufacturer",
		.value = "HUAWEI",
	},
	{
		.key = "ro.product.model",
		.value = "H60-L02",
	},
	{
		.key = "ro.product.name",
		.value = "H60-L02",
	},
	{
		.key = "ro.product.only_2Gnetwork",
		.value = "false",
	},
	{
		.key = "ro.product.platform.pseudonym",
		.value = "1ARB9CV",
	},
	{
		.key = "ro.product.playreq.range",
		.value = "true",
	},
	{
		.key = "ro.product.streaming.custom",
		.value = "true",
	},
	{
		.key = "ro.revision",
		.value = "0",
	},
	{
		.key = "ro.ril.ecclist",
		.value = "112,911,#911,*911",
	},
	{
		.key = "ro.runmode",
		.value = "normal",
	},
	{
		.key = "ro.runtime.firstboot",
		.value = "1521505064185",
	},
	{
		.key = "ro.secure",
		.value = "1",
	},
	{
		.key = "ro.serialno",
		.value = "DU2TAN1485001918",
	},
	{
		.key = "ro.setupwizard.mode",
		.value = "OPTIONAL",
	},
	{
		.key = "ro.sf.lcd_density",
		.value = "480",
	},
	{
		.key = "ro.systemui.mobileinoutextra",
		.value = "true",
	},
	{
		.key = "ro.telephony.default_network",
		.value = "9",
	},
	{
		.key = "ro.wifi.channels",
		.value = "",
	},
	{
		.key = "service.bootanim.exit",
		.value = "1",
	},
	{
		.key = "service.hdmi-daemon.exit",
		.value = "0",
	},
	{
		.key = "sys.boot_completed",
		.value = "1",
	},
	{
		.key = "sys.emergency.mountdata",
		.value = "0",
	},
	{
		.key = "sys.gps_provider_enabled",
		.value = "true",
	},
	{
		.key = "sys.hwsholder.count",
		.value = "0",
	},
	{
		.key = "sys.iswifihotspoton",
		.value = "false",
	},
	{
		.key = "sys.nsd.support",
		.value = "2",
	},
	{
		.key = "sys.refresh.dirty",
		.value = "1",
	},
	{
		.key = "sys.settings_global_version",
		.value = "9",
	},
	{
		.key = "sys.settings_secure_version",
		.value = "5",
	},
	{
		.key = "sys.settings_system_version",
		.value = "41",
	},
	{
		.key = "sys.settings_systemex_version",
		.value = "5",
	},
	{
		.key = "sys.show_google_nlp",
		.value = "false",
	},
	{
		.key = "sys.super_power_save",
		.value = "false",
	},
	{
		.key = "sys.sysctl.extra_free_kbytes",
		.value = "24300",
	},
	{
		.key = "sys.usb.config",
		.value = "mass_storage,adb",
	},
	{
		.key = "sys.usb.state",
		.value = "mass_storage,adb",
	},
	{
		.key = "trustedcore_sfs_property",
		.value = "1",
	},
	{
		.key = "viatel.device.asci",
		.value = "uart.0.ttyAMA",
	},
	{
		.key = "viatel.device.at",
		.value = "spi.10.ttySPI",
	},
	{
		.key = "viatel.device.data",
		.value = "spi.0.ttySPI",
	},
	{
		.key = "viatel.device.fls",
		.value = "spi.2.ttySPI",
	},
	{
		.key = "viatel.device.gps",
		.value = "spi.5.ttySPI",
	},
	{
		.key = "viatel.device.pcv",
		.value = "spi.4.ttySPI",
	},
	{
		.key = "vold.post_fs_data_done",
		.value = "1",
	},
	{
		.key = "wifi.interface",
		.value = "wlan0",
	},
	{
		.key = "wlan.driver.status",
		.value = "ok",
	},
	{ NULL },
};
#endif /* __ANDROID__ */
