/*
 * Decompiled with CFR 0.152.
 */
package com.sqlmagic.tinysql;

import com.sqlmagic.tinysql.DBFHeader;
import com.sqlmagic.tinysql.Utils;
import com.sqlmagic.tinysql.dbfFileTable;
import com.sqlmagic.tinysql.tinySQL;
import com.sqlmagic.tinysql.tinySQLException;
import com.sqlmagic.tinysql.tinySQLGlobals;
import com.sqlmagic.tinysql.tinySQLTable;
import com.sqlmagic.tinysql.tsColumn;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;

public class dbfFile
extends tinySQL {
    public static String dataDir;
    public static boolean debug;
    private Vector tableList = new Vector();

    public dbfFile() {
        if (tinySQLGlobals.DEBUG) {
            System.out.println("Set datadir=" + dataDir);
        }
    }

    public dbfFile(String string) {
        dataDir = string;
        if (tinySQLGlobals.DEBUG) {
            System.out.println("Set datadir=" + dataDir);
        }
    }

    void setDataDir(String string) {
        dataDir = string;
    }

    void CreateTable(String string, Vector vector) throws IOException, tinySQLException {
        Object object;
        int n = vector.size();
        int n2 = 1;
        int n3 = 0;
        while (n3 < n) {
            object = (tsColumn)vector.elementAt(n3);
            n2 += ((tsColumn)object).size;
            ++n3;
        }
        object = new DBFHeader(n, n2);
        RandomAccessFile randomAccessFile = ((DBFHeader)object).create(dataDir, string);
        int n4 = 0;
        while (n4 < vector.size()) {
            tsColumn tsColumn2 = (tsColumn)vector.elementAt(n4);
            Utils.log("CREATING COL=" + tsColumn2.name);
            this.writeColdef(randomAccessFile, tsColumn2);
            ++n4;
        }
        randomAccessFile.write(13);
        randomAccessFile.close();
    }

    void AlterTableAddCol(String string, Vector vector) throws IOException, tinySQLException {
        String string2;
        String string3 = dataDir + File.separator + string + ".DBF";
        if (!Utils.renameFile(string3, string2 = dataDir + File.separator + string + "_tmp_tmp" + ".DBF")) {
            throw new tinySQLException("ALTER TABLE ADD COL error in renaming " + string3);
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(string2, "r");
            DBFHeader dBFHeader = new DBFHeader(randomAccessFile);
            Vector<tsColumn> vector2 = new Vector<tsColumn>(dBFHeader.numFields + vector.size());
            int n = 0;
            int n2 = 1;
            while (n2 <= dBFHeader.numFields) {
                tsColumn tsColumn2 = dbfFile.readColdef(randomAccessFile, string, n2, n);
                n += tsColumn2.size;
                vector2.addElement(tsColumn2);
                ++n2;
            }
            int n3 = 0;
            while (n3 < vector.size()) {
                vector2.addElement((tsColumn)vector.elementAt(n3));
                ++n3;
            }
            this.CreateTable(string, vector2);
            RandomAccessFile randomAccessFile2 = new RandomAccessFile(string3, "rw");
            randomAccessFile2.seek(randomAccessFile2.length());
            int n4 = 0;
            int n5 = 1;
            while (n5 <= dBFHeader.numRecords) {
                String string4 = this.GetRecord(randomAccessFile, dBFHeader, n5);
                if (string4 != null) {
                    randomAccessFile2.write(string4.getBytes("Cp1252"));
                    ++n4;
                    int n6 = 0;
                    while (n6 < vector.size()) {
                        tsColumn tsColumn3 = (tsColumn)vector.elementAt(n6);
                        String string5 = Utils.forceToSize(tsColumn3.defaultVal, tsColumn3.size, " ");
                        byte[] byArray = string5.getBytes("Cp1252");
                        randomAccessFile2.write(byArray);
                        ++n6;
                    }
                }
                ++n5;
            }
            randomAccessFile.close();
            DBFHeader.writeNumRecords(randomAccessFile2, n4);
            randomAccessFile2.close();
            Utils.delFile(string2);
        }
        catch (Exception exception) {
            throw new tinySQLException(exception.getMessage());
        }
    }

    public String GetRecord(RandomAccessFile randomAccessFile, DBFHeader dBFHeader, int n) throws tinySQLException {
        if (n < 1) {
            throw new tinySQLException("Internal error - current record number < 1");
        }
        try {
            randomAccessFile.seek(dBFHeader.headerLength + (n - 1) * dBFHeader.recordLength);
            byte[] byArray = new byte[dBFHeader.recordLength];
            randomAccessFile.readFully(byArray);
            String string = new String(byArray, "Cp1252");
            if (dbfFileTable.isDeleted(string)) {
                return null;
            }
            return string;
        }
        catch (Exception exception) {
            throw new tinySQLException(exception.getMessage());
        }
    }

    void AlterTableDropCol(String string, Vector vector) throws IOException, tinySQLException {
        String string2;
        String string3 = dataDir + File.separator + string + ".DBF";
        if (!Utils.renameFile(string3, string2 = dataDir + File.separator + string + "-tmp" + ".DBF")) {
            throw new tinySQLException("ALTER TABLE DROP COL error in renaming " + string3);
        }
        try {
            Object object;
            int n;
            Object object2;
            RandomAccessFile randomAccessFile = new RandomAccessFile(string2, "r");
            DBFHeader dBFHeader = new DBFHeader(randomAccessFile);
            Vector<Object> vector2 = new Vector<Object>(dBFHeader.numFields - vector.size());
            int n2 = 0;
            int n3 = 1;
            while (n3 <= dBFHeader.numFields) {
                block10: {
                    object2 = dbfFile.readColdef(randomAccessFile, string, n3, n2);
                    n = 0;
                    while (n < vector.size()) {
                        String string4 = (String)vector.elementAt(n);
                        if (((tsColumn)object2).name.equals(string4)) {
                            Utils.log("Dropping " + string4);
                            break block10;
                        }
                        ++n;
                    }
                    n2 += ((tsColumn)object2).size;
                    vector2.addElement(object2);
                }
                ++n3;
            }
            this.CreateTable(string, vector2);
            object2 = new RandomAccessFile(string3, "rw");
            ((RandomAccessFile)object2).seek(((RandomAccessFile)object2).length());
            n = 0;
            int n4 = 1;
            while (n4 <= dBFHeader.numRecords) {
                if (!dbfFileTable.isDeleted(randomAccessFile, dBFHeader, n4)) {
                    ++n;
                    ((RandomAccessFile)object2).write(32);
                    object = dbfFileTable._GetCol(randomAccessFile, dBFHeader, n4);
                    int n5 = 0;
                    while (n5 < vector2.size()) {
                        tsColumn tsColumn2 = (tsColumn)vector2.elementAt(n5);
                        String string5 = dbfFileTable.getColumn(tsColumn2, (String)object);
                        System.out.println("From cache column value" + string5);
                        string5 = Utils.forceToSize(string5, tsColumn2.size, " ");
                        byte[] byArray = string5.getBytes("Cp1252");
                        ((RandomAccessFile)object2).write(byArray);
                        ++n5;
                    }
                }
                ++n4;
            }
            randomAccessFile.close();
            object = new File(string2);
            if (((File)object).exists()) {
                ((File)object).delete();
            }
            DBFHeader.writeNumRecords((RandomAccessFile)object2, n);
            ((RandomAccessFile)object2).close();
        }
        catch (Exception exception) {
            throw new tinySQLException(exception.getMessage());
        }
    }

    void AlterTableRenameCol(String string, String string2, String string3) throws tinySQLException {
        String string4 = dataDir + File.separator + string + ".DBF";
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(string4, "rw");
            DBFHeader dBFHeader = new DBFHeader(randomAccessFile);
            int n = 0;
            int n2 = 1;
            while (n2 <= dBFHeader.numFields) {
                tsColumn tsColumn2 = dbfFile.readColdef(randomAccessFile, string, n2, n);
                if (tsColumn2.name.equals(string2)) {
                    Utils.log("Replacing column name '" + string2 + "' with '" + string3 + "'");
                    randomAccessFile.seek((n2 - 1) * 32 + 32);
                    randomAccessFile.write(Utils.forceToSize(string3, 11, (byte)0));
                    randomAccessFile.close();
                    return;
                }
                ++n2;
            }
            randomAccessFile.close();
            throw new tinySQLException("Renaming of column name '" + string2 + "' to '" + string3 + "' failed, no column '" + string2 + "' found");
        }
        catch (Exception exception) {
            throw new tinySQLException(exception.getMessage());
        }
    }

    tinySQLTable getTable(String string) throws tinySQLException {
        tinySQLTable tinySQLTable2;
        int n = Integer.MIN_VALUE;
        if (tinySQLGlobals.DEBUG) {
            System.out.println("Trying to create table object for " + string);
        }
        int n2 = 0;
        while (n2 < this.tableList.size()) {
            tinySQLTable2 = (tinySQLTable)this.tableList.elementAt(n2);
            if (tinySQLTable2.table.equals(string)) {
                if (tinySQLTable2.isOpen()) {
                    if (tinySQLGlobals.DEBUG) {
                        System.out.println("Found in cache " + tinySQLTable2.toString());
                    }
                    return tinySQLTable2;
                }
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == Integer.MIN_VALUE) {
            this.tableList.addElement(new dbfFileTable(dataDir, string));
            tinySQLTable2 = (tinySQLTable)this.tableList.lastElement();
            if (tinySQLGlobals.DEBUG) {
                System.out.println("Add to cache " + tinySQLTable2.toString());
            }
            return (tinySQLTable)this.tableList.lastElement();
        }
        this.tableList.setElementAt(new dbfFileTable(dataDir, string), n);
        tinySQLTable2 = (tinySQLTable)this.tableList.elementAt(n);
        if (tinySQLGlobals.DEBUG) {
            System.out.println("Update in cache " + tinySQLTable2.toString());
        }
        return (tinySQLTable)this.tableList.elementAt(n);
    }

    void DropTable(String string) throws tinySQLException {
        DBFHeader.dropTable(dataDir, string);
    }

    static tsColumn readColdef(RandomAccessFile randomAccessFile, String string, int n, int n2) throws tinySQLException {
        try {
            randomAccessFile.seek((n - 1) * 32 + 32);
            byte[] byArray = new byte[11];
            randomAccessFile.readFully(byArray);
            boolean bl = false;
            int n3 = 0;
            while (n3 < 11 && byArray[n3] != 0) {
                ++n3;
            }
            while (n3 < 11) {
                byArray[n3] = 0;
                ++n3;
            }
            String string2 = new String(byArray, "Cp1252").trim();
            byte[] byArray2 = new byte[]{randomAccessFile.readByte()};
            String string3 = new String(byArray2, "Cp1252");
            randomAccessFile.skipBytes(4);
            short s = Utils.fixByte(randomAccessFile.readByte());
            short s2 = Utils.fixByte(randomAccessFile.readByte());
            if (string3.equals("N") & s2 == 0) {
                string3 = "I";
            }
            if (tinySQLGlobals.DEBUG) {
                System.out.println("Try and create tsColumn for " + string2);
            }
            tsColumn tsColumn2 = new tsColumn(string2);
            tsColumn2.type = dbfFile.typeToSQLType(string3);
            tsColumn2.size = s;
            tsColumn2.decimalPlaces = s2;
            tsColumn2.position = n2 + 1;
            tsColumn2.tableName = string;
            return tsColumn2;
        }
        catch (Exception exception) {
            throw new tinySQLException(exception.getMessage());
        }
    }

    void writeColdef(RandomAccessFile randomAccessFile, tsColumn tsColumn2) throws tinySQLException {
        try {
            randomAccessFile.write(Utils.forceToSize(tsColumn2.name, 11, (byte)0));
            String string = null;
            string = tsColumn2.type == 1 || tsColumn2.type == 12 || tsColumn2.type == -1 ? "C" : (tsColumn2.type == 2 || tsColumn2.type == 4 || tsColumn2.type == -6 || tsColumn2.type == 5 || tsColumn2.type == -5 || tsColumn2.type == 6 || tsColumn2.type == 8 || tsColumn2.type == 7 ? "N" : (tsColumn2.type == -7 ? "L" : (tsColumn2.type == 91 ? "D" : "M")));
            randomAccessFile.write(Utils.forceToSize(string, 1, (byte)0));
            randomAccessFile.write(Utils.forceToSize(null, 4, (byte)0));
            randomAccessFile.write(tsColumn2.size);
            randomAccessFile.write(tsColumn2.decimalPlaces);
            randomAccessFile.write(Utils.forceToSize(null, 14, (byte)0));
        }
        catch (Exception exception) {
            throw new tinySQLException(exception.getMessage());
        }
    }

    static String typeToLiteral(int n) {
        if (n == 1) {
            return "CHAR";
        }
        if (n == 12) {
            return "VARCHAR";
        }
        if (n == 6) {
            return "FLOAT";
        }
        if (n == 2) {
            return "NUMERIC";
        }
        if (n == 4) {
            return "INT";
        }
        if (n == -7) {
            return "BIT";
        }
        if (n == -2) {
            return "BINARY";
        }
        if (n == 91) {
            return "DATE";
        }
        return "CHAR";
    }

    static int typeToSQLType(String string) {
        if (string.equals("C")) {
            return 1;
        }
        if (string.equals("N")) {
            return 6;
        }
        if (string.equals("I")) {
            return 4;
        }
        if (string.equals("L")) {
            return 1;
        }
        if (string.equals("M")) {
            return 4;
        }
        if (string.equals("D")) {
            return 91;
        }
        return 1;
    }

    static {
        debug = false;
        try {
            dataDir = System.getProperty("user.home") + File.separator + ".tinySQL";
        }
        catch (Exception exception) {
            System.err.println("tinySQL: unable to get user.home property, reverting to current working directory.");
            dataDir = "." + File.separator + ".tinySQL";
        }
    }
}

