/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.validation.expression;

import java.util.List;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.controller.ParameterName;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.validation.ValidationErrors;
import net.sourceforge.stripes.validation.ValidationMetadata;
import net.sourceforge.stripes.validation.expression.CommonsElExpressionExecutor;
import net.sourceforge.stripes.validation.expression.ExpressionExecutor;
import net.sourceforge.stripes.validation.expression.Jsp20ExpressionExecutor;
import net.sourceforge.stripes.validation.expression.Jsp21ExpressionExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionValidator {
    private static final Log log = Log.getInstance(ExpressionValidator.class);
    private static ExpressionExecutor executor;

    public static void initialize() {
        try {
            executor = new Jsp21ExpressionExecutor();
        }
        catch (Throwable t) {
            try {
                executor = new CommonsElExpressionExecutor();
            }
            catch (Throwable t2) {
                executor = new Jsp20ExpressionExecutor();
            }
        }
        log.info("Expression validation will be performed using: " + executor.getClass().getName());
    }

    public static void evaluate(ActionBean bean, ParameterName name, List<Object> values, ValidationMetadata validationInfo, ValidationErrors errors) {
        executor.evaluate(bean, name, values, validationInfo, errors);
    }

    public static ExpressionExecutor getExecutor() {
        if (executor == null) {
            ExpressionValidator.initialize();
        }
        return executor;
    }

    public static void setExecutor(ExpressionExecutor executor) {
        ExpressionValidator.executor = executor;
    }
}

