JTS Topology Suite
==================

The JTS Topology Suite is a Java library for creating and manipulating vector geometry.  It also provides a comprehensive set of geometry test cases, and the TestBuilder GUI application for working with and visualizing geometry and JTS functions.

![JTS logo](jts_logo.png)

[![Build Status](https://api.travis-ci.org/locationtech/jts.svg)](http://travis-ci.org/locationtech/jts) [![Join the chat at https://gitter.im/locationtech/jts](https://badges.gitter.im/locationtech/jts.svg)](https://gitter.im/locationtech/jts?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge)


JTS is in incubation with the [LocationTech](http://www.locationtech.org) working group of the Eclipse Foundation.

![LocationTech](locationtech_mark.png) 

## Locations

* Git Repo: [github.com/locationtech/jts](https://github.com/locationtech/jts)
* Mailing List: [locationtech.org/mailman/listinfo/jts-dev](https://locationtech.org/mailman/listinfo/jts-dev)
* LocationTech Home: [locationtech.org/projects/technology.jts](https://locationtech.org/projects/technology.jts)
* GitHub web pages: [locationtech.github.io/jts/](https://locationtech.github.io/jts/)
* Gitter Channel: [gitter.im/locationtech/jts](https://gitter.im/locationtech/jts)

## License

JTS is open source software.  It is dual-licensed under:

* [Eclipse Public License 1.0](https://www.eclipse.org/legal/epl-v10.html)
* [Eclipse Distribution License 1.0](http://www.eclipse.org/org/documents/edl-v10.php) (a BSD Style License)

See also:

* [License details](LICENSES.md)
* Licensing [FAQ](FAQ-LICENSING.md)

## Documentation

* [**Javadoc**](https://locationtech.github.io/jts/javadoc)
* Frequently Asked Questions are documented in the [**FAQ**](https://locationtech.github.io/jts/jts-faq.html)
* Installing and using JTS is described in the [**User Guide**](USING.md).
* Building and developing with JTS is described in the [**Developing Guide**](DEVELOPING.md).
* Migrating from previous versions of JTS is described in the [**Upgrade Guide**](MIGRATION.md).

## Contributing

If you are interested in contributing to JTS please read the [**Contributing Guide**](CONTRIBUTING.md).

## Downstream Projects

### Derivative (ports to other languages)
* [**GEOS**](https://trac.osgeo.org/geos) - C++
* [**NetTopologySuite**](https://github.com/NetTopologySuite/NetTopologySuite) - .NET
* [**JSTS**](https://github.com/bjornharrtell/jsts) - JavaScript

### Via GEOS
* [**Shapely**](https://github.com/Toblerity/Shapely) - Python wrapper of GEOS
* [**R-GEOS**](https://cran.r-project.org/web/packages/rgeos/index.html) - R wrapper of GEOS
* [**rgeo**](https://github.com/rgeo/rgeo) - Ruby wrapper of GEOS
* [**GEOSwift**](https://github.com/GEOSwift/GEOSwift)- Swift library using GEOS



