
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQPageSize.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QPageSize>
#include <QRect>
#include <QRectF>
#include <QSize>
#include <QSizeF>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QPageSize

//  Constructor QPageSize::QPageSize()


static void _init_ctor_QPageSize_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QPageSize> ();
}

static void _call_ctor_QPageSize_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPageSize *> (new QPageSize ());
}


//  Constructor QPageSize::QPageSize(QPageSize::PageSizeId pageSizeId)


static void _init_ctor_QPageSize_2390 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pageSizeId");
  decl->add_arg<const qt_gsi::Converter<QPageSize::PageSizeId>::target_type & > (argspec_0);
  decl->set_return_new<QPageSize> ();
}

static void _call_ctor_QPageSize_2390 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPageSize::PageSizeId>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPageSize::PageSizeId>::target_type & >() (args, heap);
  ret.write<QPageSize *> (new QPageSize (qt_gsi::QtToCppAdaptor<QPageSize::PageSizeId>(arg1).cref()));
}


//  Constructor QPageSize::QPageSize(const QSize &pointSize, const QString &name, QPageSize::SizeMatchPolicy matchPolicy)


static void _init_ctor_QPageSize_6567 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pointSize");
  decl->add_arg<const QSize & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("name", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("matchPolicy", true, "QPageSize::FuzzyMatch");
  decl->add_arg<const qt_gsi::Converter<QPageSize::SizeMatchPolicy>::target_type & > (argspec_2);
  decl->set_return_new<QPageSize> ();
}

static void _call_ctor_QPageSize_6567 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSize &arg1 = gsi::arg_reader<const QSize & >() (args, heap);
  const QString &arg2 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  const qt_gsi::Converter<QPageSize::SizeMatchPolicy>::target_type & arg3 = args ? gsi::arg_reader<const qt_gsi::Converter<QPageSize::SizeMatchPolicy>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QPageSize::SizeMatchPolicy>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QPageSize::SizeMatchPolicy>(heap, QPageSize::FuzzyMatch), heap);
  ret.write<QPageSize *> (new QPageSize (arg1, arg2, qt_gsi::QtToCppAdaptor<QPageSize::SizeMatchPolicy>(arg3).cref()));
}


//  Constructor QPageSize::QPageSize(const QSizeF &size, QPageSize::Unit units, const QString &name, QPageSize::SizeMatchPolicy matchPolicy)


static void _init_ctor_QPageSize_8370 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const QSizeF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("units");
  decl->add_arg<const qt_gsi::Converter<QPageSize::Unit>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("name", true, "QString()");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("matchPolicy", true, "QPageSize::FuzzyMatch");
  decl->add_arg<const qt_gsi::Converter<QPageSize::SizeMatchPolicy>::target_type & > (argspec_3);
  decl->set_return_new<QPageSize> ();
}

static void _call_ctor_QPageSize_8370 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSizeF &arg1 = gsi::arg_reader<const QSizeF & >() (args, heap);
  const qt_gsi::Converter<QPageSize::Unit>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QPageSize::Unit>::target_type & >() (args, heap);
  const QString &arg3 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  const qt_gsi::Converter<QPageSize::SizeMatchPolicy>::target_type & arg4 = args ? gsi::arg_reader<const qt_gsi::Converter<QPageSize::SizeMatchPolicy>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QPageSize::SizeMatchPolicy>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QPageSize::SizeMatchPolicy>(heap, QPageSize::FuzzyMatch), heap);
  ret.write<QPageSize *> (new QPageSize (arg1, qt_gsi::QtToCppAdaptor<QPageSize::Unit>(arg2).cref(), arg3, qt_gsi::QtToCppAdaptor<QPageSize::SizeMatchPolicy>(arg4).cref()));
}


//  Constructor QPageSize::QPageSize(const QPageSize &other)


static void _init_ctor_QPageSize_2186 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QPageSize & > (argspec_0);
  decl->set_return_new<QPageSize> ();
}

static void _call_ctor_QPageSize_2186 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPageSize &arg1 = gsi::arg_reader<const QPageSize & >() (args, heap);
  ret.write<QPageSize *> (new QPageSize (arg1));
}


// QSizeF QPageSize::definitionSize()


static void _init_f_definitionSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSizeF > ();
}

static void _call_f_definitionSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSizeF > ((QSizeF)((QPageSize *)cls)->definitionSize ());
}


// QPageSize::Unit QPageSize::definitionUnits()


static void _init_f_definitionUnits_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QPageSize::Unit>::target_type > ();
}

static void _call_f_definitionUnits_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QPageSize::Unit>::target_type > ((qt_gsi::Converter<QPageSize::Unit>::target_type)qt_gsi::CppToQtAdaptor<QPageSize::Unit>(((QPageSize *)cls)->definitionUnits ()));
}


// QPageSize::PageSizeId QPageSize::id()


static void _init_f_id_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QPageSize::PageSizeId>::target_type > ();
}

static void _call_f_id_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QPageSize::PageSizeId>::target_type > ((qt_gsi::Converter<QPageSize::PageSizeId>::target_type)qt_gsi::CppToQtAdaptor<QPageSize::PageSizeId>(((QPageSize *)cls)->id ()));
}


// bool QPageSize::isEquivalentTo(const QPageSize &other)


static void _init_f_isEquivalentTo_c2186 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QPageSize & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isEquivalentTo_c2186 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPageSize &arg1 = gsi::arg_reader<const QPageSize & >() (args, heap);
  ret.write<bool > ((bool)((QPageSize *)cls)->isEquivalentTo (arg1));
}


// bool QPageSize::isValid()


static void _init_f_isValid_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isValid_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPageSize *)cls)->isValid ());
}


// QString QPageSize::key()


static void _init_f_key_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_key_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QPageSize *)cls)->key ());
}


// QString QPageSize::name()


static void _init_f_name_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_name_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QPageSize *)cls)->name ());
}


// QPageSize &QPageSize::operator=(const QPageSize &other)


static void _init_f_operator_eq__2186 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QPageSize & > (argspec_0);
  decl->set_return<QPageSize & > ();
}

static void _call_f_operator_eq__2186 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPageSize &arg1 = gsi::arg_reader<const QPageSize & >() (args, heap);
  ret.write<QPageSize & > ((QPageSize &)((QPageSize *)cls)->operator= (arg1));
}


// QRectF QPageSize::rect(QPageSize::Unit units)


static void _init_f_rect_c1841 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("units");
  decl->add_arg<const qt_gsi::Converter<QPageSize::Unit>::target_type & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_f_rect_c1841 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPageSize::Unit>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPageSize::Unit>::target_type & >() (args, heap);
  ret.write<QRectF > ((QRectF)((QPageSize *)cls)->rect (qt_gsi::QtToCppAdaptor<QPageSize::Unit>(arg1).cref()));
}


// QRect QPageSize::rectPixels(int resolution)


static void _init_f_rectPixels_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("resolution");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QRect > ();
}

static void _call_f_rectPixels_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QRect > ((QRect)((QPageSize *)cls)->rectPixels (arg1));
}


// QRect QPageSize::rectPoints()


static void _init_f_rectPoints_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_rectPoints_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRect > ((QRect)((QPageSize *)cls)->rectPoints ());
}


// QSizeF QPageSize::size(QPageSize::Unit units)


static void _init_f_size_c1841 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("units");
  decl->add_arg<const qt_gsi::Converter<QPageSize::Unit>::target_type & > (argspec_0);
  decl->set_return<QSizeF > ();
}

static void _call_f_size_c1841 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPageSize::Unit>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPageSize::Unit>::target_type & >() (args, heap);
  ret.write<QSizeF > ((QSizeF)((QPageSize *)cls)->size (qt_gsi::QtToCppAdaptor<QPageSize::Unit>(arg1).cref()));
}


// QSize QPageSize::sizePixels(int resolution)


static void _init_f_sizePixels_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("resolution");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QSize > ();
}

static void _call_f_sizePixels_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QSize > ((QSize)((QPageSize *)cls)->sizePixels (arg1));
}


// QSize QPageSize::sizePoints()


static void _init_f_sizePoints_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_sizePoints_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QPageSize *)cls)->sizePoints ());
}


// void QPageSize::swap(QPageSize &other)


static void _init_f_swap_1491 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<QPageSize & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_swap_1491 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPageSize &arg1 = gsi::arg_reader<QPageSize & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPageSize *)cls)->swap (arg1);
}


// int QPageSize::windowsId()


static void _init_f_windowsId_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_windowsId_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QPageSize *)cls)->windowsId ());
}


// static QSizeF QPageSize::definitionSize(QPageSize::PageSizeId pageSizeId)


static void _init_f_definitionSize_2390 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pageSizeId");
  decl->add_arg<const qt_gsi::Converter<QPageSize::PageSizeId>::target_type & > (argspec_0);
  decl->set_return<QSizeF > ();
}

static void _call_f_definitionSize_2390 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPageSize::PageSizeId>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPageSize::PageSizeId>::target_type & >() (args, heap);
  ret.write<QSizeF > ((QSizeF)QPageSize::definitionSize (qt_gsi::QtToCppAdaptor<QPageSize::PageSizeId>(arg1).cref()));
}


// static QPageSize::Unit QPageSize::definitionUnits(QPageSize::PageSizeId pageSizeId)


static void _init_f_definitionUnits_2390 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pageSizeId");
  decl->add_arg<const qt_gsi::Converter<QPageSize::PageSizeId>::target_type & > (argspec_0);
  decl->set_return<qt_gsi::Converter<QPageSize::Unit>::target_type > ();
}

static void _call_f_definitionUnits_2390 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPageSize::PageSizeId>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPageSize::PageSizeId>::target_type & >() (args, heap);
  ret.write<qt_gsi::Converter<QPageSize::Unit>::target_type > ((qt_gsi::Converter<QPageSize::Unit>::target_type)qt_gsi::CppToQtAdaptor<QPageSize::Unit>(QPageSize::definitionUnits (qt_gsi::QtToCppAdaptor<QPageSize::PageSizeId>(arg1).cref())));
}


// static QPageSize::PageSizeId QPageSize::id(const QSize &pointSize, QPageSize::SizeMatchPolicy matchPolicy)


static void _init_f_id_4650 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pointSize");
  decl->add_arg<const QSize & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("matchPolicy", true, "QPageSize::FuzzyMatch");
  decl->add_arg<const qt_gsi::Converter<QPageSize::SizeMatchPolicy>::target_type & > (argspec_1);
  decl->set_return<qt_gsi::Converter<QPageSize::PageSizeId>::target_type > ();
}

static void _call_f_id_4650 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSize &arg1 = gsi::arg_reader<const QSize & >() (args, heap);
  const qt_gsi::Converter<QPageSize::SizeMatchPolicy>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QPageSize::SizeMatchPolicy>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QPageSize::SizeMatchPolicy>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QPageSize::SizeMatchPolicy>(heap, QPageSize::FuzzyMatch), heap);
  ret.write<qt_gsi::Converter<QPageSize::PageSizeId>::target_type > ((qt_gsi::Converter<QPageSize::PageSizeId>::target_type)qt_gsi::CppToQtAdaptor<QPageSize::PageSizeId>(QPageSize::id (arg1, qt_gsi::QtToCppAdaptor<QPageSize::SizeMatchPolicy>(arg2).cref())));
}


// static QPageSize::PageSizeId QPageSize::id(const QSizeF &size, QPageSize::Unit units, QPageSize::SizeMatchPolicy matchPolicy)


static void _init_f_id_6453 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const QSizeF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("units");
  decl->add_arg<const qt_gsi::Converter<QPageSize::Unit>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("matchPolicy", true, "QPageSize::FuzzyMatch");
  decl->add_arg<const qt_gsi::Converter<QPageSize::SizeMatchPolicy>::target_type & > (argspec_2);
  decl->set_return<qt_gsi::Converter<QPageSize::PageSizeId>::target_type > ();
}

static void _call_f_id_6453 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSizeF &arg1 = gsi::arg_reader<const QSizeF & >() (args, heap);
  const qt_gsi::Converter<QPageSize::Unit>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QPageSize::Unit>::target_type & >() (args, heap);
  const qt_gsi::Converter<QPageSize::SizeMatchPolicy>::target_type & arg3 = args ? gsi::arg_reader<const qt_gsi::Converter<QPageSize::SizeMatchPolicy>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QPageSize::SizeMatchPolicy>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QPageSize::SizeMatchPolicy>(heap, QPageSize::FuzzyMatch), heap);
  ret.write<qt_gsi::Converter<QPageSize::PageSizeId>::target_type > ((qt_gsi::Converter<QPageSize::PageSizeId>::target_type)qt_gsi::CppToQtAdaptor<QPageSize::PageSizeId>(QPageSize::id (arg1, qt_gsi::QtToCppAdaptor<QPageSize::Unit>(arg2).cref(), qt_gsi::QtToCppAdaptor<QPageSize::SizeMatchPolicy>(arg3).cref())));
}


// static QPageSize::PageSizeId QPageSize::id(int windowsId)


static void _init_f_id_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("windowsId");
  decl->add_arg<int > (argspec_0);
  decl->set_return<qt_gsi::Converter<QPageSize::PageSizeId>::target_type > ();
}

static void _call_f_id_767 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<qt_gsi::Converter<QPageSize::PageSizeId>::target_type > ((qt_gsi::Converter<QPageSize::PageSizeId>::target_type)qt_gsi::CppToQtAdaptor<QPageSize::PageSizeId>(QPageSize::id (arg1)));
}


// static QString QPageSize::key(QPageSize::PageSizeId pageSizeId)


static void _init_f_key_2390 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pageSizeId");
  decl->add_arg<const qt_gsi::Converter<QPageSize::PageSizeId>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_key_2390 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPageSize::PageSizeId>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPageSize::PageSizeId>::target_type & >() (args, heap);
  ret.write<QString > ((QString)QPageSize::key (qt_gsi::QtToCppAdaptor<QPageSize::PageSizeId>(arg1).cref()));
}


// static QString QPageSize::name(QPageSize::PageSizeId pageSizeId)


static void _init_f_name_2390 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pageSizeId");
  decl->add_arg<const qt_gsi::Converter<QPageSize::PageSizeId>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_name_2390 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPageSize::PageSizeId>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPageSize::PageSizeId>::target_type & >() (args, heap);
  ret.write<QString > ((QString)QPageSize::name (qt_gsi::QtToCppAdaptor<QPageSize::PageSizeId>(arg1).cref()));
}


// static QSizeF QPageSize::size(QPageSize::PageSizeId pageSizeId, QPageSize::Unit units)


static void _init_f_size_4123 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pageSizeId");
  decl->add_arg<const qt_gsi::Converter<QPageSize::PageSizeId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("units");
  decl->add_arg<const qt_gsi::Converter<QPageSize::Unit>::target_type & > (argspec_1);
  decl->set_return<QSizeF > ();
}

static void _call_f_size_4123 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPageSize::PageSizeId>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPageSize::PageSizeId>::target_type & >() (args, heap);
  const qt_gsi::Converter<QPageSize::Unit>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QPageSize::Unit>::target_type & >() (args, heap);
  ret.write<QSizeF > ((QSizeF)QPageSize::size (qt_gsi::QtToCppAdaptor<QPageSize::PageSizeId>(arg1).cref(), qt_gsi::QtToCppAdaptor<QPageSize::Unit>(arg2).cref()));
}


// static QSize QPageSize::sizePixels(QPageSize::PageSizeId pageSizeId, int resolution)


static void _init_f_sizePixels_3049 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pageSizeId");
  decl->add_arg<const qt_gsi::Converter<QPageSize::PageSizeId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("resolution");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QSize > ();
}

static void _call_f_sizePixels_3049 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPageSize::PageSizeId>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPageSize::PageSizeId>::target_type & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  ret.write<QSize > ((QSize)QPageSize::sizePixels (qt_gsi::QtToCppAdaptor<QPageSize::PageSizeId>(arg1).cref(), arg2));
}


// static QSize QPageSize::sizePoints(QPageSize::PageSizeId pageSizeId)


static void _init_f_sizePoints_2390 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pageSizeId");
  decl->add_arg<const qt_gsi::Converter<QPageSize::PageSizeId>::target_type & > (argspec_0);
  decl->set_return<QSize > ();
}

static void _call_f_sizePoints_2390 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPageSize::PageSizeId>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPageSize::PageSizeId>::target_type & >() (args, heap);
  ret.write<QSize > ((QSize)QPageSize::sizePoints (qt_gsi::QtToCppAdaptor<QPageSize::PageSizeId>(arg1).cref()));
}


// static int QPageSize::windowsId(QPageSize::PageSizeId pageSizeId)


static void _init_f_windowsId_2390 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pageSizeId");
  decl->add_arg<const qt_gsi::Converter<QPageSize::PageSizeId>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_windowsId_2390 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPageSize::PageSizeId>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPageSize::PageSizeId>::target_type & >() (args, heap);
  ret.write<int > ((int)QPageSize::windowsId (qt_gsi::QtToCppAdaptor<QPageSize::PageSizeId>(arg1).cref()));
}


//  bool ::operator==(const QPageSize &lhs, const QPageSize &rhs)
static bool op_QPageSize_operator_eq__eq__4264(const QPageSize *_self, const QPageSize &rhs) {
  return ::operator==(*_self, rhs);
}

//  bool ::operator!=(const QPageSize &lhs, const QPageSize &rhs)
static bool op_QPageSize_operator_excl__eq__4264(const QPageSize *_self, const QPageSize &rhs) {
  return ::operator!=(*_self, rhs);
}


namespace gsi
{

static gsi::Methods methods_QPageSize () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPageSize::QPageSize()\nThis method creates an object of class QPageSize.", &_init_ctor_QPageSize_0, &_call_ctor_QPageSize_0);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPageSize::QPageSize(QPageSize::PageSizeId pageSizeId)\nThis method creates an object of class QPageSize.", &_init_ctor_QPageSize_2390, &_call_ctor_QPageSize_2390);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPageSize::QPageSize(const QSize &pointSize, const QString &name, QPageSize::SizeMatchPolicy matchPolicy)\nThis method creates an object of class QPageSize.", &_init_ctor_QPageSize_6567, &_call_ctor_QPageSize_6567);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPageSize::QPageSize(const QSizeF &size, QPageSize::Unit units, const QString &name, QPageSize::SizeMatchPolicy matchPolicy)\nThis method creates an object of class QPageSize.", &_init_ctor_QPageSize_8370, &_call_ctor_QPageSize_8370);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPageSize::QPageSize(const QPageSize &other)\nThis method creates an object of class QPageSize.", &_init_ctor_QPageSize_2186, &_call_ctor_QPageSize_2186);
  methods += new qt_gsi::GenericMethod ("definitionSize", "@brief Method QSizeF QPageSize::definitionSize()\n", true, &_init_f_definitionSize_c0, &_call_f_definitionSize_c0);
  methods += new qt_gsi::GenericMethod ("definitionUnits", "@brief Method QPageSize::Unit QPageSize::definitionUnits()\n", true, &_init_f_definitionUnits_c0, &_call_f_definitionUnits_c0);
  methods += new qt_gsi::GenericMethod ("id", "@brief Method QPageSize::PageSizeId QPageSize::id()\n", true, &_init_f_id_c0, &_call_f_id_c0);
  methods += new qt_gsi::GenericMethod ("isEquivalentTo?", "@brief Method bool QPageSize::isEquivalentTo(const QPageSize &other)\n", true, &_init_f_isEquivalentTo_c2186, &_call_f_isEquivalentTo_c2186);
  methods += new qt_gsi::GenericMethod ("isValid?", "@brief Method bool QPageSize::isValid()\n", true, &_init_f_isValid_c0, &_call_f_isValid_c0);
  methods += new qt_gsi::GenericMethod ("key", "@brief Method QString QPageSize::key()\n", true, &_init_f_key_c0, &_call_f_key_c0);
  methods += new qt_gsi::GenericMethod ("name", "@brief Method QString QPageSize::name()\n", true, &_init_f_name_c0, &_call_f_name_c0);
  methods += new qt_gsi::GenericMethod ("assign", "@brief Method QPageSize &QPageSize::operator=(const QPageSize &other)\n", false, &_init_f_operator_eq__2186, &_call_f_operator_eq__2186);
  methods += new qt_gsi::GenericMethod ("rect", "@brief Method QRectF QPageSize::rect(QPageSize::Unit units)\n", true, &_init_f_rect_c1841, &_call_f_rect_c1841);
  methods += new qt_gsi::GenericMethod ("rectPixels", "@brief Method QRect QPageSize::rectPixels(int resolution)\n", true, &_init_f_rectPixels_c767, &_call_f_rectPixels_c767);
  methods += new qt_gsi::GenericMethod ("rectPoints", "@brief Method QRect QPageSize::rectPoints()\n", true, &_init_f_rectPoints_c0, &_call_f_rectPoints_c0);
  methods += new qt_gsi::GenericMethod ("size", "@brief Method QSizeF QPageSize::size(QPageSize::Unit units)\n", true, &_init_f_size_c1841, &_call_f_size_c1841);
  methods += new qt_gsi::GenericMethod ("sizePixels", "@brief Method QSize QPageSize::sizePixels(int resolution)\n", true, &_init_f_sizePixels_c767, &_call_f_sizePixels_c767);
  methods += new qt_gsi::GenericMethod ("sizePoints", "@brief Method QSize QPageSize::sizePoints()\n", true, &_init_f_sizePoints_c0, &_call_f_sizePoints_c0);
  methods += new qt_gsi::GenericMethod ("swap", "@brief Method void QPageSize::swap(QPageSize &other)\n", false, &_init_f_swap_1491, &_call_f_swap_1491);
  methods += new qt_gsi::GenericMethod ("windowsId", "@brief Method int QPageSize::windowsId()\n", true, &_init_f_windowsId_c0, &_call_f_windowsId_c0);
  methods += new qt_gsi::GenericStaticMethod ("definitionSize", "@brief Static method QSizeF QPageSize::definitionSize(QPageSize::PageSizeId pageSizeId)\nThis method is static and can be called without an instance.", &_init_f_definitionSize_2390, &_call_f_definitionSize_2390);
  methods += new qt_gsi::GenericStaticMethod ("definitionUnits", "@brief Static method QPageSize::Unit QPageSize::definitionUnits(QPageSize::PageSizeId pageSizeId)\nThis method is static and can be called without an instance.", &_init_f_definitionUnits_2390, &_call_f_definitionUnits_2390);
  methods += new qt_gsi::GenericStaticMethod ("id", "@brief Static method QPageSize::PageSizeId QPageSize::id(const QSize &pointSize, QPageSize::SizeMatchPolicy matchPolicy)\nThis method is static and can be called without an instance.", &_init_f_id_4650, &_call_f_id_4650);
  methods += new qt_gsi::GenericStaticMethod ("id", "@brief Static method QPageSize::PageSizeId QPageSize::id(const QSizeF &size, QPageSize::Unit units, QPageSize::SizeMatchPolicy matchPolicy)\nThis method is static and can be called without an instance.", &_init_f_id_6453, &_call_f_id_6453);
  methods += new qt_gsi::GenericStaticMethod ("id", "@brief Static method QPageSize::PageSizeId QPageSize::id(int windowsId)\nThis method is static and can be called without an instance.", &_init_f_id_767, &_call_f_id_767);
  methods += new qt_gsi::GenericStaticMethod ("key", "@brief Static method QString QPageSize::key(QPageSize::PageSizeId pageSizeId)\nThis method is static and can be called without an instance.", &_init_f_key_2390, &_call_f_key_2390);
  methods += new qt_gsi::GenericStaticMethod ("name", "@brief Static method QString QPageSize::name(QPageSize::PageSizeId pageSizeId)\nThis method is static and can be called without an instance.", &_init_f_name_2390, &_call_f_name_2390);
  methods += new qt_gsi::GenericStaticMethod ("size", "@brief Static method QSizeF QPageSize::size(QPageSize::PageSizeId pageSizeId, QPageSize::Unit units)\nThis method is static and can be called without an instance.", &_init_f_size_4123, &_call_f_size_4123);
  methods += new qt_gsi::GenericStaticMethod ("sizePixels", "@brief Static method QSize QPageSize::sizePixels(QPageSize::PageSizeId pageSizeId, int resolution)\nThis method is static and can be called without an instance.", &_init_f_sizePixels_3049, &_call_f_sizePixels_3049);
  methods += new qt_gsi::GenericStaticMethod ("sizePoints", "@brief Static method QSize QPageSize::sizePoints(QPageSize::PageSizeId pageSizeId)\nThis method is static and can be called without an instance.", &_init_f_sizePoints_2390, &_call_f_sizePoints_2390);
  methods += new qt_gsi::GenericStaticMethod ("windowsId", "@brief Static method int QPageSize::windowsId(QPageSize::PageSizeId pageSizeId)\nThis method is static and can be called without an instance.", &_init_f_windowsId_2390, &_call_f_windowsId_2390);
  methods += gsi::method_ext("==", &::op_QPageSize_operator_eq__eq__4264, gsi::arg ("rhs"), "@brief Operator bool ::operator==(const QPageSize &lhs, const QPageSize &rhs)\nThis is the mapping of the global operator to the instance method.");
  methods += gsi::method_ext("!=", &::op_QPageSize_operator_excl__eq__4264, gsi::arg ("rhs"), "@brief Operator bool ::operator!=(const QPageSize &lhs, const QPageSize &rhs)\nThis is the mapping of the global operator to the instance method.");
  return methods;
}

gsi::Class<QPageSize> decl_QPageSize ("QtGui", "QPageSize",
  methods_QPageSize (),
  "@qt\n@brief Binding of QPageSize");


GSI_QTGUI_PUBLIC gsi::Class<QPageSize> &qtdecl_QPageSize () { return decl_QPageSize; }

}


//  Implementation of the enum wrapper class for QPageSize::PageSizeId
namespace qt_gsi
{

static gsi::Enum<QPageSize::PageSizeId> decl_QPageSize_PageSizeId_Enum ("QtGui", "QPageSize_PageSizeId",
    gsi::enum_const ("A4", QPageSize::A4, "@brief Enum constant QPageSize::A4") +
    gsi::enum_const ("B5", QPageSize::B5, "@brief Enum constant QPageSize::B5") +
    gsi::enum_const ("Letter", QPageSize::Letter, "@brief Enum constant QPageSize::Letter") +
    gsi::enum_const ("Legal", QPageSize::Legal, "@brief Enum constant QPageSize::Legal") +
    gsi::enum_const ("Executive", QPageSize::Executive, "@brief Enum constant QPageSize::Executive") +
    gsi::enum_const ("A0", QPageSize::A0, "@brief Enum constant QPageSize::A0") +
    gsi::enum_const ("A1", QPageSize::A1, "@brief Enum constant QPageSize::A1") +
    gsi::enum_const ("A2", QPageSize::A2, "@brief Enum constant QPageSize::A2") +
    gsi::enum_const ("A3", QPageSize::A3, "@brief Enum constant QPageSize::A3") +
    gsi::enum_const ("A5", QPageSize::A5, "@brief Enum constant QPageSize::A5") +
    gsi::enum_const ("A6", QPageSize::A6, "@brief Enum constant QPageSize::A6") +
    gsi::enum_const ("A7", QPageSize::A7, "@brief Enum constant QPageSize::A7") +
    gsi::enum_const ("A8", QPageSize::A8, "@brief Enum constant QPageSize::A8") +
    gsi::enum_const ("A9", QPageSize::A9, "@brief Enum constant QPageSize::A9") +
    gsi::enum_const ("B0", QPageSize::B0, "@brief Enum constant QPageSize::B0") +
    gsi::enum_const ("B1", QPageSize::B1, "@brief Enum constant QPageSize::B1") +
    gsi::enum_const ("B10", QPageSize::B10, "@brief Enum constant QPageSize::B10") +
    gsi::enum_const ("B2", QPageSize::B2, "@brief Enum constant QPageSize::B2") +
    gsi::enum_const ("B3", QPageSize::B3, "@brief Enum constant QPageSize::B3") +
    gsi::enum_const ("B4", QPageSize::B4, "@brief Enum constant QPageSize::B4") +
    gsi::enum_const ("B6", QPageSize::B6, "@brief Enum constant QPageSize::B6") +
    gsi::enum_const ("B7", QPageSize::B7, "@brief Enum constant QPageSize::B7") +
    gsi::enum_const ("B8", QPageSize::B8, "@brief Enum constant QPageSize::B8") +
    gsi::enum_const ("B9", QPageSize::B9, "@brief Enum constant QPageSize::B9") +
    gsi::enum_const ("C5E", QPageSize::C5E, "@brief Enum constant QPageSize::C5E") +
    gsi::enum_const ("Comm10E", QPageSize::Comm10E, "@brief Enum constant QPageSize::Comm10E") +
    gsi::enum_const ("DLE", QPageSize::DLE, "@brief Enum constant QPageSize::DLE") +
    gsi::enum_const ("Folio", QPageSize::Folio, "@brief Enum constant QPageSize::Folio") +
    gsi::enum_const ("Ledger", QPageSize::Ledger, "@brief Enum constant QPageSize::Ledger") +
    gsi::enum_const ("Tabloid", QPageSize::Tabloid, "@brief Enum constant QPageSize::Tabloid") +
    gsi::enum_const ("Custom", QPageSize::Custom, "@brief Enum constant QPageSize::Custom") +
    gsi::enum_const ("A10", QPageSize::A10, "@brief Enum constant QPageSize::A10") +
    gsi::enum_const ("A3Extra", QPageSize::A3Extra, "@brief Enum constant QPageSize::A3Extra") +
    gsi::enum_const ("A4Extra", QPageSize::A4Extra, "@brief Enum constant QPageSize::A4Extra") +
    gsi::enum_const ("A4Plus", QPageSize::A4Plus, "@brief Enum constant QPageSize::A4Plus") +
    gsi::enum_const ("A4Small", QPageSize::A4Small, "@brief Enum constant QPageSize::A4Small") +
    gsi::enum_const ("A5Extra", QPageSize::A5Extra, "@brief Enum constant QPageSize::A5Extra") +
    gsi::enum_const ("B5Extra", QPageSize::B5Extra, "@brief Enum constant QPageSize::B5Extra") +
    gsi::enum_const ("JisB0", QPageSize::JisB0, "@brief Enum constant QPageSize::JisB0") +
    gsi::enum_const ("JisB1", QPageSize::JisB1, "@brief Enum constant QPageSize::JisB1") +
    gsi::enum_const ("JisB2", QPageSize::JisB2, "@brief Enum constant QPageSize::JisB2") +
    gsi::enum_const ("JisB3", QPageSize::JisB3, "@brief Enum constant QPageSize::JisB3") +
    gsi::enum_const ("JisB4", QPageSize::JisB4, "@brief Enum constant QPageSize::JisB4") +
    gsi::enum_const ("JisB5", QPageSize::JisB5, "@brief Enum constant QPageSize::JisB5") +
    gsi::enum_const ("JisB6", QPageSize::JisB6, "@brief Enum constant QPageSize::JisB6") +
    gsi::enum_const ("JisB7", QPageSize::JisB7, "@brief Enum constant QPageSize::JisB7") +
    gsi::enum_const ("JisB8", QPageSize::JisB8, "@brief Enum constant QPageSize::JisB8") +
    gsi::enum_const ("JisB9", QPageSize::JisB9, "@brief Enum constant QPageSize::JisB9") +
    gsi::enum_const ("JisB10", QPageSize::JisB10, "@brief Enum constant QPageSize::JisB10") +
    gsi::enum_const ("AnsiC", QPageSize::AnsiC, "@brief Enum constant QPageSize::AnsiC") +
    gsi::enum_const ("AnsiD", QPageSize::AnsiD, "@brief Enum constant QPageSize::AnsiD") +
    gsi::enum_const ("AnsiE", QPageSize::AnsiE, "@brief Enum constant QPageSize::AnsiE") +
    gsi::enum_const ("LegalExtra", QPageSize::LegalExtra, "@brief Enum constant QPageSize::LegalExtra") +
    gsi::enum_const ("LetterExtra", QPageSize::LetterExtra, "@brief Enum constant QPageSize::LetterExtra") +
    gsi::enum_const ("LetterPlus", QPageSize::LetterPlus, "@brief Enum constant QPageSize::LetterPlus") +
    gsi::enum_const ("LetterSmall", QPageSize::LetterSmall, "@brief Enum constant QPageSize::LetterSmall") +
    gsi::enum_const ("TabloidExtra", QPageSize::TabloidExtra, "@brief Enum constant QPageSize::TabloidExtra") +
    gsi::enum_const ("ArchA", QPageSize::ArchA, "@brief Enum constant QPageSize::ArchA") +
    gsi::enum_const ("ArchB", QPageSize::ArchB, "@brief Enum constant QPageSize::ArchB") +
    gsi::enum_const ("ArchC", QPageSize::ArchC, "@brief Enum constant QPageSize::ArchC") +
    gsi::enum_const ("ArchD", QPageSize::ArchD, "@brief Enum constant QPageSize::ArchD") +
    gsi::enum_const ("ArchE", QPageSize::ArchE, "@brief Enum constant QPageSize::ArchE") +
    gsi::enum_const ("Imperial7x9", QPageSize::Imperial7x9, "@brief Enum constant QPageSize::Imperial7x9") +
    gsi::enum_const ("Imperial8x10", QPageSize::Imperial8x10, "@brief Enum constant QPageSize::Imperial8x10") +
    gsi::enum_const ("Imperial9x11", QPageSize::Imperial9x11, "@brief Enum constant QPageSize::Imperial9x11") +
    gsi::enum_const ("Imperial9x12", QPageSize::Imperial9x12, "@brief Enum constant QPageSize::Imperial9x12") +
    gsi::enum_const ("Imperial10x11", QPageSize::Imperial10x11, "@brief Enum constant QPageSize::Imperial10x11") +
    gsi::enum_const ("Imperial10x13", QPageSize::Imperial10x13, "@brief Enum constant QPageSize::Imperial10x13") +
    gsi::enum_const ("Imperial10x14", QPageSize::Imperial10x14, "@brief Enum constant QPageSize::Imperial10x14") +
    gsi::enum_const ("Imperial12x11", QPageSize::Imperial12x11, "@brief Enum constant QPageSize::Imperial12x11") +
    gsi::enum_const ("Imperial15x11", QPageSize::Imperial15x11, "@brief Enum constant QPageSize::Imperial15x11") +
    gsi::enum_const ("ExecutiveStandard", QPageSize::ExecutiveStandard, "@brief Enum constant QPageSize::ExecutiveStandard") +
    gsi::enum_const ("Note", QPageSize::Note, "@brief Enum constant QPageSize::Note") +
    gsi::enum_const ("Quarto", QPageSize::Quarto, "@brief Enum constant QPageSize::Quarto") +
    gsi::enum_const ("Statement", QPageSize::Statement, "@brief Enum constant QPageSize::Statement") +
    gsi::enum_const ("SuperA", QPageSize::SuperA, "@brief Enum constant QPageSize::SuperA") +
    gsi::enum_const ("SuperB", QPageSize::SuperB, "@brief Enum constant QPageSize::SuperB") +
    gsi::enum_const ("Postcard", QPageSize::Postcard, "@brief Enum constant QPageSize::Postcard") +
    gsi::enum_const ("DoublePostcard", QPageSize::DoublePostcard, "@brief Enum constant QPageSize::DoublePostcard") +
    gsi::enum_const ("Prc16K", QPageSize::Prc16K, "@brief Enum constant QPageSize::Prc16K") +
    gsi::enum_const ("Prc32K", QPageSize::Prc32K, "@brief Enum constant QPageSize::Prc32K") +
    gsi::enum_const ("Prc32KBig", QPageSize::Prc32KBig, "@brief Enum constant QPageSize::Prc32KBig") +
    gsi::enum_const ("FanFoldUS", QPageSize::FanFoldUS, "@brief Enum constant QPageSize::FanFoldUS") +
    gsi::enum_const ("FanFoldGerman", QPageSize::FanFoldGerman, "@brief Enum constant QPageSize::FanFoldGerman") +
    gsi::enum_const ("FanFoldGermanLegal", QPageSize::FanFoldGermanLegal, "@brief Enum constant QPageSize::FanFoldGermanLegal") +
    gsi::enum_const ("EnvelopeB4", QPageSize::EnvelopeB4, "@brief Enum constant QPageSize::EnvelopeB4") +
    gsi::enum_const ("EnvelopeB5", QPageSize::EnvelopeB5, "@brief Enum constant QPageSize::EnvelopeB5") +
    gsi::enum_const ("EnvelopeB6", QPageSize::EnvelopeB6, "@brief Enum constant QPageSize::EnvelopeB6") +
    gsi::enum_const ("EnvelopeC0", QPageSize::EnvelopeC0, "@brief Enum constant QPageSize::EnvelopeC0") +
    gsi::enum_const ("EnvelopeC1", QPageSize::EnvelopeC1, "@brief Enum constant QPageSize::EnvelopeC1") +
    gsi::enum_const ("EnvelopeC2", QPageSize::EnvelopeC2, "@brief Enum constant QPageSize::EnvelopeC2") +
    gsi::enum_const ("EnvelopeC3", QPageSize::EnvelopeC3, "@brief Enum constant QPageSize::EnvelopeC3") +
    gsi::enum_const ("EnvelopeC4", QPageSize::EnvelopeC4, "@brief Enum constant QPageSize::EnvelopeC4") +
    gsi::enum_const ("EnvelopeC6", QPageSize::EnvelopeC6, "@brief Enum constant QPageSize::EnvelopeC6") +
    gsi::enum_const ("EnvelopeC65", QPageSize::EnvelopeC65, "@brief Enum constant QPageSize::EnvelopeC65") +
    gsi::enum_const ("EnvelopeC7", QPageSize::EnvelopeC7, "@brief Enum constant QPageSize::EnvelopeC7") +
    gsi::enum_const ("Envelope9", QPageSize::Envelope9, "@brief Enum constant QPageSize::Envelope9") +
    gsi::enum_const ("Envelope11", QPageSize::Envelope11, "@brief Enum constant QPageSize::Envelope11") +
    gsi::enum_const ("Envelope12", QPageSize::Envelope12, "@brief Enum constant QPageSize::Envelope12") +
    gsi::enum_const ("Envelope14", QPageSize::Envelope14, "@brief Enum constant QPageSize::Envelope14") +
    gsi::enum_const ("EnvelopeMonarch", QPageSize::EnvelopeMonarch, "@brief Enum constant QPageSize::EnvelopeMonarch") +
    gsi::enum_const ("EnvelopePersonal", QPageSize::EnvelopePersonal, "@brief Enum constant QPageSize::EnvelopePersonal") +
    gsi::enum_const ("EnvelopeChou3", QPageSize::EnvelopeChou3, "@brief Enum constant QPageSize::EnvelopeChou3") +
    gsi::enum_const ("EnvelopeChou4", QPageSize::EnvelopeChou4, "@brief Enum constant QPageSize::EnvelopeChou4") +
    gsi::enum_const ("EnvelopeInvite", QPageSize::EnvelopeInvite, "@brief Enum constant QPageSize::EnvelopeInvite") +
    gsi::enum_const ("EnvelopeItalian", QPageSize::EnvelopeItalian, "@brief Enum constant QPageSize::EnvelopeItalian") +
    gsi::enum_const ("EnvelopeKaku2", QPageSize::EnvelopeKaku2, "@brief Enum constant QPageSize::EnvelopeKaku2") +
    gsi::enum_const ("EnvelopeKaku3", QPageSize::EnvelopeKaku3, "@brief Enum constant QPageSize::EnvelopeKaku3") +
    gsi::enum_const ("EnvelopePrc1", QPageSize::EnvelopePrc1, "@brief Enum constant QPageSize::EnvelopePrc1") +
    gsi::enum_const ("EnvelopePrc2", QPageSize::EnvelopePrc2, "@brief Enum constant QPageSize::EnvelopePrc2") +
    gsi::enum_const ("EnvelopePrc3", QPageSize::EnvelopePrc3, "@brief Enum constant QPageSize::EnvelopePrc3") +
    gsi::enum_const ("EnvelopePrc4", QPageSize::EnvelopePrc4, "@brief Enum constant QPageSize::EnvelopePrc4") +
    gsi::enum_const ("EnvelopePrc5", QPageSize::EnvelopePrc5, "@brief Enum constant QPageSize::EnvelopePrc5") +
    gsi::enum_const ("EnvelopePrc6", QPageSize::EnvelopePrc6, "@brief Enum constant QPageSize::EnvelopePrc6") +
    gsi::enum_const ("EnvelopePrc7", QPageSize::EnvelopePrc7, "@brief Enum constant QPageSize::EnvelopePrc7") +
    gsi::enum_const ("EnvelopePrc8", QPageSize::EnvelopePrc8, "@brief Enum constant QPageSize::EnvelopePrc8") +
    gsi::enum_const ("EnvelopePrc9", QPageSize::EnvelopePrc9, "@brief Enum constant QPageSize::EnvelopePrc9") +
    gsi::enum_const ("EnvelopePrc10", QPageSize::EnvelopePrc10, "@brief Enum constant QPageSize::EnvelopePrc10") +
    gsi::enum_const ("EnvelopeYou4", QPageSize::EnvelopeYou4, "@brief Enum constant QPageSize::EnvelopeYou4") +
    gsi::enum_const ("LastPageSize", QPageSize::LastPageSize, "@brief Enum constant QPageSize::LastPageSize") +
    gsi::enum_const ("NPageSize", QPageSize::NPageSize, "@brief Enum constant QPageSize::NPageSize") +
    gsi::enum_const ("NPaperSize", QPageSize::NPaperSize, "@brief Enum constant QPageSize::NPaperSize") +
    gsi::enum_const ("AnsiA", QPageSize::AnsiA, "@brief Enum constant QPageSize::AnsiA") +
    gsi::enum_const ("AnsiB", QPageSize::AnsiB, "@brief Enum constant QPageSize::AnsiB") +
    gsi::enum_const ("EnvelopeC5", QPageSize::EnvelopeC5, "@brief Enum constant QPageSize::EnvelopeC5") +
    gsi::enum_const ("EnvelopeDL", QPageSize::EnvelopeDL, "@brief Enum constant QPageSize::EnvelopeDL") +
    gsi::enum_const ("Envelope10", QPageSize::Envelope10, "@brief Enum constant QPageSize::Envelope10"),
  "@qt\n@brief This class represents the QPageSize::PageSizeId enum");

static gsi::QFlagsClass<QPageSize::PageSizeId > decl_QPageSize_PageSizeId_Enums ("QtGui", "QPageSize_QFlags_PageSizeId",
  "@qt\n@brief This class represents the QFlags<QPageSize::PageSizeId> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QPageSize> inject_QPageSize_PageSizeId_Enum_in_parent (decl_QPageSize_PageSizeId_Enum.defs ());
static gsi::ClassExt<QPageSize> decl_QPageSize_PageSizeId_Enum_as_child (decl_QPageSize_PageSizeId_Enum, "PageSizeId");
static gsi::ClassExt<QPageSize> decl_QPageSize_PageSizeId_Enums_as_child (decl_QPageSize_PageSizeId_Enums, "QFlags_PageSizeId");

}


//  Implementation of the enum wrapper class for QPageSize::SizeMatchPolicy
namespace qt_gsi
{

static gsi::Enum<QPageSize::SizeMatchPolicy> decl_QPageSize_SizeMatchPolicy_Enum ("QtGui", "QPageSize_SizeMatchPolicy",
    gsi::enum_const ("FuzzyMatch", QPageSize::FuzzyMatch, "@brief Enum constant QPageSize::FuzzyMatch") +
    gsi::enum_const ("FuzzyOrientationMatch", QPageSize::FuzzyOrientationMatch, "@brief Enum constant QPageSize::FuzzyOrientationMatch") +
    gsi::enum_const ("ExactMatch", QPageSize::ExactMatch, "@brief Enum constant QPageSize::ExactMatch"),
  "@qt\n@brief This class represents the QPageSize::SizeMatchPolicy enum");

static gsi::QFlagsClass<QPageSize::SizeMatchPolicy > decl_QPageSize_SizeMatchPolicy_Enums ("QtGui", "QPageSize_QFlags_SizeMatchPolicy",
  "@qt\n@brief This class represents the QFlags<QPageSize::SizeMatchPolicy> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QPageSize> inject_QPageSize_SizeMatchPolicy_Enum_in_parent (decl_QPageSize_SizeMatchPolicy_Enum.defs ());
static gsi::ClassExt<QPageSize> decl_QPageSize_SizeMatchPolicy_Enum_as_child (decl_QPageSize_SizeMatchPolicy_Enum, "SizeMatchPolicy");
static gsi::ClassExt<QPageSize> decl_QPageSize_SizeMatchPolicy_Enums_as_child (decl_QPageSize_SizeMatchPolicy_Enums, "QFlags_SizeMatchPolicy");

}


//  Implementation of the enum wrapper class for QPageSize::Unit
namespace qt_gsi
{

static gsi::Enum<QPageSize::Unit> decl_QPageSize_Unit_Enum ("QtGui", "QPageSize_Unit",
    gsi::enum_const ("Millimeter", QPageSize::Millimeter, "@brief Enum constant QPageSize::Millimeter") +
    gsi::enum_const ("Point", QPageSize::Point, "@brief Enum constant QPageSize::Point") +
    gsi::enum_const ("Inch", QPageSize::Inch, "@brief Enum constant QPageSize::Inch") +
    gsi::enum_const ("Pica", QPageSize::Pica, "@brief Enum constant QPageSize::Pica") +
    gsi::enum_const ("Didot", QPageSize::Didot, "@brief Enum constant QPageSize::Didot") +
    gsi::enum_const ("Cicero", QPageSize::Cicero, "@brief Enum constant QPageSize::Cicero"),
  "@qt\n@brief This class represents the QPageSize::Unit enum");

static gsi::QFlagsClass<QPageSize::Unit > decl_QPageSize_Unit_Enums ("QtGui", "QPageSize_QFlags_Unit",
  "@qt\n@brief This class represents the QFlags<QPageSize::Unit> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QPageSize> inject_QPageSize_Unit_Enum_in_parent (decl_QPageSize_Unit_Enum.defs ());
static gsi::ClassExt<QPageSize> decl_QPageSize_Unit_Enum_as_child (decl_QPageSize_Unit_Enum, "Unit");
static gsi::ClassExt<QPageSize> decl_QPageSize_Unit_Enums_as_child (decl_QPageSize_Unit_Enums, "QFlags_Unit");

}

