%
% Copyright (c) 2024 Analog Devices Inc.
%
% This file is part of libm2k
% (see http://www.github.com/analogdevicesinc/libm2k).
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU Lesser General Public License as published by
% the Free Software Foundation, either version 2.1 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU Lesser General Public License for more details.
%
% You should have received a copy of the GNU Lesser General Public License
% along with this program. If not, see <http://www.gnu.org/licenses/>.
%

%% About definelibm2k.m
% This file defines the MATLAB interface to the library |libm2k|.
%
% Commented sections represent C++ functionality that MATLAB cannot automatically define. To include
% functionality, uncomment a section and provide values for <SHAPE>, <DIRECTION>, etc. For more
% information, see helpview(fullfile(docroot,'matlab','helptargets.map'),'cpp_define_interface') to "Define MATLAB Interface for C++ Library".



%% Setup
% Do not edit this setup section.
function libDef = definelibm2k()
libDef = clibgen.LibraryDefinition("libm2kData.xml");

%% OutputFolder and Libraries 
libDef.OutputFolder = "C:\Users\imuthi\OneDrive - Analog Devices, Inc\Documents\libm2k\libm2k\bindings\matlab";
libDef.Libraries = "C:\Users\imuthi\OneDrive - Analog Devices, Inc\Documents\libm2k\libm2k\bindings\matlab\libm2k\libm2k.lib";

%% C++ class |iio_channel| with MATLAB name |clib.libm2k.iio_channel| 
iio_channelDefinition = addClass(libDef, "iio_channel", "MATLABName", "clib.libm2k.iio_channel", ...
    "Description", "clib.libm2k.iio_channel    Representation of C++ class iio_channel."); % Modify help description values as needed.

%% C++ class |iio_device| with MATLAB name |clib.libm2k.iio_device| 
iio_deviceDefinition = addClass(libDef, "iio_device", "MATLABName", "clib.libm2k.iio_device", ...
    "Description", "clib.libm2k.iio_device    Representation of C++ class iio_device."); % Modify help description values as needed.

%% C++ class |iio_buffer| with MATLAB name |clib.libm2k.iio_buffer| 
iio_bufferDefinition = addClass(libDef, "iio_buffer", "MATLABName", "clib.libm2k.iio_buffer", ...
    "Description", "clib.libm2k.iio_buffer    Representation of C++ class iio_buffer."); % Modify help description values as needed.

%% C++ class |iio_context| with MATLAB name |clib.libm2k.iio_context| 
iio_contextDefinition = addClass(libDef, "iio_context", "MATLABName", "clib.libm2k.iio_context", ...
    "Description", "clib.libm2k.iio_context    Representation of C++ class iio_context."); % Modify help description values as needed.

%% C++ enumeration |ContextTypes| with MATLAB name |clib.libm2k.ContextTypes| 
addEnumeration(libDef, "ContextTypes", "int32",...
    [...
      "CtxFMCOMMS",...  % 0
      "CtxM2K",...  % 1
      "Other",...  % 2
    ],...
    "MATLABName", "clib.libm2k.ContextTypes", ...
    "Description", "clib.libm2k.ContextTypes    Representation of C++ enumeration ContextTypes."); % Modify help description values as needed.

%% C++ enumeration |libm2k::M2K_TRIGGER_CONDITION_ANALOG| with MATLAB name |clib.libm2k.libm2k.M2K_TRIGGER_CONDITION_ANALOG| 
addEnumeration(libDef, "libm2k::M2K_TRIGGER_CONDITION_ANALOG", "int32",...
    [...
      "RISING_EDGE_ANALOG",...  % 0
      "FALLING_EDGE_ANALOG",...  % 1
      "LOW_LEVEL_ANALOG",...  % 2
      "HIGH_LEVEL_ANALOG",...  % 3
    ],...
    "MATLABName", "clib.libm2k.libm2k.M2K_TRIGGER_CONDITION_ANALOG", ...
    "Description", "clib.libm2k.libm2k.M2K_TRIGGER_CONDITION_ANALOG    Representation of C++ enumeration libm2k::M2K_TRIGGER_CONDITION_ANALOG." + newline + ...
    "Condition of triggering", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.

%% C++ enumeration |libm2k::M2K_TRIGGER_CONDITION_DIGITAL| with MATLAB name |clib.libm2k.libm2k.M2K_TRIGGER_CONDITION_DIGITAL| 
addEnumeration(libDef, "libm2k::M2K_TRIGGER_CONDITION_DIGITAL", "int32",...
    [...
      "RISING_EDGE_DIGITAL",...  % 0
      "FALLING_EDGE_DIGITAL",...  % 1
      "LOW_LEVEL_DIGITAL",...  % 2
      "HIGH_LEVEL_DIGITAL",...  % 3
      "ANY_EDGE_DIGITAL",...  % 4
      "NO_TRIGGER_DIGITAL",...  % 5
    ],...
    "MATLABName", "clib.libm2k.libm2k.M2K_TRIGGER_CONDITION_DIGITAL", ...
    "Description", "clib.libm2k.libm2k.M2K_TRIGGER_CONDITION_DIGITAL    Representation of C++ enumeration libm2k::M2K_TRIGGER_CONDITION_DIGITAL." + newline + ...
    "Condition of triggering", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.

%% C++ enumeration |libm2k::M2K_TRIGGER_MODE| with MATLAB name |clib.libm2k.libm2k.M2K_TRIGGER_MODE| 
addEnumeration(libDef, "libm2k::M2K_TRIGGER_MODE", "int32",...
    [...
      "ALWAYS",...  % 0
      "ANALOG",...  % 1
      "EXTERNAL",...  % 2
      "DIGITAL_OR_ANALOG",...  % 3
      "DIGITAL_AND_ANALOG",...  % 4
      "DIGITAL_XOR_ANALOG",...  % 5
      "N_DIGITAL_OR_ANALOG",...  % 6
      "N_DIGITAL_AND_ANALOG",...  % 7
      "N_DIGITAL_XOR_ANALOG",...  % 8
    ],...
    "MATLABName", "clib.libm2k.libm2k.M2K_TRIGGER_MODE", ...
    "Description", "clib.libm2k.libm2k.M2K_TRIGGER_MODE    Representation of C++ enumeration libm2k::M2K_TRIGGER_MODE." + newline + ...
    "Select the mode for the analog trigger", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@enum M2K_TRIGGER_MODE" + newline + ...
    "	@brief Select the mode for the analog trigger", ...
    "EnumerantDescriptions", ...
    [...
      "ALWAYS - Disable analog trigger;",...  % ALWAYS
      "ANALOG - Trigger condition specified only by analog trigger (CH1 and CH2)",...  % ANALOG
      "EXTERNAL - Trigger condition specified only by external trigger (TI)",...  % EXTERNAL
      "",...  % DIGITAL_OR_ANALOG
      "",...  % DIGITAL_AND_ANALOG
      "",...  % DIGITAL_XOR_ANALOG
      "",...  % N_DIGITAL_OR_ANALOG
      "",...  % N_DIGITAL_AND_ANALOG
      "",...  % N_DIGITAL_XOR_ANALOG
    ]); % Modify help description values as needed.

%% C++ class |libm2k::M2kHardwareTrigger| with MATLAB name |clib.libm2k.libm2k.M2kHardwareTrigger| 
M2kHardwareTriggerDefinition = addClass(libDef, "libm2k::M2kHardwareTrigger", "MATLABName", "clib.libm2k.libm2k.M2kHardwareTrigger", ...
    "Description", "clib.libm2k.libm2k.M2kHardwareTrigger    Representation of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "Contains the representation of the ADALM2000 trigger system" + newline + ...
    "" + newline + ...
    "@class M2kHardwareTrigger m2khardwaretrigger.hpp libm2k/m2khardwaretrigger.hpp" + newline + ...
    "@brief Controls the hardware trigger for ADALM2000", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@defgroup m2ktrigger HardwareTrigger" + newline + ...
    "@brief Contains the representation of the ADALM2000 trigger system" + newline + ...
    "" + newline + ...
    "@class M2kHardwareTrigger m2khardwaretrigger.hpp libm2k/m2khardwaretrigger.hpp" + newline + ...
    "@brief Controls the hardware trigger for ADALM2000"); % Modify help description values as needed.

%% C++ class method |reset| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: void libm2k::M2kHardwareTrigger::reset()

resetDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "void libm2k::M2kHardwareTrigger::reset()", ...
    "MATLABName", "reset", ...
    "Description", "reset Method of C++ class libm2k::M2kHardwareTrigger.", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@private"); % Modify help description values as needed.
validate(resetDefinition);

%% C++ class method |getAnalogLevelRaw| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: int libm2k::M2kHardwareTrigger::getAnalogLevelRaw(unsigned int chnIdx)

getAnalogLevelRawDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "int libm2k::M2kHardwareTrigger::getAnalogLevelRaw(unsigned int chnIdx)", ...
    "MATLABName", "getAnalogLevelRaw", ...
    "Description", "getAnalogLevelRaw Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "Get the raw analog trigger level for one channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getAnalogLevelRawDefinition, "chnIdx", "uint32", "Description", "chnIdx the required channel");
defineOutput(getAnalogLevelRawDefinition, "RetVal", "int32", "Description", "the raw analog trigger level");
validate(getAnalogLevelRawDefinition);

%% C++ class method |setAnalogLevelRaw| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: void libm2k::M2kHardwareTrigger::setAnalogLevelRaw(unsigned int chnIdx,int level)

setAnalogLevelRawDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "void libm2k::M2kHardwareTrigger::setAnalogLevelRaw(unsigned int chnIdx,int level)", ...
    "MATLABName", "setAnalogLevelRaw", ...
    "Description", "setAnalogLevelRaw Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "Set the raw analog trigger level for one channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setAnalogLevelRawDefinition, "chnIdx", "uint32", "Description", "chnIdx the required channel");
defineArgument(setAnalogLevelRawDefinition, "level", "int32", "Description", "level the raw analog trigger level");
validate(setAnalogLevelRawDefinition);

%% C++ class method |setAnalogLevel| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: void libm2k::M2kHardwareTrigger::setAnalogLevel(unsigned int chnIdx,double v_level)

setAnalogLevelDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "void libm2k::M2kHardwareTrigger::setAnalogLevel(unsigned int chnIdx,double v_level)", ...
    "MATLABName", "setAnalogLevel", ...
    "Description", "setAnalogLevel Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "Set the analog trigger level for one channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setAnalogLevelDefinition, "chnIdx", "uint32", "Description", "chnIdx the required channel");
defineArgument(setAnalogLevelDefinition, "v_level", "double", "Description", "v_level the analog trigger level in volts");
validate(setAnalogLevelDefinition);

%% C++ class method |getAnalogLevel| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: double libm2k::M2kHardwareTrigger::getAnalogLevel(unsigned int chnIdx)

getAnalogLevelDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "double libm2k::M2kHardwareTrigger::getAnalogLevel(unsigned int chnIdx)", ...
    "MATLABName", "getAnalogLevel", ...
    "Description", "getAnalogLevel Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "Get the analog trigger level for one channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getAnalogLevelDefinition, "chnIdx", "uint32", "Description", "chnIdx the required channel");
defineOutput(getAnalogLevelDefinition, "RetVal", "double", "Description", "the analog trigger level in volts");
validate(getAnalogLevelDefinition);

%% C++ class method |getAnalogHysteresis| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: double libm2k::M2kHardwareTrigger::getAnalogHysteresis(unsigned int chnIdx)

getAnalogHysteresisDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "double libm2k::M2kHardwareTrigger::getAnalogHysteresis(unsigned int chnIdx)", ...
    "MATLABName", "getAnalogHysteresis", ...
    "Description", "getAnalogHysteresis Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "Get the analog hysteresis value for one channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getAnalogHysteresisDefinition, "chnIdx", "uint32", "Description", "chnIdx the required channel");
defineOutput(getAnalogHysteresisDefinition, "RetVal", "double", "Description", "the value of the hysteresis in Volts");
validate(getAnalogHysteresisDefinition);

%% C++ class method |setAnalogHysteresis| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: void libm2k::M2kHardwareTrigger::setAnalogHysteresis(unsigned int chnIdx,double hysteresis)

setAnalogHysteresisDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "void libm2k::M2kHardwareTrigger::setAnalogHysteresis(unsigned int chnIdx,double hysteresis)", ...
    "MATLABName", "setAnalogHysteresis", ...
    "Description", "setAnalogHysteresis Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "Set the analog hysteresis value for one channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setAnalogHysteresisDefinition, "chnIdx", "uint32", "Description", "chnIdx the required channel");
defineArgument(setAnalogHysteresisDefinition, "hysteresis", "double", "Description", "hysteresis in Volts");
validate(setAnalogHysteresisDefinition);

%% C++ class method |getAnalogCondition| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: libm2k::M2K_TRIGGER_CONDITION_ANALOG libm2k::M2kHardwareTrigger::getAnalogCondition(unsigned int chnIdx)

getAnalogConditionDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "libm2k::M2K_TRIGGER_CONDITION_ANALOG libm2k::M2kHardwareTrigger::getAnalogCondition(unsigned int chnIdx)", ...
    "MATLABName", "getAnalogCondition", ...
    "Description", "getAnalogCondition Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "Get the trigger condition for the analog trigger on a specific channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getAnalogConditionDefinition, "chnIdx", "uint32", "Description", "chnIdx the required channel");
defineOutput(getAnalogConditionDefinition, "RetVal", "clib.libm2k.libm2k.M2K_TRIGGER_CONDITION_ANALOG", "Description", "the trigger condition");
validate(getAnalogConditionDefinition);

%% C++ class method |setAnalogCondition| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: void libm2k::M2kHardwareTrigger::setAnalogCondition(unsigned int chnIdx,libm2k::M2K_TRIGGER_CONDITION_ANALOG cond)

setAnalogConditionDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "void libm2k::M2kHardwareTrigger::setAnalogCondition(unsigned int chnIdx,libm2k::M2K_TRIGGER_CONDITION_ANALOG cond)", ...
    "MATLABName", "setAnalogCondition", ...
    "Description", "setAnalogCondition Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "Set the trigger condition for the analog trigger on a specific channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setAnalogConditionDefinition, "chnIdx", "uint32", "Description", "chnIdx the required channel");
defineArgument(setAnalogConditionDefinition, "cond", "clib.libm2k.libm2k.M2K_TRIGGER_CONDITION_ANALOG", "Description", "cond the specific trigger condition");
validate(setAnalogConditionDefinition);

%% C++ class method |getDigitalCondition| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: libm2k::M2K_TRIGGER_CONDITION_DIGITAL libm2k::M2kHardwareTrigger::getDigitalCondition(unsigned int chnIdx)

getDigitalConditionDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "libm2k::M2K_TRIGGER_CONDITION_DIGITAL libm2k::M2kHardwareTrigger::getDigitalCondition(unsigned int chnIdx)", ...
    "MATLABName", "getDigitalCondition", ...
    "Description", "getDigitalCondition Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "Get the trigger condition for the digital trigger on a specific channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getDigitalConditionDefinition, "chnIdx", "uint32", "Description", "chnIdx The index of the required channel");
defineOutput(getDigitalConditionDefinition, "RetVal", "clib.libm2k.libm2k.M2K_TRIGGER_CONDITION_DIGITAL", "Description", "The trigger condition");
validate(getDigitalConditionDefinition);

%% C++ class method |getDigitalCondition| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: libm2k::M2K_TRIGGER_CONDITION_DIGITAL libm2k::M2kHardwareTrigger::getDigitalCondition(libm2k::digital::DIO_CHANNEL chnIdx)

getDigitalConditionDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "libm2k::M2K_TRIGGER_CONDITION_DIGITAL libm2k::M2kHardwareTrigger::getDigitalCondition(libm2k::digital::DIO_CHANNEL chnIdx)", ...
    "MATLABName", "getDigitalCondition", ...
    "Description", "getDigitalCondition Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "Get the trigger condition for the digital trigger on a specific channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getDigitalConditionDefinition, "chnIdx", "clib.libm2k.libm2k.digital.DIO_CHANNEL", "Description", "chnIdx An enumerator corresponding to the index of the required channel");
defineOutput(getDigitalConditionDefinition, "RetVal", "clib.libm2k.libm2k.M2K_TRIGGER_CONDITION_DIGITAL", "Description", "The trigger condition");
validate(getDigitalConditionDefinition);

%% C++ class method |setDigitalCondition| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: void libm2k::M2kHardwareTrigger::setDigitalCondition(unsigned int chnIdx,libm2k::M2K_TRIGGER_CONDITION_DIGITAL cond)

setDigitalConditionDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "void libm2k::M2kHardwareTrigger::setDigitalCondition(unsigned int chnIdx,libm2k::M2K_TRIGGER_CONDITION_DIGITAL cond)", ...
    "MATLABName", "setDigitalCondition", ...
    "Description", "setDigitalCondition Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "Set the trigger condition for the digital trigger on a specific channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setDigitalConditionDefinition, "chnIdx", "uint32", "Description", "chnIdx The index of the required channel");
defineArgument(setDigitalConditionDefinition, "cond", "clib.libm2k.libm2k.M2K_TRIGGER_CONDITION_DIGITAL", "Description", "cond the specific trigger condition");
validate(setDigitalConditionDefinition);

%% C++ class method |setDigitalCondition| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: void libm2k::M2kHardwareTrigger::setDigitalCondition(libm2k::digital::DIO_CHANNEL chnIdx,libm2k::M2K_TRIGGER_CONDITION_DIGITAL cond)

setDigitalConditionDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "void libm2k::M2kHardwareTrigger::setDigitalCondition(libm2k::digital::DIO_CHANNEL chnIdx,libm2k::M2K_TRIGGER_CONDITION_DIGITAL cond)", ...
    "MATLABName", "setDigitalCondition", ...
    "Description", "setDigitalCondition Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "Set the trigger condition for the digital trigger on a specific channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setDigitalConditionDefinition, "chnIdx", "clib.libm2k.libm2k.digital.DIO_CHANNEL", "Description", "chnIdx An enumerator corresponding to the index of the required channel");
defineArgument(setDigitalConditionDefinition, "cond", "clib.libm2k.libm2k.M2K_TRIGGER_CONDITION_DIGITAL", "Description", "cond the specific trigger condition");
validate(setDigitalConditionDefinition);

%% C++ class method |getAnalogMode| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: libm2k::M2K_TRIGGER_MODE libm2k::M2kHardwareTrigger::getAnalogMode(unsigned int chnIdx)

getAnalogModeDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "libm2k::M2K_TRIGGER_MODE libm2k::M2kHardwareTrigger::getAnalogMode(unsigned int chnIdx)", ...
    "MATLABName", "getAnalogMode", ...
    "Description", "getAnalogMode Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "Get the mode for the analog trigger on a specific channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getAnalogModeDefinition, "chnIdx", "uint32", "Description", "chnIdx the required channel");
defineOutput(getAnalogModeDefinition, "RetVal", "clib.libm2k.libm2k.M2K_TRIGGER_MODE", "Description", "the analog trigger mode");
validate(getAnalogModeDefinition);

%% C++ class method |setAnalogMode| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: void libm2k::M2kHardwareTrigger::setAnalogMode(unsigned int chnIdx,libm2k::M2K_TRIGGER_MODE mode)

setAnalogModeDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "void libm2k::M2kHardwareTrigger::setAnalogMode(unsigned int chnIdx,libm2k::M2K_TRIGGER_MODE mode)", ...
    "MATLABName", "setAnalogMode", ...
    "Description", "setAnalogMode Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "Set the mode for the analog trigger on a specific channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setAnalogModeDefinition, "chnIdx", "uint32", "Description", "chnIdx the required channel");
defineArgument(setAnalogModeDefinition, "mode", "clib.libm2k.libm2k.M2K_TRIGGER_MODE", "Description", "mode the analog trigger mode");
validate(setAnalogModeDefinition);

%% C++ class method |getDigitalMode| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: libm2k::digital::DIO_TRIGGER_MODE libm2k::M2kHardwareTrigger::getDigitalMode()

getDigitalModeDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "libm2k::digital::DIO_TRIGGER_MODE libm2k::M2kHardwareTrigger::getDigitalMode()", ...
    "MATLABName", "getDigitalMode", ...
    "Description", "getDigitalMode Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "Get the mode for the digital trigger", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getDigitalModeDefinition, "RetVal", "clib.libm2k.libm2k.digital.DIO_TRIGGER_MODE", "Description", "the digital trigger mode (DIO_OR/DIO_AND)");
validate(getDigitalModeDefinition);

%% C++ class method |setDigitalMode| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: void libm2k::M2kHardwareTrigger::setDigitalMode(libm2k::digital::DIO_TRIGGER_MODE mode)

setDigitalModeDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "void libm2k::M2kHardwareTrigger::setDigitalMode(libm2k::digital::DIO_TRIGGER_MODE mode)", ...
    "MATLABName", "setDigitalMode", ...
    "Description", "setDigitalMode Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "Set the mode for the digital trigger", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setDigitalModeDefinition, "mode", "clib.libm2k.libm2k.digital.DIO_TRIGGER_MODE", "Description", "mode the digital trigger mode (DIO_OR/DIO_AND)");
validate(setDigitalModeDefinition);

%% C++ class method |getAnalogSource| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: libm2k::M2K_TRIGGER_SOURCE_ANALOG libm2k::M2kHardwareTrigger::getAnalogSource()

getAnalogSourceDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "libm2k::M2K_TRIGGER_SOURCE_ANALOG libm2k::M2kHardwareTrigger::getAnalogSource()", ...
    "MATLABName", "getAnalogSource", ...
    "Description", "getAnalogSource Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "Get the source of the analog trigger", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getAnalogSourceDefinition, "RetVal", "clib.libm2k.libm2k.M2K_TRIGGER_SOURCE_ANALOG", "Description", "analog trigger source (channel1, channel2, etc)");
validate(getAnalogSourceDefinition);

%% C++ class method |setAnalogSource| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: void libm2k::M2kHardwareTrigger::setAnalogSource(libm2k::M2K_TRIGGER_SOURCE_ANALOG src)

setAnalogSourceDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "void libm2k::M2kHardwareTrigger::setAnalogSource(libm2k::M2K_TRIGGER_SOURCE_ANALOG src)", ...
    "MATLABName", "setAnalogSource", ...
    "Description", "setAnalogSource Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "Set the source of the analog trigger", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setAnalogSourceDefinition, "src", "clib.libm2k.libm2k.M2K_TRIGGER_SOURCE_ANALOG", "Description", "src analog trigger source (channel1, channel2, etc)");
validate(setAnalogSourceDefinition);

%% C++ class method |getAnalogSourceChannel| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: int libm2k::M2kHardwareTrigger::getAnalogSourceChannel()

getAnalogSourceChannelDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "int libm2k::M2kHardwareTrigger::getAnalogSourceChannel()", ...
    "MATLABName", "getAnalogSourceChannel", ...
    "Description", "getAnalogSourceChannel Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "Get the channel source of the analog trigger", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getAnalogSourceChannelDefinition, "RetVal", "int32", "Description", "analog trigger channel source (channel1, channel2)");
validate(getAnalogSourceChannelDefinition);

%% C++ class method |setAnalogSourceChannel| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: void libm2k::M2kHardwareTrigger::setAnalogSourceChannel(unsigned int chnIdx)

setAnalogSourceChannelDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "void libm2k::M2kHardwareTrigger::setAnalogSourceChannel(unsigned int chnIdx)", ...
    "MATLABName", "setAnalogSourceChannel", ...
    "Description", "setAnalogSourceChannel Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "Set the channel source of the analog trigger", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setAnalogSourceChannelDefinition, "chnIdx", "uint32", "Description", "chnIdx the index of the channel that should be used");
validate(setAnalogSourceChannelDefinition);

%% C++ class method |getAnalogDelay| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: int libm2k::M2kHardwareTrigger::getAnalogDelay() const

getAnalogDelayDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "int libm2k::M2kHardwareTrigger::getAnalogDelay() const", ...
    "MATLABName", "getAnalogDelay", ...
    "Description", "getAnalogDelay Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "Get the analog trigger delay", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getAnalogDelayDefinition, "RetVal", "int32", "Description", "the value of the delay");
validate(getAnalogDelayDefinition);

%% C++ class method |setAnalogDelay| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: void libm2k::M2kHardwareTrigger::setAnalogDelay(int delay)

setAnalogDelayDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "void libm2k::M2kHardwareTrigger::setAnalogDelay(int delay)", ...
    "MATLABName", "setAnalogDelay", ...
    "Description", "setAnalogDelay Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "Set the analog trigger delay", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setAnalogDelayDefinition, "delay", "int32", "Description", "delay the value of the analog delay");
validate(setAnalogDelayDefinition);

%% C++ class method |getDigitalDelay| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: int libm2k::M2kHardwareTrigger::getDigitalDelay() const

getDigitalDelayDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "int libm2k::M2kHardwareTrigger::getDigitalDelay() const", ...
    "MATLABName", "getDigitalDelay", ...
    "Description", "getDigitalDelay Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "Get the digital trigger delay", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getDigitalDelayDefinition, "RetVal", "int32", "Description", "the value of the digital delay");
validate(getDigitalDelayDefinition);

%% C++ class method |setDigitalDelay| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: void libm2k::M2kHardwareTrigger::setDigitalDelay(int delay)

setDigitalDelayDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "void libm2k::M2kHardwareTrigger::setDigitalDelay(int delay)", ...
    "MATLABName", "setDigitalDelay", ...
    "Description", "setDigitalDelay Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "Set the digital trigger delay", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setDigitalDelayDefinition, "delay", "int32", "Description", "delay the value of the digital delay");
validate(setDigitalDelayDefinition);

%% C++ class method |getCurrentHwSettings| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: libm2k::SETTINGS * libm2k::M2kHardwareTrigger::getCurrentHwSettings()

%getCurrentHwSettingsDefinition = addMethod(M2kHardwareTriggerDefinition, ...
%    "libm2k::SETTINGS * libm2k::M2kHardwareTrigger::getCurrentHwSettings()", ...
%    "MATLABName", "getCurrentHwSettings", ...
%    "Description", "getCurrentHwSettings Method of C++ class libm2k::M2kHardwareTrigger.", ...
%    "DetailedDescription", "This content is from the external library documentation." + newline + ...
%    "" + newline + ...
%    "@private"); % Modify help description values as needed.
%defineOutput(getCurrentHwSettingsDefinition, "RetVal", "clib.libm2k.libm2k.SETTINGS", <SHAPE>);
%validate(getCurrentHwSettingsDefinition);

%% C++ class method |setHwTriggerSettings| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: void libm2k::M2kHardwareTrigger::setHwTriggerSettings(libm2k::SETTINGS * settings)

%setHwTriggerSettingsDefinition = addMethod(M2kHardwareTriggerDefinition, ...
%    "void libm2k::M2kHardwareTrigger::setHwTriggerSettings(libm2k::SETTINGS * settings)", ...
%    "MATLABName", "setHwTriggerSettings", ...
%    "Description", "setHwTriggerSettings Method of C++ class libm2k::M2kHardwareTrigger.", ...
%    "DetailedDescription", "This content is from the external library documentation." + newline + ...
%    "" + newline + ...
%    "@private"); % Modify help description values as needed.
%defineArgument(setHwTriggerSettingsDefinition, "settings", "clib.libm2k.libm2k.SETTINGS", "input", <SHAPE>); % <MLTYPE> can be "clib.libm2k.libm2k.SETTINGS", or "clib.array.libm2k.libm2k.SETTINGS"
%validate(setHwTriggerSettingsDefinition);

%% C++ class method |setAnalogStreamingFlag| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: void libm2k::M2kHardwareTrigger::setAnalogStreamingFlag(bool enable)

setAnalogStreamingFlagDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "void libm2k::M2kHardwareTrigger::setAnalogStreamingFlag(bool enable)", ...
    "MATLABName", "setAnalogStreamingFlag", ...
    "Description", "setAnalogStreamingFlag Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "Set the streaming flag for the analog part", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setAnalogStreamingFlagDefinition, "enable", "logical", "Description", "enable the streaming");
validate(setAnalogStreamingFlagDefinition);

%% C++ class method |getAnalogStreamingFlag| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: bool libm2k::M2kHardwareTrigger::getAnalogStreamingFlag()

getAnalogStreamingFlagDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "bool libm2k::M2kHardwareTrigger::getAnalogStreamingFlag()", ...
    "MATLABName", "getAnalogStreamingFlag", ...
    "Description", "getAnalogStreamingFlag Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "Get the streaming flag for the analog part", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getAnalogStreamingFlagDefinition, "RetVal", "logical", "Description", "whether the streaming is enabled (true/false)");
validate(getAnalogStreamingFlagDefinition);

%% C++ class method |setDigitalStreamingFlag| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: void libm2k::M2kHardwareTrigger::setDigitalStreamingFlag(bool enable)

setDigitalStreamingFlagDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "void libm2k::M2kHardwareTrigger::setDigitalStreamingFlag(bool enable)", ...
    "MATLABName", "setDigitalStreamingFlag", ...
    "Description", "setDigitalStreamingFlag Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "Set the streaming flag for the digital part", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setDigitalStreamingFlagDefinition, "enable", "logical", "Description", "enable the streaming");
validate(setDigitalStreamingFlagDefinition);

%% C++ class method |getDigitalStreamingFlag| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: bool libm2k::M2kHardwareTrigger::getDigitalStreamingFlag()

getDigitalStreamingFlagDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "bool libm2k::M2kHardwareTrigger::getDigitalStreamingFlag()", ...
    "MATLABName", "getDigitalStreamingFlag", ...
    "Description", "getDigitalStreamingFlag Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "Get the streaming flag for the digital part", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getDigitalStreamingFlagDefinition, "RetVal", "logical", "Description", "whether the streaming is enabled (true/false)");
validate(getDigitalStreamingFlagDefinition);

%% C++ class method |setCalibParameters| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: void libm2k::M2kHardwareTrigger::setCalibParameters(unsigned int chnIdx,double scaling,double vert_offset)

setCalibParametersDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "void libm2k::M2kHardwareTrigger::setCalibParameters(unsigned int chnIdx,double scaling,double vert_offset)", ...
    "MATLABName", "setCalibParameters", ...
    "Description", "setCalibParameters Method of C++ class libm2k::M2kHardwareTrigger.", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@private"); % Modify help description values as needed.
defineArgument(setCalibParametersDefinition, "chnIdx", "uint32");
defineArgument(setCalibParametersDefinition, "scaling", "double");
defineArgument(setCalibParametersDefinition, "vert_offset", "double");
validate(setCalibParametersDefinition);

%% C++ class method |getAnalogExternalCondition| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: libm2k::M2K_TRIGGER_CONDITION_DIGITAL libm2k::M2kHardwareTrigger::getAnalogExternalCondition(unsigned int chnIdx)

getAnalogExternalConditionDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "libm2k::M2K_TRIGGER_CONDITION_DIGITAL libm2k::M2kHardwareTrigger::getAnalogExternalCondition(unsigned int chnIdx)", ...
    "MATLABName", "getAnalogExternalCondition", ...
    "Description", "getAnalogExternalCondition Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "getAnalogExternalCondition", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getAnalogExternalConditionDefinition, "chnIdx", "uint32", "Description", "chnIdx : integer - the index of the required channel");
defineOutput(getAnalogExternalConditionDefinition, "RetVal", "clib.libm2k.libm2k.M2K_TRIGGER_CONDITION_DIGITAL", "Description", "M2K_TRIGGER_CONDITION_DIGITAL");
validate(getAnalogExternalConditionDefinition);

%% C++ class method |setAnalogExternalCondition| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: void libm2k::M2kHardwareTrigger::setAnalogExternalCondition(unsigned int chnIdx,libm2k::M2K_TRIGGER_CONDITION_DIGITAL cond)

setAnalogExternalConditionDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "void libm2k::M2kHardwareTrigger::setAnalogExternalCondition(unsigned int chnIdx,libm2k::M2K_TRIGGER_CONDITION_DIGITAL cond)", ...
    "MATLABName", "setAnalogExternalCondition", ...
    "Description", "setAnalogExternalCondition Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "setAnalogExternalCondition", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setAnalogExternalConditionDefinition, "chnIdx", "uint32", "Description", "chnIdx : integer - the index of the required channel");
defineArgument(setAnalogExternalConditionDefinition, "cond", "clib.libm2k.libm2k.M2K_TRIGGER_CONDITION_DIGITAL", "Description", "cond : M2K_TRIGGER_CONDITION_DIGITAL");
validate(setAnalogExternalConditionDefinition);

%% C++ class method |getDigitalExternalCondition| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: libm2k::M2K_TRIGGER_CONDITION_DIGITAL libm2k::M2kHardwareTrigger::getDigitalExternalCondition() const

getDigitalExternalConditionDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "libm2k::M2K_TRIGGER_CONDITION_DIGITAL libm2k::M2kHardwareTrigger::getDigitalExternalCondition() const", ...
    "MATLABName", "getDigitalExternalCondition", ...
    "Description", "getDigitalExternalCondition Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "getDigitalExternalCondition", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getDigitalExternalConditionDefinition, "RetVal", "clib.libm2k.libm2k.M2K_TRIGGER_CONDITION_DIGITAL", "Description", "M2K_TRIGGER_CONDITION_DIGITAL");
validate(getDigitalExternalConditionDefinition);

%% C++ class method |setDigitalExternalCondition| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: void libm2k::M2kHardwareTrigger::setDigitalExternalCondition(libm2k::M2K_TRIGGER_CONDITION_DIGITAL cond)

setDigitalExternalConditionDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "void libm2k::M2kHardwareTrigger::setDigitalExternalCondition(libm2k::M2K_TRIGGER_CONDITION_DIGITAL cond)", ...
    "MATLABName", "setDigitalExternalCondition", ...
    "Description", "setDigitalExternalCondition Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "setDigitalExternalCondition", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setDigitalExternalConditionDefinition, "cond", "clib.libm2k.libm2k.M2K_TRIGGER_CONDITION_DIGITAL", "Description", "cond : M2K_TRIGGER_CONDITION_DIGITAL");
validate(setDigitalExternalConditionDefinition);

%% C++ class method |setAnalogExternalOutSelect| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: void libm2k::M2kHardwareTrigger::setAnalogExternalOutSelect(libm2k::M2K_TRIGGER_OUT_SELECT output_select)

setAnalogExternalOutSelectDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "void libm2k::M2kHardwareTrigger::setAnalogExternalOutSelect(libm2k::M2K_TRIGGER_OUT_SELECT output_select)", ...
    "MATLABName", "setAnalogExternalOutSelect", ...
    "Description", "setAnalogExternalOutSelect Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "Select what should be redirected on the TO (trigger out) pin.\n" + newline + ...
    "	 *	The options are (none, trigger in, digital in, analog in).\n", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setAnalogExternalOutSelectDefinition, "output_select", "clib.libm2k.libm2k.M2K_TRIGGER_OUT_SELECT", "Description", "output_select : of type M2K_TRIGGER_OUT_SELECT:\n" + newline + ...
    "	 *	SELECT_TRIGGER_IN - forwards trigger events from TI pin(trigger in);\n" + newline + ...
    "	 *	SELECT_DIGITAL_IN - forwards trigger events from DigitalIn interface;\n" + newline + ...
    "	 *	SELECT_ANALOG_IN  - forwards trigger events from AnalogIn interface;\n" + newline + ...
    "	 *	SELECT_NONE - no trigger event is forwarded;\n");
validate(setAnalogExternalOutSelectDefinition);

%% C++ class method |getAnalogExternalOutSelect| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: libm2k::M2K_TRIGGER_OUT_SELECT libm2k::M2kHardwareTrigger::getAnalogExternalOutSelect()

getAnalogExternalOutSelectDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "libm2k::M2K_TRIGGER_OUT_SELECT libm2k::M2kHardwareTrigger::getAnalogExternalOutSelect()", ...
    "MATLABName", "getAnalogExternalOutSelect", ...
    "Description", "getAnalogExternalOutSelect Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "Check which trigger events are forwarded on the TO (trigger out) pin.", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getAnalogExternalOutSelectDefinition, "RetVal", "clib.libm2k.libm2k.M2K_TRIGGER_OUT_SELECT", "Description", "M2K_TRIGGER_OUT_SELECT :\n" + newline + ...
    "	 *	SELECT_NONE;\n" + newline + ...
    "	 *	SELECT_TRIGGER_IN;\n" + newline + ...
    "	 *	SELECT_DIGITAL_IN;\n" + newline + ...
    "	 *	SELECT_ANALOG_IN;\n" + newline + ...
    "	 @note Only available from firmware v0.24.");
validate(getAnalogExternalOutSelectDefinition);

%% C++ class method |hasExternalTriggerIn| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: bool libm2k::M2kHardwareTrigger::hasExternalTriggerIn() const

hasExternalTriggerInDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "bool libm2k::M2kHardwareTrigger::hasExternalTriggerIn() const", ...
    "MATLABName", "hasExternalTriggerIn", ...
    "Description", "hasExternalTriggerIn Method of C++ class libm2k::M2kHardwareTrigger.", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@private"); % Modify help description values as needed.
defineOutput(hasExternalTriggerInDefinition, "RetVal", "logical");
validate(hasExternalTriggerInDefinition);

%% C++ class method |hasExternalTriggerOut| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: bool libm2k::M2kHardwareTrigger::hasExternalTriggerOut() const

hasExternalTriggerOutDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "bool libm2k::M2kHardwareTrigger::hasExternalTriggerOut() const", ...
    "MATLABName", "hasExternalTriggerOut", ...
    "Description", "hasExternalTriggerOut Method of C++ class libm2k::M2kHardwareTrigger.", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@private"); % Modify help description values as needed.
defineOutput(hasExternalTriggerOutDefinition, "RetVal", "logical");
validate(hasExternalTriggerOutDefinition);

%% C++ class method |hasCrossInstrumentTrigger| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: bool libm2k::M2kHardwareTrigger::hasCrossInstrumentTrigger() const

hasCrossInstrumentTriggerDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "bool libm2k::M2kHardwareTrigger::hasCrossInstrumentTrigger() const", ...
    "MATLABName", "hasCrossInstrumentTrigger", ...
    "Description", "hasCrossInstrumentTrigger Method of C++ class libm2k::M2kHardwareTrigger.", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@private"); % Modify help description values as needed.
defineOutput(hasCrossInstrumentTriggerDefinition, "RetVal", "logical");
validate(hasCrossInstrumentTriggerDefinition);

%% C++ class method |setDigitalSource| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: void libm2k::M2kHardwareTrigger::setDigitalSource(libm2k::M2K_TRIGGER_SOURCE_DIGITAL external_src)

setDigitalSourceDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "void libm2k::M2kHardwareTrigger::setDigitalSource(libm2k::M2K_TRIGGER_SOURCE_DIGITAL external_src)", ...
    "MATLABName", "setDigitalSource", ...
    "Description", "setDigitalSource Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "Select which interface triggers the DigitalIn.", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setDigitalSourceDefinition, "external_src", "clib.libm2k.libm2k.M2K_TRIGGER_SOURCE_DIGITAL", "Description", "external_src: of type M2K_TRIGGER_SOURCE_DIGITAL:\n" + newline + ...
    "	 *	SRC_TRIGGER_IN - trigger events on the TI(trigger in) pin trigger the DigitalIn interface;\n" + newline + ...
    "	 *	SRC_ANALOG_IN - trigger events on the AnalogIn interface trigger the DigitalIn interface;\n" + newline + ...
    "	 *	SRC_NONE - trigger events on the DigitalIn are conditioned by the internal digital trigger structure;\n" + newline + ...
    "	 @note Only available from firmware v0.24.");
validate(setDigitalSourceDefinition);

%% C++ class method |getDigitalSource| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: libm2k::M2K_TRIGGER_SOURCE_DIGITAL libm2k::M2kHardwareTrigger::getDigitalSource() const

getDigitalSourceDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "libm2k::M2K_TRIGGER_SOURCE_DIGITAL libm2k::M2kHardwareTrigger::getDigitalSource() const", ...
    "MATLABName", "getDigitalSource", ...
    "Description", "getDigitalSource Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "Check which is the source of the DigitalIn interface trigger event.", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getDigitalSourceDefinition, "RetVal", "clib.libm2k.libm2k.M2K_TRIGGER_SOURCE_DIGITAL", "Description", "M2K_TRIGGER_SOURCE_DIGITAL :\n" + newline + ...
    "	 *	SRC_TRIGGER_IN;\n" + newline + ...
    "	 *	SRC_ANALOG_IN;\n" + newline + ...
    "	 *	SRC_NONE;\n" + newline + ...
    "	 @note Only available from firmware v0.24.");
validate(getDigitalSourceDefinition);

%% C++ class method |setAnalogOutTriggerSource| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: void libm2k::M2kHardwareTrigger::setAnalogOutTriggerSource(libm2k::M2K_TRIGGER_SOURCE_OUT src)

setAnalogOutTriggerSourceDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "void libm2k::M2kHardwareTrigger::setAnalogOutTriggerSource(libm2k::M2K_TRIGGER_SOURCE_OUT src)", ...
    "MATLABName", "setAnalogOutTriggerSource", ...
    "Description", "setAnalogOutTriggerSource Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "Select which interface triggers the AnalogOut.", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setAnalogOutTriggerSourceDefinition, "src", "clib.libm2k.libm2k.M2K_TRIGGER_SOURCE_OUT", "Description", "src: of type M2K_TRIGGER_SOURCE_OUT:\n" + newline + ...
    "	 *	TRIGGER_NONE - trigger events are disabled;\n" + newline + ...
    "	 *	TRIGGER_TI - trigger events on the TI pin will trigger the AnalogOut interface;\n" + newline + ...
    "	 *	TRIGGER_ADC - trigger events on the AnalogIn interface will trigger the AnalogOut interface;\n" + newline + ...
    "	 *	TRIGGER_LA - trigger events on the DigitalIn interface will trigger the AnalogOut interface;\n" + newline + ...
    "	 @note Only available from firmware v0.33.");
validate(setAnalogOutTriggerSourceDefinition);

%% C++ class method |getAnalogOutTriggerSource| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: libm2k::M2K_TRIGGER_SOURCE_OUT libm2k::M2kHardwareTrigger::getAnalogOutTriggerSource() const

getAnalogOutTriggerSourceDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "libm2k::M2K_TRIGGER_SOURCE_OUT libm2k::M2kHardwareTrigger::getAnalogOutTriggerSource() const", ...
    "MATLABName", "getAnalogOutTriggerSource", ...
    "Description", "getAnalogOutTriggerSource Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "Returns the source of the AnalogOut trigger event.", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getAnalogOutTriggerSourceDefinition, "RetVal", "clib.libm2k.libm2k.M2K_TRIGGER_SOURCE_OUT", "Description", "M2K_TRIGGER_SOURCE_OUT :\n" + newline + ...
    "	 *	TRIGGER_NONE;\n" + newline + ...
    "	 *	TRIGGER_TI;\n" + newline + ...
    "	 *	TRIGGER_ADC;\n" + newline + ...
    "	 *	TRIGGER_LA;\n" + newline + ...
    "	 @note Only available from firmware v0.33.");
validate(getAnalogOutTriggerSourceDefinition);

%% C++ class method |setAnalogOutTriggerCondition| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: void libm2k::M2kHardwareTrigger::setAnalogOutTriggerCondition(libm2k::M2K_TRIGGER_CONDITION_OUT condition)

setAnalogOutTriggerConditionDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "void libm2k::M2kHardwareTrigger::setAnalogOutTriggerCondition(libm2k::M2K_TRIGGER_CONDITION_OUT condition)", ...
    "MATLABName", "setAnalogOutTriggerCondition", ...
    "Description", "setAnalogOutTriggerCondition Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "Configures the triggering condition when the source of the AnalogOut trigger event is set to TRIGGER_TI_0.", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setAnalogOutTriggerConditionDefinition, "condition", "clib.libm2k.libm2k.M2K_TRIGGER_CONDITION_OUT", "Description", "condition: of type M2K_TRIGGER_CONDITION_OUT:\n" + newline + ...
    "	 *	NONE_OUT - disabled;\n" + newline + ...
    "	 *	LOW_LEVEL_OUT;\n" + newline + ...
    "	 *	HIGH_LEVEL_OUT;\n" + newline + ...
    "	 *	ANY_EDGE_OUT;\n" + newline + ...
    "	 *	RISING_EDGE_OUT;\n" + newline + ...
    "	 *	FALLING_EDGE_OUT;\n" + newline + ...
    "	 @note For the other sources this condition is ignored, the configuration is forwarded by the corresponding interface." + newline + ...
    "	 @note Only available from firmware v0.33.");
validate(setAnalogOutTriggerConditionDefinition);

%% C++ class method |getAnalogOutTriggerCondition| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: libm2k::M2K_TRIGGER_CONDITION_OUT libm2k::M2kHardwareTrigger::getAnalogOutTriggerCondition() const

getAnalogOutTriggerConditionDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "libm2k::M2K_TRIGGER_CONDITION_OUT libm2k::M2kHardwareTrigger::getAnalogOutTriggerCondition() const", ...
    "MATLABName", "getAnalogOutTriggerCondition", ...
    "Description", "getAnalogOutTriggerCondition Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "Returns the condition of the AnalogOut trigger event when the source is TI.", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getAnalogOutTriggerConditionDefinition, "RetVal", "clib.libm2k.libm2k.M2K_TRIGGER_CONDITION_OUT", "Description", "M2K_TRIGGER_CONDITION_OUT :\n" + newline + ...
    "	 *	NONE_OUT - disabled;\n" + newline + ...
    "	 *	LOW_LEVEL_OUT;\n" + newline + ...
    "	 *	HIGH_LEVEL_OUT;\n" + newline + ...
    "	 *	ANY_EDGE_OUT;\n" + newline + ...
    "	 *	RISING_EDGE_OUT;\n" + newline + ...
    "	 *	FALLING_EDGE_OUT;\n" + newline + ...
    "	 @note Only available from firmware v0.33.");
validate(getAnalogOutTriggerConditionDefinition);

%% C++ class method |setAnalogOutTriggerStatus| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: void libm2k::M2kHardwareTrigger::setAnalogOutTriggerStatus(libm2k::M2K_TRIGGER_STATUS_ANALOG_OUT status)

setAnalogOutTriggerStatusDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "void libm2k::M2kHardwareTrigger::setAnalogOutTriggerStatus(libm2k::M2K_TRIGGER_STATUS_ANALOG_OUT status)", ...
    "MATLABName", "setAnalogOutTriggerStatus", ...
    "Description", "setAnalogOutTriggerStatus Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "Defines the action to be performed when a trigger event occurs.", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setAnalogOutTriggerStatusDefinition, "status", "clib.libm2k.libm2k.M2K_TRIGGER_STATUS_ANALOG_OUT", "Description", "status: of type M2K_TRIGGER_STATUS_ANALOG_OUT:\n" + newline + ...
    "	 *	DISABLED - no action is performed when a trigger event occurs;\n" + newline + ...
    "	 *	START - the AnalogOut interface starts outputting samples;\n" + newline + ...
    "	 *	STOP - the AnalogOut interface stops outputting samples;\n" + newline + ...
    "	 @note Only available from firmware v0.33.");
validate(setAnalogOutTriggerStatusDefinition);

%% C++ class method |getAnalogOutTriggerStatus| for C++ class |libm2k::M2kHardwareTrigger| 
% C++ Signature: libm2k::M2K_TRIGGER_STATUS_ANALOG_OUT libm2k::M2kHardwareTrigger::getAnalogOutTriggerStatus() const

getAnalogOutTriggerStatusDefinition = addMethod(M2kHardwareTriggerDefinition, ...
    "libm2k::M2K_TRIGGER_STATUS_ANALOG_OUT libm2k::M2kHardwareTrigger::getAnalogOutTriggerStatus() const", ...
    "MATLABName", "getAnalogOutTriggerStatus", ...
    "Description", "getAnalogOutTriggerStatus Method of C++ class libm2k::M2kHardwareTrigger." + newline + ...
    "Returns the action that is performed when a trigger event occurs.", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getAnalogOutTriggerStatusDefinition, "RetVal", "clib.libm2k.libm2k.M2K_TRIGGER_STATUS_ANALOG_OUT", "Description", "M2K_TRIGGER_STATUS_ANALOG_OUT :\n" + newline + ...
    "	 *	DISABLED;\n" + newline + ...
    "	 *	START;\n" + newline + ...
    "	 *	STOP;\n" + newline + ...
    "	 @note Only available from firmware v0.33.");
validate(getAnalogOutTriggerStatusDefinition);

%% C++ enumeration |libm2k::M2K_TRIGGER_SOURCE_ANALOG| with MATLAB name |clib.libm2k.libm2k.M2K_TRIGGER_SOURCE_ANALOG| 
addEnumeration(libDef, "libm2k::M2K_TRIGGER_SOURCE_ANALOG", "int32",...
    [...
      "CHANNEL_1",...  % 0
      "CHANNEL_2",...  % 1
      "CHANNEL_1_OR_CHANNEL_2",...  % 2
      "CHANNEL_1_AND_CHANNEL_2",...  % 3
      "CHANNEL_1_XOR_CHANNEL_2",...  % 4
      "SRC_DIGITAL_IN",...  % 5
      "CHANNEL_1_OR_SRC_LOGIC_ANALYZER",...  % 6
      "CHANNEL_2_OR_SRC_LOGIC_ANALYZER",...  % 7
      "CHANNEL_1_OR_CHANNEL_2_OR_SRC_LOGIC_ANALYZER",...  % 8
      "NO_SOURCE",...  % 9
    ],...
    "MATLABName", "clib.libm2k.libm2k.M2K_TRIGGER_SOURCE_ANALOG", ...
    "Description", "clib.libm2k.libm2k.M2K_TRIGGER_SOURCE_ANALOG    Representation of C++ enumeration libm2k::M2K_TRIGGER_SOURCE_ANALOG." + newline + ...
    "Select the source for the analog trigger", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@enum M2K_TRIGGER_SOURCE_ANALOG" + newline + ...
    "	@brief Select the source for the analog trigger", ...
    "EnumerantDescriptions", ...
    [...
      "CHANNEL_1 - trigger events on analog CHANNEL_1 trigger the AnalogIn interface",...  % CHANNEL_1
      "CHANNEL_2 - trigger events on analog CHANNEL_2 trigger the AnalogIn interface",...  % CHANNEL_2
      "",...  % CHANNEL_1_OR_CHANNEL_2
      "",...  % CHANNEL_1_AND_CHANNEL_2
      "",...  % CHANNEL_1_XOR_CHANNEL_2
      "SRC_DIGITAL_IN - trigger events on the DigitalIn interface trigger the AnalogIn interface",...  % SRC_DIGITAL_IN
      "",...  % CHANNEL_1_OR_SRC_LOGIC_ANALYZER
      "",...  % CHANNEL_2_OR_SRC_LOGIC_ANALYZER
      "",...  % CHANNEL_1_OR_CHANNEL_2_OR_SRC_LOGIC_ANALYZER
      "",...  % NO_SOURCE
    ]); % Modify help description values as needed.

%% C++ class |libm2k::SETTINGS| with MATLAB name |clib.libm2k.libm2k.SETTINGS| 
SETTINGSDefinition = addClass(libDef, "libm2k::SETTINGS", "MATLABName", "clib.libm2k.libm2k.SETTINGS", ...
    "Description", "clib.libm2k.libm2k.SETTINGS    Representation of C++ class libm2k::SETTINGS." + newline + ...
    "Triggering system", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.

%% C++ class constructor for C++ class |libm2k::SETTINGS| 
% C++ Signature: libm2k::SETTINGS::SETTINGS()

SETTINGSConstructor1Definition = addConstructor(SETTINGSDefinition, ...
    "libm2k::SETTINGS::SETTINGS()", ...
    "Description", "clib.libm2k.libm2k.SETTINGS Constructor of C++ class libm2k::SETTINGS."); % Modify help description values as needed.
validate(SETTINGSConstructor1Definition);

%% C++ class constructor for C++ class |libm2k::SETTINGS| 
% C++ Signature: libm2k::SETTINGS::SETTINGS(libm2k::SETTINGS const & input1)

SETTINGSConstructor2Definition = addConstructor(SETTINGSDefinition, ...
    "libm2k::SETTINGS::SETTINGS(libm2k::SETTINGS const & input1)", ...
    "Description", "clib.libm2k.libm2k.SETTINGS Constructor of C++ class libm2k::SETTINGS."); % Modify help description values as needed.
defineArgument(SETTINGSConstructor2Definition, "input1", "clib.libm2k.libm2k.SETTINGS", "input");
validate(SETTINGSConstructor2Definition);

%% C++ class public data member |raw_level| for C++ class |libm2k::SETTINGS| 
% C++ Signature: std::vector<int, std::allocator<int>> libm2k::SETTINGS::raw_level

addProperty(SETTINGSDefinition, "raw_level", "clib.array.libm2k.Int", ...
    "Description", "clib.array.libm2k.Int    Data member of C++ class libm2k::SETTINGS." + newline + ...
    "Trigger's raw level"); % Modify help description values as needed.

%% C++ class public data member |level| for C++ class |libm2k::SETTINGS| 
% C++ Signature: std::vector<double, std::allocator<double>> libm2k::SETTINGS::level

addProperty(SETTINGSDefinition, "level", "clib.array.libm2k.Double", ...
    "Description", "clib.array.libm2k.Double    Data member of C++ class libm2k::SETTINGS." + newline + ...
    "Trigger's level"); % Modify help description values as needed.

%% C++ class public data member |hysteresis| for C++ class |libm2k::SETTINGS| 
% C++ Signature: std::vector<double, std::allocator<double>> libm2k::SETTINGS::hysteresis

addProperty(SETTINGSDefinition, "hysteresis", "clib.array.libm2k.Double", ...
    "Description", "clib.array.libm2k.Double    Data member of C++ class libm2k::SETTINGS." + newline + ...
    "Trigger's hysteresis"); % Modify help description values as needed.

%% C++ class public data member |trigger_source| for C++ class |libm2k::SETTINGS| 
% C++ Signature: libm2k::M2K_TRIGGER_SOURCE_ANALOG libm2k::SETTINGS::trigger_source

addProperty(SETTINGSDefinition, "trigger_source", "clib.libm2k.libm2k.M2K_TRIGGER_SOURCE_ANALOG", ...
    "Description", "clib.libm2k.libm2k.M2K_TRIGGER_SOURCE_ANALOG    Data member of C++ class libm2k::SETTINGS." + newline + ...
    "Triggering source"); % Modify help description values as needed.

%% C++ class public data member |delay| for C++ class |libm2k::SETTINGS| 
% C++ Signature: int libm2k::SETTINGS::delay

addProperty(SETTINGSDefinition, "delay", "int32", ...
    "Description", "int32    Data member of C++ class libm2k::SETTINGS." + newline + ...
    "Trigger's delay"); % Modify help description values as needed.

%% C++ enumeration |libm2k::M2K_TRIGGER_OUT_SELECT| with MATLAB name |clib.libm2k.libm2k.M2K_TRIGGER_OUT_SELECT| 
addEnumeration(libDef, "libm2k::M2K_TRIGGER_OUT_SELECT", "int32",...
    [...
      "SELECT_NONE",...  % 0
      "SELECT_TRIGGER_I_SAME_CHAN",...  % 1
      "SELECT_TRIGGER_IN",...  % 2
      "SELECT_ANALOG_IN",...  % 3
      "SELECT_DIGITAL_IN",...  % 4
    ],...
    "MATLABName", "clib.libm2k.libm2k.M2K_TRIGGER_OUT_SELECT", ...
    "Description", "clib.libm2k.libm2k.M2K_TRIGGER_OUT_SELECT    Representation of C++ enumeration libm2k::M2K_TRIGGER_OUT_SELECT." + newline + ...
    "Select which trigger event will be forwarded on TO pin (trigger out)", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@enum M2K_TRIGGER_OUT_SELECT" + newline + ...
    "	 @brief Select which trigger event will be forwarded on TO pin (trigger out)", ...
    "EnumerantDescriptions", ...
    [...
      "SELECT_NONE - no trigger event is forwarded",...  % SELECT_NONE
      "",...  % SELECT_TRIGGER_I_SAME_CHAN
      "SELECT_TRIGGER_IN - forwards trigger events from TI pin(trigger in)",...  % SELECT_TRIGGER_IN
      "SELECT_ANALOG_IN  - forwards trigger events from AnalogIn interface",...  % SELECT_ANALOG_IN
      "SELECT_DIGITAL_IN - forwards trigger events from DigitalIn interface",...  % SELECT_DIGITAL_IN
    ]); % Modify help description values as needed.

%% C++ enumeration |libm2k::M2K_TRIGGER_SOURCE_DIGITAL| with MATLAB name |clib.libm2k.libm2k.M2K_TRIGGER_SOURCE_DIGITAL| 
addEnumeration(libDef, "libm2k::M2K_TRIGGER_SOURCE_DIGITAL", "int32",...
    [...
      "SRC_TRIGGER_IN",...  % 0
      "SRC_ANALOG_IN",...  % 1
      "SRC_NONE",...  % 2
      "SRC_DISABLED",...  % 3
    ],...
    "MATLABName", "clib.libm2k.libm2k.M2K_TRIGGER_SOURCE_DIGITAL", ...
    "Description", "clib.libm2k.libm2k.M2K_TRIGGER_SOURCE_DIGITAL    Representation of C++ enumeration libm2k::M2K_TRIGGER_SOURCE_DIGITAL." + newline + ...
    "Select the source for the digital trigger", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@enum M2K_TRIGGER_SOURCE_DIGITAL" + newline + ...
    "	 @brief Select the source for the digital trigger", ...
    "EnumerantDescriptions", ...
    [...
      "SRC_TRIGGER_IN - trigger events on the TI(trigger in) pin trigger the DigitalIn interface",...  % SRC_TRIGGER_IN
      "SRC_ANALOG_IN - trigger events on the AnalogIn interface trigger the DigitalIn interface",...  % SRC_ANALOG_IN
      "SRC_NONE - trigger events on the DigitalIn are conditioned by the internal digital trigger structure",...  % SRC_NONE
      "",...  % SRC_DISABLED
    ]); % Modify help description values as needed.

%% C++ enumeration |libm2k::M2K_TRIGGER_SOURCE_OUT| with MATLAB name |clib.libm2k.libm2k.M2K_TRIGGER_SOURCE_OUT| 
addEnumeration(libDef, "libm2k::M2K_TRIGGER_SOURCE_OUT", "int32",...
    [...
      "TRIGGER_NONE",...  % 0
      "TRIGGER_TI",...  % 1
      "TRIGGER_ADC",...  % 2
      "TRIGGER_LA",...  % 3
    ],...
    "MATLABName", "clib.libm2k.libm2k.M2K_TRIGGER_SOURCE_OUT", ...
    "Description", "clib.libm2k.libm2k.M2K_TRIGGER_SOURCE_OUT    Representation of C++ enumeration libm2k::M2K_TRIGGER_SOURCE_OUT." + newline + ...
    "Selects the source trigger for the output interfaces"); % Modify help description values as needed.

%% C++ enumeration |libm2k::M2K_TRIGGER_CONDITION_OUT| with MATLAB name |clib.libm2k.libm2k.M2K_TRIGGER_CONDITION_OUT| 
addEnumeration(libDef, "libm2k::M2K_TRIGGER_CONDITION_OUT", "int32",...
    [...
      "NONE_OUT",...  % 0
      "LOW_LEVEL_OUT",...  % 1
      "HIGH_LEVEL_OUT",...  % 2
      "ANY_EDGE_OUT",...  % 3
      "RISING_EDGE_OUT",...  % 4
      "FALLING_EDGE_OUT",...  % 5
    ],...
    "MATLABName", "clib.libm2k.libm2k.M2K_TRIGGER_CONDITION_OUT", ...
    "Description", "clib.libm2k.libm2k.M2K_TRIGGER_CONDITION_OUT    Representation of C++ enumeration libm2k::M2K_TRIGGER_CONDITION_OUT." + newline + ...
    "Trigger condition when the source for M2K_TRIGGER_SOURCE_OUT is TRIGGER_TI", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@enum M2K_TRIGGER_CONDITION_OUT" + newline + ...
    "	@brief Trigger condition when the source for M2K_TRIGGER_SOURCE_OUT is TRIGGER_TI"); % Modify help description values as needed.

%% C++ enumeration |libm2k::M2K_TRIGGER_STATUS_ANALOG_OUT| with MATLAB name |clib.libm2k.libm2k.M2K_TRIGGER_STATUS_ANALOG_OUT| 
addEnumeration(libDef, "libm2k::M2K_TRIGGER_STATUS_ANALOG_OUT", "int32",...
    [...
      "DISABLED",...  % 0
      "START",...  % 1
      "STOP",...  % 2
    ],...
    "MATLABName", "clib.libm2k.libm2k.M2K_TRIGGER_STATUS_ANALOG_OUT", ...
    "Description", "clib.libm2k.libm2k.M2K_TRIGGER_STATUS_ANALOG_OUT    Representation of C++ enumeration libm2k::M2K_TRIGGER_STATUS_ANALOG_OUT." + newline + ...
    "The status value determines the action that the output interface will take when the trigger condition is met.", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@enum M2K_TRIGGER_STATUS_ANALOG_OUT" + newline + ...
    "	@brief The status value determines the action that the output interface will take when the trigger condition is met."); % Modify help description values as needed.

%% C++ class |libm2k::IIO_OBJECTS| with MATLAB name |clib.libm2k.libm2k.IIO_OBJECTS| 
IIO_OBJECTSDefinition = addClass(libDef, "libm2k::IIO_OBJECTS", "MATLABName", "clib.libm2k.libm2k.IIO_OBJECTS", ...
    "Description", "clib.libm2k.libm2k.IIO_OBJECTS    Representation of C++ class libm2k::IIO_OBJECTS.", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@private"); % Modify help description values as needed.

%% C++ class constructor for C++ class |libm2k::IIO_OBJECTS| 
% C++ Signature: libm2k::IIO_OBJECTS::IIO_OBJECTS()

IIO_OBJECTSConstructor1Definition = addConstructor(IIO_OBJECTSDefinition, ...
    "libm2k::IIO_OBJECTS::IIO_OBJECTS()", ...
    "Description", "clib.libm2k.libm2k.IIO_OBJECTS Constructor of C++ class libm2k::IIO_OBJECTS."); % Modify help description values as needed.
validate(IIO_OBJECTSConstructor1Definition);

%% C++ class constructor for C++ class |libm2k::IIO_OBJECTS| 
% C++ Signature: libm2k::IIO_OBJECTS::IIO_OBJECTS(libm2k::IIO_OBJECTS const & input1)

IIO_OBJECTSConstructor2Definition = addConstructor(IIO_OBJECTSDefinition, ...
    "libm2k::IIO_OBJECTS::IIO_OBJECTS(libm2k::IIO_OBJECTS const & input1)", ...
    "Description", "clib.libm2k.libm2k.IIO_OBJECTS Constructor of C++ class libm2k::IIO_OBJECTS."); % Modify help description values as needed.
defineArgument(IIO_OBJECTSConstructor2Definition, "input1", "clib.libm2k.libm2k.IIO_OBJECTS", "input");
validate(IIO_OBJECTSConstructor2Definition);

%% C++ class public data member |context| for C++ class |libm2k::IIO_OBJECTS| 
% C++ Signature: iio_context * libm2k::IIO_OBJECTS::context

%addProperty(IIO_OBJECTSDefinition, "context", "clib.libm2k.iio_context", <SHAPE>, ...
%    "Description", "clib.libm2k.iio_context    Data member of C++ class libm2k::IIO_OBJECTS."); % Modify help description values as needed.

%% C++ class |libm2k::CALIBRATION_PARAMETERS| with MATLAB name |clib.libm2k.libm2k.CALIBRATION_PARAMETERS| 
CALIBRATION_PARAMETERSDefinition = addClass(libDef, "libm2k::CALIBRATION_PARAMETERS", "MATLABName", "clib.libm2k.libm2k.CALIBRATION_PARAMETERS", ...
    "Description", "clib.libm2k.libm2k.CALIBRATION_PARAMETERS    Representation of C++ class libm2k::CALIBRATION_PARAMETERS." + newline + ...
    "Calibration parameters of m2k", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@struct CALIBRATION_PARAMETERS enums.hpp libm2k/enums.hpp" + newline + ...
    "	@brief Calibration parameters of m2k"); % Modify help description values as needed.

%% C++ class constructor for C++ class |libm2k::CALIBRATION_PARAMETERS| 
% C++ Signature: libm2k::CALIBRATION_PARAMETERS::CALIBRATION_PARAMETERS(libm2k::CALIBRATION_PARAMETERS const & input1)

CALIBRATION_PARAMETERSConstructor1Definition = addConstructor(CALIBRATION_PARAMETERSDefinition, ...
    "libm2k::CALIBRATION_PARAMETERS::CALIBRATION_PARAMETERS(libm2k::CALIBRATION_PARAMETERS const & input1)", ...
    "Description", "clib.libm2k.libm2k.CALIBRATION_PARAMETERS Constructor of C++ class libm2k::CALIBRATION_PARAMETERS."); % Modify help description values as needed.
defineArgument(CALIBRATION_PARAMETERSConstructor1Definition, "input1", "clib.libm2k.libm2k.CALIBRATION_PARAMETERS", "input");
validate(CALIBRATION_PARAMETERSConstructor1Definition);

%% C++ class constructor for C++ class |libm2k::CALIBRATION_PARAMETERS| 
% C++ Signature: libm2k::CALIBRATION_PARAMETERS::CALIBRATION_PARAMETERS()

CALIBRATION_PARAMETERSConstructor2Definition = addConstructor(CALIBRATION_PARAMETERSDefinition, ...
    "libm2k::CALIBRATION_PARAMETERS::CALIBRATION_PARAMETERS()", ...
    "Description", "clib.libm2k.libm2k.CALIBRATION_PARAMETERS Constructor of C++ class libm2k::CALIBRATION_PARAMETERS."); % Modify help description values as needed.
validate(CALIBRATION_PARAMETERSConstructor2Definition);

%% C++ class public data member |adc_offset_ch_1| for C++ class |libm2k::CALIBRATION_PARAMETERS| 
% C++ Signature: int libm2k::CALIBRATION_PARAMETERS::adc_offset_ch_1

addProperty(CALIBRATION_PARAMETERSDefinition, "adc_offset_ch_1", "int32", ...
    "Description", "int32    Data member of C++ class libm2k::CALIBRATION_PARAMETERS." + newline + ...
    "ADC calibration offset - channel 1"); % Modify help description values as needed.

%% C++ class public data member |adc_offset_ch_2| for C++ class |libm2k::CALIBRATION_PARAMETERS| 
% C++ Signature: int libm2k::CALIBRATION_PARAMETERS::adc_offset_ch_2

addProperty(CALIBRATION_PARAMETERSDefinition, "adc_offset_ch_2", "int32", ...
    "Description", "int32    Data member of C++ class libm2k::CALIBRATION_PARAMETERS." + newline + ...
    "ADC calibration offset - channel 2"); % Modify help description values as needed.

%% C++ class public data member |adc_gain_ch_1| for C++ class |libm2k::CALIBRATION_PARAMETERS| 
% C++ Signature: double libm2k::CALIBRATION_PARAMETERS::adc_gain_ch_1

addProperty(CALIBRATION_PARAMETERSDefinition, "adc_gain_ch_1", "double", ...
    "Description", "double    Data member of C++ class libm2k::CALIBRATION_PARAMETERS." + newline + ...
    "ADC calibration gain - channel 1"); % Modify help description values as needed.

%% C++ class public data member |adc_gain_ch_2| for C++ class |libm2k::CALIBRATION_PARAMETERS| 
% C++ Signature: double libm2k::CALIBRATION_PARAMETERS::adc_gain_ch_2

addProperty(CALIBRATION_PARAMETERSDefinition, "adc_gain_ch_2", "double", ...
    "Description", "double    Data member of C++ class libm2k::CALIBRATION_PARAMETERS." + newline + ...
    "ADC calibration gain - channel 2"); % Modify help description values as needed.

%% C++ class public data member |dac_a_offset| for C++ class |libm2k::CALIBRATION_PARAMETERS| 
% C++ Signature: int libm2k::CALIBRATION_PARAMETERS::dac_a_offset

addProperty(CALIBRATION_PARAMETERSDefinition, "dac_a_offset", "int32", ...
    "Description", "int32    Data member of C++ class libm2k::CALIBRATION_PARAMETERS." + newline + ...
    "DAC calibration offset - channel 1"); % Modify help description values as needed.

%% C++ class public data member |dac_b_offset| for C++ class |libm2k::CALIBRATION_PARAMETERS| 
% C++ Signature: int libm2k::CALIBRATION_PARAMETERS::dac_b_offset

addProperty(CALIBRATION_PARAMETERSDefinition, "dac_b_offset", "int32", ...
    "Description", "int32    Data member of C++ class libm2k::CALIBRATION_PARAMETERS." + newline + ...
    "DAC calibration offset - channel 2"); % Modify help description values as needed.

%% C++ class public data member |dac_a_gain| for C++ class |libm2k::CALIBRATION_PARAMETERS| 
% C++ Signature: double libm2k::CALIBRATION_PARAMETERS::dac_a_gain

addProperty(CALIBRATION_PARAMETERSDefinition, "dac_a_gain", "double", ...
    "Description", "double    Data member of C++ class libm2k::CALIBRATION_PARAMETERS." + newline + ...
    "DAC calibration gain - channel 1"); % Modify help description values as needed.

%% C++ class public data member |dac_b_gain| for C++ class |libm2k::CALIBRATION_PARAMETERS| 
% C++ Signature: double libm2k::CALIBRATION_PARAMETERS::dac_b_gain

addProperty(CALIBRATION_PARAMETERSDefinition, "dac_b_gain", "double", ...
    "Description", "double    Data member of C++ class libm2k::CALIBRATION_PARAMETERS." + newline + ...
    "DAC calibration gain - channel 2"); % Modify help description values as needed.

%% C++ class |libm2k::IIO_CONTEXT_VERSION| with MATLAB name |clib.libm2k.libm2k.IIO_CONTEXT_VERSION| 
IIO_CONTEXT_VERSIONDefinition = addClass(libDef, "libm2k::IIO_CONTEXT_VERSION", "MATLABName", "clib.libm2k.libm2k.IIO_CONTEXT_VERSION", ...
    "Description", "clib.libm2k.libm2k.IIO_CONTEXT_VERSION    Representation of C++ class libm2k::IIO_CONTEXT_VERSION." + newline + ...
    "The version of the backend", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@struct IIO_CONTEXT_VERSION enums.hpp libm2k/enums.hpp" + newline + ...
    "	 @brief The version of the backend"); % Modify help description values as needed.

%% C++ class constructor for C++ class |libm2k::IIO_CONTEXT_VERSION| 
% C++ Signature: libm2k::IIO_CONTEXT_VERSION::IIO_CONTEXT_VERSION(libm2k::IIO_CONTEXT_VERSION const & input1)

IIO_CONTEXT_VERSIONConstructor1Definition = addConstructor(IIO_CONTEXT_VERSIONDefinition, ...
    "libm2k::IIO_CONTEXT_VERSION::IIO_CONTEXT_VERSION(libm2k::IIO_CONTEXT_VERSION const & input1)", ...
    "Description", "clib.libm2k.libm2k.IIO_CONTEXT_VERSION Constructor of C++ class libm2k::IIO_CONTEXT_VERSION."); % Modify help description values as needed.
defineArgument(IIO_CONTEXT_VERSIONConstructor1Definition, "input1", "clib.libm2k.libm2k.IIO_CONTEXT_VERSION", "input");
validate(IIO_CONTEXT_VERSIONConstructor1Definition);

%% C++ class constructor for C++ class |libm2k::IIO_CONTEXT_VERSION| 
% C++ Signature: libm2k::IIO_CONTEXT_VERSION::IIO_CONTEXT_VERSION()

IIO_CONTEXT_VERSIONConstructor2Definition = addConstructor(IIO_CONTEXT_VERSIONDefinition, ...
    "libm2k::IIO_CONTEXT_VERSION::IIO_CONTEXT_VERSION()", ...
    "Description", "clib.libm2k.libm2k.IIO_CONTEXT_VERSION Constructor of C++ class libm2k::IIO_CONTEXT_VERSION."); % Modify help description values as needed.
validate(IIO_CONTEXT_VERSIONConstructor2Definition);

%% C++ class public data member |major| for C++ class |libm2k::IIO_CONTEXT_VERSION| 
% C++ Signature: unsigned int libm2k::IIO_CONTEXT_VERSION::major

addProperty(IIO_CONTEXT_VERSIONDefinition, "major", "uint32", ...
    "Description", "uint32    Data member of C++ class libm2k::IIO_CONTEXT_VERSION." + newline + ...
    "major version"); % Modify help description values as needed.

%% C++ class public data member |minor| for C++ class |libm2k::IIO_CONTEXT_VERSION| 
% C++ Signature: unsigned int libm2k::IIO_CONTEXT_VERSION::minor

addProperty(IIO_CONTEXT_VERSIONDefinition, "minor", "uint32", ...
    "Description", "uint32    Data member of C++ class libm2k::IIO_CONTEXT_VERSION." + newline + ...
    "minor version"); % Modify help description values as needed.

%% C++ class public data member |git_tag| for C++ class |libm2k::IIO_CONTEXT_VERSION| 
% C++ Signature: char [8] libm2k::IIO_CONTEXT_VERSION::git_tag

addProperty(IIO_CONTEXT_VERSIONDefinition, "git_tag", "clib.array.libm2k.Char", [8], ... % <MLTYPE> can be "clib.array.libm2k.Char","int8", or "char"
    "Description", "clib.array.libm2k.Char    Data member of C++ class libm2k::IIO_CONTEXT_VERSION."); % Modify help description values as needed.

%% C++ class |libm2k::CONTEXT_INFO| with MATLAB name |clib.libm2k.libm2k.CONTEXT_INFO| 
CONTEXT_INFODefinition = addClass(libDef, "libm2k::CONTEXT_INFO", "MATLABName", "clib.libm2k.libm2k.CONTEXT_INFO", ...
    "Description", "clib.libm2k.libm2k.CONTEXT_INFO    Representation of C++ class libm2k::CONTEXT_INFO." + newline + ...
    "Additional information about the context", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@struct CONTEXT_INFO enums.hpp libm2k/enums.hpp" + newline + ...
    "	 @brief Additional information about the context"); % Modify help description values as needed.

%% C++ class constructor for C++ class |libm2k::CONTEXT_INFO| 
% C++ Signature: libm2k::CONTEXT_INFO::CONTEXT_INFO()

CONTEXT_INFOConstructor1Definition = addConstructor(CONTEXT_INFODefinition, ...
    "libm2k::CONTEXT_INFO::CONTEXT_INFO()", ...
    "Description", "clib.libm2k.libm2k.CONTEXT_INFO Constructor of C++ class libm2k::CONTEXT_INFO."); % Modify help description values as needed.
validate(CONTEXT_INFOConstructor1Definition);

%% C++ class constructor for C++ class |libm2k::CONTEXT_INFO| 
% C++ Signature: libm2k::CONTEXT_INFO::CONTEXT_INFO(libm2k::CONTEXT_INFO const & input1)

CONTEXT_INFOConstructor2Definition = addConstructor(CONTEXT_INFODefinition, ...
    "libm2k::CONTEXT_INFO::CONTEXT_INFO(libm2k::CONTEXT_INFO const & input1)", ...
    "Description", "clib.libm2k.libm2k.CONTEXT_INFO Constructor of C++ class libm2k::CONTEXT_INFO."); % Modify help description values as needed.
defineArgument(CONTEXT_INFOConstructor2Definition, "input1", "clib.libm2k.libm2k.CONTEXT_INFO", "input");
validate(CONTEXT_INFOConstructor2Definition);

%% C++ class public data member |id_vendor| for C++ class |libm2k::CONTEXT_INFO| 
% C++ Signature: std::string libm2k::CONTEXT_INFO::id_vendor

addProperty(CONTEXT_INFODefinition, "id_vendor", "string", ...
    "Description", "string    Data member of C++ class libm2k::CONTEXT_INFO." + newline + ...
    "Vendor ID extracted from IIO context"); % Modify help description values as needed.

%% C++ class public data member |id_product| for C++ class |libm2k::CONTEXT_INFO| 
% C++ Signature: std::string libm2k::CONTEXT_INFO::id_product

addProperty(CONTEXT_INFODefinition, "id_product", "string", ...
    "Description", "string    Data member of C++ class libm2k::CONTEXT_INFO." + newline + ...
    "Product ID extracted from IIO context"); % Modify help description values as needed.

%% C++ class public data member |manufacturer| for C++ class |libm2k::CONTEXT_INFO| 
% C++ Signature: std::string libm2k::CONTEXT_INFO::manufacturer

addProperty(CONTEXT_INFODefinition, "manufacturer", "string", ...
    "Description", "string    Data member of C++ class libm2k::CONTEXT_INFO." + newline + ...
    "Manufacturer extracted from IIO context"); % Modify help description values as needed.

%% C++ class public data member |product| for C++ class |libm2k::CONTEXT_INFO| 
% C++ Signature: std::string libm2k::CONTEXT_INFO::product

addProperty(CONTEXT_INFODefinition, "product", "string", ...
    "Description", "string    Data member of C++ class libm2k::CONTEXT_INFO." + newline + ...
    "Product name extracted from IIO context"); % Modify help description values as needed.

%% C++ class public data member |serial| for C++ class |libm2k::CONTEXT_INFO| 
% C++ Signature: std::string libm2k::CONTEXT_INFO::serial

addProperty(CONTEXT_INFODefinition, "serial", "string", ...
    "Description", "string    Data member of C++ class libm2k::CONTEXT_INFO." + newline + ...
    "Serial number"); % Modify help description values as needed.

%% C++ class public data member |uri| for C++ class |libm2k::CONTEXT_INFO| 
% C++ Signature: std::string libm2k::CONTEXT_INFO::uri

addProperty(CONTEXT_INFODefinition, "uri", "string", ...
    "Description", "string    Data member of C++ class libm2k::CONTEXT_INFO." + newline + ...
    "IIO context URI"); % Modify help description values as needed.

%% C++ enumeration |libm2k::CALIBRATION_MODE| with MATLAB name |clib.libm2k.libm2k.CALIBRATION_MODE| 
addEnumeration(libDef, "libm2k::CALIBRATION_MODE", "int32",...
    [...
      "ADC_REF1",...  % 0
      "ADC_REF2",...  % 1
      "ADC_GND",...  % 2
      "DAC",...  % 3
      "NONE",...  % 4
    ],...
    "MATLABName", "clib.libm2k.libm2k.CALIBRATION_MODE", ...
    "Description", "clib.libm2k.libm2k.CALIBRATION_MODE    Representation of C++ enumeration libm2k::CALIBRATION_MODE.", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@private"); % Modify help description values as needed.

%% C++ enumeration |libm2k::GAIN_MODE| with MATLAB name |clib.libm2k.libm2k.GAIN_MODE| 
addEnumeration(libDef, "libm2k::GAIN_MODE", "int32",...
    [...
      "LOW_GAIN",...  % 0
      "HIGH_GAIN",...  % 1
    ],...
    "MATLABName", "clib.libm2k.libm2k.GAIN_MODE", ...
    "Description", "clib.libm2k.libm2k.GAIN_MODE    Representation of C++ enumeration libm2k::GAIN_MODE.", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@private"); % Modify help description values as needed.

%% C++ enumeration |libm2k::M2K_EXCEPTION_TYPE| with MATLAB name |clib.libm2k.libm2k.M2K_EXCEPTION_TYPE| 
addEnumeration(libDef, "libm2k::M2K_EXCEPTION_TYPE", "int32",...
    [...
      "EXC_OUT_OF_RANGE",...  % 0
      "EXC_RUNTIME_ERROR",...  % 1
      "EXC_INVALID_PARAMETER",...  % 2
      "EXC_TIMEOUT",...  % 3
      "EXC_INVALID_FIRMWARE_VERSION",...  % 4
    ],...
    "MATLABName", "clib.libm2k.libm2k.M2K_EXCEPTION_TYPE", ...
    "Description", "clib.libm2k.libm2k.M2K_EXCEPTION_TYPE    Representation of C++ enumeration libm2k::M2K_EXCEPTION_TYPE." + newline + ...
    "M2k exception types", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.

%% C++ class |libm2k::m2k_exception| with MATLAB name |clib.libm2k.libm2k.m2k_exception| 
m2k_exceptionDefinition = addClass(libDef, "libm2k::m2k_exception", "MATLABName", "clib.libm2k.libm2k.m2k_exception", ...
    "Description", "clib.libm2k.libm2k.m2k_exception    Representation of C++ class libm2k::m2k_exception."); % Modify help description values as needed.

%% C++ class method |make| for C++ class |libm2k::m2k_exception| 
% C++ Signature: static libm2k::m2k_exception_builder libm2k::m2k_exception::make(std::string what)

makeDefinition = addMethod(m2k_exceptionDefinition, ...
    "static libm2k::m2k_exception_builder libm2k::m2k_exception::make(std::string what)", ...
    "MATLABName", "make", ...
    "Description", "make Method of C++ class libm2k::m2k_exception."); % Modify help description values as needed.
defineArgument(makeDefinition, "what", "string");
defineOutput(makeDefinition, "RetVal", "clib.libm2k.libm2k.m2k_exception_builder");
validate(makeDefinition);

%% C++ class method |iioCode| for C++ class |libm2k::m2k_exception| 
% C++ Signature: int libm2k::m2k_exception::iioCode() const

iioCodeDefinition = addMethod(m2k_exceptionDefinition, ...
    "int libm2k::m2k_exception::iioCode() const", ...
    "MATLABName", "iioCode", ...
    "Description", "iioCode Method of C++ class libm2k::m2k_exception."); % Modify help description values as needed.
defineOutput(iioCodeDefinition, "RetVal", "int32");
validate(iioCodeDefinition);

%% C++ class method |type| for C++ class |libm2k::m2k_exception| 
% C++ Signature: libm2k::M2K_EXCEPTION_TYPE libm2k::m2k_exception::type() const

typeDefinition = addMethod(m2k_exceptionDefinition, ...
    "libm2k::M2K_EXCEPTION_TYPE libm2k::m2k_exception::type() const", ...
    "MATLABName", "type", ...
    "Description", "type Method of C++ class libm2k::m2k_exception."); % Modify help description values as needed.
defineOutput(typeDefinition, "RetVal", "clib.libm2k.libm2k.M2K_EXCEPTION_TYPE");
validate(typeDefinition);

%% C++ class method |line| for C++ class |libm2k::m2k_exception| 
% C++ Signature: int libm2k::m2k_exception::line() const

lineDefinition = addMethod(m2k_exceptionDefinition, ...
    "int libm2k::m2k_exception::line() const", ...
    "MATLABName", "line", ...
    "Description", "line Method of C++ class libm2k::m2k_exception."); % Modify help description values as needed.
defineOutput(lineDefinition, "RetVal", "int32");
validate(lineDefinition);

%% C++ class method |file| for C++ class |libm2k::m2k_exception| 
% C++ Signature: std::string libm2k::m2k_exception::file() const

fileDefinition = addMethod(m2k_exceptionDefinition, ...
    "std::string libm2k::m2k_exception::file() const", ...
    "MATLABName", "file", ...
    "Description", "file Method of C++ class libm2k::m2k_exception."); % Modify help description values as needed.
defineOutput(fileDefinition, "RetVal", "string");
validate(fileDefinition);

%% C++ class method |what| for C++ class |libm2k::m2k_exception| 
% C++ Signature: char const * libm2k::m2k_exception::what() const

%whatDefinition = addMethod(m2k_exceptionDefinition, ...
%    "char const * libm2k::m2k_exception::what() const", ...
%    "MATLABName", "what", ...
%    "Description", "what Method of C++ class libm2k::m2k_exception."); % Modify help description values as needed.
%defineOutput(whatDefinition, "RetVal", <MLTYPE>, <SHAPE>); % <MLTYPE> can be "clib.array.libm2k.Char","int8","string", or "char"
%validate(whatDefinition);

%% C++ class constructor for C++ class |libm2k::m2k_exception| 
% C++ Signature: libm2k::m2k_exception::m2k_exception(libm2k::m2k_exception const & input1)

m2k_exceptionConstructor1Definition = addConstructor(m2k_exceptionDefinition, ...
    "libm2k::m2k_exception::m2k_exception(libm2k::m2k_exception const & input1)", ...
    "Description", "clib.libm2k.libm2k.m2k_exception Constructor of C++ class libm2k::m2k_exception."); % Modify help description values as needed.
defineArgument(m2k_exceptionConstructor1Definition, "input1", "clib.libm2k.libm2k.m2k_exception", "input");
validate(m2k_exceptionConstructor1Definition);

%% C++ class |libm2k::m2k_exception_builder| with MATLAB name |clib.libm2k.libm2k.m2k_exception_builder| 
m2k_exception_builderDefinition = addClass(libDef, "libm2k::m2k_exception_builder", "MATLABName", "clib.libm2k.libm2k.m2k_exception_builder", ...
    "Description", "clib.libm2k.libm2k.m2k_exception_builder    Representation of C++ class libm2k::m2k_exception_builder."); % Modify help description values as needed.

%% C++ class constructor for C++ class |libm2k::m2k_exception_builder| 
% C++ Signature: libm2k::m2k_exception_builder::m2k_exception_builder()

m2k_exception_builderConstructor1Definition = addConstructor(m2k_exception_builderDefinition, ...
    "libm2k::m2k_exception_builder::m2k_exception_builder()", ...
    "Description", "clib.libm2k.libm2k.m2k_exception_builder Constructor of C++ class libm2k::m2k_exception_builder."); % Modify help description values as needed.
validate(m2k_exception_builderConstructor1Definition);

%% C++ class constructor for C++ class |libm2k::m2k_exception_builder| 
% C++ Signature: libm2k::m2k_exception_builder::m2k_exception_builder(std::string & what)

m2k_exception_builderConstructor2Definition = addConstructor(m2k_exception_builderDefinition, ...
    "libm2k::m2k_exception_builder::m2k_exception_builder(std::string & what)", ...
    "Description", "clib.libm2k.libm2k.m2k_exception_builder Constructor of C++ class libm2k::m2k_exception_builder."); % Modify help description values as needed.
defineArgument(m2k_exception_builderConstructor2Definition, "what", "string", "input");
validate(m2k_exception_builderConstructor2Definition);

%% C++ class constructor for C++ class |libm2k::m2k_exception_builder| 
% C++ Signature: libm2k::m2k_exception_builder::m2k_exception_builder(char const * what)

%m2k_exception_builderConstructor3Definition = addConstructor(m2k_exception_builderDefinition, ...
%    "libm2k::m2k_exception_builder::m2k_exception_builder(char const * what)", ...
%    "Description", "clib.libm2k.libm2k.m2k_exception_builder Constructor of C++ class libm2k::m2k_exception_builder."); % Modify help description values as needed.
%defineArgument(m2k_exception_builderConstructor3Definition, "what", <MLTYPE>, "input", <SHAPE>); % <MLTYPE> can be "clib.array.libm2k.Char","int8","string", or "char"
%validate(m2k_exception_builderConstructor3Definition);

%% C++ class method |iioCode| for C++ class |libm2k::m2k_exception_builder| 
% C++ Signature: libm2k::m2k_exception_builder & libm2k::m2k_exception_builder::iioCode(int code)

iioCodeDefinition = addMethod(m2k_exception_builderDefinition, ...
    "libm2k::m2k_exception_builder & libm2k::m2k_exception_builder::iioCode(int code)", ...
    "MATLABName", "iioCode", ...
    "Description", "iioCode Method of C++ class libm2k::m2k_exception_builder."); % Modify help description values as needed.
defineArgument(iioCodeDefinition, "code", "int32");
defineOutput(iioCodeDefinition, "RetVal", "clib.libm2k.libm2k.m2k_exception_builder");
validate(iioCodeDefinition);

%% C++ class method |type| for C++ class |libm2k::m2k_exception_builder| 
% C++ Signature: libm2k::m2k_exception_builder & libm2k::m2k_exception_builder::type(libm2k::M2K_EXCEPTION_TYPE type)

typeDefinition = addMethod(m2k_exception_builderDefinition, ...
    "libm2k::m2k_exception_builder & libm2k::m2k_exception_builder::type(libm2k::M2K_EXCEPTION_TYPE type)", ...
    "MATLABName", "type", ...
    "Description", "type Method of C++ class libm2k::m2k_exception_builder."); % Modify help description values as needed.
defineArgument(typeDefinition, "type", "clib.libm2k.libm2k.M2K_EXCEPTION_TYPE");
defineOutput(typeDefinition, "RetVal", "clib.libm2k.libm2k.m2k_exception_builder");
validate(typeDefinition);

%% C++ class method |line| for C++ class |libm2k::m2k_exception_builder| 
% C++ Signature: libm2k::m2k_exception_builder & libm2k::m2k_exception_builder::line(int lineNumber)

lineDefinition = addMethod(m2k_exception_builderDefinition, ...
    "libm2k::m2k_exception_builder & libm2k::m2k_exception_builder::line(int lineNumber)", ...
    "MATLABName", "line", ...
    "Description", "line Method of C++ class libm2k::m2k_exception_builder."); % Modify help description values as needed.
defineArgument(lineDefinition, "lineNumber", "int32");
defineOutput(lineDefinition, "RetVal", "clib.libm2k.libm2k.m2k_exception_builder");
validate(lineDefinition);

%% C++ class method |file| for C++ class |libm2k::m2k_exception_builder| 
% C++ Signature: libm2k::m2k_exception_builder & libm2k::m2k_exception_builder::file(std::string const & fileName)

fileDefinition = addMethod(m2k_exception_builderDefinition, ...
    "libm2k::m2k_exception_builder & libm2k::m2k_exception_builder::file(std::string const & fileName)", ...
    "MATLABName", "file", ...
    "Description", "file Method of C++ class libm2k::m2k_exception_builder."); % Modify help description values as needed.
defineArgument(fileDefinition, "fileName", "string", "input");
defineOutput(fileDefinition, "RetVal", "clib.libm2k.libm2k.m2k_exception_builder");
validate(fileDefinition);

%% C++ class method |build| for C++ class |libm2k::m2k_exception_builder| 
% C++ Signature: libm2k::m2k_exception libm2k::m2k_exception_builder::build()

buildDefinition = addMethod(m2k_exception_builderDefinition, ...
    "libm2k::m2k_exception libm2k::m2k_exception_builder::build()", ...
    "MATLABName", "build", ...
    "Description", "build Method of C++ class libm2k::m2k_exception_builder."); % Modify help description values as needed.
defineOutput(buildDefinition, "RetVal", "clib.libm2k.libm2k.m2k_exception");
validate(buildDefinition);

%% C++ class constructor for C++ class |libm2k::m2k_exception_builder| 
% C++ Signature: libm2k::m2k_exception_builder::m2k_exception_builder(libm2k::m2k_exception_builder const & input1)

m2k_exception_builderConstructor4Definition = addConstructor(m2k_exception_builderDefinition, ...
    "libm2k::m2k_exception_builder::m2k_exception_builder(libm2k::m2k_exception_builder const & input1)", ...
    "Description", "clib.libm2k.libm2k.m2k_exception_builder Constructor of C++ class libm2k::m2k_exception_builder."); % Modify help description values as needed.
defineArgument(m2k_exception_builderConstructor4Definition, "input1", "clib.libm2k.libm2k.m2k_exception_builder", "input");
validate(m2k_exception_builderConstructor4Definition);

%% C++ class |libm2k::M2kCalibration| with MATLAB name |clib.libm2k.libm2k.M2kCalibration| 
M2kCalibrationDefinition = addClass(libDef, "libm2k::M2kCalibration", "MATLABName", "clib.libm2k.libm2k.M2kCalibration", ...
    "Description", "clib.libm2k.libm2k.M2kCalibration    Representation of C++ class libm2k::M2kCalibration."); % Modify help description values as needed.

%% C++ class method |initialize| for C++ class |libm2k::M2kCalibration| 
% C++ Signature: bool libm2k::M2kCalibration::initialize()

initializeDefinition = addMethod(M2kCalibrationDefinition, ...
    "bool libm2k::M2kCalibration::initialize()", ...
    "MATLABName", "initialize", ...
    "Description", "initialize Method of C++ class libm2k::M2kCalibration."); % Modify help description values as needed.
defineOutput(initializeDefinition, "RetVal", "logical");
validate(initializeDefinition);

%% C++ class method |isInitialized| for C++ class |libm2k::M2kCalibration| 
% C++ Signature: bool libm2k::M2kCalibration::isInitialized() const

isInitializedDefinition = addMethod(M2kCalibrationDefinition, ...
    "bool libm2k::M2kCalibration::isInitialized() const", ...
    "MATLABName", "isInitialized", ...
    "Description", "isInitialized Method of C++ class libm2k::M2kCalibration."); % Modify help description values as needed.
defineOutput(isInitializedDefinition, "RetVal", "logical");
validate(isInitializedDefinition);

%% C++ class method |calibrateAll| for C++ class |libm2k::M2kCalibration| 
% C++ Signature: bool libm2k::M2kCalibration::calibrateAll()

calibrateAllDefinition = addMethod(M2kCalibrationDefinition, ...
    "bool libm2k::M2kCalibration::calibrateAll()", ...
    "MATLABName", "calibrateAll", ...
    "Description", "calibrateAll Method of C++ class libm2k::M2kCalibration."); % Modify help description values as needed.
defineOutput(calibrateAllDefinition, "RetVal", "logical");
validate(calibrateAllDefinition);

%% C++ class method |calibrateADC| for C++ class |libm2k::M2kCalibration| 
% C++ Signature: bool libm2k::M2kCalibration::calibrateADC()

calibrateADCDefinition = addMethod(M2kCalibrationDefinition, ...
    "bool libm2k::M2kCalibration::calibrateADC()", ...
    "MATLABName", "calibrateADC", ...
    "Description", "calibrateADC Method of C++ class libm2k::M2kCalibration."); % Modify help description values as needed.
defineOutput(calibrateADCDefinition, "RetVal", "logical");
validate(calibrateADCDefinition);

%% C++ class method |calibrateDAC| for C++ class |libm2k::M2kCalibration| 
% C++ Signature: bool libm2k::M2kCalibration::calibrateDAC()

calibrateDACDefinition = addMethod(M2kCalibrationDefinition, ...
    "bool libm2k::M2kCalibration::calibrateDAC()", ...
    "MATLABName", "calibrateDAC", ...
    "Description", "calibrateDAC Method of C++ class libm2k::M2kCalibration."); % Modify help description values as needed.
defineOutput(calibrateDACDefinition, "RetVal", "logical");
validate(calibrateDACDefinition);

%% C++ class method |cancelCalibration| for C++ class |libm2k::M2kCalibration| 
% C++ Signature: void libm2k::M2kCalibration::cancelCalibration()

cancelCalibrationDefinition = addMethod(M2kCalibrationDefinition, ...
    "void libm2k::M2kCalibration::cancelCalibration()", ...
    "MATLABName", "cancelCalibration", ...
    "Description", "cancelCalibration Method of C++ class libm2k::M2kCalibration."); % Modify help description values as needed.
validate(cancelCalibrationDefinition);

%% C++ class method |getAdcOffset| for C++ class |libm2k::M2kCalibration| 
% C++ Signature: int libm2k::M2kCalibration::getAdcOffset(unsigned int channel)

getAdcOffsetDefinition = addMethod(M2kCalibrationDefinition, ...
    "int libm2k::M2kCalibration::getAdcOffset(unsigned int channel)", ...
    "MATLABName", "getAdcOffset", ...
    "Description", "getAdcOffset Method of C++ class libm2k::M2kCalibration."); % Modify help description values as needed.
defineArgument(getAdcOffsetDefinition, "channel", "uint32");
defineOutput(getAdcOffsetDefinition, "RetVal", "int32");
validate(getAdcOffsetDefinition);

%% C++ class method |getDacOffset| for C++ class |libm2k::M2kCalibration| 
% C++ Signature: int libm2k::M2kCalibration::getDacOffset(unsigned int channel)

getDacOffsetDefinition = addMethod(M2kCalibrationDefinition, ...
    "int libm2k::M2kCalibration::getDacOffset(unsigned int channel)", ...
    "MATLABName", "getDacOffset", ...
    "Description", "getDacOffset Method of C++ class libm2k::M2kCalibration."); % Modify help description values as needed.
defineArgument(getDacOffsetDefinition, "channel", "uint32");
defineOutput(getDacOffsetDefinition, "RetVal", "int32");
validate(getDacOffsetDefinition);

%% C++ class method |getAdcGain| for C++ class |libm2k::M2kCalibration| 
% C++ Signature: double libm2k::M2kCalibration::getAdcGain(unsigned int channel)

getAdcGainDefinition = addMethod(M2kCalibrationDefinition, ...
    "double libm2k::M2kCalibration::getAdcGain(unsigned int channel)", ...
    "MATLABName", "getAdcGain", ...
    "Description", "getAdcGain Method of C++ class libm2k::M2kCalibration."); % Modify help description values as needed.
defineArgument(getAdcGainDefinition, "channel", "uint32");
defineOutput(getAdcGainDefinition, "RetVal", "double");
validate(getAdcGainDefinition);

%% C++ class method |getDacGain| for C++ class |libm2k::M2kCalibration| 
% C++ Signature: double libm2k::M2kCalibration::getDacGain(unsigned int channel)

getDacGainDefinition = addMethod(M2kCalibrationDefinition, ...
    "double libm2k::M2kCalibration::getDacGain(unsigned int channel)", ...
    "MATLABName", "getDacGain", ...
    "Description", "getDacGain Method of C++ class libm2k::M2kCalibration."); % Modify help description values as needed.
defineArgument(getDacGainDefinition, "channel", "uint32");
defineOutput(getDacGainDefinition, "RetVal", "double");
validate(getDacGainDefinition);

%% C++ class method |getAdcCalibrated| for C++ class |libm2k::M2kCalibration| 
% C++ Signature: bool libm2k::M2kCalibration::getAdcCalibrated() const

getAdcCalibratedDefinition = addMethod(M2kCalibrationDefinition, ...
    "bool libm2k::M2kCalibration::getAdcCalibrated() const", ...
    "MATLABName", "getAdcCalibrated", ...
    "Description", "getAdcCalibrated Method of C++ class libm2k::M2kCalibration."); % Modify help description values as needed.
defineOutput(getAdcCalibratedDefinition, "RetVal", "logical");
validate(getAdcCalibratedDefinition);

%% C++ class method |getDacCalibrated| for C++ class |libm2k::M2kCalibration| 
% C++ Signature: bool libm2k::M2kCalibration::getDacCalibrated() const

getDacCalibratedDefinition = addMethod(M2kCalibrationDefinition, ...
    "bool libm2k::M2kCalibration::getDacCalibrated() const", ...
    "MATLABName", "getDacCalibrated", ...
    "Description", "getDacCalibrated Method of C++ class libm2k::M2kCalibration."); % Modify help description values as needed.
defineOutput(getDacCalibratedDefinition, "RetVal", "logical");
validate(getDacCalibratedDefinition);

%% C++ class method |resetCalibration| for C++ class |libm2k::M2kCalibration| 
% C++ Signature: bool libm2k::M2kCalibration::resetCalibration()

resetCalibrationDefinition = addMethod(M2kCalibrationDefinition, ...
    "bool libm2k::M2kCalibration::resetCalibration()", ...
    "MATLABName", "resetCalibration", ...
    "Description", "resetCalibration Method of C++ class libm2k::M2kCalibration."); % Modify help description values as needed.
defineOutput(resetCalibrationDefinition, "RetVal", "logical");
validate(resetCalibrationDefinition);

%% C++ class method |setDacGain| for C++ class |libm2k::M2kCalibration| 
% C++ Signature: void libm2k::M2kCalibration::setDacGain(unsigned int chn,double gain)

setDacGainDefinition = addMethod(M2kCalibrationDefinition, ...
    "void libm2k::M2kCalibration::setDacGain(unsigned int chn,double gain)", ...
    "MATLABName", "setDacGain", ...
    "Description", "setDacGain Method of C++ class libm2k::M2kCalibration."); % Modify help description values as needed.
defineArgument(setDacGainDefinition, "chn", "uint32");
defineArgument(setDacGainDefinition, "gain", "double");
validate(setDacGainDefinition);

%% C++ class method |setDacOffset| for C++ class |libm2k::M2kCalibration| 
% C++ Signature: void libm2k::M2kCalibration::setDacOffset(unsigned int chn,int offset)

setDacOffsetDefinition = addMethod(M2kCalibrationDefinition, ...
    "void libm2k::M2kCalibration::setDacOffset(unsigned int chn,int offset)", ...
    "MATLABName", "setDacOffset", ...
    "Description", "setDacOffset Method of C++ class libm2k::M2kCalibration."); % Modify help description values as needed.
defineArgument(setDacOffsetDefinition, "chn", "uint32");
defineArgument(setDacOffsetDefinition, "offset", "int32");
validate(setDacOffsetDefinition);

%% C++ class method |setAdcOffset| for C++ class |libm2k::M2kCalibration| 
% C++ Signature: void libm2k::M2kCalibration::setAdcOffset(unsigned int chn,int offset)

setAdcOffsetDefinition = addMethod(M2kCalibrationDefinition, ...
    "void libm2k::M2kCalibration::setAdcOffset(unsigned int chn,int offset)", ...
    "MATLABName", "setAdcOffset", ...
    "Description", "setAdcOffset Method of C++ class libm2k::M2kCalibration."); % Modify help description values as needed.
defineArgument(setAdcOffsetDefinition, "chn", "uint32");
defineArgument(setAdcOffsetDefinition, "offset", "int32");
validate(setAdcOffsetDefinition);

%% C++ class method |setAdcGain| for C++ class |libm2k::M2kCalibration| 
% C++ Signature: void libm2k::M2kCalibration::setAdcGain(unsigned int chn,double gain)

setAdcGainDefinition = addMethod(M2kCalibrationDefinition, ...
    "void libm2k::M2kCalibration::setAdcGain(unsigned int chn,double gain)", ...
    "MATLABName", "setAdcGain", ...
    "Description", "setAdcGain Method of C++ class libm2k::M2kCalibration."); % Modify help description values as needed.
defineArgument(setAdcGainDefinition, "chn", "uint32");
defineArgument(setAdcGainDefinition, "gain", "double");
validate(setAdcGainDefinition);

%% C++ function |libm2k::throw_exception| with MATLAB name |clib.libm2k.libm2k.throw_exception|
% C++ Signature: void libm2k::throw_exception(libm2k::m2k_exception const & exception)

throw_exceptionDefinition = addFunction(libDef, ...
    "void libm2k::throw_exception(libm2k::m2k_exception const & exception)", ...
    "MATLABName", "clib.libm2k.libm2k.throw_exception", ...
    "Description", "clib.libm2k.libm2k.throw_exception Representation of C++ function libm2k::throw_exception."); % Modify help description values as needed.
defineArgument(throw_exceptionDefinition, "exception", "clib.libm2k.libm2k.m2k_exception", "input");
validate(throw_exceptionDefinition);

%% C++ enumeration |libm2k::digital::DIO_CHANNEL| with MATLAB name |clib.libm2k.libm2k.digital.DIO_CHANNEL| 
addEnumeration(libDef, "libm2k::digital::DIO_CHANNEL", "int32",...
    [...
      "DIO_CHANNEL_0",...  % 0
      "DIO_CHANNEL_1",...  % 1
      "DIO_CHANNEL_2",...  % 2
      "DIO_CHANNEL_3",...  % 3
      "DIO_CHANNEL_4",...  % 4
      "DIO_CHANNEL_5",...  % 5
      "DIO_CHANNEL_6",...  % 6
      "DIO_CHANNEL_7",...  % 7
      "DIO_CHANNEL_8",...  % 8
      "DIO_CHANNEL_9",...  % 9
      "DIO_CHANNEL_10",...  % 10
      "DIO_CHANNEL_11",...  % 11
      "DIO_CHANNEL_12",...  % 12
      "DIO_CHANNEL_13",...  % 13
      "DIO_CHANNEL_14",...  % 14
      "DIO_CHANNEL_15",...  % 15
    ],...
    "MATLABName", "clib.libm2k.libm2k.digital.DIO_CHANNEL", ...
    "Description", "clib.libm2k.libm2k.digital.DIO_CHANNEL    Representation of C++ enumeration libm2k::digital::DIO_CHANNEL." + newline + ...
    "Indexes of the channels", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@note Each channel can be accessed through its index"); % Modify help description values as needed.

%% C++ enumeration |libm2k::digital::DIO_TRIGGER_MODE| with MATLAB name |clib.libm2k.libm2k.digital.DIO_TRIGGER_MODE| 
addEnumeration(libDef, "libm2k::digital::DIO_TRIGGER_MODE", "int32",...
    [...
      "DIO_OR",...  % 0
      "DIO_AND",...  % 1
    ],...
    "MATLABName", "clib.libm2k.libm2k.digital.DIO_TRIGGER_MODE", ...
    "Description", "clib.libm2k.libm2k.digital.DIO_TRIGGER_MODE    Representation of C++ enumeration libm2k::digital::DIO_TRIGGER_MODE." + newline + ...
    "Triggering mode for digital channels", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.

%% C++ class |libm2k::digital::M2kDigital| with MATLAB name |clib.libm2k.libm2k.digital.M2kDigital| 
M2kDigitalDefinition = addClass(libDef, "libm2k::digital::M2kDigital", "MATLABName", "clib.libm2k.libm2k.digital.M2kDigital", ...
    "Description", "clib.libm2k.libm2k.digital.M2kDigital    Representation of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Contains the representation of the digital segment" + newline + ...
    "" + newline + ...
    "@class M2kDigital m2kdigital.hpp libm2k/digital/m2kdigital.hpp" + newline + ...
    "@brief Controls the digital input and output segment", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@defgroup digital Digital" + newline + ...
    "@brief Contains the representation of the digital segment" + newline + ...
    "" + newline + ...
    "@class M2kDigital m2kdigital.hpp libm2k/digital/m2kdigital.hpp" + newline + ...
    "@brief Controls the digital input and output segment"); % Modify help description values as needed.

%% C++ class method |reset| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: void libm2k::digital::M2kDigital::reset()

resetDefinition = addMethod(M2kDigitalDefinition, ...
    "void libm2k::digital::M2kDigital::reset()", ...
    "MATLABName", "reset", ...
    "Description", "reset Method of C++ class libm2k::digital::M2kDigital.", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@private"); % Modify help description values as needed.
validate(resetDefinition);

%% C++ class method |setDirection| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: void libm2k::digital::M2kDigital::setDirection(unsigned short mask)

setDirectionDefinition = addMethod(M2kDigitalDefinition, ...
    "void libm2k::digital::M2kDigital::setDirection(unsigned short mask)", ...
    "MATLABName", "setDirection", ...
    "Description", "setDirection Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Set the direction for all digital channels", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setDirectionDefinition, "mask", "uint16", "Description", "mask A bitmask" + newline + ...
    "	@note Each bit of the mask corresponds to the channel with the same index. The value of the bit represents the channel's direction. O - input, 1 - output");
validate(setDirectionDefinition);

%% C++ class method |setDirection| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: void libm2k::digital::M2kDigital::setDirection(unsigned int index,libm2k::digital::DIO_DIRECTION dir)

setDirectionDefinition = addMethod(M2kDigitalDefinition, ...
    "void libm2k::digital::M2kDigital::setDirection(unsigned int index,libm2k::digital::DIO_DIRECTION dir)", ...
    "MATLABName", "setDirection", ...
    "Description", "setDirection Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Set the direction of the given digital channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setDirectionDefinition, "index", "uint32", "Description", "index The index corresponding to the channel");
defineArgument(setDirectionDefinition, "dir", "clib.libm2k.libm2k.digital.DIO_DIRECTION", "Description", "dir An enumerator that indicates the direction of a channel");
validate(setDirectionDefinition);

%% C++ class method |setDirection| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: void libm2k::digital::M2kDigital::setDirection(unsigned int index,bool dir)

setDirectionDefinition = addMethod(M2kDigitalDefinition, ...
    "void libm2k::digital::M2kDigital::setDirection(unsigned int index,bool dir)", ...
    "MATLABName", "setDirection", ...
    "Description", "setDirection Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Set the direction of the given digital channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setDirectionDefinition, "index", "uint32", "Description", "index The index corresponding to the channel");
defineArgument(setDirectionDefinition, "dir", "logical", "Description", "dir A boolean value that corresponds to one direction" + newline + ...
    "	@note The boolean value for input direction is false and for output direction is true");
validate(setDirectionDefinition);

%% C++ class method |setDirection| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: void libm2k::digital::M2kDigital::setDirection(libm2k::digital::DIO_CHANNEL index,bool dir)

setDirectionDefinition = addMethod(M2kDigitalDefinition, ...
    "void libm2k::digital::M2kDigital::setDirection(libm2k::digital::DIO_CHANNEL index,bool dir)", ...
    "MATLABName", "setDirection", ...
    "Description", "setDirection Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Set the direction of the given digital channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setDirectionDefinition, "index", "clib.libm2k.libm2k.digital.DIO_CHANNEL", "Description", "index An enumerator corresponding to the channel's index");
defineArgument(setDirectionDefinition, "dir", "logical", "Description", "dir A boolean value that corresponds to one direction" + newline + ...
    "	@note The boolean value for input direction is false and for output direction is true");
validate(setDirectionDefinition);

%% C++ class method |setDirection| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: void libm2k::digital::M2kDigital::setDirection(libm2k::digital::DIO_CHANNEL index,libm2k::digital::DIO_DIRECTION dir)

setDirectionDefinition = addMethod(M2kDigitalDefinition, ...
    "void libm2k::digital::M2kDigital::setDirection(libm2k::digital::DIO_CHANNEL index,libm2k::digital::DIO_DIRECTION dir)", ...
    "MATLABName", "setDirection", ...
    "Description", "setDirection Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Set the direction of the given digital channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setDirectionDefinition, "index", "clib.libm2k.libm2k.digital.DIO_CHANNEL", "Description", "index An enumerator corresponding to the channel's index");
defineArgument(setDirectionDefinition, "dir", "clib.libm2k.libm2k.digital.DIO_DIRECTION", "Description", "dir An enumerator that indicates the direction of a channel");
validate(setDirectionDefinition);

%% C++ class method |getDirection| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: libm2k::digital::DIO_DIRECTION libm2k::digital::M2kDigital::getDirection(libm2k::digital::DIO_CHANNEL index)

getDirectionDefinition = addMethod(M2kDigitalDefinition, ...
    "libm2k::digital::DIO_DIRECTION libm2k::digital::M2kDigital::getDirection(libm2k::digital::DIO_CHANNEL index)", ...
    "MATLABName", "getDirection", ...
    "Description", "getDirection Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Retrieve the direction of the given digital channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getDirectionDefinition, "index", "clib.libm2k.libm2k.digital.DIO_CHANNEL", "Description", "index An enumerator corresponding to the channel's index");
defineOutput(getDirectionDefinition, "RetVal", "clib.libm2k.libm2k.digital.DIO_DIRECTION", "Description", "DIO_DIRECTION An enumerator that indicates the direction of a channel");
validate(getDirectionDefinition);

%% C++ class method |setValueRaw| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: void libm2k::digital::M2kDigital::setValueRaw(libm2k::digital::DIO_CHANNEL index,libm2k::digital::DIO_LEVEL level)

setValueRawDefinition = addMethod(M2kDigitalDefinition, ...
    "void libm2k::digital::M2kDigital::setValueRaw(libm2k::digital::DIO_CHANNEL index,libm2k::digital::DIO_LEVEL level)", ...
    "MATLABName", "setValueRaw", ...
    "Description", "setValueRaw Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Set the raw value of a given digital channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setValueRawDefinition, "index", "clib.libm2k.libm2k.digital.DIO_CHANNEL", "Description", "index An enumerator corresponding to the channel's index");
defineArgument(setValueRawDefinition, "level", "clib.libm2k.libm2k.digital.DIO_LEVEL", "Description", "level An enumerator corresponding to the raw value");
validate(setValueRawDefinition);

%% C++ class method |push| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: void libm2k::digital::M2kDigital::push(std::vector<unsigned short, std::allocator<unsigned short>> const & data)

pushDefinition = addMethod(M2kDigitalDefinition, ...
    "void libm2k::digital::M2kDigital::push(std::vector<unsigned short, std::allocator<unsigned short>> const & data)", ...
    "MATLABName", "push", ...
    "Description", "push Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Send the samples to all digital channels", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(pushDefinition, "data", "clib.array.libm2k.UnsignedShort", "Description", "data The std vector that contains the samples" + newline + ...
    "	@note Due to a hardware limitation, the number of samples must" + newline + ...
    "	be a multiple of 4 and greater than 16.");
validate(pushDefinition);

%% C++ class method |push| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: void libm2k::digital::M2kDigital::push(unsigned short * data,unsigned int nb_samples)

%pushDefinition = addMethod(M2kDigitalDefinition, ...
%    "void libm2k::digital::M2kDigital::push(unsigned short * data,unsigned int nb_samples)", ...
%    "MATLABName", "push", ...
%    "Description", "push Method of C++ class libm2k::digital::M2kDigital." + newline + ...
%    "Send the samples to all digital channels", ...
%    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
%defineArgument(pushDefinition, "data", "clib.array.libm2k.UnsignedShort", "input", <SHAPE>, "Description", "data a pointer to the samples"); % <MLTYPE> can be "clib.array.libm2k.UnsignedShort", or "uint16"
%defineArgument(pushDefinition, "nb_samples", "uint32", "Description", "nb_samples the number of samples" + newline + ...
%    "	@note Due to a hardware limitation, the number of samples must" + newline + ...
%    "	be a multiple of 4 and greater than 16.");
%validate(pushDefinition);

%% C++ class method |setValueRaw| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: void libm2k::digital::M2kDigital::setValueRaw(unsigned int index,libm2k::digital::DIO_LEVEL level)

setValueRawDefinition = addMethod(M2kDigitalDefinition, ...
    "void libm2k::digital::M2kDigital::setValueRaw(unsigned int index,libm2k::digital::DIO_LEVEL level)", ...
    "MATLABName", "setValueRaw", ...
    "Description", "setValueRaw Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Set the raw value of a given digital channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setValueRawDefinition, "index", "uint32", "Description", "index The index corresponding to the channel");
defineArgument(setValueRawDefinition, "level", "clib.libm2k.libm2k.digital.DIO_LEVEL", "Description", "level An enumerator corresponding to the raw value");
validate(setValueRawDefinition);

%% C++ class method |setValueRaw| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: void libm2k::digital::M2kDigital::setValueRaw(libm2k::digital::DIO_CHANNEL index,bool level)

setValueRawDefinition = addMethod(M2kDigitalDefinition, ...
    "void libm2k::digital::M2kDigital::setValueRaw(libm2k::digital::DIO_CHANNEL index,bool level)", ...
    "MATLABName", "setValueRaw", ...
    "Description", "setValueRaw Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Set the raw value of a given digital channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setValueRawDefinition, "index", "clib.libm2k.libm2k.digital.DIO_CHANNEL", "Description", "index An enumerator corresponding to the channel's index");
defineArgument(setValueRawDefinition, "level", "logical", "Description", "level A boolean value corresponding to the raw value");
validate(setValueRawDefinition);

%% C++ class method |getValueRaw| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: libm2k::digital::DIO_LEVEL libm2k::digital::M2kDigital::getValueRaw(libm2k::digital::DIO_CHANNEL index)

getValueRawDefinition = addMethod(M2kDigitalDefinition, ...
    "libm2k::digital::DIO_LEVEL libm2k::digital::M2kDigital::getValueRaw(libm2k::digital::DIO_CHANNEL index)", ...
    "MATLABName", "getValueRaw", ...
    "Description", "getValueRaw Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Retrieve the raw value of the given digital channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getValueRawDefinition, "index", "clib.libm2k.libm2k.digital.DIO_CHANNEL", "Description", "index An enumerator corresponding to the channel's index");
defineOutput(getValueRawDefinition, "RetVal", "clib.libm2k.libm2k.digital.DIO_LEVEL", "Description", "DIO_LEVEL An enumerator corresponding to the raw value");
validate(getValueRawDefinition);

%% C++ class method |getValueRaw| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: libm2k::digital::DIO_LEVEL libm2k::digital::M2kDigital::getValueRaw(unsigned int index)

getValueRawDefinition = addMethod(M2kDigitalDefinition, ...
    "libm2k::digital::DIO_LEVEL libm2k::digital::M2kDigital::getValueRaw(unsigned int index)", ...
    "MATLABName", "getValueRaw", ...
    "Description", "getValueRaw Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Retrieve the raw value of the given digital channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getValueRawDefinition, "index", "uint32", "Description", "index The index corresponding to the channel");
defineOutput(getValueRawDefinition, "RetVal", "clib.libm2k.libm2k.digital.DIO_LEVEL", "Description", "DIO_LEVEL An enumerator corresponding to the raw value");
validate(getValueRawDefinition);

%% C++ class method |stopBufferOut| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: void libm2k::digital::M2kDigital::stopBufferOut()

stopBufferOutDefinition = addMethod(M2kDigitalDefinition, ...
    "void libm2k::digital::M2kDigital::stopBufferOut()", ...
    "MATLABName", "stopBufferOut", ...
    "Description", "stopBufferOut Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Stop all digital channels from sending the signals", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@brief Stop all digital channels from sending the signals"); % Modify help description values as needed.
validate(stopBufferOutDefinition);

%% C++ class method |startAcquisition| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: void libm2k::digital::M2kDigital::startAcquisition(unsigned int nb_samples)

startAcquisitionDefinition = addMethod(M2kDigitalDefinition, ...
    "void libm2k::digital::M2kDigital::startAcquisition(unsigned int nb_samples)", ...
    "MATLABName", "startAcquisition", ...
    "Description", "startAcquisition Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Create the buffer for all channels and start the acquisition", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(startAcquisitionDefinition, "nb_samples", "uint32", "Description", "nb_samples size of the buffer in samples");
validate(startAcquisitionDefinition);

%% C++ class method |stopAcquisition| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: void libm2k::digital::M2kDigital::stopAcquisition()

stopAcquisitionDefinition = addMethod(M2kDigitalDefinition, ...
    "void libm2k::digital::M2kDigital::stopAcquisition()", ...
    "MATLABName", "stopAcquisition", ...
    "Description", "stopAcquisition Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Destroy the buffer and stop the acquisition", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@brief Destroy the buffer and stop the acquisition"); % Modify help description values as needed.
validate(stopAcquisitionDefinition);

%% C++ class method |cancelAcquisition| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: void libm2k::digital::M2kDigital::cancelAcquisition()

cancelAcquisitionDefinition = addMethod(M2kDigitalDefinition, ...
    "void libm2k::digital::M2kDigital::cancelAcquisition()", ...
    "MATLABName", "cancelAcquisition", ...
    "Description", "cancelAcquisition Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Cancel all rx-buffer operations" + newline + ...
    "	@note Should be used to cancel an ongoing acquisition", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@brief Cancel all rx-buffer operations" + newline + ...
    "	@note Should be used to cancel an ongoing acquisition"); % Modify help description values as needed.
validate(cancelAcquisitionDefinition);

%% C++ class method |cancelBufferOut| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: void libm2k::digital::M2kDigital::cancelBufferOut()

cancelBufferOutDefinition = addMethod(M2kDigitalDefinition, ...
    "void libm2k::digital::M2kDigital::cancelBufferOut()", ...
    "MATLABName", "cancelBufferOut", ...
    "Description", "cancelBufferOut Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Cancel all tx-buffer operations" + newline + ...
    "	@note Should be used to cancel an ongoing data write.", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@brief Cancel all tx-buffer operations" + newline + ...
    "	@note Should be used to cancel an ongoing data write."); % Modify help description values as needed.
validate(cancelBufferOutDefinition);

%% C++ class method |getSamples| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: std::vector<unsigned short, std::allocator<unsigned short>> libm2k::digital::M2kDigital::getSamples(unsigned int nb_samples)

getSamplesDefinition = addMethod(M2kDigitalDefinition, ...
    "std::vector<unsigned short, std::allocator<unsigned short>> libm2k::digital::M2kDigital::getSamples(unsigned int nb_samples)", ...
    "MATLABName", "getSamples", ...
    "Description", "getSamples Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Retrieve a specific number of samples", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getSamplesDefinition, "nb_samples", "uint32", "Description", "nb_samples The number of samples that will be retrieved");
defineOutput(getSamplesDefinition, "RetVal", "clib.array.libm2k.UnsignedShort", "Description", "A list that contains the samples" + newline + ...
    "	@note Due to a hardware limitation, the number of samples must" + newline + ...
    "	be a multiple of 4 and greater than 16.");
validate(getSamplesDefinition);

%% C++ class method |getSamplesP| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: unsigned short const * libm2k::digital::M2kDigital::getSamplesP(unsigned int nb_samples)

%getSamplesPDefinition = addMethod(M2kDigitalDefinition, ...
%    "unsigned short const * libm2k::digital::M2kDigital::getSamplesP(unsigned int nb_samples)", ...
%    "MATLABName", "getSamplesP", ...
%    "Description", "getSamplesP Method of C++ class libm2k::digital::M2kDigital." + newline + ...
%    "Retrieve a specific number of samples", ...
%    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
%defineArgument(getSamplesPDefinition, "nb_samples", "uint32", "Description", "nb_samples The number of samples that will be retrieved");
%defineOutput(getSamplesPDefinition, "RetVal", "clib.array.libm2k.UnsignedShort", <SHAPE>, "Description", "A pointer to the data" + newline + ...
%    "	 @note Due to a hardware limitation, the number of samples must" + newline + ...
%    "	 be a multiple of 4 and greater than 16."); % <MLTYPE> can be "clib.array.libm2k.UnsignedShort", or "uint16"
%validate(getSamplesPDefinition);

%% C++ class method |enableChannel| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: void libm2k::digital::M2kDigital::enableChannel(unsigned int index,bool enable)

enableChannelDefinition = addMethod(M2kDigitalDefinition, ...
    "void libm2k::digital::M2kDigital::enableChannel(unsigned int index,bool enable)", ...
    "MATLABName", "enableChannel", ...
    "Description", "enableChannel Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Enable or disable the given digital channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(enableChannelDefinition, "index", "uint32", "Description", "index The index corresponding to the channel");
defineArgument(enableChannelDefinition, "enable", "logical", "Description", "enable A boolean value corresponding to the channel's state");
validate(enableChannelDefinition);

%% C++ class method |enableChannel| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: void libm2k::digital::M2kDigital::enableChannel(libm2k::digital::DIO_CHANNEL index,bool enable)

enableChannelDefinition = addMethod(M2kDigitalDefinition, ...
    "void libm2k::digital::M2kDigital::enableChannel(libm2k::digital::DIO_CHANNEL index,bool enable)", ...
    "MATLABName", "enableChannel", ...
    "Description", "enableChannel Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Enable or disable the given digital channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(enableChannelDefinition, "index", "clib.libm2k.libm2k.digital.DIO_CHANNEL", "Description", "index An enumerator corresponding to the channel's index");
defineArgument(enableChannelDefinition, "enable", "logical", "Description", "enable A boolean value corresponding to the channel's state");
validate(enableChannelDefinition);

%% C++ class method |enableAllOut| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: void libm2k::digital::M2kDigital::enableAllOut(bool enable)

enableAllOutDefinition = addMethod(M2kDigitalDefinition, ...
    "void libm2k::digital::M2kDigital::enableAllOut(bool enable)", ...
    "MATLABName", "enableAllOut", ...
    "Description", "enableAllOut Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Enable or disable all output channels", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(enableAllOutDefinition, "enable", "logical", "Description", "enable A boolean value corresponding to the channel's state");
validate(enableAllOutDefinition);

%% C++ class method |anyChannelEnabled| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: bool libm2k::digital::M2kDigital::anyChannelEnabled(libm2k::digital::DIO_DIRECTION dir)

anyChannelEnabledDefinition = addMethod(M2kDigitalDefinition, ...
    "bool libm2k::digital::M2kDigital::anyChannelEnabled(libm2k::digital::DIO_DIRECTION dir)", ...
    "MATLABName", "anyChannelEnabled", ...
    "Description", "anyChannelEnabled Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Check if there is at least one channel enabled", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(anyChannelEnabledDefinition, "dir", "clib.libm2k.libm2k.digital.DIO_DIRECTION", "Description", "dir An enumerator corresponding to the direction of a channel");
defineOutput(anyChannelEnabledDefinition, "RetVal", "logical", "Description", "On succces, true");
validate(anyChannelEnabledDefinition);

%% C++ class method |setOutputMode| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: void libm2k::digital::M2kDigital::setOutputMode(libm2k::digital::DIO_CHANNEL chn,libm2k::digital::DIO_MODE mode)

setOutputModeDefinition = addMethod(M2kDigitalDefinition, ...
    "void libm2k::digital::M2kDigital::setOutputMode(libm2k::digital::DIO_CHANNEL chn,libm2k::digital::DIO_MODE mode)", ...
    "MATLABName", "setOutputMode", ...
    "Description", "setOutputMode Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Set the output mode for the given digital channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setOutputModeDefinition, "chn", "clib.libm2k.libm2k.digital.DIO_CHANNEL", "Description", "chn An enumerator corresponding to the channel's index");
defineArgument(setOutputModeDefinition, "mode", "clib.libm2k.libm2k.digital.DIO_MODE", "Description", "mode An enumerator corresponding to the output mode");
validate(setOutputModeDefinition);

%% C++ class method |setOutputMode| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: void libm2k::digital::M2kDigital::setOutputMode(unsigned int chn,libm2k::digital::DIO_MODE mode)

setOutputModeDefinition = addMethod(M2kDigitalDefinition, ...
    "void libm2k::digital::M2kDigital::setOutputMode(unsigned int chn,libm2k::digital::DIO_MODE mode)", ...
    "MATLABName", "setOutputMode", ...
    "Description", "setOutputMode Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Set the output mode for the given digital channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setOutputModeDefinition, "chn", "uint32", "Description", "chn The index corresponding to the channel");
defineArgument(setOutputModeDefinition, "mode", "clib.libm2k.libm2k.digital.DIO_MODE", "Description", "mode An enumerator corresponding to the output mode");
validate(setOutputModeDefinition);

%% C++ class method |getOutputMode| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: libm2k::digital::DIO_MODE libm2k::digital::M2kDigital::getOutputMode(libm2k::digital::DIO_CHANNEL chn)

getOutputModeDefinition = addMethod(M2kDigitalDefinition, ...
    "libm2k::digital::DIO_MODE libm2k::digital::M2kDigital::getOutputMode(libm2k::digital::DIO_CHANNEL chn)", ...
    "MATLABName", "getOutputMode", ...
    "Description", "getOutputMode Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Retrieve the output mode for the given digital channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getOutputModeDefinition, "chn", "clib.libm2k.libm2k.digital.DIO_CHANNEL", "Description", "chn An enumerator corresponding to the channel's index");
defineOutput(getOutputModeDefinition, "RetVal", "clib.libm2k.libm2k.digital.DIO_MODE", "Description", "An enumerator corresponding to the output mode");
validate(getOutputModeDefinition);

%% C++ class method |getOutputMode| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: libm2k::digital::DIO_MODE libm2k::digital::M2kDigital::getOutputMode(unsigned int chn)

getOutputModeDefinition = addMethod(M2kDigitalDefinition, ...
    "libm2k::digital::DIO_MODE libm2k::digital::M2kDigital::getOutputMode(unsigned int chn)", ...
    "MATLABName", "getOutputMode", ...
    "Description", "getOutputMode Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Retrieve the output mode for the given digital channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getOutputModeDefinition, "chn", "uint32", "Description", "chn The index corresponding to the channel");
defineOutput(getOutputModeDefinition, "RetVal", "clib.libm2k.libm2k.digital.DIO_MODE", "Description", "An enumerator corresponding to the output mode");
validate(getOutputModeDefinition);

%% C++ class method |setSampleRateIn| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: double libm2k::digital::M2kDigital::setSampleRateIn(double samplerate)

setSampleRateInDefinition = addMethod(M2kDigitalDefinition, ...
    "double libm2k::digital::M2kDigital::setSampleRateIn(double samplerate)", ...
    "MATLABName", "setSampleRateIn", ...
    "Description", "setSampleRateIn Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Set the sample rate for all digital input channels", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setSampleRateInDefinition, "samplerate", "double", "Description", "samplerate A double value to set the sample rate to");
defineOutput(setSampleRateInDefinition, "RetVal", "double", "Description", "The current sample rate for all digital input channels");
validate(setSampleRateInDefinition);

%% C++ class method |setSampleRateOut| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: double libm2k::digital::M2kDigital::setSampleRateOut(double samplerate)

setSampleRateOutDefinition = addMethod(M2kDigitalDefinition, ...
    "double libm2k::digital::M2kDigital::setSampleRateOut(double samplerate)", ...
    "MATLABName", "setSampleRateOut", ...
    "Description", "setSampleRateOut Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Set the sample rate for all digital output channels", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setSampleRateOutDefinition, "samplerate", "double", "Description", "samplerate A double value to set the sample rate to");
defineOutput(setSampleRateOutDefinition, "RetVal", "double", "Description", "The current sample rate for all digital output channels");
validate(setSampleRateOutDefinition);

%% C++ class method |getSampleRateIn| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: double libm2k::digital::M2kDigital::getSampleRateIn()

getSampleRateInDefinition = addMethod(M2kDigitalDefinition, ...
    "double libm2k::digital::M2kDigital::getSampleRateIn()", ...
    "MATLABName", "getSampleRateIn", ...
    "Description", "getSampleRateIn Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Retrieve the sample rate of all digital input channels", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getSampleRateInDefinition, "RetVal", "double", "Description", "The value of the sample rate");
validate(getSampleRateInDefinition);

%% C++ class method |getSampleRateOut| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: double libm2k::digital::M2kDigital::getSampleRateOut()

getSampleRateOutDefinition = addMethod(M2kDigitalDefinition, ...
    "double libm2k::digital::M2kDigital::getSampleRateOut()", ...
    "MATLABName", "getSampleRateOut", ...
    "Description", "getSampleRateOut Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Retrieve the sample rate of all digital output channels", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getSampleRateOutDefinition, "RetVal", "double", "Description", "The value of the sample rate");
validate(getSampleRateOutDefinition);

%% C++ class method |getCyclic| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: bool libm2k::digital::M2kDigital::getCyclic()

getCyclicDefinition = addMethod(M2kDigitalDefinition, ...
    "bool libm2k::digital::M2kDigital::getCyclic()", ...
    "MATLABName", "getCyclic", ...
    "Description", "getCyclic Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Retrieve the value of the cyclic mode", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getCyclicDefinition, "RetVal", "logical", "Description", "A boolean value corresponding to the state of the cyclic mode");
validate(getCyclicDefinition);

%% C++ class method |setCyclic| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: void libm2k::digital::M2kDigital::setCyclic(bool cyclic)

setCyclicDefinition = addMethod(M2kDigitalDefinition, ...
    "void libm2k::digital::M2kDigital::setCyclic(bool cyclic)", ...
    "MATLABName", "setCyclic", ...
    "Description", "setCyclic Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Enable or disable the cyclic mode for all digital channels", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setCyclicDefinition, "cyclic", "logical", "Description", "cyclic If true, enable cyclic mode");
validate(setCyclicDefinition);

%% C++ class method |getTrigger| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: libm2k::M2kHardwareTrigger * libm2k::digital::M2kDigital::getTrigger()

%getTriggerDefinition = addMethod(M2kDigitalDefinition, ...
%    "libm2k::M2kHardwareTrigger * libm2k::digital::M2kDigital::getTrigger()", ...
%    "MATLABName", "getTrigger", ...
%    "Description", "getTrigger Method of C++ class libm2k::digital::M2kDigital." + newline + ...
%    "Get the hardware trigger handler", ...
%    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
%defineOutput(getTriggerDefinition, "RetVal", "clib.libm2k.libm2k.M2kHardwareTrigger", <SHAPE>, "Description", "the trigger object");
%validate(getTriggerDefinition);

%% C++ class method |setKernelBuffersCountIn| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: void libm2k::digital::M2kDigital::setKernelBuffersCountIn(unsigned int count)

setKernelBuffersCountInDefinition = addMethod(M2kDigitalDefinition, ...
    "void libm2k::digital::M2kDigital::setKernelBuffersCountIn(unsigned int count)", ...
    "MATLABName", "setKernelBuffersCountIn", ...
    "Description", "setKernelBuffersCountIn Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Set the kernel buffers for input to a specific value", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setKernelBuffersCountInDefinition, "count", "uint32", "Description", "count the number of kernel buffers");
validate(setKernelBuffersCountInDefinition);

%% C++ class method |setKernelBuffersCountOut| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: void libm2k::digital::M2kDigital::setKernelBuffersCountOut(unsigned int count)

setKernelBuffersCountOutDefinition = addMethod(M2kDigitalDefinition, ...
    "void libm2k::digital::M2kDigital::setKernelBuffersCountOut(unsigned int count)", ...
    "MATLABName", "setKernelBuffersCountOut", ...
    "Description", "setKernelBuffersCountOut Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Set the kernel buffers for output to a specific value", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setKernelBuffersCountOutDefinition, "count", "uint32", "Description", "count the number of kernel buffers");
validate(setKernelBuffersCountOutDefinition);

%% C++ class method |getIioObjects| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: libm2k::IIO_OBJECTS libm2k::digital::M2kDigital::getIioObjects()

getIioObjectsDefinition = addMethod(M2kDigitalDefinition, ...
    "libm2k::IIO_OBJECTS libm2k::digital::M2kDigital::getIioObjects()", ...
    "MATLABName", "getIioObjects", ...
    "Description", "getIioObjects Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Get access to IIO channels, buffers, devices and context." + newline + ...
    "	 Can be used when debugging directly with libiio.", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getIioObjectsDefinition, "RetVal", "clib.libm2k.libm2k.IIO_OBJECTS", "Description", "IIO_OBJECTS structure.");
validate(getIioObjectsDefinition);

%% C++ class method |getNbChannelsIn| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: unsigned int libm2k::digital::M2kDigital::getNbChannelsIn()

getNbChannelsInDefinition = addMethod(M2kDigitalDefinition, ...
    "unsigned int libm2k::digital::M2kDigital::getNbChannelsIn()", ...
    "MATLABName", "getNbChannelsIn", ...
    "Description", "getNbChannelsIn Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Retrieve the number of digital input channels", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getNbChannelsInDefinition, "RetVal", "uint32", "Description", "an unsigned int representing the number of digital IN channels");
validate(getNbChannelsInDefinition);

%% C++ class method |getNbChannelsOut| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: unsigned int libm2k::digital::M2kDigital::getNbChannelsOut()

getNbChannelsOutDefinition = addMethod(M2kDigitalDefinition, ...
    "unsigned int libm2k::digital::M2kDigital::getNbChannelsOut()", ...
    "MATLABName", "getNbChannelsOut", ...
    "Description", "getNbChannelsOut Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Retrieve the number of digital output channels", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getNbChannelsOutDefinition, "RetVal", "uint32", "Description", "an unsigned int representing the number of digital OUT channels");
validate(getNbChannelsOutDefinition);

%% C++ class method |getSamples| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: void libm2k::digital::M2kDigital::getSamples(std::vector<unsigned short, std::allocator<unsigned short>> & data,unsigned int nb_samples)

getSamplesDefinition = addMethod(M2kDigitalDefinition, ...
    "void libm2k::digital::M2kDigital::getSamples(std::vector<unsigned short, std::allocator<unsigned short>> & data,unsigned int nb_samples)", ...
    "MATLABName", "getSamples", ...
    "Description", "getSamples Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Retrieve a specific number of samples", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getSamplesDefinition, "data", "clib.array.libm2k.UnsignedShort", "Description", "data - a reference to a vector owned/created by the client");
defineArgument(getSamplesDefinition, "nb_samples", "uint32", "Description", "nb_samples The number of samples that will be retrieved. The vector will be cleaned and then filled with samples." + newline + ...
    "	 @note Due to a hardware limitation, the number of samples must" + newline + ...
    "	 be a multiple of 4 and greater than 16.");
validate(getSamplesDefinition);

%% C++ class method |setRateMux| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: void libm2k::digital::M2kDigital::setRateMux()

setRateMuxDefinition = addMethod(M2kDigitalDefinition, ...
    "void libm2k::digital::M2kDigital::setRateMux()", ...
    "MATLABName", "setRateMux", ...
    "Description", "setRateMux Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Force the digital interface to use the analogical rate", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@note Only available from firmware v0.26."); % Modify help description values as needed.
validate(setRateMuxDefinition);

%% C++ class method |resetRateMux| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: void libm2k::digital::M2kDigital::resetRateMux()

resetRateMuxDefinition = addMethod(M2kDigitalDefinition, ...
    "void libm2k::digital::M2kDigital::resetRateMux()", ...
    "MATLABName", "resetRateMux", ...
    "Description", "resetRateMux Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Reset the digital rate to default", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@note Only available from firmware v0.26."); % Modify help description values as needed.
validate(resetRateMuxDefinition);

%% C++ class method |setExternalClocksource| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: void libm2k::digital::M2kDigital::setExternalClocksource(bool external)

setExternalClocksourceDefinition = addMethod(M2kDigitalDefinition, ...
    "void libm2k::digital::M2kDigital::setExternalClocksource(bool external)", ...
    "MATLABName", "setExternalClocksource", ...
    "Description", "setExternalClocksource Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Set the clocksource", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setExternalClocksourceDefinition, "external", "logical", "Description", "external - True to set source to external" + newline + ...
    "	 *		   - False to set source to internal");
validate(setExternalClocksourceDefinition);

%% C++ class method |isClocksourceExternal| for C++ class |libm2k::digital::M2kDigital| 
% C++ Signature: bool libm2k::digital::M2kDigital::isClocksourceExternal()

isClocksourceExternalDefinition = addMethod(M2kDigitalDefinition, ...
    "bool libm2k::digital::M2kDigital::isClocksourceExternal()", ...
    "MATLABName", "isClocksourceExternal", ...
    "Description", "isClocksourceExternal Method of C++ class libm2k::digital::M2kDigital." + newline + ...
    "Get the current clocksource", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(isClocksourceExternalDefinition, "RetVal", "logical", "Description", "True if clocksource is set to external");
validate(isClocksourceExternalDefinition);

%% C++ enumeration |libm2k::digital::DIO_DIRECTION| with MATLAB name |clib.libm2k.libm2k.digital.DIO_DIRECTION| 
addEnumeration(libDef, "libm2k::digital::DIO_DIRECTION", "int32",...
    [...
      "DIO_INPUT",...  % 0
      "DIO_OUTPUT",...  % 1
    ],...
    "MATLABName", "clib.libm2k.libm2k.digital.DIO_DIRECTION", ...
    "Description", "clib.libm2k.libm2k.digital.DIO_DIRECTION    Representation of C++ enumeration libm2k::digital::DIO_DIRECTION." + newline + ...
    "Direction of a digital channel", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@note Digital channels can be used both for transmitting and receiving digital signals"); % Modify help description values as needed.

%% C++ enumeration |libm2k::digital::DIO_LEVEL| with MATLAB name |clib.libm2k.libm2k.digital.DIO_LEVEL| 
addEnumeration(libDef, "libm2k::digital::DIO_LEVEL", "int32",...
    [...
      "LOW",...  % 0
      "HIGH",...  % 1
    ],...
    "MATLABName", "clib.libm2k.libm2k.digital.DIO_LEVEL", ...
    "Description", "clib.libm2k.libm2k.digital.DIO_LEVEL    Representation of C++ enumeration libm2k::digital::DIO_LEVEL." + newline + ...
    "Logic voltage levels", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@note At any given time a digital signals can only take two possible values, namely low or high"); % Modify help description values as needed.

%% C++ enumeration |libm2k::digital::DIO_MODE| with MATLAB name |clib.libm2k.libm2k.digital.DIO_MODE| 
addEnumeration(libDef, "libm2k::digital::DIO_MODE", "int32",...
    [...
      "DIO_OPENDRAIN",...  % 0
      "DIO_PUSHPULL",...  % 1
    ],...
    "MATLABName", "clib.libm2k.libm2k.digital.DIO_MODE", ...
    "Description", "clib.libm2k.libm2k.digital.DIO_MODE    Representation of C++ enumeration libm2k::digital::DIO_MODE." + newline + ...
    "Output mode for a digital channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.

%% C++ class |libm2k::digital::channel| with MATLAB name |clib.libm2k.libm2k.digital.channel| 
channelDefinition = addClass(libDef, "libm2k::digital::channel", "MATLABName", "clib.libm2k.libm2k.digital.channel", ...
    "Description", "clib.libm2k.libm2k.digital.channel    Representation of C++ class libm2k::digital::channel.", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@private"); % Modify help description values as needed.

%% C++ class constructor for C++ class |libm2k::digital::channel| 
% C++ Signature: libm2k::digital::channel::channel(libm2k::digital::channel const & input1)

channelConstructor1Definition = addConstructor(channelDefinition, ...
    "libm2k::digital::channel::channel(libm2k::digital::channel const & input1)", ...
    "Description", "clib.libm2k.libm2k.digital.channel Constructor of C++ class libm2k::digital::channel."); % Modify help description values as needed.
defineArgument(channelConstructor1Definition, "input1", "clib.libm2k.libm2k.digital.channel", "input");
validate(channelConstructor1Definition);

%% C++ class constructor for C++ class |libm2k::digital::channel| 
% C++ Signature: libm2k::digital::channel::channel()

channelConstructor2Definition = addConstructor(channelDefinition, ...
    "libm2k::digital::channel::channel()", ...
    "Description", "clib.libm2k.libm2k.digital.channel Constructor of C++ class libm2k::digital::channel."); % Modify help description values as needed.
validate(channelConstructor2Definition);

%% C++ class public data member |m_channel| for C++ class |libm2k::digital::channel| 
% C++ Signature: iio_channel * libm2k::digital::channel::m_channel

%addProperty(channelDefinition, "m_channel", "clib.libm2k.iio_channel", <SHAPE>, ...
%    "Description", "clib.libm2k.iio_channel    Data member of C++ class libm2k::digital::channel." + newline + ...
%    "A pointer to an iio_channel structure"); % Modify help description values as needed.

%% C++ class public data member |m_direction| for C++ class |libm2k::digital::channel| 
% C++ Signature: libm2k::digital::DIO_DIRECTION libm2k::digital::channel::m_direction

addProperty(channelDefinition, "m_direction", "clib.libm2k.libm2k.digital.DIO_DIRECTION", ...
    "Description", "clib.libm2k.libm2k.digital.DIO_DIRECTION    Data member of C++ class libm2k::digital::channel." + newline + ...
    "The direction of the channel"); % Modify help description values as needed.

%% C++ class |libm2k::analog::DMM| with MATLAB name |clib.libm2k.libm2k.analog.DMM| 
DMMDefinition = addClass(libDef, "libm2k::analog::DMM", "MATLABName", "clib.libm2k.libm2k.analog.DMM", ...
    "Description", "clib.libm2k.libm2k.analog.DMM    Representation of C++ class libm2k::analog::DMM." + newline + ...
    "Contains the representation of the digital multimeter" + newline + ...
    "" + newline + ...
    "@class DMM dmm.hpp libm2k/analog/dmm.hpp" + newline + ...
    "@brief Controls the digital multimeter", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@defgroup dmm DMM" + newline + ...
    "@brief Contains the representation of the digital multimeter" + newline + ...
    "" + newline + ...
    "@class DMM dmm.hpp libm2k/analog/dmm.hpp" + newline + ...
    "@brief Controls the digital multimeter"); % Modify help description values as needed.

%% C++ class method |reset| for C++ class |libm2k::analog::DMM| 
% C++ Signature: void libm2k::analog::DMM::reset()

resetDefinition = addMethod(DMMDefinition, ...
    "void libm2k::analog::DMM::reset()", ...
    "MATLABName", "reset", ...
    "Description", "reset Method of C++ class libm2k::analog::DMM.", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@private"); % Modify help description values as needed.
validate(resetDefinition);

%% C++ class method |getAllChannels| for C++ class |libm2k::analog::DMM| 
% C++ Signature: std::vector<std::string> libm2k::analog::DMM::getAllChannels()

getAllChannelsDefinition = addMethod(DMMDefinition, ...
    "std::vector<std::string> libm2k::analog::DMM::getAllChannels()", ...
    "MATLABName", "getAllChannels", ...
    "Description", "getAllChannels Method of C++ class libm2k::analog::DMM." + newline + ...
    "Retrieve all channels", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getAllChannelsDefinition, "RetVal", "clib.array.libm2k.std.String", "Description", "A list containing the name of all channels");
validate(getAllChannelsDefinition);

%% C++ class method |readChannel| for C++ class |libm2k::analog::DMM| 
% C++ Signature: libm2k::analog::DMM_READING libm2k::analog::DMM::readChannel(unsigned int index)

readChannelDefinition = addMethod(DMMDefinition, ...
    "libm2k::analog::DMM_READING libm2k::analog::DMM::readChannel(unsigned int index)", ...
    "MATLABName", "readChannel", ...
    "Description", "readChannel Method of C++ class libm2k::analog::DMM." + newline + ...
    "Retrieve additional information about the given channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(readChannelDefinition, "index", "uint32", "Description", "index The index corresponding to the channel");
defineOutput(readChannelDefinition, "RetVal", "clib.libm2k.libm2k.analog.DMM_READING", "Description", "A structure containing additional information");
validate(readChannelDefinition);

%% C++ class method |readChannel| for C++ class |libm2k::analog::DMM| 
% C++ Signature: libm2k::analog::DMM_READING libm2k::analog::DMM::readChannel(std::string chn_name)

readChannelDefinition = addMethod(DMMDefinition, ...
    "libm2k::analog::DMM_READING libm2k::analog::DMM::readChannel(std::string chn_name)", ...
    "MATLABName", "readChannel", ...
    "Description", "readChannel Method of C++ class libm2k::analog::DMM." + newline + ...
    "Retrieve additional information about the given channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(readChannelDefinition, "chn_name", "string", "Description", "chn_name The name corresponding to the channel");
defineOutput(readChannelDefinition, "RetVal", "clib.libm2k.libm2k.analog.DMM_READING", "Description", "A structure containing additional information");
validate(readChannelDefinition);

%% C++ class method |readAll| for C++ class |libm2k::analog::DMM| 
% C++ Signature: std::vector<libm2k::analog::DMM_READING, std::allocator<libm2k::analog::DMM_READING>> libm2k::analog::DMM::readAll()

readAllDefinition = addMethod(DMMDefinition, ...
    "std::vector<libm2k::analog::DMM_READING, std::allocator<libm2k::analog::DMM_READING>> libm2k::analog::DMM::readAll()", ...
    "MATLABName", "readAll", ...
    "Description", "readAll Method of C++ class libm2k::analog::DMM." + newline + ...
    "Retrieve additional information about all channels", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(readAllDefinition, "RetVal", "clib.array.libm2k.libm2k.analog.DMM_READING", "Description", "A list containing structures for each channel");
validate(readAllDefinition);

%% C++ class method |getName| for C++ class |libm2k::analog::DMM| 
% C++ Signature: std::string libm2k::analog::DMM::getName()

getNameDefinition = addMethod(DMMDefinition, ...
    "std::string libm2k::analog::DMM::getName()", ...
    "MATLABName", "getName", ...
    "Description", "getName Method of C++ class libm2k::analog::DMM." + newline + ...
    "Retrieve the device's name", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getNameDefinition, "RetVal", "string", "Description", "The name of the device");
validate(getNameDefinition);

%% C++ class |libm2k::analog::DMM_READING| with MATLAB name |clib.libm2k.libm2k.analog.DMM_READING| 
DMM_READINGDefinition = addClass(libDef, "libm2k::analog::DMM_READING", "MATLABName", "clib.libm2k.libm2k.analog.DMM_READING", ...
    "Description", "clib.libm2k.libm2k.analog.DMM_READING    Representation of C++ class libm2k::analog::DMM_READING." + newline + ...
    "The structure of a DMM", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.

%% C++ class constructor for C++ class |libm2k::analog::DMM_READING| 
% C++ Signature: libm2k::analog::DMM_READING::DMM_READING()

DMM_READINGConstructor1Definition = addConstructor(DMM_READINGDefinition, ...
    "libm2k::analog::DMM_READING::DMM_READING()", ...
    "Description", "clib.libm2k.libm2k.analog.DMM_READING Constructor of C++ class libm2k::analog::DMM_READING."); % Modify help description values as needed.
validate(DMM_READINGConstructor1Definition);

%% C++ class constructor for C++ class |libm2k::analog::DMM_READING| 
% C++ Signature: libm2k::analog::DMM_READING::DMM_READING(libm2k::analog::DMM_READING const & input1)

DMM_READINGConstructor2Definition = addConstructor(DMM_READINGDefinition, ...
    "libm2k::analog::DMM_READING::DMM_READING(libm2k::analog::DMM_READING const & input1)", ...
    "Description", "clib.libm2k.libm2k.analog.DMM_READING Constructor of C++ class libm2k::analog::DMM_READING."); % Modify help description values as needed.
defineArgument(DMM_READINGConstructor2Definition, "input1", "clib.libm2k.libm2k.analog.DMM_READING", "input");
validate(DMM_READINGConstructor2Definition);

%% C++ class public data member |name| for C++ class |libm2k::analog::DMM_READING| 
% C++ Signature: std::string libm2k::analog::DMM_READING::name

addProperty(DMM_READINGDefinition, "name", "string", ...
    "Description", "string    Data member of C++ class libm2k::analog::DMM_READING." + newline + ...
    "The name of the channel"); % Modify help description values as needed.

%% C++ class public data member |id| for C++ class |libm2k::analog::DMM_READING| 
% C++ Signature: std::string libm2k::analog::DMM_READING::id

addProperty(DMM_READINGDefinition, "id", "string", ...
    "Description", "string    Data member of C++ class libm2k::analog::DMM_READING." + newline + ...
    "Channel's id"); % Modify help description values as needed.

%% C++ class public data member |value| for C++ class |libm2k::analog::DMM_READING| 
% C++ Signature: double libm2k::analog::DMM_READING::value

addProperty(DMM_READINGDefinition, "value", "double", ...
    "Description", "double    Data member of C++ class libm2k::analog::DMM_READING." + newline + ...
    "The measured value"); % Modify help description values as needed.

%% C++ class public data member |unit_name| for C++ class |libm2k::analog::DMM_READING| 
% C++ Signature: std::string libm2k::analog::DMM_READING::unit_name

addProperty(DMM_READINGDefinition, "unit_name", "string", ...
    "Description", "string    Data member of C++ class libm2k::analog::DMM_READING." + newline + ...
    "Unit of measurement"); % Modify help description values as needed.

%% C++ class public data member |unit_symbol| for C++ class |libm2k::analog::DMM_READING| 
% C++ Signature: std::string libm2k::analog::DMM_READING::unit_symbol

addProperty(DMM_READINGDefinition, "unit_symbol", "string", ...
    "Description", "string    Data member of C++ class libm2k::analog::DMM_READING." + newline + ...
    "Unit symbol"); % Modify help description values as needed.

%% C++ class |libm2k::analog::M2kAnalogIn| with MATLAB name |clib.libm2k.libm2k.analog.M2kAnalogIn| 
M2kAnalogInDefinition = addClass(libDef, "libm2k::analog::M2kAnalogIn", "MATLABName", "clib.libm2k.libm2k.analog.M2kAnalogIn", ...
    "Description", "clib.libm2k.libm2k.analog.M2kAnalogIn    Representation of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
    "Contains the representation of the analogical input segment" + newline + ...
    "" + newline + ...
    "@class M2kAnalogIn m2kanalogin.hpp libm2k/analog/m2kanalogin.hpp" + newline + ...
    "@brief Controls the analogical input compound", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@defgroup analogin AnalogIn" + newline + ...
    "@brief Contains the representation of the analogical input segment" + newline + ...
    "" + newline + ...
    "@class M2kAnalogIn m2kanalogin.hpp libm2k/analog/m2kanalogin.hpp" + newline + ...
    "@brief Controls the analogical input compound"); % Modify help description values as needed.

%% C++ class method |reset| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: void libm2k::analog::M2kAnalogIn::reset()

resetDefinition = addMethod(M2kAnalogInDefinition, ...
    "void libm2k::analog::M2kAnalogIn::reset()", ...
    "MATLABName", "reset", ...
    "Description", "reset Method of C++ class libm2k::analog::M2kAnalogIn.", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@private"); % Modify help description values as needed.
validate(resetDefinition);

%% C++ class method |startAcquisition| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: void libm2k::analog::M2kAnalogIn::startAcquisition(unsigned int nb_samples)

startAcquisitionDefinition = addMethod(M2kAnalogInDefinition, ...
    "void libm2k::analog::M2kAnalogIn::startAcquisition(unsigned int nb_samples)", ...
    "MATLABName", "startAcquisition", ...
    "Description", "startAcquisition Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
    "Create the buffer for both channels and start the acquisition", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(startAcquisitionDefinition, "nb_samples", "uint32", "Description", "nb_samples size of the buffer in samples for each channel");
validate(startAcquisitionDefinition);

%% C++ class method |stopAcquisition| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: void libm2k::analog::M2kAnalogIn::stopAcquisition()

stopAcquisitionDefinition = addMethod(M2kAnalogInDefinition, ...
    "void libm2k::analog::M2kAnalogIn::stopAcquisition()", ...
    "MATLABName", "stopAcquisition", ...
    "Description", "stopAcquisition Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
    "Destroy the buffer and stop the acquisition", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@brief Destroy the buffer and stop the acquisition"); % Modify help description values as needed.
validate(stopAcquisitionDefinition);

%% C++ class method |getSamplesInterleaved| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: double const * libm2k::analog::M2kAnalogIn::getSamplesInterleaved(unsigned int nb_samples_per_channel)

%getSamplesInterleavedDefinition = addMethod(M2kAnalogInDefinition, ...
%    "double const * libm2k::analog::M2kAnalogIn::getSamplesInterleaved(unsigned int nb_samples_per_channel)", ...
%    "MATLABName", "getSamplesInterleaved", ...
%    "Description", "getSamplesInterleaved Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
%    "Retrieve a specific number of samples from each channel", ...
%    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
%defineArgument(getSamplesInterleavedDefinition, "nb_samples_per_channel", "uint32", "Description", "nb_samples_per_channel The number of samples that will be retrieved");
%defineOutput(getSamplesInterleavedDefinition, "RetVal", "clib.array.libm2k.Double", <SHAPE>, "Description", "A pointer to the interleaved samples"); % <MLTYPE> can be "clib.array.libm2k.Double", or "double"
%validate(getSamplesInterleavedDefinition);

%% C++ class method |getSamplesRawInterleaved| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: short const * libm2k::analog::M2kAnalogIn::getSamplesRawInterleaved(unsigned int nb_samples_per_channel)

%getSamplesRawInterleavedDefinition = addMethod(M2kAnalogInDefinition, ...
%    "short const * libm2k::analog::M2kAnalogIn::getSamplesRawInterleaved(unsigned int nb_samples_per_channel)", ...
%    "MATLABName", "getSamplesRawInterleaved", ...
%    "Description", "getSamplesRawInterleaved Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
%    "Retrieve a specific number of raw samples from each channel", ...
%    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
%defineArgument(getSamplesRawInterleavedDefinition, "nb_samples_per_channel", "uint32", "Description", "nb_samples_per_channel The number of samples that will be retrieved");
%defineOutput(getSamplesRawInterleavedDefinition, "RetVal", "clib.array.libm2k.Short", <SHAPE>, "Description", "A pointer to the interleaved raw samples"); % <MLTYPE> can be "clib.array.libm2k.Short", or "int16"
%validate(getSamplesRawInterleavedDefinition);

%% C++ class method |getSamplesInterleaved_matlab| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: double const * libm2k::analog::M2kAnalogIn::getSamplesInterleaved_matlab(unsigned int nb_samples)

getSamplesInterleaved_matlabDefinition = addMethod(M2kAnalogInDefinition, ...
   "double const * libm2k::analog::M2kAnalogIn::getSamplesInterleaved_matlab(unsigned int nb_samples)", ...
   "MATLABName", "getSamplesInterleaved_matlab", ...
   "Description", "getSamplesInterleaved_matlab Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
   "Retrieve a specific number of samples from both channels", ...
   "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getSamplesInterleaved_matlabDefinition, "nb_samples", "uint32", "Description", "nb_samples The number of samples that will be retrieved");
defineOutput(getSamplesInterleaved_matlabDefinition, "RetVal", "clib.array.libm2k.Double","nb_samples", "Description", "A pointer to the interleaved samples"); % <MLTYPE> can be "clib.array.libm2k.Double", or "double"
validate(getSamplesInterleaved_matlabDefinition);

%% C++ class method |getSamplesRawInterleaved_matlab| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: short const * libm2k::analog::M2kAnalogIn::getSamplesRawInterleaved_matlab(unsigned int nb_samples)

%getSamplesRawInterleaved_matlabDefinition = addMethod(M2kAnalogInDefinition, ...
%    "short const * libm2k::analog::M2kAnalogIn::getSamplesRawInterleaved_matlab(unsigned int nb_samples)", ...
%    "MATLABName", "getSamplesRawInterleaved_matlab", ...
%    "Description", "getSamplesRawInterleaved_matlab Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
%    "Retrieve a specific number of raw samples from both channels", ...
%    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
%defineArgument(getSamplesRawInterleaved_matlabDefinition, "nb_samples", "uint32", "Description", "nb_samples The number of samples that will be retrieved");
%defineOutput(getSamplesRawInterleaved_matlabDefinition, "RetVal", "clib.array.libm2k.Short", <SHAPE>, "Description", "A pointer to the interleaved raw samples"); % <MLTYPE> can be "clib.array.libm2k.Short", or "int16"
%validate(getSamplesRawInterleaved_matlabDefinition);

%% C++ class method |getVoltageRaw| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: short libm2k::analog::M2kAnalogIn::getVoltageRaw(unsigned int ch)

getVoltageRawDefinition = addMethod(M2kAnalogInDefinition, ...
    "short libm2k::analog::M2kAnalogIn::getVoltageRaw(unsigned int ch)", ...
    "MATLABName", "getVoltageRaw", ...
    "Description", "getVoltageRaw Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
    "Retrieve the average raw value of the given channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getVoltageRawDefinition, "ch", "uint32", "Description", "ch The index corresponding to the channel");
defineOutput(getVoltageRawDefinition, "RetVal", "int16", "Description", "The average raw value");
validate(getVoltageRawDefinition);

%% C++ class method |getVoltage| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: double libm2k::analog::M2kAnalogIn::getVoltage(unsigned int ch)

getVoltageDefinition = addMethod(M2kAnalogInDefinition, ...
    "double libm2k::analog::M2kAnalogIn::getVoltage(unsigned int ch)", ...
    "MATLABName", "getVoltage", ...
    "Description", "getVoltage Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
    "Retrieve the average voltage of the given channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getVoltageDefinition, "ch", "uint32", "Description", "ch The index corresponding to the channel");
defineOutput(getVoltageDefinition, "RetVal", "double", "Description", "The average voltage");
validate(getVoltageDefinition);

%% C++ class method |getVoltageRaw| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: short libm2k::analog::M2kAnalogIn::getVoltageRaw(libm2k::analog::ANALOG_IN_CHANNEL ch)

getVoltageRawDefinition = addMethod(M2kAnalogInDefinition, ...
    "short libm2k::analog::M2kAnalogIn::getVoltageRaw(libm2k::analog::ANALOG_IN_CHANNEL ch)", ...
    "MATLABName", "getVoltageRaw", ...
    "Description", "getVoltageRaw Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
    "Retrieve the average raw value of the given channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getVoltageRawDefinition, "ch", "clib.libm2k.libm2k.analog.ANALOG_IN_CHANNEL", "Description", "ch  An enumerator corresponding to the channel's index");
defineOutput(getVoltageRawDefinition, "RetVal", "int16", "Description", "The average raw value");
validate(getVoltageRawDefinition);

%% C++ class method |getVoltage| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: double libm2k::analog::M2kAnalogIn::getVoltage(libm2k::analog::ANALOG_IN_CHANNEL ch)

getVoltageDefinition = addMethod(M2kAnalogInDefinition, ...
    "double libm2k::analog::M2kAnalogIn::getVoltage(libm2k::analog::ANALOG_IN_CHANNEL ch)", ...
    "MATLABName", "getVoltage", ...
    "Description", "getVoltage Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
    "Retrieve the average voltage of the given channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getVoltageDefinition, "ch", "clib.libm2k.libm2k.analog.ANALOG_IN_CHANNEL", "Description", "ch An enumerator corresponding to the channel's index");
defineOutput(getVoltageDefinition, "RetVal", "double", "Description", "The average voltage");
validate(getVoltageDefinition);

%% C++ class method |getVoltageRaw| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: std::vector<short, std::allocator<short>> libm2k::analog::M2kAnalogIn::getVoltageRaw()

getVoltageRawDefinition = addMethod(M2kAnalogInDefinition, ...
    "std::vector<short, std::allocator<short>> libm2k::analog::M2kAnalogIn::getVoltageRaw()", ...
    "MATLABName", "getVoltageRaw", ...
    "Description", "getVoltageRaw Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
    "Retrieve the average raw value for each channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getVoltageRawDefinition, "RetVal", "clib.array.libm2k.Short", "Description", "A list containing the average raw value of each channel");
validate(getVoltageRawDefinition);

%% C++ class method |getVoltage| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: std::vector<double, std::allocator<double>> libm2k::analog::M2kAnalogIn::getVoltage()

getVoltageDefinition = addMethod(M2kAnalogInDefinition, ...
    "std::vector<double, std::allocator<double>> libm2k::analog::M2kAnalogIn::getVoltage()", ...
    "MATLABName", "getVoltage", ...
    "Description", "getVoltage Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
    "Retrieve the average voltage for each channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getVoltageDefinition, "RetVal", "clib.array.libm2k.Double", "Description", "A list containing the average voltage of each channel");
validate(getVoltageDefinition);

%% C++ class method |getVoltageRawP| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: short const * libm2k::analog::M2kAnalogIn::getVoltageRawP()

%getVoltageRawPDefinition = addMethod(M2kAnalogInDefinition, ...
%    "short const * libm2k::analog::M2kAnalogIn::getVoltageRawP()", ...
%    "MATLABName", "getVoltageRawP", ...
%    "Description", "getVoltageRawP Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
%    "Retrieve the average raw value for both channels", ...
%    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
%defineOutput(getVoltageRawPDefinition, "RetVal", "clib.array.libm2k.Short", <SHAPE>, "Description", "A pointer to the average raw value of both channels"); % <MLTYPE> can be "clib.array.libm2k.Short", or "int16"
%validate(getVoltageRawPDefinition);

%% C++ class method |getVoltageP| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: double const * libm2k::analog::M2kAnalogIn::getVoltageP()

%getVoltagePDefinition = addMethod(M2kAnalogInDefinition, ...
%    "double const * libm2k::analog::M2kAnalogIn::getVoltageP()", ...
%    "MATLABName", "getVoltageP", ...
%    "Description", "getVoltageP Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
%    "Retrieve the average voltage for both channels", ...
%    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
%defineOutput(getVoltagePDefinition, "RetVal", "clib.array.libm2k.Double", <SHAPE>, "Description", "A pointer to the average voltage of both channels"); % <MLTYPE> can be "clib.array.libm2k.Double", or "double"
%validate(getVoltagePDefinition);

%% C++ class method |setVerticalOffset| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: void libm2k::analog::M2kAnalogIn::setVerticalOffset(libm2k::analog::ANALOG_IN_CHANNEL channel,double vertOffset)

setVerticalOffsetDefinition = addMethod(M2kAnalogInDefinition, ...
    "void libm2k::analog::M2kAnalogIn::setVerticalOffset(libm2k::analog::ANALOG_IN_CHANNEL channel,double vertOffset)", ...
    "MATLABName", "setVerticalOffset", ...
    "Description", "setVerticalOffset Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
    "Set the vertical offset, in Volts, of a specific channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setVerticalOffsetDefinition, "channel", "clib.libm2k.libm2k.analog.ANALOG_IN_CHANNEL", "Description", "channel the index of the channel");
defineArgument(setVerticalOffsetDefinition, "vertOffset", "double", "Description", "vertOffset the value of the offset in Volts");
validate(setVerticalOffsetDefinition);

%% C++ class method |getVerticalOffset| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: double libm2k::analog::M2kAnalogIn::getVerticalOffset(libm2k::analog::ANALOG_IN_CHANNEL channel)

getVerticalOffsetDefinition = addMethod(M2kAnalogInDefinition, ...
    "double libm2k::analog::M2kAnalogIn::getVerticalOffset(libm2k::analog::ANALOG_IN_CHANNEL channel)", ...
    "MATLABName", "getVerticalOffset", ...
    "Description", "getVerticalOffset Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
    "getVerticalOffset", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getVerticalOffsetDefinition, "channel", "clib.libm2k.libm2k.analog.ANALOG_IN_CHANNEL", "Description", "channel the index of the channel");
defineOutput(getVerticalOffsetDefinition, "RetVal", "double", "Description", "the value of the offset in Volts");
validate(getVerticalOffsetDefinition);

%% C++ class method |getScalingFactor| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: double libm2k::analog::M2kAnalogIn::getScalingFactor(libm2k::analog::ANALOG_IN_CHANNEL ch)

getScalingFactorDefinition = addMethod(M2kAnalogInDefinition, ...
    "double libm2k::analog::M2kAnalogIn::getScalingFactor(libm2k::analog::ANALOG_IN_CHANNEL ch)", ...
    "MATLABName", "getScalingFactor", ...
    "Description", "getScalingFactor Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
    "Retrieve the scaling factor", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getScalingFactorDefinition, "ch", "clib.libm2k.libm2k.analog.ANALOG_IN_CHANNEL", "Description", "ch An enumerator corresponding to the channel's index");
defineOutput(getScalingFactorDefinition, "RetVal", "double", "Description", "The value of the scaling factor");
validate(getScalingFactorDefinition);

%% C++ class method |setRange| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: void libm2k::analog::M2kAnalogIn::setRange(libm2k::analog::ANALOG_IN_CHANNEL channel,libm2k::analog::M2K_RANGE range)

setRangeDefinition = addMethod(M2kAnalogInDefinition, ...
    "void libm2k::analog::M2kAnalogIn::setRange(libm2k::analog::ANALOG_IN_CHANNEL channel,libm2k::analog::M2K_RANGE range)", ...
    "MATLABName", "setRange", ...
    "Description", "setRange Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
    "Set the range for the given channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setRangeDefinition, "channel", "clib.libm2k.libm2k.analog.ANALOG_IN_CHANNEL", "Description", "channel An enumerator corresponding to the channel's index");
defineArgument(setRangeDefinition, "range", "clib.libm2k.libm2k.analog.M2K_RANGE", "Description", "range  An enumerator corresponding to a range");
validate(setRangeDefinition);

%% C++ class method |setRange| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: void libm2k::analog::M2kAnalogIn::setRange(libm2k::analog::ANALOG_IN_CHANNEL channel,double min,double max)

setRangeDefinition = addMethod(M2kAnalogInDefinition, ...
    "void libm2k::analog::M2kAnalogIn::setRange(libm2k::analog::ANALOG_IN_CHANNEL channel,double min,double max)", ...
    "MATLABName", "setRange", ...
    "Description", "setRange Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
    "Set the range for the given channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setRangeDefinition, "channel", "clib.libm2k.libm2k.analog.ANALOG_IN_CHANNEL", "Description", "channel An enumerator corresponding to the channel's index");
defineArgument(setRangeDefinition, "min", "double", "Description", "min Upper bound");
defineArgument(setRangeDefinition, "max", "double", "Description", "max Lower bound");
validate(setRangeDefinition);

%% C++ class method |getRange| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: libm2k::analog::M2K_RANGE libm2k::analog::M2kAnalogIn::getRange(libm2k::analog::ANALOG_IN_CHANNEL channel)

getRangeDefinition = addMethod(M2kAnalogInDefinition, ...
    "libm2k::analog::M2K_RANGE libm2k::analog::M2kAnalogIn::getRange(libm2k::analog::ANALOG_IN_CHANNEL channel)", ...
    "MATLABName", "getRange", ...
    "Description", "getRange Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
    "Retrieve the range for the given channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getRangeDefinition, "channel", "clib.libm2k.libm2k.analog.ANALOG_IN_CHANNEL", "Description", "channel An enumerator corresponding to the channel's index");
defineOutput(getRangeDefinition, "RetVal", "clib.libm2k.libm2k.analog.M2K_RANGE", "Description", "An enumerator corresponding to the range");
validate(getRangeDefinition);

%% C++ class method |getOversamplingRatio| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: int libm2k::analog::M2kAnalogIn::getOversamplingRatio()

getOversamplingRatioDefinition = addMethod(M2kAnalogInDefinition, ...
    "int libm2k::analog::M2kAnalogIn::getOversamplingRatio()", ...
    "MATLABName", "getOversamplingRatio", ...
    "Description", "getOversamplingRatio Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
    "Retrieve the global oversampling ratio", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getOversamplingRatioDefinition, "RetVal", "int32", "Description", "The value of the global ratio");
validate(getOversamplingRatioDefinition);

%% C++ class method |getOversamplingRatio| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: int libm2k::analog::M2kAnalogIn::getOversamplingRatio(unsigned int chn_idx)

getOversamplingRatioDefinition = addMethod(M2kAnalogInDefinition, ...
    "int libm2k::analog::M2kAnalogIn::getOversamplingRatio(unsigned int chn_idx)", ...
    "MATLABName", "getOversamplingRatio", ...
    "Description", "getOversamplingRatio Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
    "Retrieve the oversampling ratio for the given channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getOversamplingRatioDefinition, "chn_idx", "uint32", "Description", "chn_idx The index corresponding to the channel");
defineOutput(getOversamplingRatioDefinition, "RetVal", "int32", "Description", "The ratio value");
validate(getOversamplingRatioDefinition);

%% C++ class method |setOversamplingRatio| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: int libm2k::analog::M2kAnalogIn::setOversamplingRatio(int oversampling)

setOversamplingRatioDefinition = addMethod(M2kAnalogInDefinition, ...
    "int libm2k::analog::M2kAnalogIn::setOversamplingRatio(int oversampling)", ...
    "MATLABName", "setOversamplingRatio", ...
    "Description", "setOversamplingRatio Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
    "Set the global oversampling ratio", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setOversamplingRatioDefinition, "oversampling", "int32", "Description", "oversampling Integer value to set the oversampling ratio to");
defineOutput(setOversamplingRatioDefinition, "RetVal", "int32", "Description", "The current value of the global ratio");
validate(setOversamplingRatioDefinition);

%% C++ class method |setOversamplingRatio| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: int libm2k::analog::M2kAnalogIn::setOversamplingRatio(unsigned int chn_idx,int oversampling)

setOversamplingRatioDefinition = addMethod(M2kAnalogInDefinition, ...
    "int libm2k::analog::M2kAnalogIn::setOversamplingRatio(unsigned int chn_idx,int oversampling)", ...
    "MATLABName", "setOversamplingRatio", ...
    "Description", "setOversamplingRatio Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
    "Set the oversampling ratio for the given channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setOversamplingRatioDefinition, "chn_idx", "uint32", "Description", "chn_idx The index corresponding to the channel");
defineArgument(setOversamplingRatioDefinition, "oversampling", "int32", "Description", "oversampling Integer value to set the oversampling ratio to");
defineOutput(setOversamplingRatioDefinition, "RetVal", "int32", "Description", "The current ratio value");
validate(setOversamplingRatioDefinition);

%% C++ class method |getSampleRate| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: double libm2k::analog::M2kAnalogIn::getSampleRate()

getSampleRateDefinition = addMethod(M2kAnalogInDefinition, ...
    "double libm2k::analog::M2kAnalogIn::getSampleRate()", ...
    "MATLABName", "getSampleRate", ...
    "Description", "getSampleRate Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
    "Retrieve the global sample rate", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getSampleRateDefinition, "RetVal", "double", "Description", "The value of the sample rate");
validate(getSampleRateDefinition);

%% C++ class method |getAvailableSampleRates| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: std::vector<double, std::allocator<double>> libm2k::analog::M2kAnalogIn::getAvailableSampleRates()

getAvailableSampleRatesDefinition = addMethod(M2kAnalogInDefinition, ...
    "std::vector<double, std::allocator<double>> libm2k::analog::M2kAnalogIn::getAvailableSampleRates()", ...
    "MATLABName", "getAvailableSampleRates", ...
    "Description", "getAvailableSampleRates Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
    "getAvailableSampleRates", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getAvailableSampleRatesDefinition, "RetVal", "clib.array.libm2k.Double", "Description", "The list of available samplerates for this device");
validate(getAvailableSampleRatesDefinition);

%% C++ class method |setSampleRate| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: double libm2k::analog::M2kAnalogIn::setSampleRate(double samplerate)

setSampleRateDefinition = addMethod(M2kAnalogInDefinition, ...
    "double libm2k::analog::M2kAnalogIn::setSampleRate(double samplerate)", ...
    "MATLABName", "setSampleRate", ...
    "Description", "setSampleRate Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
    "Set the global sample rate", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setSampleRateDefinition, "samplerate", "double", "Description", "samplerate A double value to set the sample rate to");
defineOutput(setSampleRateDefinition, "RetVal", "double", "Description", "The value of the global sample rate");
validate(setSampleRateDefinition);

%% C++ class method |getFilterCompensation| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: double libm2k::analog::M2kAnalogIn::getFilterCompensation(double samplerate)

getFilterCompensationDefinition = addMethod(M2kAnalogInDefinition, ...
    "double libm2k::analog::M2kAnalogIn::getFilterCompensation(double samplerate)", ...
    "MATLABName", "getFilterCompensation", ...
    "Description", "getFilterCompensation Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
    "Retrieve the filter compensation for the given sample rate", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getFilterCompensationDefinition, "samplerate", "double", "Description", "samplerate A double value representing the sample rate");
defineOutput(getFilterCompensationDefinition, "RetVal", "double", "Description", "The value of the filter compensation");
validate(getFilterCompensationDefinition);

%% C++ class method |getValueForRange| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: double libm2k::analog::M2kAnalogIn::getValueForRange(libm2k::analog::M2K_RANGE range)

getValueForRangeDefinition = addMethod(M2kAnalogInDefinition, ...
    "double libm2k::analog::M2kAnalogIn::getValueForRange(libm2k::analog::M2K_RANGE range)", ...
    "MATLABName", "getValueForRange", ...
    "Description", "getValueForRange Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
    "Retrieve the numeric value corresponding to the given range", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getValueForRangeDefinition, "range", "clib.libm2k.libm2k.analog.M2K_RANGE", "Description", "range");
defineOutput(getValueForRangeDefinition, "RetVal", "double", "Description", "double");
validate(getValueForRangeDefinition);

%% C++ class method |convertRawToVolts| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: double libm2k::analog::M2kAnalogIn::convertRawToVolts(unsigned int channel,short raw)

convertRawToVoltsDefinition = addMethod(M2kAnalogInDefinition, ...
    "double libm2k::analog::M2kAnalogIn::convertRawToVolts(unsigned int channel,short raw)", ...
    "MATLABName", "convertRawToVolts", ...
    "Description", "convertRawToVolts Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
    "Convert the raw value of a sample into volts", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(convertRawToVoltsDefinition, "channel", "uint32", "Description", "raw: the raw value of a sample;");
defineArgument(convertRawToVoltsDefinition, "raw", "int16", "Description", "channel: The index corresponding to the channel;");
defineOutput(convertRawToVoltsDefinition, "RetVal", "double", "Description", "The value of a sample converted into volts;");
validate(convertRawToVoltsDefinition);

%% C++ class method |convertVoltsToRaw| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: short libm2k::analog::M2kAnalogIn::convertVoltsToRaw(unsigned int channel,double voltage)

convertVoltsToRawDefinition = addMethod(M2kAnalogInDefinition, ...
    "short libm2k::analog::M2kAnalogIn::convertVoltsToRaw(unsigned int channel,double voltage)", ...
    "MATLABName", "convertVoltsToRaw", ...
    "Description", "convertVoltsToRaw Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
    "Convert the voltage value of a sample into raw", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(convertVoltsToRawDefinition, "channel", "uint32", "Description", "voltage The voltage value of a sample;");
defineArgument(convertVoltsToRawDefinition, "voltage", "double", "Description", "channel The index corresponding to the channel;");
defineOutput(convertVoltsToRawDefinition, "RetVal", "int16", "Description", "The value of a sample converted into raw;");
validate(convertVoltsToRawDefinition);

%% C++ class method |getNbChannels| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: unsigned int libm2k::analog::M2kAnalogIn::getNbChannels()

getNbChannelsDefinition = addMethod(M2kAnalogInDefinition, ...
    "unsigned int libm2k::analog::M2kAnalogIn::getNbChannels()", ...
    "MATLABName", "getNbChannels", ...
    "Description", "getNbChannels Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
    "Retrieve the number of analogical channels", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getNbChannelsDefinition, "RetVal", "uint32", "Description", "The number of channels");
validate(getNbChannelsDefinition);

%% C++ class method |getName| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: std::string libm2k::analog::M2kAnalogIn::getName()

getNameDefinition = addMethod(M2kAnalogInDefinition, ...
    "std::string libm2k::analog::M2kAnalogIn::getName()", ...
    "MATLABName", "getName", ...
    "Description", "getName Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
    "Retrieve the name of the device", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getNameDefinition, "RetVal", "string", "Description", "The name of the device");
validate(getNameDefinition);

%% C++ class method |enableChannel| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: void libm2k::analog::M2kAnalogIn::enableChannel(unsigned int chnIdx,bool enable)

enableChannelDefinition = addMethod(M2kAnalogInDefinition, ...
    "void libm2k::analog::M2kAnalogIn::enableChannel(unsigned int chnIdx,bool enable)", ...
    "MATLABName", "enableChannel", ...
    "Description", "enableChannel Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
    "Enable or disable the given channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(enableChannelDefinition, "chnIdx", "uint32", "Description", "chnIdx The index corresponding to the channel");
defineArgument(enableChannelDefinition, "enable", "logical", "Description", "enable A boolean value corresponding to the channel's state");
validate(enableChannelDefinition);

%% C++ class method |isChannelEnabled| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: bool libm2k::analog::M2kAnalogIn::isChannelEnabled(unsigned int chnIdx)

isChannelEnabledDefinition = addMethod(M2kAnalogInDefinition, ...
    "bool libm2k::analog::M2kAnalogIn::isChannelEnabled(unsigned int chnIdx)", ...
    "MATLABName", "isChannelEnabled", ...
    "Description", "isChannelEnabled Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
    "Retrieve the state of the given channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(isChannelEnabledDefinition, "chnIdx", "uint32", "Description", "chnIdx The index corresponding to the channel");
defineOutput(isChannelEnabledDefinition, "RetVal", "logical", "Description", "True if the channel is enabled");
validate(isChannelEnabledDefinition);

%% C++ class method |cancelAcquisition| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: void libm2k::analog::M2kAnalogIn::cancelAcquisition()

cancelAcquisitionDefinition = addMethod(M2kAnalogInDefinition, ...
    "void libm2k::analog::M2kAnalogIn::cancelAcquisition()", ...
    "MATLABName", "cancelAcquisition", ...
    "Description", "cancelAcquisition Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
    "Cancel all buffer operations" + newline + ...
    "	@note Should be used to cancel an ongoing acquisition", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@brief Cancel all buffer operations" + newline + ...
    "	@note Should be used to cancel an ongoing acquisition"); % Modify help description values as needed.
validate(cancelAcquisitionDefinition);

%% C++ class method |setKernelBuffersCount| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: void libm2k::analog::M2kAnalogIn::setKernelBuffersCount(unsigned int count)

setKernelBuffersCountDefinition = addMethod(M2kAnalogInDefinition, ...
    "void libm2k::analog::M2kAnalogIn::setKernelBuffersCount(unsigned int count)", ...
    "MATLABName", "setKernelBuffersCount", ...
    "Description", "setKernelBuffersCount Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
    "Set the kernel buffers to a specific value", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setKernelBuffersCountDefinition, "count", "uint32", "Description", "count the number of kernel buffers");
validate(setKernelBuffersCountDefinition);

%% C++ class method |getKernelBuffersCount| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: unsigned int libm2k::analog::M2kAnalogIn::getKernelBuffersCount() const

getKernelBuffersCountDefinition = addMethod(M2kAnalogInDefinition, ...
    "unsigned int libm2k::analog::M2kAnalogIn::getKernelBuffersCount() const", ...
    "MATLABName", "getKernelBuffersCount", ...
    "Description", "getKernelBuffersCount Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
    "Get the number of kernel buffers", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getKernelBuffersCountDefinition, "RetVal", "uint32", "Description", "the number of previously set kernel buffers (saved in this session)");
validate(getKernelBuffersCountDefinition);

%% C++ class method |getTrigger| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: libm2k::M2kHardwareTrigger * libm2k::analog::M2kAnalogIn::getTrigger()

getTriggerDefinition = addMethod(M2kAnalogInDefinition, ...
   "libm2k::M2kHardwareTrigger * libm2k::analog::M2kAnalogIn::getTrigger()", ...
   "MATLABName", "getTrigger", ...
   "Description", "getTrigger Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
   "Get the hardware trigger handler", ...
   "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getTriggerDefinition, "RetVal", "clib.libm2k.libm2k.M2kHardwareTrigger", 1, "Description", "A pointer to the hardware trigger trigger");
validate(getTriggerDefinition);

%% C++ class method |getIioObjects| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: libm2k::IIO_OBJECTS libm2k::analog::M2kAnalogIn::getIioObjects()

getIioObjectsDefinition = addMethod(M2kAnalogInDefinition, ...
    "libm2k::IIO_OBJECTS libm2k::analog::M2kAnalogIn::getIioObjects()", ...
    "MATLABName", "getIioObjects", ...
    "Description", "getIioObjects Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
    "Get access to IIO channels, buffers, devices and context." + newline + ...
    "	 Can be used when debugging directly with libiio.", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getIioObjectsDefinition, "RetVal", "clib.libm2k.libm2k.IIO_OBJECTS", "Description", "IIO_OBJECTS structure.");
validate(getIioObjectsDefinition);

%% C++ class method |getChannelName| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: std::string libm2k::analog::M2kAnalogIn::getChannelName(unsigned int channel)

getChannelNameDefinition = addMethod(M2kAnalogInDefinition, ...
    "std::string libm2k::analog::M2kAnalogIn::getChannelName(unsigned int channel)", ...
    "MATLABName", "getChannelName", ...
    "Description", "getChannelName Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
    "Get the channel name for each ADC channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getChannelNameDefinition, "channel", "uint32", "Description", "channel - unsigned int representing the index of the channel");
defineOutput(getChannelNameDefinition, "RetVal", "string", "Description", "std::string - name of the channel");
validate(getChannelNameDefinition);

%% C++ class method |getMaximumSamplerate| for C++ class |libm2k::analog::M2kAnalogIn| 
% C++ Signature: double libm2k::analog::M2kAnalogIn::getMaximumSamplerate()

getMaximumSamplerateDefinition = addMethod(M2kAnalogInDefinition, ...
    "double libm2k::analog::M2kAnalogIn::getMaximumSamplerate()", ...
    "MATLABName", "getMaximumSamplerate", ...
    "Description", "getMaximumSamplerate Method of C++ class libm2k::analog::M2kAnalogIn." + newline + ...
    "Get the maximum samplerate for the ADC", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getMaximumSamplerateDefinition, "RetVal", "double", "Description", "double - the value of the maximum samplerate");
validate(getMaximumSamplerateDefinition);

%% C++ enumeration |libm2k::analog::ANALOG_IN_CHANNEL| with MATLAB name |clib.libm2k.libm2k.analog.ANALOG_IN_CHANNEL| 
addEnumeration(libDef, "libm2k::analog::ANALOG_IN_CHANNEL", "int32",...
    [...
      "ANALOG_IN_CHANNEL_1",...  % 0
      "ANALOG_IN_CHANNEL_2",...  % 1
    ],...
    "MATLABName", "clib.libm2k.libm2k.analog.ANALOG_IN_CHANNEL", ...
    "Description", "clib.libm2k.libm2k.analog.ANALOG_IN_CHANNEL    Representation of C++ enumeration libm2k::analog::ANALOG_IN_CHANNEL." + newline + ...
    "Indexes of the channels", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@note Each channel can be accessed through its index"); % Modify help description values as needed.

%% C++ enumeration |libm2k::analog::M2K_RANGE| with MATLAB name |clib.libm2k.libm2k.analog.M2K_RANGE| 
addEnumeration(libDef, "libm2k::analog::M2K_RANGE", "int32",...
    [...
      "PLUS_MINUS_25V",...  % 0
      "PLUS_MINUS_2_5V",...  % 1
    ],...
    "MATLABName", "clib.libm2k.libm2k.analog.M2K_RANGE", ...
    "Description", "clib.libm2k.libm2k.analog.M2K_RANGE    Representation of C++ enumeration libm2k::analog::M2K_RANGE." + newline + ...
    "Range of the signal's amplitude", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.

%% C++ class |libm2k::analog::M2kAnalogOut| with MATLAB name |clib.libm2k.libm2k.analog.M2kAnalogOut| 
M2kAnalogOutDefinition = addClass(libDef, "libm2k::analog::M2kAnalogOut", "MATLABName", "clib.libm2k.libm2k.analog.M2kAnalogOut", ...
    "Description", "clib.libm2k.libm2k.analog.M2kAnalogOut    Representation of C++ class libm2k::analog::M2kAnalogOut." + newline + ...
    "Contains the representation of the analogical output segment" + newline + ...
    "" + newline + ...
    "@class M2kAnalogOut m2kanalogout.hpp libm2k/analog/m2kanalogout.hpp" + newline + ...
    "@brief Controls the analogical output compound", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@defgroup analogout AnalogOut" + newline + ...
    "@brief Contains the representation of the analogical output segment" + newline + ...
    "" + newline + ...
    "@class M2kAnalogOut m2kanalogout.hpp libm2k/analog/m2kanalogout.hpp" + newline + ...
    "@brief Controls the analogical output compound"); % Modify help description values as needed.

%% C++ class method |reset| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: void libm2k::analog::M2kAnalogOut::reset()

resetDefinition = addMethod(M2kAnalogOutDefinition, ...
    "void libm2k::analog::M2kAnalogOut::reset()", ...
    "MATLABName", "reset", ...
    "Description", "reset Method of C++ class libm2k::analog::M2kAnalogOut.", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@private"); % Modify help description values as needed.
validate(resetDefinition);

%% C++ class method |getOversamplingRatio| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: std::vector<int, std::allocator<int>> libm2k::analog::M2kAnalogOut::getOversamplingRatio()

getOversamplingRatioDefinition = addMethod(M2kAnalogOutDefinition, ...
    "std::vector<int, std::allocator<int>> libm2k::analog::M2kAnalogOut::getOversamplingRatio()", ...
    "MATLABName", "getOversamplingRatio", ...
    "Description", "getOversamplingRatio Method of C++ class libm2k::analog::M2kAnalogOut." + newline + ...
    "Retrieve the global oversampling ratio", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getOversamplingRatioDefinition, "RetVal", "clib.array.libm2k.Int", "Description", "The value of the global oversampling ratio");
validate(getOversamplingRatioDefinition);

%% C++ class method |getOversamplingRatio| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: int libm2k::analog::M2kAnalogOut::getOversamplingRatio(unsigned int chn)

getOversamplingRatioDefinition = addMethod(M2kAnalogOutDefinition, ...
    "int libm2k::analog::M2kAnalogOut::getOversamplingRatio(unsigned int chn)", ...
    "MATLABName", "getOversamplingRatio", ...
    "Description", "getOversamplingRatio Method of C++ class libm2k::analog::M2kAnalogOut." + newline + ...
    "Retrieve the oversampling ratio for the given channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getOversamplingRatioDefinition, "chn", "uint32", "Description", "chn The index corresponding to the channel");
defineOutput(getOversamplingRatioDefinition, "RetVal", "int32", "Description", "The oversampling ratio value");
validate(getOversamplingRatioDefinition);

%% C++ class method |setOversamplingRatio| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: std::vector<int, std::allocator<int>> libm2k::analog::M2kAnalogOut::setOversamplingRatio(std::vector<int, std::allocator<int>> oversampling_ratio)

setOversamplingRatioDefinition = addMethod(M2kAnalogOutDefinition, ...
    "std::vector<int, std::allocator<int>> libm2k::analog::M2kAnalogOut::setOversamplingRatio(std::vector<int, std::allocator<int>> oversampling_ratio)", ...
    "MATLABName", "setOversamplingRatio", ...
    "Description", "setOversamplingRatio Method of C++ class libm2k::analog::M2kAnalogOut." + newline + ...
    "Set the value of the oversampling ratio for each channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setOversamplingRatioDefinition, "oversampling_ratio", "clib.array.libm2k.Int", "Description", "oversampling_ratio A list containing the ratios for each channel (as integers)");
defineOutput(setOversamplingRatioDefinition, "RetVal", "clib.array.libm2k.Int", "Description", "A list containing the oversampling ratio value for each channel");
validate(setOversamplingRatioDefinition);

%% C++ class method |setOversamplingRatio| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: int libm2k::analog::M2kAnalogOut::setOversamplingRatio(unsigned int chn,int oversampling_ratio)

setOversamplingRatioDefinition = addMethod(M2kAnalogOutDefinition, ...
    "int libm2k::analog::M2kAnalogOut::setOversamplingRatio(unsigned int chn,int oversampling_ratio)", ...
    "MATLABName", "setOversamplingRatio", ...
    "Description", "setOversamplingRatio Method of C++ class libm2k::analog::M2kAnalogOut." + newline + ...
    "Set the oversampling ratio for the given channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setOversamplingRatioDefinition, "chn", "uint32", "Description", "chn The index corresponding to the channel");
defineArgument(setOversamplingRatioDefinition, "oversampling_ratio", "int32", "Description", "oversampling_ratio Integer value to set the oversampling ratio to");
defineOutput(setOversamplingRatioDefinition, "RetVal", "int32", "Description", "The current oversampling ratio value");
validate(setOversamplingRatioDefinition);

%% C++ class method |getSampleRate| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: std::vector<double, std::allocator<double>> libm2k::analog::M2kAnalogOut::getSampleRate()

getSampleRateDefinition = addMethod(M2kAnalogOutDefinition, ...
    "std::vector<double, std::allocator<double>> libm2k::analog::M2kAnalogOut::getSampleRate()", ...
    "MATLABName", "getSampleRate", ...
    "Description", "getSampleRate Method of C++ class libm2k::analog::M2kAnalogOut." + newline + ...
    "Retrieve the sample rate of both DACs", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getSampleRateDefinition, "RetVal", "clib.array.libm2k.Double", "Description", "A list containing the sample rates");
validate(getSampleRateDefinition);

%% C++ class method |getSampleRate| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: double libm2k::analog::M2kAnalogOut::getSampleRate(unsigned int chn)

getSampleRateDefinition = addMethod(M2kAnalogOutDefinition, ...
    "double libm2k::analog::M2kAnalogOut::getSampleRate(unsigned int chn)", ...
    "MATLABName", "getSampleRate", ...
    "Description", "getSampleRate Method of C++ class libm2k::analog::M2kAnalogOut." + newline + ...
    "Retrieve the sample rate for the given channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getSampleRateDefinition, "chn", "uint32", "Description", "chn The index corresponding to the channel");
defineOutput(getSampleRateDefinition, "RetVal", "double", "Description", "The value of the sample rate");
validate(getSampleRateDefinition);

%% C++ class method |getAvailableSampleRates| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: std::vector<double, std::allocator<double>> libm2k::analog::M2kAnalogOut::getAvailableSampleRates(unsigned int chn)

getAvailableSampleRatesDefinition = addMethod(M2kAnalogOutDefinition, ...
    "std::vector<double, std::allocator<double>> libm2k::analog::M2kAnalogOut::getAvailableSampleRates(unsigned int chn)", ...
    "MATLABName", "getAvailableSampleRates", ...
    "Description", "getAvailableSampleRates Method of C++ class libm2k::analog::M2kAnalogOut." + newline + ...
    "getAvailableSampleRates", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getAvailableSampleRatesDefinition, "chn", "uint32", "Description", "chn The index corresponding to the required channel");
defineOutput(getAvailableSampleRatesDefinition, "RetVal", "clib.array.libm2k.Double", "Description", "The list of available samplerates for this device");
validate(getAvailableSampleRatesDefinition);

%% C++ class method |setSampleRate| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: std::vector<double, std::allocator<double>> libm2k::analog::M2kAnalogOut::setSampleRate(std::vector<double, std::allocator<double>> samplerates)

setSampleRateDefinition = addMethod(M2kAnalogOutDefinition, ...
    "std::vector<double, std::allocator<double>> libm2k::analog::M2kAnalogOut::setSampleRate(std::vector<double, std::allocator<double>> samplerates)", ...
    "MATLABName", "setSampleRate", ...
    "Description", "setSampleRate Method of C++ class libm2k::analog::M2kAnalogOut." + newline + ...
    "Set the sample rate for both channels", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setSampleRateDefinition, "samplerates", "clib.array.libm2k.Double", "Description", "samplerates A list containing the sample rates of each channel");
defineOutput(setSampleRateDefinition, "RetVal", "clib.array.libm2k.Double", "Description", "A list containing the previously set sample rates");
validate(setSampleRateDefinition);

%% C++ class method |setSampleRate| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: double libm2k::analog::M2kAnalogOut::setSampleRate(unsigned int chn,double samplerate)

setSampleRateDefinition = addMethod(M2kAnalogOutDefinition, ...
    "double libm2k::analog::M2kAnalogOut::setSampleRate(unsigned int chn,double samplerate)", ...
    "MATLABName", "setSampleRate", ...
    "Description", "setSampleRate Method of C++ class libm2k::analog::M2kAnalogOut." + newline + ...
    "Set the sample rate for the given channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setSampleRateDefinition, "chn", "uint32", "Description", "chn The index corresponding to the channel");
defineArgument(setSampleRateDefinition, "samplerate", "double", "Description", "samplerate A double value to set the sample rate to");
defineOutput(setSampleRateDefinition, "RetVal", "double", "Description", "The value of the sample rate");
validate(setSampleRateDefinition);

%% C++ class method |setSyncedDma| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: void libm2k::analog::M2kAnalogOut::setSyncedDma(bool en,int chn = -1)

setSyncedDmaDefinition = addMethod(M2kAnalogOutDefinition, ...
    "void libm2k::analog::M2kAnalogOut::setSyncedDma(bool en,int chn = -1)", ...
    "MATLABName", "setSyncedDma", ...
    "Description", "setSyncedDma Method of C++ class libm2k::analog::M2kAnalogOut.", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@private"); % Modify help description values as needed.
defineArgument(setSyncedDmaDefinition, "en", "logical");
defineArgument(setSyncedDmaDefinition, "chn", "int32");
validate(setSyncedDmaDefinition);

%% C++ class method |getSyncedDma| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: bool libm2k::analog::M2kAnalogOut::getSyncedDma(int chn = -1)

getSyncedDmaDefinition = addMethod(M2kAnalogOutDefinition, ...
    "bool libm2k::analog::M2kAnalogOut::getSyncedDma(int chn = -1)", ...
    "MATLABName", "getSyncedDma", ...
    "Description", "getSyncedDma Method of C++ class libm2k::analog::M2kAnalogOut.", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@private"); % Modify help description values as needed.
defineArgument(getSyncedDmaDefinition, "chn", "int32");
defineOutput(getSyncedDmaDefinition, "RetVal", "logical");
validate(getSyncedDmaDefinition);

%% C++ class method |setSyncedStartDma| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: void libm2k::analog::M2kAnalogOut::setSyncedStartDma(bool en,int chn = -1)

setSyncedStartDmaDefinition = addMethod(M2kAnalogOutDefinition, ...
    "void libm2k::analog::M2kAnalogOut::setSyncedStartDma(bool en,int chn = -1)", ...
    "MATLABName", "setSyncedStartDma", ...
    "Description", "setSyncedStartDma Method of C++ class libm2k::analog::M2kAnalogOut.", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@private"); % Modify help description values as needed.
defineArgument(setSyncedStartDmaDefinition, "en", "logical");
defineArgument(setSyncedStartDmaDefinition, "chn", "int32");
validate(setSyncedStartDmaDefinition);

%% C++ class method |getSyncedStartDma| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: bool libm2k::analog::M2kAnalogOut::getSyncedStartDma(int chn = -1)

getSyncedStartDmaDefinition = addMethod(M2kAnalogOutDefinition, ...
    "bool libm2k::analog::M2kAnalogOut::getSyncedStartDma(int chn = -1)", ...
    "MATLABName", "getSyncedStartDma", ...
    "Description", "getSyncedStartDma Method of C++ class libm2k::analog::M2kAnalogOut.", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@private"); % Modify help description values as needed.
defineArgument(getSyncedStartDmaDefinition, "chn", "int32");
defineOutput(getSyncedStartDmaDefinition, "RetVal", "logical");
validate(getSyncedStartDmaDefinition);

%% C++ class method |setCyclic| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: void libm2k::analog::M2kAnalogOut::setCyclic(bool en)

setCyclicDefinition = addMethod(M2kAnalogOutDefinition, ...
    "void libm2k::analog::M2kAnalogOut::setCyclic(bool en)", ...
    "MATLABName", "setCyclic", ...
    "Description", "setCyclic Method of C++ class libm2k::analog::M2kAnalogOut." + newline + ...
    "Enable or disable the cyclic mode for all digital channels", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setCyclicDefinition, "en", "logical", "Description", "en If true, enable cyclic mode");
validate(setCyclicDefinition);

%% C++ class method |setCyclic| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: void libm2k::analog::M2kAnalogOut::setCyclic(unsigned int chn,bool en)

setCyclicDefinition = addMethod(M2kAnalogOutDefinition, ...
    "void libm2k::analog::M2kAnalogOut::setCyclic(unsigned int chn,bool en)", ...
    "MATLABName", "setCyclic", ...
    "Description", "setCyclic Method of C++ class libm2k::analog::M2kAnalogOut." + newline + ...
    "Enable or disable the cyclic mode for all digital channels", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setCyclicDefinition, "chn", "uint32", "Description", "chn The index corresponding to the channel");
defineArgument(setCyclicDefinition, "en", "logical", "Description", "en If true, enable cyclic mode");
validate(setCyclicDefinition);

%% C++ class method |getCyclic| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: bool libm2k::analog::M2kAnalogOut::getCyclic(unsigned int chn)

getCyclicDefinition = addMethod(M2kAnalogOutDefinition, ...
    "bool libm2k::analog::M2kAnalogOut::getCyclic(unsigned int chn)", ...
    "MATLABName", "getCyclic", ...
    "Description", "getCyclic Method of C++ class libm2k::analog::M2kAnalogOut." + newline + ...
    "Retrieve the value of the cyclic mode", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getCyclicDefinition, "chn", "uint32", "Description", "chn The index corresponding to the channel");
defineOutput(getCyclicDefinition, "RetVal", "logical", "Description", "A boolean value corresponding to the state of the cyclic mode");
validate(getCyclicDefinition);

%% C++ class method |getScalingFactor| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: double libm2k::analog::M2kAnalogOut::getScalingFactor(unsigned int chn)

getScalingFactorDefinition = addMethod(M2kAnalogOutDefinition, ...
    "double libm2k::analog::M2kAnalogOut::getScalingFactor(unsigned int chn)", ...
    "MATLABName", "getScalingFactor", ...
    "Description", "getScalingFactor Method of C++ class libm2k::analog::M2kAnalogOut." + newline + ...
    "Retrieve the scaling factor for the given channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getScalingFactorDefinition, "chn", "uint32", "Description", "chn The index corresponding to the channel");
defineOutput(getScalingFactorDefinition, "RetVal", "double", "Description", "The value of the scaling factor");
validate(getScalingFactorDefinition);

%% C++ class method |getFilterCompensation| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: double libm2k::analog::M2kAnalogOut::getFilterCompensation(double samplerate)

getFilterCompensationDefinition = addMethod(M2kAnalogOutDefinition, ...
    "double libm2k::analog::M2kAnalogOut::getFilterCompensation(double samplerate)", ...
    "MATLABName", "getFilterCompensation", ...
    "Description", "getFilterCompensation Method of C++ class libm2k::analog::M2kAnalogOut." + newline + ...
    "Retrieve the filter compensation for the given sample rate", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getFilterCompensationDefinition, "samplerate", "double", "Description", "samplerate A double value representing the sample rate");
defineOutput(getFilterCompensationDefinition, "RetVal", "double", "Description", "The value of the filter compensation");
validate(getFilterCompensationDefinition);

%% C++ class method |pushBytes| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: void libm2k::analog::M2kAnalogOut::pushBytes(unsigned int chnIdx,double * data,unsigned int nb_samples)

pushBytesDefinition = addMethod(M2kAnalogOutDefinition, ...
   "void libm2k::analog::M2kAnalogOut::pushBytes(unsigned int chnIdx,double * data,unsigned int nb_samples)", ...
   "MATLABName", "pushBytes", ...
   "Description", "pushBytes Method of C++ class libm2k::analog::M2kAnalogOut." + newline + ...
   "Send the samples to the given channel", ...
   "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(pushBytesDefinition, "chnIdx", "uint32", "Description", "chnIdx The index corresponding to the channel");
defineArgument(pushBytesDefinition, "data", "clib.array.libm2k.Double", "input", "nb_samples", "Description", "data A pointer to the samples"); % <MLTYPE> can be "clib.array.libm2k.Double", or "double"
defineArgument(pushBytesDefinition, "nb_samples", "uint32", "Description", "nb_samples the number of samples");
validate(pushBytesDefinition);

%% C++ class method |pushRawBytes| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: void libm2k::analog::M2kAnalogOut::pushRawBytes(unsigned int chnIdx,short * data,unsigned int nb_samples)

pushRawBytesDefinition = addMethod(M2kAnalogOutDefinition, ...
   "void libm2k::analog::M2kAnalogOut::pushRawBytes(unsigned int chnIdx,short * data,unsigned int nb_samples)", ...
   "MATLABName", "pushRawBytes", ...
   "Description", "pushRawBytes Method of C++ class libm2k::analog::M2kAnalogOut." + newline + ...
   "Send the samples to the given channel", ...
   "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(pushRawBytesDefinition, "chnIdx", "uint32", "Description", "chnIdx The index corresponding to the channel");
defineArgument(pushRawBytesDefinition, "data", "clib.array.libm2k.Short", "input", "nb_samples", "Description", "data A pointer to the raw samples"); % <MLTYPE> can be "clib.array.libm2k.Short", or "int16"
defineArgument(pushRawBytesDefinition, "nb_samples", "uint32", "Description", "nb_samples the number of samples");
validate(pushRawBytesDefinition);

%% C++ class method |pushInterleaved| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: void libm2k::analog::M2kAnalogOut::pushInterleaved(double * data,unsigned int nb_channels,unsigned int nb_samples)

pushInterleavedDefinition = addMethod(M2kAnalogOutDefinition, ...
   "void libm2k::analog::M2kAnalogOut::pushInterleaved(double * data,unsigned int nb_channels,unsigned int nb_samples)", ...
   "MATLABName", "pushInterleaved", ...
   "Description", "pushInterleaved Method of C++ class libm2k::analog::M2kAnalogOut." + newline + ...
   "Send samples to all the channels", ...
   "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(pushInterleavedDefinition, "data", "clib.array.libm2k.Double", "input", "nb_samples", "Description", "data A pointer to the interleaved data"); % <MLTYPE> can be "clib.array.libm2k.Double", or "double"
defineArgument(pushInterleavedDefinition, "nb_channels", "uint32", "Description", "nb_channels the number of channels on which we want to push");
defineArgument(pushInterleavedDefinition, "nb_samples", "uint32", "Description", "nb_samples the number of samples total (samples_per_channel channels)" + newline + ...
   "	@note Make sure the samples are interleaved" + newline + ...
   "	@note Streaming data is possible - required multiple kernel buffers" + newline + ...
   "	@note The given channel will be synchronized with the other channel" + newline + ...
   "	@note Due to a hardware limitation, the number of samples per channel must" + newline + ...
   "	be a multiple of 4 and greater than 16 (non-cyclic buffers) or 1024 (cyclic buffers)" + newline + ...
   "	@note The samples in the buffer can be repeated until the buffer reaches the size requirements");
validate(pushInterleavedDefinition);

%% C++ class method |pushRawInterleaved| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: void libm2k::analog::M2kAnalogOut::pushRawInterleaved(short * data,unsigned int nb_channels,unsigned int nb_samples)

pushRawInterleavedDefinition = addMethod(M2kAnalogOutDefinition, ...
   "void libm2k::analog::M2kAnalogOut::pushRawInterleaved(short * data,unsigned int nb_channels,unsigned int nb_samples)", ...
   "MATLABName", "pushRawInterleaved", ...
   "Description", "pushRawInterleaved Method of C++ class libm2k::analog::M2kAnalogOut." + newline + ...
   "Send samples to all the channels", ...
   "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(pushRawInterleavedDefinition, "data", "clib.array.libm2k.Short", "input", "nb_samples", "Description", "data A pointer to the interleaved raw data"); % <MLTYPE> can be "clib.array.libm2k.Short", or "int16"
defineArgument(pushRawInterleavedDefinition, "nb_channels", "uint32", "Description", "nb_channels the number of channels on which we want to push");
defineArgument(pushRawInterleavedDefinition, "nb_samples", "uint32", "Description", "nb_samples the number of samples total (samples_per_channel channels)" + newline + ...
   "	@note Make sure the raw samples are interleaved" + newline + ...
   "	@note Streaming data is possible - required multiple kernel buffers" + newline + ...
   "	@note The given channel will be synchronized with the other channel" + newline + ...
   "	@note Due to a hardware limitation, the number of samples per channel must" + newline + ...
   "	be a multiple of 4 and greater than 16 (non-cyclic buffers) or 1024 (cyclic buffers)" + newline + ...
   "	@note The samples in the buffer can be repeated until the buffer reaches the size requirements");
validate(pushRawInterleavedDefinition);

%% C++ class method |push| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: void libm2k::analog::M2kAnalogOut::push(unsigned int chnIdx,std::vector<double, std::allocator<double>> const & data)

pushDefinition = addMethod(M2kAnalogOutDefinition, ...
    "void libm2k::analog::M2kAnalogOut::push(unsigned int chnIdx,std::vector<double, std::allocator<double>> const & data)", ...
    "MATLABName", "push", ...
    "Description", "push Method of C++ class libm2k::analog::M2kAnalogOut." + newline + ...
    "Send the samples to the given channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(pushDefinition, "chnIdx", "uint32", "Description", "chnIdx The index corresponding to the channel");
defineArgument(pushDefinition, "data", "clib.array.libm2k.Double", "Description", "data A list of doubles containing all samples");
validate(pushDefinition);

%% C++ class method |pushRaw| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: void libm2k::analog::M2kAnalogOut::pushRaw(unsigned int chnIdx,std::vector<short, std::allocator<short>> const & data)

pushRawDefinition = addMethod(M2kAnalogOutDefinition, ...
    "void libm2k::analog::M2kAnalogOut::pushRaw(unsigned int chnIdx,std::vector<short, std::allocator<short>> const & data)", ...
    "MATLABName", "pushRaw", ...
    "Description", "pushRaw Method of C++ class libm2k::analog::M2kAnalogOut." + newline + ...
    "Send the samples to the given channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(pushRawDefinition, "chnIdx", "uint32", "Description", "chnIdx The index corresponding to the channel");
defineArgument(pushRawDefinition, "data", "clib.array.libm2k.Short", "Description", "data A list of shorts containing all samples");
validate(pushRawDefinition);

%% C++ class method |stop| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: void libm2k::analog::M2kAnalogOut::stop()

stopDefinition = addMethod(M2kAnalogOutDefinition, ...
    "void libm2k::analog::M2kAnalogOut::stop()", ...
    "MATLABName", "stop", ...
    "Description", "stop Method of C++ class libm2k::analog::M2kAnalogOut." + newline + ...
    "Stop all channels from sending the signals.", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@note Both DACs will be powered down"); % Modify help description values as needed.
validate(stopDefinition);

%% C++ class method |stop| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: void libm2k::analog::M2kAnalogOut::stop(unsigned int chn)

stopDefinition = addMethod(M2kAnalogOutDefinition, ...
    "void libm2k::analog::M2kAnalogOut::stop(unsigned int chn)", ...
    "MATLABName", "stop", ...
    "Description", "stop Method of C++ class libm2k::analog::M2kAnalogOut." + newline + ...
    "Stop the given channels from sending the signals", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(stopDefinition, "chn", "uint32", "Description", "chn The index corresponding to the channel");
validate(stopDefinition);

%% C++ class method |cancelBuffer| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: void libm2k::analog::M2kAnalogOut::cancelBuffer()

cancelBufferDefinition = addMethod(M2kAnalogOutDefinition, ...
    "void libm2k::analog::M2kAnalogOut::cancelBuffer()", ...
    "MATLABName", "cancelBuffer", ...
    "Description", "cancelBuffer Method of C++ class libm2k::analog::M2kAnalogOut." + newline + ...
    "Cancel all buffer operations of enabled channels" + newline + ...
    "	 @note Should be used to cancel an ongoing data write.", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@brief Cancel all buffer operations of enabled channels" + newline + ...
    "	 @note Should be used to cancel an ongoing data write."); % Modify help description values as needed.
validate(cancelBufferDefinition);

%% C++ class method |cancelBuffer| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: void libm2k::analog::M2kAnalogOut::cancelBuffer(unsigned int chn)

cancelBufferDefinition = addMethod(M2kAnalogOutDefinition, ...
    "void libm2k::analog::M2kAnalogOut::cancelBuffer(unsigned int chn)", ...
    "MATLABName", "cancelBuffer", ...
    "Description", "cancelBuffer Method of C++ class libm2k::analog::M2kAnalogOut." + newline + ...
    "Cancel all buffer operations of the given channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(cancelBufferDefinition, "chn", "uint32", "Description", "chn The index corresponding to the channel" + newline + ...
    "	 @note Should be used to cancel an ongoing data write.");
validate(cancelBufferDefinition);

%% C++ class method |enableChannel| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: void libm2k::analog::M2kAnalogOut::enableChannel(unsigned int chnIdx,bool enable)

enableChannelDefinition = addMethod(M2kAnalogOutDefinition, ...
    "void libm2k::analog::M2kAnalogOut::enableChannel(unsigned int chnIdx,bool enable)", ...
    "MATLABName", "enableChannel", ...
    "Description", "enableChannel Method of C++ class libm2k::analog::M2kAnalogOut." + newline + ...
    "Enable or disable the given digital channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(enableChannelDefinition, "chnIdx", "uint32", "Description", "chnIdx The index corresponding to the channel");
defineArgument(enableChannelDefinition, "enable", "logical", "Description", "enable A boolean value corresponding to the channel's state");
validate(enableChannelDefinition);

%% C++ class method |isChannelEnabled| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: bool libm2k::analog::M2kAnalogOut::isChannelEnabled(unsigned int chnIdx)

isChannelEnabledDefinition = addMethod(M2kAnalogOutDefinition, ...
    "bool libm2k::analog::M2kAnalogOut::isChannelEnabled(unsigned int chnIdx)", ...
    "MATLABName", "isChannelEnabled", ...
    "Description", "isChannelEnabled Method of C++ class libm2k::analog::M2kAnalogOut." + newline + ...
    "Check if the given channel is enabled", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(isChannelEnabledDefinition, "chnIdx", "uint32", "Description", "chnIdx The index corresponding to the channel");
defineOutput(isChannelEnabledDefinition, "RetVal", "logical", "Description", "A boolean value corresponding to the state of the channel");
validate(isChannelEnabledDefinition);

%% C++ class method |isPushDone| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: bool libm2k::analog::M2kAnalogOut::isPushDone(unsigned int chnIdx) const

isPushDoneDefinition = addMethod(M2kAnalogOutDefinition, ...
    "bool libm2k::analog::M2kAnalogOut::isPushDone(unsigned int chnIdx) const", ...
    "MATLABName", "isPushDone", ...
    "Description", "isPushDone Method of C++ class libm2k::analog::M2kAnalogOut." + newline + ...
    "Check if the generation of the signal (only for non-cyclic buffer) is done", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(isPushDoneDefinition, "chnIdx", "uint32", "Description", "chnIdx The index corresponding to the channel");
defineOutput(isPushDoneDefinition, "RetVal", "logical", "Description", "True if the push process is done, false otherwise");
validate(isPushDoneDefinition);

%% C++ class method |setKernelBuffersCount| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: void libm2k::analog::M2kAnalogOut::setKernelBuffersCount(unsigned int chnIdx,unsigned int count)

setKernelBuffersCountDefinition = addMethod(M2kAnalogOutDefinition, ...
    "void libm2k::analog::M2kAnalogOut::setKernelBuffersCount(unsigned int chnIdx,unsigned int count)", ...
    "MATLABName", "setKernelBuffersCount", ...
    "Description", "setKernelBuffersCount Method of C++ class libm2k::analog::M2kAnalogOut." + newline + ...
    "Set the kernel buffers to a specific value", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setKernelBuffersCountDefinition, "chnIdx", "uint32", "Description", "chnIdx The index corresponding to the channel");
defineArgument(setKernelBuffersCountDefinition, "count", "uint32", "Description", "count the number of kernel buffers");
validate(setKernelBuffersCountDefinition);

%% C++ class method |getKernelBuffersCount| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: unsigned int libm2k::analog::M2kAnalogOut::getKernelBuffersCount(unsigned int chnIdx) const

getKernelBuffersCountDefinition = addMethod(M2kAnalogOutDefinition, ...
    "unsigned int libm2k::analog::M2kAnalogOut::getKernelBuffersCount(unsigned int chnIdx) const", ...
    "MATLABName", "getKernelBuffersCount", ...
    "Description", "getKernelBuffersCount Method of C++ class libm2k::analog::M2kAnalogOut." + newline + ...
    "Get the number of kernel buffers", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getKernelBuffersCountDefinition, "chnIdx", "uint32", "Description", "chnIdx The index corresponding to the channel");
defineOutput(getKernelBuffersCountDefinition, "RetVal", "uint32", "Description", "the number of previously set kernel buffers (saved in this session)");
validate(getKernelBuffersCountDefinition);

%% C++ class method |convertVoltsToRaw| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: short libm2k::analog::M2kAnalogOut::convertVoltsToRaw(unsigned int channel,double voltage)

convertVoltsToRawDefinition = addMethod(M2kAnalogOutDefinition, ...
    "short libm2k::analog::M2kAnalogOut::convertVoltsToRaw(unsigned int channel,double voltage)", ...
    "MATLABName", "convertVoltsToRaw", ...
    "Description", "convertVoltsToRaw Method of C++ class libm2k::analog::M2kAnalogOut." + newline + ...
    "Convert the volts value of a sample into raw", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(convertVoltsToRawDefinition, "channel", "uint32", "Description", "channel The index corresponding to the channel");
defineArgument(convertVoltsToRawDefinition, "voltage", "double", "Description", "voltage The volts value of a sample");
defineOutput(convertVoltsToRawDefinition, "RetVal", "int16", "Description", "The value of a sample converted into raw");
validate(convertVoltsToRawDefinition);

%% C++ class method |convertRawToVolts| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: double libm2k::analog::M2kAnalogOut::convertRawToVolts(unsigned int channel,short raw)

convertRawToVoltsDefinition = addMethod(M2kAnalogOutDefinition, ...
    "double libm2k::analog::M2kAnalogOut::convertRawToVolts(unsigned int channel,short raw)", ...
    "MATLABName", "convertRawToVolts", ...
    "Description", "convertRawToVolts Method of C++ class libm2k::analog::M2kAnalogOut." + newline + ...
    "Convert the raw value of a sample into volts", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(convertRawToVoltsDefinition, "channel", "uint32", "Description", "channel The index corresponding to the channel");
defineArgument(convertRawToVoltsDefinition, "raw", "int16", "Description", "raw The raw value of a sample");
defineOutput(convertRawToVoltsDefinition, "RetVal", "double", "Description", "The value of a sample converted into volts");
validate(convertRawToVoltsDefinition);

%% C++ class method |getIioObjects| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: libm2k::IIO_OBJECTS libm2k::analog::M2kAnalogOut::getIioObjects()

getIioObjectsDefinition = addMethod(M2kAnalogOutDefinition, ...
    "libm2k::IIO_OBJECTS libm2k::analog::M2kAnalogOut::getIioObjects()", ...
    "MATLABName", "getIioObjects", ...
    "Description", "getIioObjects Method of C++ class libm2k::analog::M2kAnalogOut." + newline + ...
    "Get access to IIO channels, buffers, devices and context." + newline + ...
    "	 @note Can be used when debugging directly with libiio.", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getIioObjectsDefinition, "RetVal", "clib.libm2k.libm2k.IIO_OBJECTS", "Description", "IIO_OBJECTS structure.");
validate(getIioObjectsDefinition);

%% C++ class method |getNbChannels| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: unsigned int libm2k::analog::M2kAnalogOut::getNbChannels()

getNbChannelsDefinition = addMethod(M2kAnalogOutDefinition, ...
    "unsigned int libm2k::analog::M2kAnalogOut::getNbChannels()", ...
    "MATLABName", "getNbChannels", ...
    "Description", "getNbChannels Method of C++ class libm2k::analog::M2kAnalogOut." + newline + ...
    "Retrieve the number of analogical channels", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getNbChannelsDefinition, "RetVal", "uint32", "Description", "The number of channels");
validate(getNbChannelsDefinition);

%% C++ class method |getChannelName| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: std::string libm2k::analog::M2kAnalogOut::getChannelName(unsigned int channel)

getChannelNameDefinition = addMethod(M2kAnalogOutDefinition, ...
    "std::string libm2k::analog::M2kAnalogOut::getChannelName(unsigned int channel)", ...
    "MATLABName", "getChannelName", ...
    "Description", "getChannelName Method of C++ class libm2k::analog::M2kAnalogOut." + newline + ...
    "Get the channel name for each DAC channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getChannelNameDefinition, "channel", "uint32", "Description", "channel - unsigned int representing the index of the channel");
defineOutput(getChannelNameDefinition, "RetVal", "string", "Description", "std::string - name of the channel");
validate(getChannelNameDefinition);

%% C++ class method |getMaximumSamplerate| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: double libm2k::analog::M2kAnalogOut::getMaximumSamplerate(unsigned int chn_idx)

getMaximumSamplerateDefinition = addMethod(M2kAnalogOutDefinition, ...
    "double libm2k::analog::M2kAnalogOut::getMaximumSamplerate(unsigned int chn_idx)", ...
    "MATLABName", "getMaximumSamplerate", ...
    "Description", "getMaximumSamplerate Method of C++ class libm2k::analog::M2kAnalogOut." + newline + ...
    "Get the maximum samplerate for the DAC", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getMaximumSamplerateDefinition, "chn_idx", "uint32", "Description", "chn_idx - unsigned int representing the index of the channel");
defineOutput(getMaximumSamplerateDefinition, "RetVal", "double", "Description", "double - the value of the maximum samplerate");
validate(getMaximumSamplerateDefinition);

%% C++ class method |setVoltage| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: unsigned short libm2k::analog::M2kAnalogOut::setVoltage(unsigned int chn_idx,double volts)

setVoltageDefinition = addMethod(M2kAnalogOutDefinition, ...
    "unsigned short libm2k::analog::M2kAnalogOut::setVoltage(unsigned int chn_idx,double volts)", ...
    "MATLABName", "setVoltage", ...
    "Description", "setVoltage Method of C++ class libm2k::analog::M2kAnalogOut." + newline + ...
    "Sets the voltage output of the DAC channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setVoltageDefinition, "chn_idx", "uint32", "Description", "chn_idx - unsigned int representing the index of the channel");
defineArgument(setVoltageDefinition, "volts", "double", "Description", "volts - actual value to be set" + newline + ...
    "	 " + newline + ...
    "	 @note In scenarios where the DMA is not active, such as when an output buffer is destroyed," + newline + ...
    "	 the DAC will revert to using the raw value set by this function.");
defineOutput(setVoltageDefinition, "RetVal", "uint16", "Description", "unsigned short - the corresponding raw value for the given voltage");
validate(setVoltageDefinition);

%% C++ class method |setVoltageRaw| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: unsigned short libm2k::analog::M2kAnalogOut::setVoltageRaw(unsigned int chn_idx,unsigned short raw)

setVoltageRawDefinition = addMethod(M2kAnalogOutDefinition, ...
    "unsigned short libm2k::analog::M2kAnalogOut::setVoltageRaw(unsigned int chn_idx,unsigned short raw)", ...
    "MATLABName", "setVoltageRaw", ...
    "Description", "setVoltageRaw Method of C++ class libm2k::analog::M2kAnalogOut." + newline + ...
    "Sets the raw output of the DAC channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setVoltageRawDefinition, "chn_idx", "uint32", "Description", "chn_idx - unsigned int representing the index of the channel");
defineArgument(setVoltageRawDefinition, "raw", "uint16", "Description", "raw - actual value to be set" + newline + ...
    "	 " + newline + ...
    "	 @note In scenarios where the DMA is not active, such as when an output buffer is destroyed," + newline + ...
    "	 the DAC will revert to using the raw value set by this function.");
defineOutput(setVoltageRawDefinition, "RetVal", "uint16", "Description", "unsigned short - the value set in the raw attribute");
validate(setVoltageRawDefinition);

%% C++ class method |getTrigger| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: libm2k::M2kHardwareTrigger * libm2k::analog::M2kAnalogOut::getTrigger()

getTriggerDefinition = addMethod(M2kAnalogOutDefinition, ...
   "libm2k::M2kHardwareTrigger * libm2k::analog::M2kAnalogOut::getTrigger()", ...
   "MATLABName", "getTrigger", ...
   "Description", "getTrigger Method of C++ class libm2k::analog::M2kAnalogOut." + newline + ...
   "Get the hardware trigger handler", ...
   "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getTriggerDefinition, "RetVal", "clib.libm2k.libm2k.M2kHardwareTrigger", 1, "Description", "A pointer to the hardware trigger");
validate(getTriggerDefinition);

%% C++ class method |setBufferRearmOnTrigger| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: void libm2k::analog::M2kAnalogOut::setBufferRearmOnTrigger(bool enable)

setBufferRearmOnTriggerDefinition = addMethod(M2kAnalogOutDefinition, ...
    "void libm2k::analog::M2kAnalogOut::setBufferRearmOnTrigger(bool enable)", ...
    "MATLABName", "setBufferRearmOnTrigger", ...
    "Description", "setBufferRearmOnTrigger Method of C++ class libm2k::analog::M2kAnalogOut." + newline + ...
    "Allows sequential output of multiple buffers with each trigger event.", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setBufferRearmOnTriggerDefinition, "enable", "logical", "Description", "enable A boolean value that enables or disables the buffer rearm functionality.");
validate(setBufferRearmOnTriggerDefinition);

%% C++ class method |getBufferRearmOnTrigger| for C++ class |libm2k::analog::M2kAnalogOut| 
% C++ Signature: bool libm2k::analog::M2kAnalogOut::getBufferRearmOnTrigger() const

getBufferRearmOnTriggerDefinition = addMethod(M2kAnalogOutDefinition, ...
    "bool libm2k::analog::M2kAnalogOut::getBufferRearmOnTrigger() const", ...
    "MATLABName", "getBufferRearmOnTrigger", ...
    "Description", "getBufferRearmOnTrigger Method of C++ class libm2k::analog::M2kAnalogOut." + newline + ...
    "Retrieve the value of the attribute that controls buffer rearm on trigger" + newline + ...
    "	@note The buffer rearm on trigger is disabled by default." + newline + ...
    "	@note The attribute is shared between both channels." + newline + ...
    "	@note Only available from firmware v0.33.", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getBufferRearmOnTriggerDefinition, "RetVal", "logical", "Description", "A boolean value corresponding to the state of the rearm on trigger.");
validate(getBufferRearmOnTriggerDefinition);

%% C++ class |libm2k::analog::M2kPowerSupply| with MATLAB name |clib.libm2k.libm2k.analog.M2kPowerSupply| 
M2kPowerSupplyDefinition = addClass(libDef, "libm2k::analog::M2kPowerSupply", "MATLABName", "clib.libm2k.libm2k.analog.M2kPowerSupply", ...
    "Description", "clib.libm2k.libm2k.analog.M2kPowerSupply    Representation of C++ class libm2k::analog::M2kPowerSupply." + newline + ...
    "Contains the representation of the power supply" + newline + ...
    "" + newline + ...
    "@class M2kPowerSupply m2kpowersupply.hpp libm2k/analog/m2kpowersupply.hpp" + newline + ...
    "@brief Controls the power supply", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@defgroup powersupply PowerSupply" + newline + ...
    "@brief Contains the representation of the power supply" + newline + ...
    "" + newline + ...
    "@class M2kPowerSupply m2kpowersupply.hpp libm2k/analog/m2kpowersupply.hpp" + newline + ...
    "@brief Controls the power supply"); % Modify help description values as needed.

%% C++ class method |reset| for C++ class |libm2k::analog::M2kPowerSupply| 
% C++ Signature: void libm2k::analog::M2kPowerSupply::reset()

resetDefinition = addMethod(M2kPowerSupplyDefinition, ...
    "void libm2k::analog::M2kPowerSupply::reset()", ...
    "MATLABName", "reset", ...
    "Description", "reset Method of C++ class libm2k::analog::M2kPowerSupply.", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@private"); % Modify help description values as needed.
validate(resetDefinition);

%% C++ class method |enableChannel| for C++ class |libm2k::analog::M2kPowerSupply| 
% C++ Signature: void libm2k::analog::M2kPowerSupply::enableChannel(unsigned int chn,bool en)

enableChannelDefinition = addMethod(M2kPowerSupplyDefinition, ...
    "void libm2k::analog::M2kPowerSupply::enableChannel(unsigned int chn,bool en)", ...
    "MATLABName", "enableChannel", ...
    "Description", "enableChannel Method of C++ class libm2k::analog::M2kPowerSupply." + newline + ...
    "Enable or disable the given channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(enableChannelDefinition, "chn", "uint32", "Description", "chn The index corresponding to the channel");
defineArgument(enableChannelDefinition, "en", "logical", "Description", "en A boolean value corresponding to the state of the channel");
validate(enableChannelDefinition);

%% C++ class method |enableAll| for C++ class |libm2k::analog::M2kPowerSupply| 
% C++ Signature: void libm2k::analog::M2kPowerSupply::enableAll(bool en)

enableAllDefinition = addMethod(M2kPowerSupplyDefinition, ...
    "void libm2k::analog::M2kPowerSupply::enableAll(bool en)", ...
    "MATLABName", "enableAll", ...
    "Description", "enableAll Method of C++ class libm2k::analog::M2kPowerSupply." + newline + ...
    "Enable or disable all channels", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(enableAllDefinition, "en", "logical", "Description", "en A boolean value corresponding to the state of the channels");
validate(enableAllDefinition);

%% C++ class method |readChannel| for C++ class |libm2k::analog::M2kPowerSupply| 
% C++ Signature: double libm2k::analog::M2kPowerSupply::readChannel(unsigned int chn,bool calibrated = 1)

readChannelDefinition = addMethod(M2kPowerSupplyDefinition, ...
    "double libm2k::analog::M2kPowerSupply::readChannel(unsigned int chn,bool calibrated = 1)", ...
    "MATLABName", "readChannel", ...
    "Description", "readChannel Method of C++ class libm2k::analog::M2kPowerSupply." + newline + ...
    "Retrieve the value of a given channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(readChannelDefinition, "chn", "uint32", "Description", "chn The index corresponding to the channel");
defineArgument(readChannelDefinition, "calibrated", "logical", "Description", "calibrated Read values are converted using the calibration" + newline + ...
    "	coefficients from the IIO context by default; This boolean flag" + newline + ...
    "	specifies whether the coefficients should be used.");
defineOutput(readChannelDefinition, "RetVal", "double", "Description", "double The voltage transmitted by the given channel");
validate(readChannelDefinition);

%% C++ class method |pushChannel| for C++ class |libm2k::analog::M2kPowerSupply| 
% C++ Signature: void libm2k::analog::M2kPowerSupply::pushChannel(unsigned int chn,double value,bool calibrated = 1)

pushChannelDefinition = addMethod(M2kPowerSupplyDefinition, ...
    "void libm2k::analog::M2kPowerSupply::pushChannel(unsigned int chn,double value,bool calibrated = 1)", ...
    "MATLABName", "pushChannel", ...
    "Description", "pushChannel Method of C++ class libm2k::analog::M2kPowerSupply." + newline + ...
    "Set the voltage for the given channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(pushChannelDefinition, "chn", "uint32", "Description", "chn The index corresponding to the channel");
defineArgument(pushChannelDefinition, "value", "double", "Description", "value The voltage (up to 5V)");
defineArgument(pushChannelDefinition, "calibrated", "logical", "Description", "calibrated Written values are converted using the calibration" + newline + ...
    "	coefficients from the IIO context by default; This boolean flag" + newline + ...
    "	specifies whether the coefficients should be used.");
validate(pushChannelDefinition);

%% C++ class method |powerDownDacs| for C++ class |libm2k::analog::M2kPowerSupply| 
% C++ Signature: void libm2k::analog::M2kPowerSupply::powerDownDacs(bool powerdown)

powerDownDacsDefinition = addMethod(M2kPowerSupplyDefinition, ...
    "void libm2k::analog::M2kPowerSupply::powerDownDacs(bool powerdown)", ...
    "MATLABName", "powerDownDacs", ...
    "Description", "powerDownDacs Method of C++ class libm2k::analog::M2kPowerSupply.", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@private"); % Modify help description values as needed.
defineArgument(powerDownDacsDefinition, "powerdown", "logical");
validate(powerDownDacsDefinition);

%% C++ class method |anyChannelEnabled| for C++ class |libm2k::analog::M2kPowerSupply| 
% C++ Signature: bool libm2k::analog::M2kPowerSupply::anyChannelEnabled()

anyChannelEnabledDefinition = addMethod(M2kPowerSupplyDefinition, ...
    "bool libm2k::analog::M2kPowerSupply::anyChannelEnabled()", ...
    "MATLABName", "anyChannelEnabled", ...
    "Description", "anyChannelEnabled Method of C++ class libm2k::analog::M2kPowerSupply." + newline + ...
    "Check if there is at least one enabled channel", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(anyChannelEnabledDefinition, "RetVal", "logical", "Description", "On succes, true");
validate(anyChannelEnabledDefinition);

%% C++ class |libm2k::analog::GenericAnalogOut| with MATLAB name |clib.libm2k.libm2k.analog.GenericAnalogOut| 
GenericAnalogOutDefinition = addClass(libDef, "libm2k::analog::GenericAnalogOut", "MATLABName", "clib.libm2k.libm2k.analog.GenericAnalogOut", ...
    "Description", "clib.libm2k.libm2k.analog.GenericAnalogOut    Representation of C++ class libm2k::analog::GenericAnalogOut."); % Modify help description values as needed.

%% C++ class method |getSampleRate| for C++ class |libm2k::analog::GenericAnalogOut| 
% C++ Signature: double libm2k::analog::GenericAnalogOut::getSampleRate()

getSampleRateDefinition = addMethod(GenericAnalogOutDefinition, ...
    "double libm2k::analog::GenericAnalogOut::getSampleRate()", ...
    "MATLABName", "getSampleRate", ...
    "Description", "getSampleRate Method of C++ class libm2k::analog::GenericAnalogOut."); % Modify help description values as needed.
defineOutput(getSampleRateDefinition, "RetVal", "double");
validate(getSampleRateDefinition);

%% C++ class method |getSampleRate| for C++ class |libm2k::analog::GenericAnalogOut| 
% C++ Signature: double libm2k::analog::GenericAnalogOut::getSampleRate(unsigned int input1)

getSampleRateDefinition = addMethod(GenericAnalogOutDefinition, ...
    "double libm2k::analog::GenericAnalogOut::getSampleRate(unsigned int input1)", ...
    "MATLABName", "getSampleRate", ...
    "Description", "getSampleRate Method of C++ class libm2k::analog::GenericAnalogOut."); % Modify help description values as needed.
defineArgument(getSampleRateDefinition, "input1", "uint32");
defineOutput(getSampleRateDefinition, "RetVal", "double");
validate(getSampleRateDefinition);

%% C++ class method |setSampleRate| for C++ class |libm2k::analog::GenericAnalogOut| 
% C++ Signature: double libm2k::analog::GenericAnalogOut::setSampleRate(double sampleRate)

setSampleRateDefinition = addMethod(GenericAnalogOutDefinition, ...
    "double libm2k::analog::GenericAnalogOut::setSampleRate(double sampleRate)", ...
    "MATLABName", "setSampleRate", ...
    "Description", "setSampleRate Method of C++ class libm2k::analog::GenericAnalogOut."); % Modify help description values as needed.
defineArgument(setSampleRateDefinition, "sampleRate", "double");
defineOutput(setSampleRateDefinition, "RetVal", "double");
validate(setSampleRateDefinition);

%% C++ class method |setSampleRate| for C++ class |libm2k::analog::GenericAnalogOut| 
% C++ Signature: double libm2k::analog::GenericAnalogOut::setSampleRate(unsigned int chn_idx,double sampleRate)

setSampleRateDefinition = addMethod(GenericAnalogOutDefinition, ...
    "double libm2k::analog::GenericAnalogOut::setSampleRate(unsigned int chn_idx,double sampleRate)", ...
    "MATLABName", "setSampleRate", ...
    "Description", "setSampleRate Method of C++ class libm2k::analog::GenericAnalogOut."); % Modify help description values as needed.
defineArgument(setSampleRateDefinition, "chn_idx", "uint32");
defineArgument(setSampleRateDefinition, "sampleRate", "double");
defineOutput(setSampleRateDefinition, "RetVal", "double");
validate(setSampleRateDefinition);

%% C++ class method |getAvailableSampleRates| for C++ class |libm2k::analog::GenericAnalogOut| 
% C++ Signature: std::vector<double, std::allocator<double>> libm2k::analog::GenericAnalogOut::getAvailableSampleRates()

getAvailableSampleRatesDefinition = addMethod(GenericAnalogOutDefinition, ...
    "std::vector<double, std::allocator<double>> libm2k::analog::GenericAnalogOut::getAvailableSampleRates()", ...
    "MATLABName", "getAvailableSampleRates", ...
    "Description", "getAvailableSampleRates Method of C++ class libm2k::analog::GenericAnalogOut."); % Modify help description values as needed.
defineOutput(getAvailableSampleRatesDefinition, "RetVal", "clib.array.libm2k.Double");
validate(getAvailableSampleRatesDefinition);

%% C++ class method |setCyclic| for C++ class |libm2k::analog::GenericAnalogOut| 
% C++ Signature: void libm2k::analog::GenericAnalogOut::setCyclic(bool en)

setCyclicDefinition = addMethod(GenericAnalogOutDefinition, ...
    "void libm2k::analog::GenericAnalogOut::setCyclic(bool en)", ...
    "MATLABName", "setCyclic", ...
    "Description", "setCyclic Method of C++ class libm2k::analog::GenericAnalogOut."); % Modify help description values as needed.
defineArgument(setCyclicDefinition, "en", "logical");
validate(setCyclicDefinition);

%% C++ class method |setCyclic| for C++ class |libm2k::analog::GenericAnalogOut| 
% C++ Signature: void libm2k::analog::GenericAnalogOut::setCyclic(unsigned int chn,bool en)

setCyclicDefinition = addMethod(GenericAnalogOutDefinition, ...
    "void libm2k::analog::GenericAnalogOut::setCyclic(unsigned int chn,bool en)", ...
    "MATLABName", "setCyclic", ...
    "Description", "setCyclic Method of C++ class libm2k::analog::GenericAnalogOut."); % Modify help description values as needed.
defineArgument(setCyclicDefinition, "chn", "uint32");
defineArgument(setCyclicDefinition, "en", "logical");
validate(setCyclicDefinition);

%% C++ class method |getCyclic| for C++ class |libm2k::analog::GenericAnalogOut| 
% C++ Signature: bool libm2k::analog::GenericAnalogOut::getCyclic(unsigned int chn)

getCyclicDefinition = addMethod(GenericAnalogOutDefinition, ...
    "bool libm2k::analog::GenericAnalogOut::getCyclic(unsigned int chn)", ...
    "MATLABName", "getCyclic", ...
    "Description", "getCyclic Method of C++ class libm2k::analog::GenericAnalogOut."); % Modify help description values as needed.
defineArgument(getCyclicDefinition, "chn", "uint32");
defineOutput(getCyclicDefinition, "RetVal", "logical");
validate(getCyclicDefinition);

%% C++ class method |push| for C++ class |libm2k::analog::GenericAnalogOut| 
% C++ Signature: void libm2k::analog::GenericAnalogOut::push(unsigned int chn_idx,std::vector<double, std::allocator<double>> const & data)

pushDefinition = addMethod(GenericAnalogOutDefinition, ...
    "void libm2k::analog::GenericAnalogOut::push(unsigned int chn_idx,std::vector<double, std::allocator<double>> const & data)", ...
    "MATLABName", "push", ...
    "Description", "push Method of C++ class libm2k::analog::GenericAnalogOut."); % Modify help description values as needed.
defineArgument(pushDefinition, "chn_idx", "uint32");
defineArgument(pushDefinition, "data", "clib.array.libm2k.Double");
validate(pushDefinition);

%% C++ class method |pushRaw| for C++ class |libm2k::analog::GenericAnalogOut| 
% C++ Signature: void libm2k::analog::GenericAnalogOut::pushRaw(unsigned int chn_idx,std::vector<short, std::allocator<short>> const & data)

pushRawDefinition = addMethod(GenericAnalogOutDefinition, ...
    "void libm2k::analog::GenericAnalogOut::pushRaw(unsigned int chn_idx,std::vector<short, std::allocator<short>> const & data)", ...
    "MATLABName", "pushRaw", ...
    "Description", "pushRaw Method of C++ class libm2k::analog::GenericAnalogOut."); % Modify help description values as needed.
defineArgument(pushRawDefinition, "chn_idx", "uint32");
defineArgument(pushRawDefinition, "data", "clib.array.libm2k.Short");
validate(pushRawDefinition);

%% C++ class method |push| for C++ class |libm2k::analog::GenericAnalogOut| 
% C++ Signature: void libm2k::analog::GenericAnalogOut::push(unsigned int chn_idx,double * data,unsigned int nb_samples)

%pushDefinition = addMethod(GenericAnalogOutDefinition, ...
%    "void libm2k::analog::GenericAnalogOut::push(unsigned int chn_idx,double * data,unsigned int nb_samples)", ...
%    "MATLABName", "push", ...
%    "Description", "push Method of C++ class libm2k::analog::GenericAnalogOut."); % Modify help description values as needed.
%defineArgument(pushDefinition, "chn_idx", "uint32");
%defineArgument(pushDefinition, "data", "clib.array.libm2k.Double", "input", <SHAPE>); % <MLTYPE> can be "clib.array.libm2k.Double", or "double"
%defineArgument(pushDefinition, "nb_samples", "uint32");
%validate(pushDefinition);

%% C++ class method |pushRaw| for C++ class |libm2k::analog::GenericAnalogOut| 
% C++ Signature: void libm2k::analog::GenericAnalogOut::pushRaw(unsigned int chn_idx,short * data,unsigned int nb_samples)

%pushRawDefinition = addMethod(GenericAnalogOutDefinition, ...
%    "void libm2k::analog::GenericAnalogOut::pushRaw(unsigned int chn_idx,short * data,unsigned int nb_samples)", ...
%    "MATLABName", "pushRaw", ...
%    "Description", "pushRaw Method of C++ class libm2k::analog::GenericAnalogOut."); % Modify help description values as needed.
%defineArgument(pushRawDefinition, "chn_idx", "uint32");
%defineArgument(pushRawDefinition, "data", "clib.array.libm2k.Short", "input", <SHAPE>); % <MLTYPE> can be "clib.array.libm2k.Short", or "int16"
%defineArgument(pushRawDefinition, "nb_samples", "uint32");
%validate(pushRawDefinition);

%% C++ class method |stop| for C++ class |libm2k::analog::GenericAnalogOut| 
% C++ Signature: void libm2k::analog::GenericAnalogOut::stop()

stopDefinition = addMethod(GenericAnalogOutDefinition, ...
    "void libm2k::analog::GenericAnalogOut::stop()", ...
    "MATLABName", "stop", ...
    "Description", "stop Method of C++ class libm2k::analog::GenericAnalogOut."); % Modify help description values as needed.
validate(stopDefinition);

%% C++ class method |getName| for C++ class |libm2k::analog::GenericAnalogOut| 
% C++ Signature: std::string libm2k::analog::GenericAnalogOut::getName()

getNameDefinition = addMethod(GenericAnalogOutDefinition, ...
    "std::string libm2k::analog::GenericAnalogOut::getName()", ...
    "MATLABName", "getName", ...
    "Description", "getName Method of C++ class libm2k::analog::GenericAnalogOut."); % Modify help description values as needed.
defineOutput(getNameDefinition, "RetVal", "string");
validate(getNameDefinition);

%% C++ class method |enableChannel| for C++ class |libm2k::analog::GenericAnalogOut| 
% C++ Signature: void libm2k::analog::GenericAnalogOut::enableChannel(unsigned int chnIdx,bool enable)

enableChannelDefinition = addMethod(GenericAnalogOutDefinition, ...
    "void libm2k::analog::GenericAnalogOut::enableChannel(unsigned int chnIdx,bool enable)", ...
    "MATLABName", "enableChannel", ...
    "Description", "enableChannel Method of C++ class libm2k::analog::GenericAnalogOut."); % Modify help description values as needed.
defineArgument(enableChannelDefinition, "chnIdx", "uint32");
defineArgument(enableChannelDefinition, "enable", "logical");
validate(enableChannelDefinition);

%% C++ class method |isChannelEnabled| for C++ class |libm2k::analog::GenericAnalogOut| 
% C++ Signature: bool libm2k::analog::GenericAnalogOut::isChannelEnabled(unsigned int chnIdx)

isChannelEnabledDefinition = addMethod(GenericAnalogOutDefinition, ...
    "bool libm2k::analog::GenericAnalogOut::isChannelEnabled(unsigned int chnIdx)", ...
    "MATLABName", "isChannelEnabled", ...
    "Description", "isChannelEnabled Method of C++ class libm2k::analog::GenericAnalogOut."); % Modify help description values as needed.
defineArgument(isChannelEnabledDefinition, "chnIdx", "uint32");
defineOutput(isChannelEnabledDefinition, "RetVal", "logical");
validate(isChannelEnabledDefinition);

%% C++ class |libm2k::analog::IIO_OBJECTS| with MATLAB name |clib.libm2k.libm2k.analog.IIO_OBJECTS| 
% IIO_OBJECTSDefinition = addClass(libDef, "libm2k::analog::IIO_OBJECTS", "MATLABName", "clib.libm2k.libm2k.analog.IIO_OBJECTS", ...
%     "Description", "clib.libm2k.libm2k.analog.IIO_OBJECTS    Representation of C++ class libm2k::analog::IIO_OBJECTS."); % Modify help description values as needed.

%% C++ class |libm2k::analog::GenericAnalogIn| with MATLAB name |clib.libm2k.libm2k.analog.GenericAnalogIn| 
GenericAnalogInDefinition = addClass(libDef, "libm2k::analog::GenericAnalogIn", "MATLABName", "clib.libm2k.libm2k.analog.GenericAnalogIn", ...
    "Description", "clib.libm2k.libm2k.analog.GenericAnalogIn    Representation of C++ class libm2k::analog::GenericAnalogIn."); % Modify help description values as needed.

%% C++ class method |getSamplesInterleaved| for C++ class |libm2k::analog::GenericAnalogIn| 
% C++ Signature: double const * libm2k::analog::GenericAnalogIn::getSamplesInterleaved(unsigned int nb_samples)

%getSamplesInterleavedDefinition = addMethod(GenericAnalogInDefinition, ...
%    "double const * libm2k::analog::GenericAnalogIn::getSamplesInterleaved(unsigned int nb_samples)", ...
%    "MATLABName", "getSamplesInterleaved", ...
%    "Description", "getSamplesInterleaved Method of C++ class libm2k::analog::GenericAnalogIn."); % Modify help description values as needed.
%defineArgument(getSamplesInterleavedDefinition, "nb_samples", "uint32");
%defineOutput(getSamplesInterleavedDefinition, "RetVal", "clib.array.libm2k.Double", <SHAPE>); % <MLTYPE> can be "clib.array.libm2k.Double", or "double"
%validate(getSamplesInterleavedDefinition);

%% C++ class method |getSamplesRawInterleaved| for C++ class |libm2k::analog::GenericAnalogIn| 
% C++ Signature: short const * libm2k::analog::GenericAnalogIn::getSamplesRawInterleaved(unsigned int nb_samples)

%getSamplesRawInterleavedDefinition = addMethod(GenericAnalogInDefinition, ...
%    "short const * libm2k::analog::GenericAnalogIn::getSamplesRawInterleaved(unsigned int nb_samples)", ...
%    "MATLABName", "getSamplesRawInterleaved", ...
%    "Description", "getSamplesRawInterleaved Method of C++ class libm2k::analog::GenericAnalogIn."); % Modify help description values as needed.
%defineArgument(getSamplesRawInterleavedDefinition, "nb_samples", "uint32");
%defineOutput(getSamplesRawInterleavedDefinition, "RetVal", "clib.array.libm2k.Short", <SHAPE>); % <MLTYPE> can be "clib.array.libm2k.Short", or "int16"
%validate(getSamplesRawInterleavedDefinition);

%% C++ class method |getSampleRate| for C++ class |libm2k::analog::GenericAnalogIn| 
% C++ Signature: double libm2k::analog::GenericAnalogIn::getSampleRate()

getSampleRateDefinition = addMethod(GenericAnalogInDefinition, ...
    "double libm2k::analog::GenericAnalogIn::getSampleRate()", ...
    "MATLABName", "getSampleRate", ...
    "Description", "getSampleRate Method of C++ class libm2k::analog::GenericAnalogIn."); % Modify help description values as needed.
defineOutput(getSampleRateDefinition, "RetVal", "double");
validate(getSampleRateDefinition);

%% C++ class method |getSampleRate| for C++ class |libm2k::analog::GenericAnalogIn| 
% C++ Signature: double libm2k::analog::GenericAnalogIn::getSampleRate(unsigned int input1)

getSampleRateDefinition = addMethod(GenericAnalogInDefinition, ...
    "double libm2k::analog::GenericAnalogIn::getSampleRate(unsigned int input1)", ...
    "MATLABName", "getSampleRate", ...
    "Description", "getSampleRate Method of C++ class libm2k::analog::GenericAnalogIn."); % Modify help description values as needed.
defineArgument(getSampleRateDefinition, "input1", "uint32");
defineOutput(getSampleRateDefinition, "RetVal", "double");
validate(getSampleRateDefinition);

%% C++ class method |setSampleRate| for C++ class |libm2k::analog::GenericAnalogIn| 
% C++ Signature: double libm2k::analog::GenericAnalogIn::setSampleRate(double sampleRate)

setSampleRateDefinition = addMethod(GenericAnalogInDefinition, ...
    "double libm2k::analog::GenericAnalogIn::setSampleRate(double sampleRate)", ...
    "MATLABName", "setSampleRate", ...
    "Description", "setSampleRate Method of C++ class libm2k::analog::GenericAnalogIn."); % Modify help description values as needed.
defineArgument(setSampleRateDefinition, "sampleRate", "double");
defineOutput(setSampleRateDefinition, "RetVal", "double");
validate(setSampleRateDefinition);

%% C++ class method |setSampleRate| for C++ class |libm2k::analog::GenericAnalogIn| 
% C++ Signature: double libm2k::analog::GenericAnalogIn::setSampleRate(unsigned int chn_idx,double sampleRate)

setSampleRateDefinition = addMethod(GenericAnalogInDefinition, ...
    "double libm2k::analog::GenericAnalogIn::setSampleRate(unsigned int chn_idx,double sampleRate)", ...
    "MATLABName", "setSampleRate", ...
    "Description", "setSampleRate Method of C++ class libm2k::analog::GenericAnalogIn."); % Modify help description values as needed.
defineArgument(setSampleRateDefinition, "chn_idx", "uint32");
defineArgument(setSampleRateDefinition, "sampleRate", "double");
defineOutput(setSampleRateDefinition, "RetVal", "double");
validate(setSampleRateDefinition);

%% C++ class method |getAvailableSampleRates| for C++ class |libm2k::analog::GenericAnalogIn| 
% C++ Signature: std::vector<double, std::allocator<double>> libm2k::analog::GenericAnalogIn::getAvailableSampleRates()

getAvailableSampleRatesDefinition = addMethod(GenericAnalogInDefinition, ...
    "std::vector<double, std::allocator<double>> libm2k::analog::GenericAnalogIn::getAvailableSampleRates()", ...
    "MATLABName", "getAvailableSampleRates", ...
    "Description", "getAvailableSampleRates Method of C++ class libm2k::analog::GenericAnalogIn."); % Modify help description values as needed.
defineOutput(getAvailableSampleRatesDefinition, "RetVal", "clib.array.libm2k.Double");
validate(getAvailableSampleRatesDefinition);

%% C++ class method |getAvailableSampleRates| for C++ class |libm2k::analog::GenericAnalogIn| 
% C++ Signature: std::vector<double, std::allocator<double>> libm2k::analog::GenericAnalogIn::getAvailableSampleRates(unsigned int chn_idx)

getAvailableSampleRatesDefinition = addMethod(GenericAnalogInDefinition, ...
    "std::vector<double, std::allocator<double>> libm2k::analog::GenericAnalogIn::getAvailableSampleRates(unsigned int chn_idx)", ...
    "MATLABName", "getAvailableSampleRates", ...
    "Description", "getAvailableSampleRates Method of C++ class libm2k::analog::GenericAnalogIn."); % Modify help description values as needed.
defineArgument(getAvailableSampleRatesDefinition, "chn_idx", "uint32");
defineOutput(getAvailableSampleRatesDefinition, "RetVal", "clib.array.libm2k.Double");
validate(getAvailableSampleRatesDefinition);

%% C++ class method |getMaximumSamplerate| for C++ class |libm2k::analog::GenericAnalogIn| 
% C++ Signature: double libm2k::analog::GenericAnalogIn::getMaximumSamplerate()

getMaximumSamplerateDefinition = addMethod(GenericAnalogInDefinition, ...
    "double libm2k::analog::GenericAnalogIn::getMaximumSamplerate()", ...
    "MATLABName", "getMaximumSamplerate", ...
    "Description", "getMaximumSamplerate Method of C++ class libm2k::analog::GenericAnalogIn."); % Modify help description values as needed.
defineOutput(getMaximumSamplerateDefinition, "RetVal", "double");
validate(getMaximumSamplerateDefinition);

%% C++ class method |getMaximumSamplerate| for C++ class |libm2k::analog::GenericAnalogIn| 
% C++ Signature: double libm2k::analog::GenericAnalogIn::getMaximumSamplerate(unsigned int chn_idx)

getMaximumSamplerateDefinition = addMethod(GenericAnalogInDefinition, ...
    "double libm2k::analog::GenericAnalogIn::getMaximumSamplerate(unsigned int chn_idx)", ...
    "MATLABName", "getMaximumSamplerate", ...
    "Description", "getMaximumSamplerate Method of C++ class libm2k::analog::GenericAnalogIn."); % Modify help description values as needed.
defineArgument(getMaximumSamplerateDefinition, "chn_idx", "uint32");
defineOutput(getMaximumSamplerateDefinition, "RetVal", "double");
validate(getMaximumSamplerateDefinition);

%% C++ class method |enableChannel| for C++ class |libm2k::analog::GenericAnalogIn| 
% C++ Signature: void libm2k::analog::GenericAnalogIn::enableChannel(unsigned int index,bool enable)

enableChannelDefinition = addMethod(GenericAnalogInDefinition, ...
    "void libm2k::analog::GenericAnalogIn::enableChannel(unsigned int index,bool enable)", ...
    "MATLABName", "enableChannel", ...
    "Description", "enableChannel Method of C++ class libm2k::analog::GenericAnalogIn."); % Modify help description values as needed.
defineArgument(enableChannelDefinition, "index", "uint32");
defineArgument(enableChannelDefinition, "enable", "logical");
validate(enableChannelDefinition);

%% C++ class method |setKernelBuffersCount| for C++ class |libm2k::analog::GenericAnalogIn| 
% C++ Signature: void libm2k::analog::GenericAnalogIn::setKernelBuffersCount(unsigned int count)

setKernelBuffersCountDefinition = addMethod(GenericAnalogInDefinition, ...
    "void libm2k::analog::GenericAnalogIn::setKernelBuffersCount(unsigned int count)", ...
    "MATLABName", "setKernelBuffersCount", ...
    "Description", "setKernelBuffersCount Method of C++ class libm2k::analog::GenericAnalogIn."); % Modify help description values as needed.
defineArgument(setKernelBuffersCountDefinition, "count", "uint32");
validate(setKernelBuffersCountDefinition);

%% C++ class method |getDeviceName| for C++ class |libm2k::analog::GenericAnalogIn| 
% C++ Signature: std::string libm2k::analog::GenericAnalogIn::getDeviceName()

getDeviceNameDefinition = addMethod(GenericAnalogInDefinition, ...
    "std::string libm2k::analog::GenericAnalogIn::getDeviceName()", ...
    "MATLABName", "getDeviceName", ...
    "Description", "getDeviceName Method of C++ class libm2k::analog::GenericAnalogIn."); % Modify help description values as needed.
defineOutput(getDeviceNameDefinition, "RetVal", "string");
validate(getDeviceNameDefinition);

%% C++ class method |getNbChannels| for C++ class |libm2k::analog::GenericAnalogIn| 
% C++ Signature: unsigned int libm2k::analog::GenericAnalogIn::getNbChannels()

getNbChannelsDefinition = addMethod(GenericAnalogInDefinition, ...
    "unsigned int libm2k::analog::GenericAnalogIn::getNbChannels()", ...
    "MATLABName", "getNbChannels", ...
    "Description", "getNbChannels Method of C++ class libm2k::analog::GenericAnalogIn."); % Modify help description values as needed.
defineOutput(getNbChannelsDefinition, "RetVal", "uint32");
validate(getNbChannelsDefinition);

%% C++ class |libm2k::context::Context| with MATLAB name |clib.libm2k.libm2k.context.Context| 
ContextDefinition = addClass(libDef, "libm2k::context::Context", "MATLABName", "clib.libm2k.libm2k.context.Context", ...
    "Description", "clib.libm2k.libm2k.context.Context    Representation of C++ class libm2k::context::Context." + newline + ...
    "Contains the representation of a generic IIO context" + newline + ...
    "" + newline + ...
    "@class Context context.hpp libm2k/context.hpp" + newline + ...
    "@brief Controls the IIO context"); % Modify help description values as needed.

%% C++ class method |reset| for C++ class |libm2k::context::Context| 
% C++ Signature: void libm2k::context::Context::reset()

resetDefinition = addMethod(ContextDefinition, ...
    "void libm2k::context::Context::reset()", ...
    "MATLABName", "reset", ...
    "Description", "reset Method of C++ class libm2k::context::Context.", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@private"); % Modify help description values as needed.
validate(resetDefinition);

%% C++ class method |deinitialize| for C++ class |libm2k::context::Context| 
% C++ Signature: void libm2k::context::Context::deinitialize()

deinitializeDefinition = addMethod(ContextDefinition, ...
    "void libm2k::context::Context::deinitialize()", ...
    "MATLABName", "deinitialize", ...
    "Description", "deinitialize Method of C++ class libm2k::context::Context.", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@private"); % Modify help description values as needed.
validate(deinitializeDefinition);

%% C++ class method |getUri| for C++ class |libm2k::context::Context| 
% C++ Signature: std::string libm2k::context::Context::getUri()

getUriDefinition = addMethod(ContextDefinition, ...
    "std::string libm2k::context::Context::getUri()", ...
    "MATLABName", "getUri", ...
    "Description", "getUri Method of C++ class libm2k::context::Context." + newline + ...
    "Get the URI of the current context", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getUriDefinition, "RetVal", "string", "Description", "string containing the context URI (ex: ""usb:1.2.3"", ""ip:192.168.2.1"")");
validate(getUriDefinition);

%% C++ class method |getDMM| for C++ class |libm2k::context::Context| 
% C++ Signature: libm2k::analog::DMM * libm2k::context::Context::getDMM(unsigned int index)

getDMMDefinition = addMethod(ContextDefinition, ...
   "libm2k::analog::DMM * libm2k::context::Context::getDMM(unsigned int index)", ...
   "MATLABName", "getDMM", ...
   "Description", "getDMM Method of C++ class libm2k::context::Context." + newline + ...
   "Retrieve the DMM object at a certain index", ...
   "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getDMMDefinition, "index", "uint32", "Description", "index The index corresponding to the DMM");
defineOutput(getDMMDefinition, "RetVal", "clib.libm2k.libm2k.analog.DMM", 1, "Description", "On success, a pointer to a DMM object");
validate(getDMMDefinition);

%% C++ class method |getDMM| for C++ class |libm2k::context::Context| 
% C++ Signature: libm2k::analog::DMM * libm2k::context::Context::getDMM(std::string name)

getDMMDefinition = addMethod(ContextDefinition, ...
   "libm2k::analog::DMM * libm2k::context::Context::getDMM(std::string name)", ...
   "MATLABName", "getDMM", ...
   "Description", "getDMM Method of C++ class libm2k::context::Context." + newline + ...
   "Retrieve the DMM object which has the provided name", ...
   "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getDMMDefinition, "name", "string", "Description", "name The name corresponding to the DMM");
defineOutput(getDMMDefinition, "RetVal", "clib.libm2k.libm2k.analog.DMM", 1, "Description", "On success, a pointer to a DMM object");
validate(getDMMDefinition);

%% C++ class method |getAvailableContextAttributes| for C++ class |libm2k::context::Context| 
% C++ Signature: std::vector<std::string> libm2k::context::Context::getAvailableContextAttributes()

getAvailableContextAttributesDefinition = addMethod(ContextDefinition, ...
    "std::vector<std::string> libm2k::context::Context::getAvailableContextAttributes()", ...
    "MATLABName", "getAvailableContextAttributes", ...
    "Description", "getAvailableContextAttributes Method of C++ class libm2k::context::Context." + newline + ...
    "Retrieve all the available context attributes", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getAvailableContextAttributesDefinition, "RetVal", "clib.array.libm2k.std.String", "Description", "A list of strings containing all the context attributes");
validate(getAvailableContextAttributesDefinition);

%% C++ class method |getContextAttributeValue| for C++ class |libm2k::context::Context| 
% C++ Signature: std::string libm2k::context::Context::getContextAttributeValue(std::string attr)

getContextAttributeValueDefinition = addMethod(ContextDefinition, ...
    "std::string libm2k::context::Context::getContextAttributeValue(std::string attr)", ...
    "MATLABName", "getContextAttributeValue", ...
    "Description", "getContextAttributeValue Method of C++ class libm2k::context::Context." + newline + ...
    "Retrieve the value of one context attribute", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getContextAttributeValueDefinition, "attr", "string", "Description", "attr The name of the required attribute");
defineOutput(getContextAttributeValueDefinition, "RetVal", "string", "Description", "On success, return a string containing the value of the attribute" + newline + ...
    "	 @throw On error, throw an exception if the attribute is not found");
validate(getContextAttributeValueDefinition);

%% C++ class method |getContextDescription| for C++ class |libm2k::context::Context| 
% C++ Signature: std::string libm2k::context::Context::getContextDescription()

getContextDescriptionDefinition = addMethod(ContextDefinition, ...
    "std::string libm2k::context::Context::getContextDescription()", ...
    "MATLABName", "getContextDescription", ...
    "Description", "getContextDescription Method of C++ class libm2k::context::Context." + newline + ...
    "Retrieve a detailed context description", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getContextDescriptionDefinition, "RetVal", "string", "Description", "string containing the current context description");
validate(getContextDescriptionDefinition);

%% C++ class method |getSerialNumber| for C++ class |libm2k::context::Context| 
% C++ Signature: std::string libm2k::context::Context::getSerialNumber()

getSerialNumberDefinition = addMethod(ContextDefinition, ...
    "std::string libm2k::context::Context::getSerialNumber()", ...
    "MATLABName", "getSerialNumber", ...
    "Description", "getSerialNumber Method of C++ class libm2k::context::Context." + newline + ...
    "Retrieve the current context serial number", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getSerialNumberDefinition, "RetVal", "string", "Description", "string containing the current context serial number");
validate(getSerialNumberDefinition);

%% C++ class method |logAllAttributes| for C++ class |libm2k::context::Context| 
% C++ Signature: void libm2k::context::Context::logAllAttributes() const

logAllAttributesDefinition = addMethod(ContextDefinition, ...
    "void libm2k::context::Context::logAllAttributes() const", ...
    "MATLABName", "logAllAttributes", ...
    "Description", "logAllAttributes Method of C++ class libm2k::context::Context." + newline + ...
    "Log all the attributes" + newline + ...
    "	 @note The logging system should be enabled", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@brief Log all the attributes" + newline + ...
    "	 @note The logging system should be enabled"); % Modify help description values as needed.
validate(logAllAttributesDefinition);

%% C++ class method |toM2k| for C++ class |libm2k::context::Context| 
% C++ Signature: libm2k::context::M2k * libm2k::context::Context::toM2k()

%toM2kDefinition = addMethod(ContextDefinition, ...
%    "libm2k::context::M2k * libm2k::context::Context::toM2k()", ...
%    "MATLABName", "toM2k", ...
%    "Description", "toM2k Method of C++ class libm2k::context::Context." + newline + ...
%    "Convert the current context to M2k context, if possible", ...
%    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
%defineOutput(toM2kDefinition, "RetVal", "clib.libm2k.libm2k.context.M2k", <SHAPE>, "Description", "On success, return the corresponding M2k object");
%validate(toM2kDefinition);

%% C++ class method |toGeneric| for C++ class |libm2k::context::Context| 
% C++ Signature: libm2k::context::Generic * libm2k::context::Context::toGeneric()

%toGenericDefinition = addMethod(ContextDefinition, ...
%    "libm2k::context::Generic * libm2k::context::Context::toGeneric()", ...
%    "MATLABName", "toGeneric", ...
%    "Description", "toGeneric Method of C++ class libm2k::context::Context." + newline + ...
%    "Convert the current context to Generic context, if possible", ...
%    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
%defineOutput(toGenericDefinition, "RetVal", "clib.libm2k.libm2k.context.Generic", <SHAPE>, "Description", "On success, return the corresponding Generic object");
%validate(toGenericDefinition);

%% C++ class method |getDmmCount| for C++ class |libm2k::context::Context| 
% C++ Signature: unsigned int libm2k::context::Context::getDmmCount()

getDmmCountDefinition = addMethod(ContextDefinition, ...
    "unsigned int libm2k::context::Context::getDmmCount()", ...
    "MATLABName", "getDmmCount", ...
    "Description", "getDmmCount Method of C++ class libm2k::context::Context." + newline + ...
    "Retrieve the number of DMM objects", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getDmmCountDefinition, "RetVal", "uint32", "Description", "an unsigned int representing the number of DMM objects in the context");
validate(getDmmCountDefinition);

%% C++ class method |getFirmwareVersion| for C++ class |libm2k::context::Context| 
% C++ Signature: std::string libm2k::context::Context::getFirmwareVersion()

getFirmwareVersionDefinition = addMethod(ContextDefinition, ...
    "std::string libm2k::context::Context::getFirmwareVersion()", ...
    "MATLABName", "getFirmwareVersion", ...
    "Description", "getFirmwareVersion Method of C++ class libm2k::context::Context." + newline + ...
    "Retrieve the firmware version of the current context", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getFirmwareVersionDefinition, "RetVal", "string", "Description", "a string containing the firmware version");
validate(getFirmwareVersionDefinition);

%% C++ class method |getIioContextVersion| for C++ class |libm2k::context::Context| 
% C++ Signature: libm2k::IIO_CONTEXT_VERSION const libm2k::context::Context::getIioContextVersion()

getIioContextVersionDefinition = addMethod(ContextDefinition, ...
    "libm2k::IIO_CONTEXT_VERSION const libm2k::context::Context::getIioContextVersion()", ...
    "MATLABName", "getIioContextVersion", ...
    "Description", "getIioContextVersion Method of C++ class libm2k::context::Context.", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "Get the version of the backend in use"); % Modify help description values as needed.
defineOutput(getIioContextVersionDefinition, "RetVal", "clib.libm2k.libm2k.IIO_CONTEXT_VERSION", "Description", "IIO_CONTEXT_VERSION struct");
validate(getIioContextVersionDefinition);

%% C++ class method |getIioContext| for C++ class |libm2k::context::Context| 
% C++ Signature: iio_context * libm2k::context::Context::getIioContext()

getIioContextDefinition = addMethod(ContextDefinition, ...
   "iio_context * libm2k::context::Context::getIioContext()", ...
   "MATLABName", "getIioContext", ...
   "Description", "getIioContext Method of C++ class libm2k::context::Context.", ...
   "DetailedDescription", "This content is from the external library documentation." + newline + ...
   "" + newline + ...
   "Retrieve the iio context"); % Modify help description values as needed.
defineOutput(getIioContextDefinition, "RetVal", "clib.libm2k.iio_context", 1, "Description", "A pointer to the iio context");
validate(getIioContextDefinition);

%% C++ class method |setTimeout| for C++ class |libm2k::context::Context| 
% C++ Signature: void libm2k::context::Context::setTimeout(unsigned int timeout)

setTimeoutDefinition = addMethod(ContextDefinition, ...
    "void libm2k::context::Context::setTimeout(unsigned int timeout)", ...
    "MATLABName", "setTimeout", ...
    "Description", "setTimeout Method of C++ class libm2k::context::Context." + newline + ...
    "Set a timeout for I/O operations", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setTimeoutDefinition, "timeout", "uint32", "Description", "timeout A positive integer representing the time in milliseconds after which a timeout occurs. A value of 0 is used to specify that no timeout should occur.");
validate(setTimeoutDefinition);

%% C++ class |libm2k::context::M2k| with MATLAB name |clib.libm2k.libm2k.context.M2k| 
M2kDefinition = addClass(libDef, "libm2k::context::M2k", "MATLABName", "clib.libm2k.libm2k.context.M2k", ...
    "Description", "clib.libm2k.libm2k.context.M2k    Representation of C++ class libm2k::context::M2k." + newline + ...
    "Contains the representation of the M2K" + newline + ...
    "" + newline + ...
    "@class M2k m2k.hpp libm2k/m2k.hpp" + newline + ...
    "@brief Controls the ADALM2000", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@defgroup m2k M2k" + newline + ...
    "@brief Contains the representation of the M2K" + newline + ...
    "" + newline + ...
    "@class M2k m2k.hpp libm2k/m2k.hpp" + newline + ...
    "@brief Controls the ADALM2000"); % Modify help description values as needed.

%% C++ class method |reset| for C++ class |libm2k::context::M2k| 
% C++ Signature: void libm2k::context::M2k::reset()

resetDefinition = addMethod(M2kDefinition, ...
    "void libm2k::context::M2k::reset()", ...
    "MATLABName", "reset", ...
    "Description", "reset Method of C++ class libm2k::context::M2k." + newline + ...
    "Reset the M2K device to default settings:" + newline + ...
    "	 *	- Reset calibration coefficients" + newline + ...
    "	 *	- Maximum samplerates" + newline + ...
    "	 *	- Set oversampling ratio to 1" + newline + ...
    "	 *	- Set AnalogIn range to low range" + newline + ...
    "	 *	- Set kernel buffers count to 4 (analog/digital and in/out devices)" + newline + ...
    "	 *	- Disable all TX digital channels and enable all RX digital channels" + newline + ...
    "	 @note A calibration is needed afterwards", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@brief Reset the M2K device to default settings:" + newline + ...
    "	 *	- Reset calibration coefficients" + newline + ...
    "	 *	- Maximum samplerates" + newline + ...
    "	 *	- Set oversampling ratio to 1" + newline + ...
    "	 *	- Set AnalogIn range to low range" + newline + ...
    "	 *	- Set kernel buffers count to 4 (analog/digital and in/out devices)" + newline + ...
    "	 *	- Disable all TX digital channels and enable all RX digital channels" + newline + ...
    "	 @note A calibration is needed afterwards"); % Modify help description values as needed.
validate(resetDefinition);

%% C++ class method |deinitialize| for C++ class |libm2k::context::M2k| 
% C++ Signature: void libm2k::context::M2k::deinitialize()

deinitializeDefinition = addMethod(M2kDefinition, ...
    "void libm2k::context::M2k::deinitialize()", ...
    "MATLABName", "deinitialize", ...
    "Description", "deinitialize Method of C++ class libm2k::context::M2k.", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@private"); % Modify help description values as needed.
validate(deinitializeDefinition);

%% C++ class method |calibrate| for C++ class |libm2k::context::M2k| 
% C++ Signature: bool libm2k::context::M2k::calibrate()

calibrateDefinition = addMethod(M2kDefinition, ...
    "bool libm2k::context::M2k::calibrate()", ...
    "MATLABName", "calibrate", ...
    "Description", "calibrate Method of C++ class libm2k::context::M2k.", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@private"); % Modify help description values as needed.
defineOutput(calibrateDefinition, "RetVal", "logical");
validate(calibrateDefinition);

%% C++ class method |calibrateADC| for C++ class |libm2k::context::M2k| 
% C++ Signature: bool libm2k::context::M2k::calibrateADC()

calibrateADCDefinition = addMethod(M2kDefinition, ...
    "bool libm2k::context::M2k::calibrateADC()", ...
    "MATLABName", "calibrateADC", ...
    "Description", "calibrateADC Method of C++ class libm2k::context::M2k." + newline + ...
    "Calibrate the ADC", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(calibrateADCDefinition, "RetVal", "logical", "Description", "On succces, true");
validate(calibrateADCDefinition);

%% C++ class method |calibrateDAC| for C++ class |libm2k::context::M2k| 
% C++ Signature: bool libm2k::context::M2k::calibrateDAC()

calibrateDACDefinition = addMethod(M2kDefinition, ...
    "bool libm2k::context::M2k::calibrateDAC()", ...
    "MATLABName", "calibrateDAC", ...
    "Description", "calibrateDAC Method of C++ class libm2k::context::M2k." + newline + ...
    "Calibrate the DAC", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(calibrateDACDefinition, "RetVal", "logical", "Description", "On succces, true");
validate(calibrateDACDefinition);

%% C++ class method |resetCalibration| for C++ class |libm2k::context::M2k| 
% C++ Signature: bool libm2k::context::M2k::resetCalibration()

resetCalibrationDefinition = addMethod(M2kDefinition, ...
    "bool libm2k::context::M2k::resetCalibration()", ...
    "MATLABName", "resetCalibration", ...
    "Description", "resetCalibration Method of C++ class libm2k::context::M2k.", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@private"); % Modify help description values as needed.
defineOutput(resetCalibrationDefinition, "RetVal", "logical");
validate(resetCalibrationDefinition);

%% C++ class method |calibrateFromContext| for C++ class |libm2k::context::M2k| 
% C++ Signature: double libm2k::context::M2k::calibrateFromContext()

calibrateFromContextDefinition = addMethod(M2kDefinition, ...
    "double libm2k::context::M2k::calibrateFromContext()", ...
    "MATLABName", "calibrateFromContext", ...
    "Description", "calibrateFromContext Method of C++ class libm2k::context::M2k." + newline + ...
    "Calibrate both ADC and DACs using predefined calibration values located in context", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(calibrateFromContextDefinition, "RetVal", "double", "Description", "The closest temperature found in the lookup table");
validate(calibrateFromContextDefinition);

%% C++ class method |getDigital| for C++ class |libm2k::context::M2k| 
% C++ Signature: libm2k::digital::M2kDigital * libm2k::context::M2k::getDigital()

getDigitalDefinition = addMethod(M2kDefinition, ...
   "libm2k::digital::M2kDigital * libm2k::context::M2k::getDigital()", ...
   "MATLABName", "getDigital", ...
   "Description", "getDigital Method of C++ class libm2k::context::M2k." + newline + ...
   "Retrieve the Digital object", ...
   "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getDigitalDefinition, "RetVal", "clib.libm2k.libm2k.digital.M2kDigital", 1, "Description", "On success, a pointer to a Digital object" + newline + ...
   "	@throw EXC_INVALID_PARAMETER No M2K digital device found");
validate(getDigitalDefinition);

%% C++ class method |getPowerSupply| for C++ class |libm2k::context::M2k| 
% C++ Signature: libm2k::analog::M2kPowerSupply * libm2k::context::M2k::getPowerSupply()

getPowerSupplyDefinition = addMethod(M2kDefinition, ...
   "libm2k::analog::M2kPowerSupply * libm2k::context::M2k::getPowerSupply()", ...
   "MATLABName", "getPowerSupply", ...
   "Description", "getPowerSupply Method of C++ class libm2k::context::M2k." + newline + ...
   "Retrieve the PowerSupply object", ...
   "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getPowerSupplyDefinition, "RetVal", "clib.libm2k.libm2k.analog.M2kPowerSupply", 1, "Description", "On success, a pointer to a PowerSupply object" + newline + ...
   "	@throw EXC_INVALID_PARAMETER No M2K power supply");
validate(getPowerSupplyDefinition);

%% C++ class method |getAnalogIn| for C++ class |libm2k::context::M2k| 
% C++ Signature: libm2k::analog::M2kAnalogIn * libm2k::context::M2k::getAnalogIn()

getAnalogInDefinition = addMethod(M2kDefinition, ...
   "libm2k::analog::M2kAnalogIn * libm2k::context::M2k::getAnalogIn()", ...
   "MATLABName", "getAnalogIn", ...
   "Description", "getAnalogIn Method of C++ class libm2k::context::M2k." + newline + ...
   "Retrieve the AnalogIn object", ...
   "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getAnalogInDefinition, "RetVal", "clib.libm2k.libm2k.analog.M2kAnalogIn", 1, "Description", "On success, a pointer to an AnalogIn object");
validate(getAnalogInDefinition);

%% C++ class method |getAnalogIn| for C++ class |libm2k::context::M2k| 
% C++ Signature: libm2k::analog::M2kAnalogIn * libm2k::context::M2k::getAnalogIn(std::string dev_name)

getAnalogInDefinition = addMethod(M2kDefinition, ...
   "libm2k::analog::M2kAnalogIn * libm2k::context::M2k::getAnalogIn(std::string dev_name)", ...
   "MATLABName", "getAnalogIn", ...
   "Description", "getAnalogIn Method of C++ class libm2k::context::M2k." + newline + ...
   "Retrieve the AnalogIn object of a device", ...
   "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getAnalogInDefinition, "dev_name", "string", "Description", "dev_name The name corresponding to a device");
defineOutput(getAnalogInDefinition, "RetVal", "clib.libm2k.libm2k.analog.M2kAnalogIn", 1, "Description", "On success, a pointer to an AnalogIn object");
validate(getAnalogInDefinition);

%% C++ class method |getAnalogOut| for C++ class |libm2k::context::M2k| 
% C++ Signature: libm2k::analog::M2kAnalogOut * libm2k::context::M2k::getAnalogOut()

getAnalogOutDefinition = addMethod(M2kDefinition, ...
   "libm2k::analog::M2kAnalogOut * libm2k::context::M2k::getAnalogOut()", ...
   "MATLABName", "getAnalogOut", ...
   "Description", "getAnalogOut Method of C++ class libm2k::context::M2k." + newline + ...
   "Retrieve the AnalogOut object", ...
   "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getAnalogOutDefinition, "RetVal", "clib.libm2k.libm2k.analog.M2kAnalogOut", 1, "Description", "On success, a pointer to an AnalogOut object");
validate(getAnalogOutDefinition);

%% C++ class method |hasMixedSignal| for C++ class |libm2k::context::M2k| 
% C++ Signature: bool libm2k::context::M2k::hasMixedSignal()

hasMixedSignalDefinition = addMethod(M2kDefinition, ...
    "bool libm2k::context::M2k::hasMixedSignal()", ...
    "MATLABName", "hasMixedSignal", ...
    "Description", "hasMixedSignal Method of C++ class libm2k::context::M2k." + newline + ...
    "Check if the mixed signal acquisition is available on the current firmware version", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(hasMixedSignalDefinition, "RetVal", "logical", "Description", "True if the mixed signal acquisition is available, false otherwise");
validate(hasMixedSignalDefinition);

%% C++ class method |startMixedSignalAcquisition| for C++ class |libm2k::context::M2k| 
% C++ Signature: void libm2k::context::M2k::startMixedSignalAcquisition(unsigned int nb_samples)

startMixedSignalAcquisitionDefinition = addMethod(M2kDefinition, ...
    "void libm2k::context::M2k::startMixedSignalAcquisition(unsigned int nb_samples)", ...
    "MATLABName", "startMixedSignalAcquisition", ...
    "Description", "startMixedSignalAcquisition Method of C++ class libm2k::context::M2k." + newline + ...
    "Initiate the mixed acquisition", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(startMixedSignalAcquisitionDefinition, "nb_samples", "uint32", "Description", "nb_samples The number of samples that will be retrieved");
validate(startMixedSignalAcquisitionDefinition);

%% C++ class method |stopMixedSignalAcquisition| for C++ class |libm2k::context::M2k| 
% C++ Signature: void libm2k::context::M2k::stopMixedSignalAcquisition()

stopMixedSignalAcquisitionDefinition = addMethod(M2kDefinition, ...
    "void libm2k::context::M2k::stopMixedSignalAcquisition()", ...
    "MATLABName", "stopMixedSignalAcquisition", ...
    "Description", "stopMixedSignalAcquisition Method of C++ class libm2k::context::M2k." + newline + ...
    "Stop the mixed acquisition", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@note Only available from firmware v0.26."); % Modify help description values as needed.
validate(stopMixedSignalAcquisitionDefinition);

%% C++ class method |getDacCalibrationOffset| for C++ class |libm2k::context::M2k| 
% C++ Signature: int libm2k::context::M2k::getDacCalibrationOffset(unsigned int chn)

getDacCalibrationOffsetDefinition = addMethod(M2kDefinition, ...
    "int libm2k::context::M2k::getDacCalibrationOffset(unsigned int chn)", ...
    "MATLABName", "getDacCalibrationOffset", ...
    "Description", "getDacCalibrationOffset Method of C++ class libm2k::context::M2k." + newline + ...
    "Get the calibration offset of the DAC", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getDacCalibrationOffsetDefinition, "chn", "uint32", "Description", "chn The index corresponding to a channel");
defineOutput(getDacCalibrationOffsetDefinition, "RetVal", "int32", "Description", "The value of the calibration offset");
validate(getDacCalibrationOffsetDefinition);

%% C++ class method |getDacCalibrationGain| for C++ class |libm2k::context::M2k| 
% C++ Signature: double libm2k::context::M2k::getDacCalibrationGain(unsigned int chn)

getDacCalibrationGainDefinition = addMethod(M2kDefinition, ...
    "double libm2k::context::M2k::getDacCalibrationGain(unsigned int chn)", ...
    "MATLABName", "getDacCalibrationGain", ...
    "Description", "getDacCalibrationGain Method of C++ class libm2k::context::M2k." + newline + ...
    "Get the calibration gain of the DAC", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getDacCalibrationGainDefinition, "chn", "uint32", "Description", "chn The index corresponding to a channel");
defineOutput(getDacCalibrationGainDefinition, "RetVal", "double", "Description", "The value of the calibration gain");
validate(getDacCalibrationGainDefinition);

%% C++ class method |getAdcCalibrationOffset| for C++ class |libm2k::context::M2k| 
% C++ Signature: int libm2k::context::M2k::getAdcCalibrationOffset(unsigned int chn)

getAdcCalibrationOffsetDefinition = addMethod(M2kDefinition, ...
    "int libm2k::context::M2k::getAdcCalibrationOffset(unsigned int chn)", ...
    "MATLABName", "getAdcCalibrationOffset", ...
    "Description", "getAdcCalibrationOffset Method of C++ class libm2k::context::M2k." + newline + ...
    "Get the calibration offset of the ADC", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getAdcCalibrationOffsetDefinition, "chn", "uint32", "Description", "chn The index corresponding to a channel");
defineOutput(getAdcCalibrationOffsetDefinition, "RetVal", "int32", "Description", "The value of the calibration offset");
validate(getAdcCalibrationOffsetDefinition);

%% C++ class method |getAdcCalibrationGain| for C++ class |libm2k::context::M2k| 
% C++ Signature: double libm2k::context::M2k::getAdcCalibrationGain(unsigned int chn)

getAdcCalibrationGainDefinition = addMethod(M2kDefinition, ...
    "double libm2k::context::M2k::getAdcCalibrationGain(unsigned int chn)", ...
    "MATLABName", "getAdcCalibrationGain", ...
    "Description", "getAdcCalibrationGain Method of C++ class libm2k::context::M2k." + newline + ...
    "Get the calibration gain of the ADC", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(getAdcCalibrationGainDefinition, "chn", "uint32", "Description", "chn The index corresponding to a channel");
defineOutput(getAdcCalibrationGainDefinition, "RetVal", "double", "Description", "The value of the calibration gain");
validate(getAdcCalibrationGainDefinition);

%% C++ class method |setDacCalibrationOffset| for C++ class |libm2k::context::M2k| 
% C++ Signature: void libm2k::context::M2k::setDacCalibrationOffset(unsigned int chn,int offset)

setDacCalibrationOffsetDefinition = addMethod(M2kDefinition, ...
    "void libm2k::context::M2k::setDacCalibrationOffset(unsigned int chn,int offset)", ...
    "MATLABName", "setDacCalibrationOffset", ...
    "Description", "setDacCalibrationOffset Method of C++ class libm2k::context::M2k." + newline + ...
    "Set the calibration offset of the DAC", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setDacCalibrationOffsetDefinition, "chn", "uint32", "Description", "chn The index corresponding to a channel");
defineArgument(setDacCalibrationOffsetDefinition, "offset", "int32", "Description", "offset The calibration offset value" + newline + ...
    "	@note Overrides the calibration coefficients.\n" + newline + ...
    "	Can be reset by running a calibration.");
validate(setDacCalibrationOffsetDefinition);

%% C++ class method |setDacCalibrationGain| for C++ class |libm2k::context::M2k| 
% C++ Signature: void libm2k::context::M2k::setDacCalibrationGain(unsigned int chn,double gain)

setDacCalibrationGainDefinition = addMethod(M2kDefinition, ...
    "void libm2k::context::M2k::setDacCalibrationGain(unsigned int chn,double gain)", ...
    "MATLABName", "setDacCalibrationGain", ...
    "Description", "setDacCalibrationGain Method of C++ class libm2k::context::M2k." + newline + ...
    "Set the calibration gain of the DAC", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setDacCalibrationGainDefinition, "chn", "uint32", "Description", "chn The index corresponding to a channel");
defineArgument(setDacCalibrationGainDefinition, "gain", "double", "Description", "gain The calibration gain value" + newline + ...
    "	@note Overrides the calibration coefficients.\n" + newline + ...
    "	Can be reset by running a calibration.\n" + newline + ...
    "	The gain value is currently limited at the (-2,2) range  by the hardware.");
validate(setDacCalibrationGainDefinition);

%% C++ class method |setAdcCalibrationOffset| for C++ class |libm2k::context::M2k| 
% C++ Signature: void libm2k::context::M2k::setAdcCalibrationOffset(unsigned int chn,int offset)

setAdcCalibrationOffsetDefinition = addMethod(M2kDefinition, ...
    "void libm2k::context::M2k::setAdcCalibrationOffset(unsigned int chn,int offset)", ...
    "MATLABName", "setAdcCalibrationOffset", ...
    "Description", "setAdcCalibrationOffset Method of C++ class libm2k::context::M2k." + newline + ...
    "Set the calibration offset of the ADC", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setAdcCalibrationOffsetDefinition, "chn", "uint32", "Description", "chn The index corresponding to a channel");
defineArgument(setAdcCalibrationOffsetDefinition, "offset", "int32", "Description", "offset The calibration offset value" + newline + ...
    "	@note Overrides the calibration coefficients.\n" + newline + ...
    "	Can be reset by running a calibration.");
validate(setAdcCalibrationOffsetDefinition);

%% C++ class method |setAdcCalibrationGain| for C++ class |libm2k::context::M2k| 
% C++ Signature: void libm2k::context::M2k::setAdcCalibrationGain(unsigned int chn,double gain)

setAdcCalibrationGainDefinition = addMethod(M2kDefinition, ...
    "void libm2k::context::M2k::setAdcCalibrationGain(unsigned int chn,double gain)", ...
    "MATLABName", "setAdcCalibrationGain", ...
    "Description", "setAdcCalibrationGain Method of C++ class libm2k::context::M2k." + newline + ...
    "Set the calibration gain of the ADC", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setAdcCalibrationGainDefinition, "chn", "uint32", "Description", "chn The index corresponding to a channel");
defineArgument(setAdcCalibrationGainDefinition, "gain", "double", "Description", "gain The calibration gain value" + newline + ...
    "	@note Overrides the calibration coefficients.\n" + newline + ...
    "	Can be reset by running a calibration.\n" + newline + ...
    "	The gain value is currently limited at the (-2,2) range  by the hardware.");
validate(setAdcCalibrationGainDefinition);

%% C++ class method |hasContextCalibration| for C++ class |libm2k::context::M2k| 
% C++ Signature: bool libm2k::context::M2k::hasContextCalibration()

hasContextCalibrationDefinition = addMethod(M2kDefinition, ...
    "bool libm2k::context::M2k::hasContextCalibration()", ...
    "MATLABName", "hasContextCalibration", ...
    "Description", "hasContextCalibration Method of C++ class libm2k::context::M2k." + newline + ...
    "Check if the calibration based on temperature can be performed", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(hasContextCalibrationDefinition, "RetVal", "logical", "Description", "True if the calibration parameters are available, False otherwise");
validate(hasContextCalibrationDefinition);

%% C++ class method |isCalibrated| for C++ class |libm2k::context::M2k| 
% C++ Signature: bool libm2k::context::M2k::isCalibrated()

isCalibratedDefinition = addMethod(M2kDefinition, ...
    "bool libm2k::context::M2k::isCalibrated()", ...
    "MATLABName", "isCalibrated", ...
    "Description", "isCalibrated Method of C++ class libm2k::context::M2k." + newline + ...
    "Check if the board was calibrated", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(isCalibratedDefinition, "RetVal", "logical", "Description", "True if the board was calibrated, False otherwise");
validate(isCalibratedDefinition);

%% C++ class method |setLed| for C++ class |libm2k::context::M2k| 
% C++ Signature: void libm2k::context::M2k::setLed(bool on)

setLedDefinition = addMethod(M2kDefinition, ...
    "void libm2k::context::M2k::setLed(bool on)", ...
    "MATLABName", "setLed", ...
    "Description", "setLed Method of C++ class libm2k::context::M2k." + newline + ...
    "Turn on or off the board's led", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(setLedDefinition, "on", "logical", "Description", "on A boolean value corresponding to the state of the led");
validate(setLedDefinition);

%% C++ class method |getLed| for C++ class |libm2k::context::M2k| 
% C++ Signature: bool libm2k::context::M2k::getLed()

getLedDefinition = addMethod(M2kDefinition, ...
    "bool libm2k::context::M2k::getLed()", ...
    "MATLABName", "getLed", ...
    "Description", "getLed Method of C++ class libm2k::context::M2k." + newline + ...
    "Retrieve the state of the led", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getLedDefinition, "RetVal", "logical", "Description", "If the led is turned on, true");
validate(getLedDefinition);

%% C++ class |libm2k::context::Generic| with MATLAB name |clib.libm2k.libm2k.context.Generic| 
GenericDefinition = addClass(libDef, "libm2k::context::Generic", "MATLABName", "clib.libm2k.libm2k.context.Generic", ...
    "Description", "clib.libm2k.libm2k.context.Generic    Representation of C++ class libm2k::context::Generic."); % Modify help description values as needed.

%% C++ class |libm2k::context::ContextBuilder| with MATLAB name |clib.libm2k.libm2k.context.ContextBuilder| 
ContextBuilderDefinition = addClass(libDef, "libm2k::context::ContextBuilder", "MATLABName", "clib.libm2k.libm2k.context.ContextBuilder", ...
    "Description", "clib.libm2k.libm2k.context.ContextBuilder    Representation of C++ class libm2k::context::ContextBuilder.", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@private"); % Modify help description values as needed.

%% C++ class constructor for C++ class |libm2k::context::ContextBuilder| 
% C++ Signature: libm2k::context::ContextBuilder::ContextBuilder()

ContextBuilderConstructor1Definition = addConstructor(ContextBuilderDefinition, ...
    "libm2k::context::ContextBuilder::ContextBuilder()", ...
    "Description", "clib.libm2k.libm2k.context.ContextBuilder Constructor of C++ class libm2k::context::ContextBuilder.", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@private"); % Modify help description values as needed.
validate(ContextBuilderConstructor1Definition);

%% C++ class method |getAllContexts| for C++ class |libm2k::context::ContextBuilder| 
% C++ Signature: static std::vector<std::string> libm2k::context::ContextBuilder::getAllContexts()

getAllContextsDefinition = addMethod(ContextBuilderDefinition, ...
    "static std::vector<std::string> libm2k::context::ContextBuilder::getAllContexts()", ...
    "MATLABName", "getAllContexts", ...
    "Description", "getAllContexts Method of C++ class libm2k::context::ContextBuilder.", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@private"); % Modify help description values as needed.
defineOutput(getAllContextsDefinition, "RetVal", "clib.array.libm2k.std.String");
validate(getAllContextsDefinition);

%% C++ class method |contextOpen| for C++ class |libm2k::context::ContextBuilder| 
% C++ Signature: static libm2k::context::Context * libm2k::context::ContextBuilder::contextOpen(char const * input1)

%contextOpenDefinition = addMethod(ContextBuilderDefinition, ...
%    "static libm2k::context::Context * libm2k::context::ContextBuilder::contextOpen(char const * input1)", ...
%    "MATLABName", "contextOpen", ...
%    "Description", "contextOpen Method of C++ class libm2k::context::ContextBuilder.", ...
%    "DetailedDescription", "This content is from the external library documentation." + newline + ...
%    "" + newline + ...
%    "@private"); % Modify help description values as needed.
%defineArgument(contextOpenDefinition, "input1", <MLTYPE>, "input", <SHAPE>); % <MLTYPE> can be "clib.array.libm2k.Char","int8","string", or "char"
%defineOutput(contextOpenDefinition, "RetVal", "clib.libm2k.libm2k.context.Context", <SHAPE>);
%validate(contextOpenDefinition);

%% C++ class method |contextOpen| for C++ class |libm2k::context::ContextBuilder| 
% C++ Signature: static libm2k::context::Context * libm2k::context::ContextBuilder::contextOpen(iio_context * input1,char const * input2)

%contextOpenDefinition = addMethod(ContextBuilderDefinition, ...
%    "static libm2k::context::Context * libm2k::context::ContextBuilder::contextOpen(iio_context * input1,char const * input2)", ...
%    "MATLABName", "contextOpen", ...
%    "Description", "contextOpen Method of C++ class libm2k::context::ContextBuilder.", ...
%    "DetailedDescription", "This content is from the external library documentation." + newline + ...
%    "" + newline + ...
%    "@private"); % Modify help description values as needed.
%defineArgument(contextOpenDefinition, "input1", "clib.libm2k.iio_context", "input", <SHAPE>);
%defineArgument(contextOpenDefinition, "input2", <MLTYPE>, "input", <SHAPE>); % <MLTYPE> can be "clib.array.libm2k.Char","int8","string", or "char"
%defineOutput(contextOpenDefinition, "RetVal", "clib.libm2k.libm2k.context.Context", <SHAPE>);
%validate(contextOpenDefinition);

%% C++ class method |contextOpen| for C++ class |libm2k::context::ContextBuilder| 
% C++ Signature: static libm2k::context::Context * libm2k::context::ContextBuilder::contextOpen()

%contextOpenDefinition = addMethod(ContextBuilderDefinition, ...
%    "static libm2k::context::Context * libm2k::context::ContextBuilder::contextOpen()", ...
%    "MATLABName", "contextOpen", ...
%    "Description", "contextOpen Method of C++ class libm2k::context::ContextBuilder.", ...
%    "DetailedDescription", "This content is from the external library documentation." + newline + ...
%    "" + newline + ...
%    "@private"); % Modify help description values as needed.
%defineOutput(contextOpenDefinition, "RetVal", "clib.libm2k.libm2k.context.Context", <SHAPE>);
%validate(contextOpenDefinition);

%% C++ class method |m2kOpen| for C++ class |libm2k::context::ContextBuilder| 
% C++ Signature: static libm2k::context::M2k * libm2k::context::ContextBuilder::m2kOpen(char const * input1)

%m2kOpenDefinition = addMethod(ContextBuilderDefinition, ...
%    "static libm2k::context::M2k * libm2k::context::ContextBuilder::m2kOpen(char const * input1)", ...
%    "MATLABName", "m2kOpen", ...
%    "Description", "m2kOpen Method of C++ class libm2k::context::ContextBuilder.", ...
%    "DetailedDescription", "This content is from the external library documentation." + newline + ...
%    "" + newline + ...
%    "@private"); % Modify help description values as needed.
%defineArgument(m2kOpenDefinition, "input1", <MLTYPE>, "input", <SHAPE>); % <MLTYPE> can be "clib.array.libm2k.Char","int8","string", or "char"
%defineOutput(m2kOpenDefinition, "RetVal", "clib.libm2k.libm2k.context.M2k", <SHAPE>);
%validate(m2kOpenDefinition);

%% C++ class method |m2kOpen| for C++ class |libm2k::context::ContextBuilder| 
% C++ Signature: static libm2k::context::M2k * libm2k::context::ContextBuilder::m2kOpen(iio_context * input1,char const * input2)

%m2kOpenDefinition = addMethod(ContextBuilderDefinition, ...
%    "static libm2k::context::M2k * libm2k::context::ContextBuilder::m2kOpen(iio_context * input1,char const * input2)", ...
%    "MATLABName", "m2kOpen", ...
%    "Description", "m2kOpen Method of C++ class libm2k::context::ContextBuilder.", ...
%    "DetailedDescription", "This content is from the external library documentation." + newline + ...
%    "" + newline + ...
%    "@private"); % Modify help description values as needed.
%defineArgument(m2kOpenDefinition, "input1", "clib.libm2k.iio_context", "input", <SHAPE>);
%defineArgument(m2kOpenDefinition, "input2", <MLTYPE>, "input", <SHAPE>); % <MLTYPE> can be "clib.array.libm2k.Char","int8","string", or "char"
%defineOutput(m2kOpenDefinition, "RetVal", "clib.libm2k.libm2k.context.M2k", <SHAPE>);
%validate(m2kOpenDefinition);

%% C++ class method |m2kOpen| for C++ class |libm2k::context::ContextBuilder| 
% C++ Signature: static libm2k::context::M2k * libm2k::context::ContextBuilder::m2kOpen()

%m2kOpenDefinition = addMethod(ContextBuilderDefinition, ...
%    "static libm2k::context::M2k * libm2k::context::ContextBuilder::m2kOpen()", ...
%    "MATLABName", "m2kOpen", ...
%    "Description", "m2kOpen Method of C++ class libm2k::context::ContextBuilder.", ...
%    "DetailedDescription", "This content is from the external library documentation." + newline + ...
%    "" + newline + ...
%    "@private"); % Modify help description values as needed.
%defineOutput(m2kOpenDefinition, "RetVal", "clib.libm2k.libm2k.context.M2k", <SHAPE>);
%validate(m2kOpenDefinition);

%% C++ class method |contextClose| for C++ class |libm2k::context::ContextBuilder| 
% C++ Signature: static void libm2k::context::ContextBuilder::contextClose(libm2k::context::Context * input1,bool deinit = 1)

%contextCloseDefinition = addMethod(ContextBuilderDefinition, ...
%    "static void libm2k::context::ContextBuilder::contextClose(libm2k::context::Context * input1,bool deinit = 1)", ...
%    "MATLABName", "contextClose", ...
%    "Description", "contextClose Method of C++ class libm2k::context::ContextBuilder.", ...
%    "DetailedDescription", "This content is from the external library documentation." + newline + ...
%    "" + newline + ...
%    "@private"); % Modify help description values as needed.
%defineArgument(contextCloseDefinition, "input1", "clib.libm2k.libm2k.context.Context", "input", <SHAPE>); % <MLTYPE> can be "clib.libm2k.libm2k.context.Context", or "clib.array.libm2k.libm2k.context.Context"
%defineArgument(contextCloseDefinition, "deinit", "logical");
%validate(contextCloseDefinition);

%% C++ class method |contextCloseAll| for C++ class |libm2k::context::ContextBuilder| 
% C++ Signature: static void libm2k::context::ContextBuilder::contextCloseAll()

contextCloseAllDefinition = addMethod(ContextBuilderDefinition, ...
    "static void libm2k::context::ContextBuilder::contextCloseAll()", ...
    "MATLABName", "contextCloseAll", ...
    "Description", "contextCloseAll Method of C++ class libm2k::context::ContextBuilder."); % Modify help description values as needed.
validate(contextCloseAllDefinition);

%% C++ class method |getVersion| for C++ class |libm2k::context::ContextBuilder| 
% C++ Signature: static std::string libm2k::context::ContextBuilder::getVersion()

getVersionDefinition = addMethod(ContextBuilderDefinition, ...
    "static std::string libm2k::context::ContextBuilder::getVersion()", ...
    "MATLABName", "getVersion", ...
    "Description", "getVersion Method of C++ class libm2k::context::ContextBuilder."); % Modify help description values as needed.
defineOutput(getVersionDefinition, "RetVal", "string");
validate(getVersionDefinition);

%% C++ class method |enableLogging| for C++ class |libm2k::context::ContextBuilder| 
% C++ Signature: static void libm2k::context::ContextBuilder::enableLogging(bool enable)

enableLoggingDefinition = addMethod(ContextBuilderDefinition, ...
    "static void libm2k::context::ContextBuilder::enableLogging(bool enable)", ...
    "MATLABName", "enableLogging", ...
    "Description", "enableLogging Method of C++ class libm2k::context::ContextBuilder.", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@private"); % Modify help description values as needed.
defineArgument(enableLoggingDefinition, "enable", "logical");
validate(enableLoggingDefinition);

%% C++ class constructor for C++ class |libm2k::context::ContextBuilder| 
% C++ Signature: libm2k::context::ContextBuilder::ContextBuilder(libm2k::context::ContextBuilder const & input1)

ContextBuilderConstructor2Definition = addConstructor(ContextBuilderDefinition, ...
    "libm2k::context::ContextBuilder::ContextBuilder(libm2k::context::ContextBuilder const & input1)", ...
    "Description", "clib.libm2k.libm2k.context.ContextBuilder Constructor of C++ class libm2k::context::ContextBuilder."); % Modify help description values as needed.
defineArgument(ContextBuilderConstructor2Definition, "input1", "clib.libm2k.libm2k.context.ContextBuilder", "input");
validate(ContextBuilderConstructor2Definition);

%% C++ function |libm2k::context::contextOpen| with MATLAB name |clib.libm2k.libm2k.context.contextOpen|
% C++ Signature: libm2k::context::Context * libm2k::context::contextOpen()

%contextOpenDefinition = addFunction(libDef, ...
%    "libm2k::context::Context * libm2k::context::contextOpen()", ...
%    "MATLABName", "clib.libm2k.libm2k.context.contextOpen", ...
%    "Description", "clib.libm2k.libm2k.context.contextOpen Representation of C++ function libm2k::context::contextOpen.", ...
%    "DetailedDescription", "This content is from the external library documentation." + newline + ...
%    "" + newline + ...
%    "@private"); % Modify help description values as needed.
%defineOutput(contextOpenDefinition, "RetVal", "clib.libm2k.libm2k.context.Context", <SHAPE>);
%validate(contextOpenDefinition);

%% C++ function |libm2k::context::contextOpen| with MATLAB name |clib.libm2k.libm2k.context.contextOpen|
% C++ Signature: libm2k::context::Context * libm2k::context::contextOpen(char const * uri)

%contextOpenDefinition = addFunction(libDef, ...
%    "libm2k::context::Context * libm2k::context::contextOpen(char const * uri)", ...
%    "MATLABName", "clib.libm2k.libm2k.context.contextOpen", ...
%    "Description", "clib.libm2k.libm2k.context.contextOpen Representation of C++ function libm2k::context::contextOpen.", ...
%    "DetailedDescription", "This content is from the external library documentation." + newline + ...
%    "" + newline + ...
%    "@private"); % Modify help description values as needed.
%defineArgument(contextOpenDefinition, "uri", <MLTYPE>, "input", <SHAPE>); % <MLTYPE> can be "clib.array.libm2k.Char","int8","string", or "char"
%defineOutput(contextOpenDefinition, "RetVal", "clib.libm2k.libm2k.context.Context", <SHAPE>);
%validate(contextOpenDefinition);

%% C++ function |libm2k::context::contextOpen| with MATLAB name |clib.libm2k.libm2k.context.contextOpen|
% C++ Signature: libm2k::context::Context * libm2k::context::contextOpen(iio_context * ctx,char const * uri)

%contextOpenDefinition = addFunction(libDef, ...
%    "libm2k::context::Context * libm2k::context::contextOpen(iio_context * ctx,char const * uri)", ...
%    "MATLABName", "clib.libm2k.libm2k.context.contextOpen", ...
%    "Description", "clib.libm2k.libm2k.context.contextOpen Representation of C++ function libm2k::context::contextOpen.", ...
%    "DetailedDescription", "This content is from the external library documentation." + newline + ...
%    "" + newline + ...
%    "@private"); % Modify help description values as needed.
%defineArgument(contextOpenDefinition, "ctx", "clib.libm2k.iio_context", "input", <SHAPE>);
%defineArgument(contextOpenDefinition, "uri", <MLTYPE>, "input", <SHAPE>); % <MLTYPE> can be "clib.array.libm2k.Char","int8","string", or "char"
%defineOutput(contextOpenDefinition, "RetVal", "clib.libm2k.libm2k.context.Context", <SHAPE>);
%validate(contextOpenDefinition);

%% C++ function |libm2k::context::m2kOpen| with MATLAB name |clib.libm2k.libm2k.context.m2kOpen|
% C++ Signature: libm2k::context::M2k * libm2k::context::m2kOpen(char const * uri)

m2kOpenDefinition = addFunction(libDef, ...
   "libm2k::context::M2k * libm2k::context::m2kOpen(char const * uri)", ...
   "MATLABName", "clib.libm2k.libm2k.context.m2kOpen", ...
   "Description", "clib.libm2k.libm2k.context.m2kOpen Representation of C++ function libm2k::context::m2kOpen." + newline + ...
   "Open an ADALM2000 based on a given uri", ...
   "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(m2kOpenDefinition, "uri", "string", "input", "nullTerminated", "Description", "uri Describe the location of the context"); % <MLTYPE> can be "clib.array.libm2k.Char","int8","string", or "char"
defineOutput(m2kOpenDefinition, "RetVal", "clib.libm2k.libm2k.context.M2k", 1, "Description", "M2k object or nullptr if no ADALM2000 was found/available");
validate(m2kOpenDefinition);

%% C++ function |libm2k::context::m2kOpen| with MATLAB name |clib.libm2k.libm2k.context.m2kOpen|
% C++ Signature: libm2k::context::M2k * libm2k::context::m2kOpen(iio_context * ctx,char const * uri)

%m2kOpenDefinition = addFunction(libDef, ...
%    "libm2k::context::M2k * libm2k::context::m2kOpen(iio_context * ctx,char const * uri)", ...
%    "MATLABName", "clib.libm2k.libm2k.context.m2kOpen", ...
%    "Description", "clib.libm2k.libm2k.context.m2kOpen Representation of C++ function libm2k::context::m2kOpen." + newline + ...
%    "Open an ADALM2000 based on an existing iio_context and uri", ...
%    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
%defineArgument(m2kOpenDefinition, "ctx", "clib.libm2k.iio_context", "input", <SHAPE>, "Description", "ctx A pointer to an iio_context structure");
%defineArgument(m2kOpenDefinition, "uri", <MLTYPE>, "input", <SHAPE>, "Description", "uri Describe the location of the context"); % <MLTYPE> can be "clib.array.libm2k.Char","int8","string", or "char"
%defineOutput(m2kOpenDefinition, "RetVal", "clib.libm2k.libm2k.context.M2k", <SHAPE>, "Description", "M2k object or nullptr if no ADALM2000 was found/available");
%validate(m2kOpenDefinition);

%% C++ function |libm2k::context::m2kOpen| with MATLAB name |clib.libm2k.libm2k.context.m2kOpen|
% C++ Signature: libm2k::context::M2k * libm2k::context::m2kOpen()

m2kOpenDefinition = addFunction(libDef, ...
   "libm2k::context::M2k * libm2k::context::m2kOpen()", ...
   "MATLABName", "clib.libm2k.libm2k.context.m2kOpen", ...
   "Description", "clib.libm2k.libm2k.context.m2kOpen Representation of C++ function libm2k::context::m2kOpen." + newline + ...
   "Open an ADALM2000", ...
   "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(m2kOpenDefinition, "RetVal", "clib.libm2k.libm2k.context.M2k", 1, "Description", "M2k object or nullptr if no ADALM2000 was found/available");
validate(m2kOpenDefinition);

%% C++ function |libm2k::context::getAllContexts| with MATLAB name |clib.libm2k.libm2k.context.getAllContexts|
% C++ Signature: std::vector<std::string> libm2k::context::getAllContexts()

getAllContextsDefinition = addFunction(libDef, ...
    "std::vector<std::string> libm2k::context::getAllContexts()", ...
    "MATLABName", "clib.libm2k.libm2k.context.getAllContexts", ...
    "Description", "clib.libm2k.libm2k.context.getAllContexts Representation of C++ function libm2k::context::getAllContexts." + newline + ...
    "List all available contexts", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getAllContextsDefinition, "RetVal", "clib.array.libm2k.std.String", "Description", "A list containing the available contexts");
validate(getAllContextsDefinition);

%% C++ function |libm2k::context::contextClose| with MATLAB name |clib.libm2k.libm2k.context.contextClose|
% C++ Signature: void libm2k::context::contextClose(libm2k::context::Context * ctx,bool deinit = 1)

%contextCloseDefinition = addFunction(libDef, ...
%    "void libm2k::context::contextClose(libm2k::context::Context * ctx,bool deinit = 1)", ...
%    "MATLABName", "clib.libm2k.libm2k.context.contextClose", ...
%    "Description", "clib.libm2k.libm2k.context.contextClose Representation of C++ function libm2k::context::contextClose." + newline + ...
%    "Destroy the given context", ...
%    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
%defineArgument(contextCloseDefinition, "ctx", "clib.libm2k.libm2k.context.Context", "input", <SHAPE>, "Description", "ctx The context to be destroyed"); % <MLTYPE> can be "clib.libm2k.libm2k.context.Context", or "clib.array.libm2k.libm2k.context.Context"
%defineArgument(contextCloseDefinition, "deinit", "logical", "Description", "deinit If deinit is set to false, running contexts won't be affected");
%validate(contextCloseDefinition);

%% C++ function |libm2k::context::contextCloseAll| with MATLAB name |clib.libm2k.libm2k.context.contextCloseAll|
% C++ Signature: void libm2k::context::contextCloseAll()

contextCloseAllDefinition = addFunction(libDef, ...
    "void libm2k::context::contextCloseAll()", ...
    "MATLABName", "clib.libm2k.libm2k.context.contextCloseAll", ...
    "Description", "clib.libm2k.libm2k.context.contextCloseAll Representation of C++ function libm2k::context::contextCloseAll." + newline + ...
    "Close all the devices", ...
    "DetailedDescription", "This content is from the external library documentation." + newline + ...
    "" + newline + ...
    "@brief Close all the devices"); % Modify help description values as needed.
validate(contextCloseAllDefinition);

%% C++ function |libm2k::context::getVersion| with MATLAB name |clib.libm2k.libm2k.context.getVersion|
% C++ Signature: std::string libm2k::context::getVersion()

getVersionDefinition = addFunction(libDef, ...
    "std::string libm2k::context::getVersion()", ...
    "MATLABName", "clib.libm2k.libm2k.context.getVersion", ...
    "Description", "clib.libm2k.libm2k.context.getVersion Representation of C++ function libm2k::context::getVersion." + newline + ...
    "Get library version", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineOutput(getVersionDefinition, "RetVal", "string", "Description", "a string containing the libm2k version");
validate(getVersionDefinition);

%% C++ function |libm2k::context::enableLogging| with MATLAB name |clib.libm2k.libm2k.context.enableLogging|
% C++ Signature: void libm2k::context::enableLogging(bool enable)

enableLoggingDefinition = addFunction(libDef, ...
    "void libm2k::context::enableLogging(bool enable)", ...
    "MATLABName", "clib.libm2k.libm2k.context.enableLogging", ...
    "Description", "clib.libm2k.libm2k.context.enableLogging Representation of C++ function libm2k::context::enableLogging." + newline + ...
    "Enable/disable the logging system", ...
    "DetailedDescription", "This content is from the external library documentation."); % Modify help description values as needed.
defineArgument(enableLoggingDefinition, "enable", "logical", "Description", "enable If true enable, otherwise disable");
validate(enableLoggingDefinition);

%% Validate the library definition
validate(libDef);

end
