//******************************************************************************
//  Copyright (c) 2005-2011 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#ifndef QX11INFO_X11_C_H
#define QX11INFO_X11_C_H

#include <qx11info_x11.h>
#include <QtGui>
#include "pascalbind.h"

#if defined BINUX
C_EXPORT QX11InfoH QX11Info_create();
C_EXPORT void QX11Info_destroy(QX11InfoH handle);
C_EXPORT QX11InfoH QX11Info_create2(const QX11InfoH other);
C_EXPORT Display* QX11Info_display();
C_EXPORT const char* QX11Info_appClass();
C_EXPORT int QX11Info_screen(QX11InfoH handle);
C_EXPORT int QX11Info_depth(QX11InfoH handle);
C_EXPORT int QX11Info_cells(QX11InfoH handle);
C_EXPORT Qt::HANDLE QX11Info_colormap(QX11InfoH handle);
C_EXPORT bool QX11Info_defaultColormap(QX11InfoH handle);
C_EXPORT void* QX11Info_visual(QX11InfoH handle);
C_EXPORT bool QX11Info_defaultVisual(QX11InfoH handle);
C_EXPORT int QX11Info_appScreen();
C_EXPORT int QX11Info_appDepth(int screen);
C_EXPORT int QX11Info_appCells(int screen);
C_EXPORT Qt::HANDLE QX11Info_appColormap(int screen);
C_EXPORT void* QX11Info_appVisual(int screen);
C_EXPORT Qt::HANDLE QX11Info_appRootWindow(int screen);
C_EXPORT bool QX11Info_appDefaultColormap(int screen);
C_EXPORT bool QX11Info_appDefaultVisual(int screen);
C_EXPORT int QX11Info_appDpiX(int screen);
C_EXPORT int QX11Info_appDpiY(int screen);
C_EXPORT void QX11Info_setAppDpiX(int screen, int dpi);
C_EXPORT void QX11Info_setAppDpiY(int screen, int dpi);
C_EXPORT unsigned long QX11Info_appTime();
C_EXPORT unsigned long QX11Info_appUserTime();
C_EXPORT void QX11Info_setAppTime(unsigned long time);
C_EXPORT void QX11Info_setAppUserTime(unsigned long time);
C_EXPORT bool QX11Info_isCompositingManagerRunning();
#endif

#endif
