[![Maven Central](https://img.shields.io/maven-central/v/org.mapsforge/mapsforge-core.svg)](https://search.maven.org/search?q=g:org.mapsforge)
[![Build Status](https://travis-ci.org/mapsforge/mapsforge.svg?branch=master)](https://travis-ci.org/mapsforge/mapsforge)
[![License: LGPL v3](https://img.shields.io/badge/License-LGPL%20v3-blue.svg)](http://www.gnu.org/licenses/lgpl-3.0)

# Mapsforge

See the **[integration guide](docs/Integration.md)** and [changelog](docs/Changelog.md). And read through [how to contribute](.github/CONTRIBUTING.md) guidelines.

If you have any questions or problems, don't hesitate to ask our public [mailing list](https://groups.google.com/group/mapsforge-dev) for help.

- Mapsforge project uses a [compact file format](docs/Specification-Binary-Map-File.md) for fast ad-hoc rendering of OpenStreetMap data.
- We provide tools to [compile your own maps](docs/Getting-Started-Map-Writer.md) with detailed [instructions](docs/MapCreation.md) and also [precompiled maps](http://download.mapsforge.org).
- It provides [simple boilerplate code](mapsforge-samples-android/src/main/java/org/mapsforge/samples/android/GettingStarted.java) to build applications for Android that display OpenStreetMap-based maps.
- It provides a library to build standalone applications in Java ([instructions](docs/Desktop.md)).
- Mapsforge maps can be flexibly styled with XML style files ([render themes](docs/Rendertheme.md)).
- We provide [tools & library](docs/POI.md) for POI search and also [precompiled POI](http://download.mapsforge.org).
- Mapsforge supports Android 2.3.3 (API level 10) and above.
- Mapsforge is used by many [applications](docs/Mapsforge-Applications.md).
- Mapsforge is in active [development](docs/Contributors.md). 
- Mapsforge [map providers](docs/Mapsforge-Maps.md).
- Mapsforge [talks](docs/Mapsforge-Talks.md).

## Screenshots

### Android
![Android](docs/images/android.png)

### Desktop
![Desktop](docs/images/desktop.png)
