/*

  This file is provided under a dual BSD/GPLv2 license.  When using or
  redistributing this file, you may do so under either license.

  GPL LICENSE SUMMARY

  Copyright(c) 2015 Intel Corporation.

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License as
  published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  Contact Information:
  Intel Corporation, www.intel.com

  BSD LICENSE

  Copyright(c) 2015 Intel Corporation.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in
      the documentation and/or other materials provided with the
      distribution.
    * Neither the name of Intel Corporation nor the names of its
      contributors may be used to endorse or promote products derived
      from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*/

#ifndef _PSMI_NETUTILS_H
#define _PSMI_NETUTILS_H

#include <arpa/inet.h>		/* ipv4addr */
#include <stdlib.h>
#include <ifaddrs.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/ip.h>

// network function subset of psm_utils.c so that HAL can use this without
// needing psm_ep_t and psm_epid_t from psm_user.h

/*
 * network address manipulation
 */
	// prefered size for psmi_sockaddr_ntop
#define PSM_ADDRSTRLEN (INET6_ADDRSTRLEN+19+7)	// 16 digit sid, plus 3 " 0x"
												// 4 digit pkey plues 3 " 0x"
const char *psmi_sockaddr_ntop(struct sockaddr* addr, char *dst, socklen_t size);
const char *psmi_ipv4_ntop(uint32_t ip_addr, char *dst, socklen_t size);
socklen_t psmi_sockaddr_len(struct sockaddr* addr);

int psmi_count_high_bits(uint32_t netmask);
// This converts a bit count generated by psmi_count_high_bits back into
// a IPv4 netmask
static inline uint32_t psmi_bit_count_to_mask(int count)
{
	return (uint32_t)(0xffffffff << (32-count));
}

int psmi_get_eth_netmask(__be32 ip_addr, __be32 *netmask);

#endif /* _PSMI_NETUTILS_H */
