/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1998 Samuel Fung, Dennis Sinitsky and Stephen Tang
File: b3soipd.c          98/5/01
Modified by Pin Su and Jan Feng	99/2/15 
Modified by Pin Su 99/4/30
Modified by Wei Jin 99/9/27
Modified by Pin Su 00/3/1
Modified by Pin Su 01/2/15
Modified by Pin Su 02/3/5
Modified by Paolo Nenzi 2002
**********/

/*
 * Revision 2.2.3  02/3/5  Pin Su 
 * BSIMPD2.2.3 release
 */

#include "ngspice/ngspice.h"
#include "ngspice/devdefs.h"
#include "b3soipddef.h"
#include "ngspice/suffix.h"

IFparm B3SOIPDpTable[] = { /* parameters */
IOP( "l",   B3SOIPD_L,      IF_REAL   , "Length"),
IOP( "w",   B3SOIPD_W,      IF_REAL   , "Width"),
IOP( "m",   B3SOIPD_M,      IF_REAL   , "Parallel Multiplier"),
IOP( "ad",  B3SOIPD_AD,     IF_REAL   , "Drain area"),
IOP( "as",  B3SOIPD_AS,     IF_REAL   , "Source area"),
IOP( "pd",  B3SOIPD_PD,     IF_REAL   , "Drain perimeter"),
IOP( "ps",  B3SOIPD_PS,     IF_REAL   , "Source perimeter"),
IOP( "nrd", B3SOIPD_NRD,    IF_REAL   , "Number of squares in drain"),
IOP( "nrs", B3SOIPD_NRS,    IF_REAL   , "Number of squares in source"),
IOP( "off", B3SOIPD_OFF,    IF_FLAG   , "Device is initially off"),
IP( "ic",  B3SOIPD_IC,     IF_REALVEC , "Vector of DS,GS,BS initial voltages"),
OP( "gmbs",         B3SOIPD_GMBS,       IF_REAL,    "Gmb"),
OP( "gm",           B3SOIPD_GM,         IF_REAL,    "Gm"),
OP( "gm/ids",       B3SOIPD_GMID,       IF_REAL,    "Gm/Ids"),
OP( "gds",          B3SOIPD_GDS,        IF_REAL,    "Gds"),
OP( "vdsat",        B3SOIPD_VDSAT,      IF_REAL,    "Vdsat"),
OP( "vth",          B3SOIPD_VON,        IF_REAL,    "Vth"),
OP( "ids",          B3SOIPD_CD,         IF_REAL,    "Ids"),
OP( "vbs",          B3SOIPD_VBS,        IF_REAL,    "Vbs"),
OP( "vgs",          B3SOIPD_VGS,        IF_REAL,    "Vgs"),
OP( "vds",          B3SOIPD_VDS,        IF_REAL,    "Vds"),
OP( "ves",	    B3SOIPD_VES,	      IF_REAL,    "Ves"),
IOP( "bjtoff", B3SOIPD_BJTOFF,	      IF_INTEGER, "BJT on/off flag"),
IOP( "debug", B3SOIPD_DEBUG,	      IF_INTEGER, "BJT on/off flag"),
IOP( "rth0", B3SOIPD_RTH0,  IF_REAL,    "Instance Thermal Resistance"),
IOP( "cth0", B3SOIPD_CTH0,  IF_REAL,    "Instance Thermal Capacitance"),
IOP( "nrb", B3SOIPD_NRB,    IF_REAL,    "Number of squares in body"),
IOP( "frbody", B3SOIPD_FRBODY,    IF_REAL,    "layout dependent body-resistance coefficient"),


/* v2.0 release */
IOP( "nbc",      B3SOIPD_NBC,      IF_REAL, "Number of body contact isolation edge"),
IOP( "nseg",     B3SOIPD_NSEG,     IF_REAL, "Number segments for width partitioning"),
IOP( "pdbcp",    B3SOIPD_PDBCP,    IF_REAL, "Perimeter length for bc parasitics at drain side"),
IOP( "psbcp",    B3SOIPD_PSBCP,    IF_REAL, "Perimeter length for bc parasitics at source side"),
IOP( "agbcp",    B3SOIPD_AGBCP,    IF_REAL, "Gate to body overlap area for bc parasitics"),
IOP( "aebcp",    B3SOIPD_AEBCP,    IF_REAL, "Substrate to body overlap area for bc prasitics"),
IOP( "vbsusr",   B3SOIPD_VBSUSR,   IF_REAL, "Vbs specified by user"),
IOP( "tnodeout", B3SOIPD_TNODEOUT, IF_FLAG, "Flag indicating external temp node")

};

IFparm B3SOIPDmPTable[] = { /* model parameters */
IOP( "capmod", B3SOIPD_MOD_CAPMOD, IF_INTEGER, "Capacitance model selector"),
IOP( "mobmod", B3SOIPD_MOD_MOBMOD, IF_INTEGER, "Mobility model selector"),
IOP( "noimod", B3SOIPD_MOD_NOIMOD, IF_INTEGER, "Noise model selector"),
IOP( "paramchk", B3SOIPD_MOD_PARAMCHK, IF_INTEGER, "Model parameter checking selector"),
IOP( "binunit", B3SOIPD_MOD_BINUNIT, IF_INTEGER, "Bin  unit  selector"),
IOP( "version", B3SOIPD_MOD_VERSION, IF_REAL, " parameter for model version"),
IOP( "tox", B3SOIPD_MOD_TOX, IF_REAL, "Gate oxide thickness in meters"),
IOP( "dtoxcv", B3SOIPD_MOD_DTOXCV, IF_REAL, "Delta oxide thickness in meters in CapMod3"), /* v2.2.3 */

IOP( "cdsc", B3SOIPD_MOD_CDSC, IF_REAL, "Drain/Source and channel coupling capacitance"),
IOP( "cdscb", B3SOIPD_MOD_CDSCB, IF_REAL, "Body-bias dependence of cdsc"), 
IOP( "cdscd", B3SOIPD_MOD_CDSCD, IF_REAL, "Drain-bias dependence of cdsc"), 
IOP( "cit", B3SOIPD_MOD_CIT, IF_REAL, "Interface state capacitance"),
IOP( "nfactor", B3SOIPD_MOD_NFACTOR, IF_REAL, "Subthreshold swing Coefficient"),
IOP( "vsat", B3SOIPD_MOD_VSAT, IF_REAL, "Saturation velocity at tnom"),
IOP( "at", B3SOIPD_MOD_AT, IF_REAL, "Temperature coefficient of vsat"),
IOP( "a0", B3SOIPD_MOD_A0, IF_REAL, "Non-uniform depletion width effect coefficient."), 
IOP( "ags", B3SOIPD_MOD_AGS, IF_REAL, "Gate bias  coefficient of Abulk."), 
IOP( "a1", B3SOIPD_MOD_A1, IF_REAL, "Non-saturation effect coefficient"),
IOP( "a2", B3SOIPD_MOD_A2, IF_REAL, "Non-saturation effect coefficient"),
IOP( "keta", B3SOIPD_MOD_KETA, IF_REAL, "Body-bias coefficient of non-uniform depletion width effect."),
IOP( "nsub", B3SOIPD_MOD_NSUB, IF_REAL, "Substrate doping concentration with polarity"),
IOP( "nch", B3SOIPD_MOD_NPEAK, IF_REAL, "Channel doping concentration"),
IOP( "ngate", B3SOIPD_MOD_NGATE, IF_REAL, "Poly-gate doping concentration"),
IOP( "gamma1", B3SOIPD_MOD_GAMMA1, IF_REAL, "Vth body coefficient"),
IOP( "gamma2", B3SOIPD_MOD_GAMMA2, IF_REAL, "Vth body coefficient"),
IOP( "vbx", B3SOIPD_MOD_VBX, IF_REAL, "Vth transition body Voltage"),
IOP( "vbm", B3SOIPD_MOD_VBM, IF_REAL, "Maximum body voltage"),

IOP( "xt", B3SOIPD_MOD_XT, IF_REAL, "Doping depth"),
IOP( "k1", B3SOIPD_MOD_K1, IF_REAL, "Bulk effect coefficient 1"),
IOP( "kt1", B3SOIPD_MOD_KT1, IF_REAL, "Temperature coefficient of Vth"),
IOP( "kt1l", B3SOIPD_MOD_KT1L, IF_REAL, "Temperature coefficient of Vth"),
IOP( "kt2",  B3SOIPD_MOD_KT2, IF_REAL, "Body-coefficient of kt1"),
IOP( "k2",   B3SOIPD_MOD_K2,  IF_REAL, "Bulk effect coefficient 2"),
IOP( "k3",   B3SOIPD_MOD_K3,  IF_REAL, "Narrow width effect coefficient"),
IOP( "k3b",  B3SOIPD_MOD_K3B, IF_REAL, "Body effect coefficient of k3"),
IOP( "w0",   B3SOIPD_MOD_W0,  IF_REAL, "Narrow width effect parameter"),
IOP( "nlx",  B3SOIPD_MOD_NLX, IF_REAL, "Lateral non-uniform doping effect"),
IOP( "dvt0", B3SOIPD_MOD_DVT0, IF_REAL, "Short channel effect coeff. 0"),
IOP( "dvt1", B3SOIPD_MOD_DVT1, IF_REAL, "Short channel effect coeff. 1"),
IOP( "dvt2", B3SOIPD_MOD_DVT2, IF_REAL, "Short channel effect coeff. 2"),
IOP( "dvt0w", B3SOIPD_MOD_DVT0W, IF_REAL, "Narrow Width coeff. 0"),
IOP( "dvt1w", B3SOIPD_MOD_DVT1W, IF_REAL, "Narrow Width effect coeff. 1"),
IOP( "dvt2w", B3SOIPD_MOD_DVT2W, IF_REAL, "Narrow Width effect coeff. 2"),
IOP( "drout", B3SOIPD_MOD_DROUT, IF_REAL, "DIBL coefficient of output resistance"),
IOP( "dsub", B3SOIPD_MOD_DSUB, IF_REAL, "DIBL coefficient in the subthreshold region"),
IOP( "vth0", B3SOIPD_MOD_VTH0, IF_REAL,"Threshold voltage"),
IOPR("vtho", B3SOIPD_MOD_VTH0, IF_REAL,"Threshold voltage"),
IOP( "ua", B3SOIPD_MOD_UA, IF_REAL, "Linear gate dependence of mobility"),
IOP( "ua1", B3SOIPD_MOD_UA1, IF_REAL, "Temperature coefficient of ua"),
IOP( "ub", B3SOIPD_MOD_UB, IF_REAL, "Quadratic gate dependence of mobility"),
IOP( "ub1", B3SOIPD_MOD_UB1, IF_REAL, "Temperature coefficient of ub"),
IOP( "uc", B3SOIPD_MOD_UC, IF_REAL, "Body-bias dependence of mobility"),
IOP( "uc1", B3SOIPD_MOD_UC1, IF_REAL, "Temperature coefficient of uc"),
IOP( "u0", B3SOIPD_MOD_U0, IF_REAL, "Low-field mobility at Tnom"),
IOP( "ute", B3SOIPD_MOD_UTE, IF_REAL, "Temperature coefficient of mobility"),
IOP( "voff", B3SOIPD_MOD_VOFF, IF_REAL, "Threshold voltage offset"),
IOP( "tnom", B3SOIPD_MOD_TNOM, IF_REAL, "Parameter measurement temperature"),
IOP( "cgso", B3SOIPD_MOD_CGSO, IF_REAL, "Gate-source overlap capacitance per width"),
IOP( "cgdo", B3SOIPD_MOD_CGDO, IF_REAL, "Gate-drain overlap capacitance per width"),
IOP( "xpart", B3SOIPD_MOD_XPART, IF_REAL, "Channel charge partitioning"),
IOP( "delta", B3SOIPD_MOD_DELTA, IF_REAL, "Effective Vds parameter"),
IOP( "rsh", B3SOIPD_MOD_RSH, IF_REAL, "Source-drain sheet resistance"),
IOP( "rdsw", B3SOIPD_MOD_RDSW, IF_REAL, "Source-drain resistance per width"),    

IOP( "prwg", B3SOIPD_MOD_PRWG, IF_REAL, "Gate-bias effect on parasitic resistance "),    
IOP( "prwb", B3SOIPD_MOD_PRWB, IF_REAL, "Body-effect on parasitic resistance "),    

IOP( "prt", B3SOIPD_MOD_PRT, IF_REAL, "Temperature coefficient of parasitic resistance "),    
IOP( "eta0", B3SOIPD_MOD_ETA0, IF_REAL, "Subthreshold region DIBL coefficient"),
IOP( "etab", B3SOIPD_MOD_ETAB, IF_REAL, "Subthreshold region DIBL coefficient"),
IOP( "pclm", B3SOIPD_MOD_PCLM, IF_REAL, "Channel length modulation Coefficient"),
IOP( "pdiblc1", B3SOIPD_MOD_PDIBL1, IF_REAL, "Drain-induced barrier lowering coefficient"),   
IOP( "pdiblc2", B3SOIPD_MOD_PDIBL2, IF_REAL, "Drain-induced barrier lowering coefficient"),   
IOP( "pdiblcb", B3SOIPD_MOD_PDIBLB, IF_REAL, "Body-effect on drain-induced barrier lowering"),   

IOP( "pvag", B3SOIPD_MOD_PVAG, IF_REAL, "Gate dependence of output resistance parameter"),   

IOP( "shmod", B3SOIPD_MOD_SHMOD, IF_INTEGER, "Self heating mode selector"),
IOP( "ddmod", B3SOIPD_MOD_DDMOD, IF_INTEGER, "Dynamic depletion mode selector"),
IOP( "tbox", B3SOIPD_MOD_TBOX, IF_REAL, "Back gate oxide thickness in meters"),   
IOP( "tsi", B3SOIPD_MOD_TSI, IF_REAL, "Silicon-on-insulator thickness in meters"),   
IOP( "xj", B3SOIPD_MOD_XJ, IF_REAL, "Junction Depth"),   
IOP( "rth0", B3SOIPD_MOD_RTH0, IF_REAL, "Self-heating thermal resistance"),   
IOP( "cth0", B3SOIPD_MOD_CTH0, IF_REAL, "Self-heating thermal capacitance"),
IOP( "ngidl", B3SOIPD_MOD_NGIDL, IF_REAL, "GIDL first parameter"),   
IOP( "agidl", B3SOIPD_MOD_AGIDL, IF_REAL, "GIDL second parameter"),   
IOP( "bgidl", B3SOIPD_MOD_BGIDL, IF_REAL, "GIDL third parameter"),   
IOP( "ndiode", B3SOIPD_MOD_NDIODE, IF_REAL, "Diode non-ideality factor"),   
IOP( "xbjt", B3SOIPD_MOD_XBJT, IF_REAL, "Temperature coefficient for Isbjt"),   

IOP( "xdif", B3SOIPD_MOD_XDIF, IF_REAL, "Temperature coefficient for Isdif"),

IOP( "xrec", B3SOIPD_MOD_XREC, IF_REAL, "Temperature coefficient for Isrec"),   
IOP( "xtun", B3SOIPD_MOD_XTUN, IF_REAL, "Temperature coefficient for Istun"),   

IOP( "pbswg", B3SOIPD_MOD_PBSWG, IF_REAL, "Source/drain (gate side) sidewall junction capacitance built in potential"),
IOP( "mjswg", B3SOIPD_MOD_MJSWG, IF_REAL, "Source/drain (gate side) sidewall junction capacitance grading coefficient"),

IOP( "cjswg", B3SOIPD_MOD_CJSWG, IF_REAL, "Source/drain (gate side) sidewall junction capacitance per unit width"),
IOP( "lint", B3SOIPD_MOD_LINT, IF_REAL, "Length reduction parameter"),
IOP( "ll",   B3SOIPD_MOD_LL, IF_REAL, "Length reduction parameter"),
IOP( "llc",   B3SOIPD_MOD_LLC, IF_REAL, "Length reduction parameter"), /* v2.2.3 */
IOP( "lln",  B3SOIPD_MOD_LLN, IF_REAL, "Length reduction parameter"),
IOP( "lw",   B3SOIPD_MOD_LW,  IF_REAL, "Length reduction parameter"),
IOP( "lwc",   B3SOIPD_MOD_LWC,  IF_REAL, "Length reduction parameter"), /* v2.2.3 */
IOP( "lwn",  B3SOIPD_MOD_LWN, IF_REAL, "Length reduction parameter"),
IOP( "lwl",  B3SOIPD_MOD_LWL, IF_REAL, "Length reduction parameter"),
IOP( "lwlc",  B3SOIPD_MOD_LWLC, IF_REAL, "Length reduction parameter"), /* v2.2.3 */

IOP( "wr",   B3SOIPD_MOD_WR, IF_REAL, "Width dependence of rds"),
IOP( "wint", B3SOIPD_MOD_WINT, IF_REAL, "Width reduction parameter"),
IOP( "dwg",  B3SOIPD_MOD_DWG, IF_REAL, "Width reduction parameter"),
IOP( "dwb",  B3SOIPD_MOD_DWB, IF_REAL, "Width reduction parameter"),

IOP( "wl",   B3SOIPD_MOD_WL, IF_REAL, "Width reduction parameter"),
IOP( "wlc",   B3SOIPD_MOD_WLC, IF_REAL, "Width reduction parameter"), /* v2.2.3 */
IOP( "wln",  B3SOIPD_MOD_WLN, IF_REAL, "Width reduction parameter"),
IOP( "ww",   B3SOIPD_MOD_WW, IF_REAL, "Width reduction parameter"),
IOP( "wwc",   B3SOIPD_MOD_WWC, IF_REAL, "Width reduction parameter"), /* v2.2.3 */
IOP( "wwn",  B3SOIPD_MOD_WWN, IF_REAL, "Width reduction parameter"),
IOP( "wwl",  B3SOIPD_MOD_WWL, IF_REAL, "Width reduction parameter"),
IOP( "wwlc",  B3SOIPD_MOD_WWLC, IF_REAL, "Width reduction parameter"), /* v2.2.3 */

IOP( "b0",  B3SOIPD_MOD_B0, IF_REAL, "Abulk narrow width parameter"),
IOP( "b1",  B3SOIPD_MOD_B1, IF_REAL, "Abulk narrow width parameter"),

IOP( "cgsl", B3SOIPD_MOD_CGSL, IF_REAL, "New C-V model parameter"),
IOP( "cgdl", B3SOIPD_MOD_CGDL, IF_REAL, "New C-V model parameter"),
IOP( "ckappa", B3SOIPD_MOD_CKAPPA, IF_REAL, "New C-V model parameter"),
IOP( "cf",  B3SOIPD_MOD_CF, IF_REAL, "Fringe capacitance parameter"),
IOP( "clc", B3SOIPD_MOD_CLC, IF_REAL, "Vdsat parameter for C-V model"),
IOP( "cle", B3SOIPD_MOD_CLE, IF_REAL, "Vdsat parameter for C-V model"),
IOP( "dwc", B3SOIPD_MOD_DWC, IF_REAL, "Delta W for C-V model"),
IOP( "dlc", B3SOIPD_MOD_DLC, IF_REAL, "Delta L for C-V model"),

IOP( "alpha0", B3SOIPD_MOD_ALPHA0, IF_REAL, "substrate current model parameter"),

IOP( "noia", B3SOIPD_MOD_NOIA, IF_REAL, "Flicker noise parameter"),
IOP( "noib", B3SOIPD_MOD_NOIB, IF_REAL, "Flicker noise parameter"),
IOP( "noic", B3SOIPD_MOD_NOIC, IF_REAL, "Flicker noise parameter"),
IOP( "em", B3SOIPD_MOD_EM, IF_REAL, "Flicker noise parameter"),
IOP( "ef", B3SOIPD_MOD_EF, IF_REAL, "Flicker noise frequency exponent"),
IOP( "af", B3SOIPD_MOD_AF, IF_REAL, "Flicker noise exponent"),
IOP( "kf", B3SOIPD_MOD_KF, IF_REAL, "Flicker noise coefficient"),
IOP( "noif", B3SOIPD_MOD_NOIF, IF_REAL, "Floating body excess noise ideality factor"),


/* v2.0 release */
IOP( "k1w1", B3SOIPD_MOD_K1W1, IF_REAL, "First Body effect width dependent parameter"),    
IOP( "k1w2", B3SOIPD_MOD_K1W2, IF_REAL, "Second Boby effect width dependent parameter"),
IOP( "ketas", B3SOIPD_MOD_KETAS, IF_REAL, "Surface potential adjustment for bulk charge effect"),
IOP( "dwbc", B3SOIPD_MOD_DWBC, IF_REAL, "Width offset for body contact isolation edge"),
IOP( "beta0", B3SOIPD_MOD_BETA0, IF_REAL, "First Vds dependent parameter of impact ionizition current"),
IOP( "beta1", B3SOIPD_MOD_BETA1, IF_REAL, "Second Vds dependent parameter of impact ionizition current"),
IOP( "beta2", B3SOIPD_MOD_BETA2, IF_REAL, "Third Vds dependent parameter of impact ionizition current"),
IOP( "vdsatii0", B3SOIPD_MOD_VDSATII0, IF_REAL, "Nominal drain saturation voltage at threshold for impact ionizition current"),
IOP( "tii", B3SOIPD_MOD_TII, IF_REAL, "Temperature dependent parameter for impact ionizition"),
IOP( "lii", B3SOIPD_MOD_LII, IF_REAL, "Channel length dependent parameter at threshold for impact ionizition current"),
IOP( "sii0", B3SOIPD_MOD_SII0, IF_REAL, "First Vgs dependent parameter for impact ionizition current"),
IOP( "sii1", B3SOIPD_MOD_SII1, IF_REAL, "Second Vgs dependent parameter for impact ionizition current"),
IOP( "sii2", B3SOIPD_MOD_SII2, IF_REAL, "Third Vgs dependent parameter for impact ionizition current"),
IOP( "siid", B3SOIPD_MOD_SIID, IF_REAL, "Vds dependent parameter of drain saturation voltage for impact ionizition current"),
IOP( "fbjtii", B3SOIPD_MOD_FBJTII, IF_REAL, "Fraction of bipolar current affecting the impact ionization"),
IOP( "esatii", B3SOIPD_MOD_ESATII, IF_REAL, "Saturation electric field for impact ionization"),
IOP( "ntun", B3SOIPD_MOD_NTUN, IF_REAL, "Reverse tunneling non-ideality factor"),
IOP( "nrecf0", B3SOIPD_MOD_NRECF0, IF_REAL, "Recombination non-ideality factor at forward bias"),
IOP( "nrecr0", B3SOIPD_MOD_NRECR0, IF_REAL, "Recombination non-ideality factor at reversed bias"),
IOP( "isbjt", B3SOIPD_MOD_ISBJT, IF_REAL, "BJT injection saturation current"),
IOP( "isdif", B3SOIPD_MOD_ISDIF, IF_REAL, "Body to source/drain injection saturation current"),
IOP( "isrec", B3SOIPD_MOD_ISREC, IF_REAL, "Recombination in depletion saturation current"),
IOP( "istun", B3SOIPD_MOD_ISTUN, IF_REAL, "Reverse tunneling saturation current"),
IOP( "ln", B3SOIPD_MOD_LN, IF_REAL, "Electron/hole diffusion length"),
IOP( "vrec0", B3SOIPD_MOD_VREC0, IF_REAL, "Voltage dependent parameter for recombination current"),
IOP( "vtun0", B3SOIPD_MOD_VTUN0, IF_REAL, "Voltage dependent parameter for tunneling current"),
IOP( "nbjt", B3SOIPD_MOD_NBJT, IF_REAL, "Power coefficient of channel length dependency for bipolar current"),
IOP( "lbjt0", B3SOIPD_MOD_LBJT0, IF_REAL, "Refferenc channel length for bipolar cuurent"),
IOP( "ldif0", B3SOIPD_MOD_LDIF0, IF_REAL, "Channel-length dependency coefficient of diffusion cap"),
IOP( "vabjt", B3SOIPD_MOD_VABJT, IF_REAL, "Early voltage for bipolar current"),
IOP( "aely", B3SOIPD_MOD_AELY, IF_REAL, "Channel length dependency of early voltage for bipolar cuurent"),
IOP( "ahli", B3SOIPD_MOD_AHLI, IF_REAL, "High level injection parameter for bipolar current"),
IOP( "rbody", B3SOIPD_MOD_RBODY, IF_REAL, "Intrinsic body contact sheet resistance"),
IOP( "rbsh", B3SOIPD_MOD_RBSH, IF_REAL, "Extrinsic body contact sheet resistance"),
IOP( "cgeo", B3SOIPD_MOD_CGEO, IF_REAL, "Gate substrate overlap capacitance per unit channel length"),
IOP( "tt", B3SOIPD_MOD_TT, IF_REAL, "Diffusion capacitance transit time coefficient"),
IOP( "ndif", B3SOIPD_MOD_NDIF, IF_REAL, "Power coefficient of channel length dependency for diffusion capacitance"),
IOP( "vsdfb", B3SOIPD_MOD_VSDFB, IF_REAL, "Source/drain bottom diffusion capacitance flatband voltage"),
IOP( "vsdth", B3SOIPD_MOD_VSDTH, IF_REAL, "Source/drain bottom diffusion capacitance threshold voltage"),
IOP( "csdmin", B3SOIPD_MOD_CSDMIN, IF_REAL, "Source/drain bottom diffusion minimum capacitance"),
IOP( "asd", B3SOIPD_MOD_ASD, IF_REAL, "Source/drain bottom diffusion smoothing parameter"),
IOP( "csdesw", B3SOIPD_MOD_CSDESW, IF_REAL, "Source/drain sidewall fringing capacitance per unit length"),
IOP( "ntrecf", B3SOIPD_MOD_NTRECF, IF_REAL, "Temperature coefficient for Nrecf"),
IOP( "ntrecr", B3SOIPD_MOD_NTRECR, IF_REAL, "Temperature coefficient for Nrecr"),
IOP( "dlcb", B3SOIPD_MOD_DLCB, IF_REAL, "Length offset fitting parameter for body charge"),
IOP( "fbody", B3SOIPD_MOD_FBODY, IF_REAL, "Scaling factor for body charge"),
IOP( "tcjswg", B3SOIPD_MOD_TCJSWG, IF_REAL, "Temperature coefficient of Cjswg"),
IOP( "tpbswg", B3SOIPD_MOD_TPBSWG, IF_REAL, "Temperature coefficient of Pbswg"),
IOP( "acde", B3SOIPD_MOD_ACDE, IF_REAL, "Exponential coefficient for charge thickness in capMod=3 for accumulation and depletion regions"),
IOP( "moin", B3SOIPD_MOD_MOIN, IF_REAL, "Coefficient for the gate-bias dependent surface potential"),
IOP( "delvt", B3SOIPD_MOD_DELVT, IF_REAL, "Threshold voltage adjust for CV"),
IOP( "kb1", B3SOIPD_MOD_KB1, IF_REAL, "Scaling factor for backgate charge"),
IOP( "dlbg", B3SOIPD_MOD_DLBG, IF_REAL, "Length offset fitting parameter for backgate charge"),


/* v2.2 release */
IOP( "igmod", B3SOIPD_MOD_IGMOD, IF_INTEGER, "gate current model selector"),
IOP( "toxqm", B3SOIPD_MOD_TOXQM, IF_REAL, "effective oxide thickness considering quantum effect"),
IOP( "wth0", B3SOIPD_MOD_WTH0, IF_REAL, "Minimum width for thermal resistance calculation"),
IOP( "rhalo", B3SOIPD_MOD_RHALO, IF_REAL, "body halo sheet resistance"),
IOP( "ntox", B3SOIPD_MOD_NTOX, IF_REAL, "power term of gate current"),
IOP( "toxref", B3SOIPD_MOD_TOXREF, IF_REAL, "target oxide thickness"),
IOP( "ebg", B3SOIPD_MOD_EBG, IF_REAL, "effective bandgap in gate current calcula."),
IOP( "vevb", B3SOIPD_MOD_VEVB, IF_REAL, "Vaux parameter for valence-band electron tunneling"),
IOP( "alphagb1", B3SOIPD_MOD_ALPHAGB1, IF_REAL, "First Vox dependent parameter for gate current in inversion"),
IOP( "betagb1", B3SOIPD_MOD_BETAGB1, IF_REAL, "Second Vox dependent parameter for gate current in inversion"),
IOP( "vgb1", B3SOIPD_MOD_VGB1, IF_REAL, "Third Vox dependent parameter for gate current in inversion"),
IOP( "vecb", B3SOIPD_MOD_VECB, IF_REAL, "Vaux parameter for conduction-band electron tunneling"),
IOP( "alphagb2", B3SOIPD_MOD_ALPHAGB2, IF_REAL, "First Vox dependent parameter for gate current in accumulation"),
IOP( "betagb2", B3SOIPD_MOD_BETAGB2, IF_REAL, "Second Vox dependent parameter for gate current in accumulation"),
IOP( "vgb2", B3SOIPD_MOD_VGB2, IF_REAL, "Third Vox dependent parameter for gate current in accumulation"),
IOP( "voxh", B3SOIPD_MOD_VOXH, IF_REAL, "the limit of Vox in gate current calculation"),
IOP( "deltavox", B3SOIPD_MOD_DELTAVOX, IF_REAL, "the smoothing parameter in the Vox smoothing function"),


/* Added for binning - START */
/* Length Dependence */
IOP( "lnch",  B3SOIPD_MOD_LNPEAK, IF_REAL, "Length dependence of nch"),
IOP( "lnsub", B3SOIPD_MOD_LNSUB, IF_REAL, "Length dependence of nsub"),
IOP( "lngate", B3SOIPD_MOD_LNGATE, IF_REAL, "Length dependence of ngate"),
IOP( "lvth0", B3SOIPD_MOD_LVTH0, IF_REAL,"Length dependence of vth0"),
IOP( "lk1",   B3SOIPD_MOD_LK1,  IF_REAL, "Length dependence of k1"),
IOP( "lk1w1",   B3SOIPD_MOD_LK1W1,  IF_REAL, "Length dependence of k1w1"),
IOP( "lk1w2",   B3SOIPD_MOD_LK1W2,  IF_REAL, "Length dependence of k1w2"),
IOP( "lk2",   B3SOIPD_MOD_LK2,  IF_REAL, "Length dependence of k2"),
IOP( "lk3",   B3SOIPD_MOD_LK3,  IF_REAL, "Length dependence of k3"),
IOP( "lk3b",  B3SOIPD_MOD_LK3B, IF_REAL, "Length dependence of k3b"),
IOP( "lkb1",  B3SOIPD_MOD_LKB1, IF_REAL, "Length dependence of kb1"),
IOP( "lw0",   B3SOIPD_MOD_LW0,  IF_REAL, "Length dependence of w0"),
IOP( "lnlx",  B3SOIPD_MOD_LNLX, IF_REAL, "Length dependence of nlx"),
IOP( "ldvt0", B3SOIPD_MOD_LDVT0, IF_REAL, "Length dependence of dvt0"),
IOP( "ldvt1", B3SOIPD_MOD_LDVT1, IF_REAL, "Length dependence of dvt1"),
IOP( "ldvt2", B3SOIPD_MOD_LDVT2, IF_REAL, "Length dependence of dvt2"),
IOP( "ldvt0w", B3SOIPD_MOD_LDVT0W, IF_REAL, "Length dependence of dvt0w"),
IOP( "ldvt1w", B3SOIPD_MOD_LDVT1W, IF_REAL, "Length dependence of dvt1w"),
IOP( "ldvt2w", B3SOIPD_MOD_LDVT2W, IF_REAL, "Length dependence of dvt2w"),
IOP( "lu0",  B3SOIPD_MOD_LU0, IF_REAL, "Length dependence of u0"),
IOP( "lua",  B3SOIPD_MOD_LUA, IF_REAL, "Length dependence of ua"),
IOP( "lub", B3SOIPD_MOD_LUB, IF_REAL, "Length dependence of ub"),
IOP( "luc",  B3SOIPD_MOD_LUC, IF_REAL, "Length dependence of uc"),
IOP( "lvsat", B3SOIPD_MOD_LVSAT, IF_REAL, "Length dependence of vsat"),
IOP( "la0", B3SOIPD_MOD_LA0, IF_REAL, "Length dependence of a0"),
IOP( "lags", B3SOIPD_MOD_LAGS, IF_REAL, "Length dependence of ags"),
IOP( "lb0",  B3SOIPD_MOD_LB0, IF_REAL, "Length dependence of b0"),
IOP( "lb1",  B3SOIPD_MOD_LB1, IF_REAL, "Length dependence of b1"),
IOP( "lketa", B3SOIPD_MOD_LKETA, IF_REAL, "Length dependence of keta"),
IOP( "lketas", B3SOIPD_MOD_LKETAS, IF_REAL, "Length dependence of ketas"),
IOP( "la1", B3SOIPD_MOD_LA1, IF_REAL, "Length dependence of a1"),
IOP( "la2", B3SOIPD_MOD_LA2, IF_REAL, "Length dependence of a2"),
IOP( "lrdsw", B3SOIPD_MOD_LRDSW,  IF_REAL, "Length dependence of rdsw "),
IOP( "lprwb", B3SOIPD_MOD_LPRWB,  IF_REAL, "Length dependence of prwb "),
IOP( "lprwg", B3SOIPD_MOD_LPRWG,  IF_REAL, "Length dependence of prwg "),
IOP( "lwr",  B3SOIPD_MOD_LWR, IF_REAL, "Length dependence of wr"),
IOP( "lnfactor", B3SOIPD_MOD_LNFACTOR, IF_REAL, "Length dependence of nfactor"),
IOP( "ldwg", B3SOIPD_MOD_LDWG, IF_REAL, "Length dependence of dwg"),
IOP( "ldwb", B3SOIPD_MOD_LDWB, IF_REAL, "Length dependence of dwb"),
IOP( "lvoff", B3SOIPD_MOD_LVOFF, IF_REAL, "Length dependence of voff"),
IOP( "leta0", B3SOIPD_MOD_LETA0, IF_REAL, "Length dependence of eta0"),
IOP( "letab", B3SOIPD_MOD_LETAB, IF_REAL, "Length dependence of etab"),
IOP( "ldsub", B3SOIPD_MOD_LDSUB, IF_REAL, "Length dependence of dsub"),
IOP( "lcit",   B3SOIPD_MOD_LCIT,  IF_REAL, "Length dependence of cit"),
IOP( "lcdsc",  B3SOIPD_MOD_LCDSC, IF_REAL, "Length dependence of cdsc"),
IOP( "lcdscb", B3SOIPD_MOD_LCDSCB, IF_REAL, "Length dependence of cdscb"),
IOP( "lcdscd", B3SOIPD_MOD_LCDSCD, IF_REAL, "Length dependence of cdscd"),
IOP( "lpclm", B3SOIPD_MOD_LPCLM, IF_REAL, "Length dependence of pclm"),
IOP( "lpdiblc1", B3SOIPD_MOD_LPDIBL1, IF_REAL, "Length dependence of pdiblc1"),
IOP( "lpdiblc2", B3SOIPD_MOD_LPDIBL2, IF_REAL, "Length dependence of pdiblc2"),
IOP( "lpdiblcb", B3SOIPD_MOD_LPDIBLB, IF_REAL, "Length dependence of pdiblcb"),
IOP( "ldrout", B3SOIPD_MOD_LDROUT, IF_REAL, "Length dependence of drout"),
IOP( "lpvag", B3SOIPD_MOD_LPVAG, IF_REAL, "Length dependence of pvag"),
IOP( "ldelta", B3SOIPD_MOD_LDELTA, IF_REAL, "Length dependence of delta"),
IOP( "lalpha0", B3SOIPD_MOD_LALPHA0, IF_REAL, "Length dependence of alpha0"),
IOP( "lfbjtii", B3SOIPD_MOD_LFBJTII, IF_REAL, "Length dependence of fbjtii"),
IOP( "lbeta0", B3SOIPD_MOD_LBETA0, IF_REAL, "Length dependence of beta0"),
IOP( "lbeta1", B3SOIPD_MOD_LBETA1, IF_REAL, "Length dependence of beta1"),
IOP( "lbeta2", B3SOIPD_MOD_LBETA2, IF_REAL, "Length dependence of beta2"),
IOP( "lvdsatii0", B3SOIPD_MOD_LVDSATII0, IF_REAL, "Length dependence of vdsatii0"),
IOP( "llii", B3SOIPD_MOD_LLII, IF_REAL, "Length dependence of lii"),
IOP( "lesatii", B3SOIPD_MOD_LESATII, IF_REAL, "Length dependence of esatii"),
IOP( "lsii0", B3SOIPD_MOD_LSII0, IF_REAL, "Length dependence of sii0"),
IOP( "lsii1", B3SOIPD_MOD_LSII1, IF_REAL, "Length dependence of sii1"),
IOP( "lsii2", B3SOIPD_MOD_LSII2, IF_REAL, "Length dependence of sii2"),
IOP( "lsiid", B3SOIPD_MOD_LSIID, IF_REAL, "Length dependence of siid"),
IOP( "lagidl", B3SOIPD_MOD_LAGIDL, IF_REAL, "Length dependence of agidl"),
IOP( "lbgidl", B3SOIPD_MOD_LBGIDL, IF_REAL, "Length dependence of bgidl"),
IOP( "lngidl", B3SOIPD_MOD_LNGIDL, IF_REAL, "Length dependence of ngidl"),
IOP( "lntun", B3SOIPD_MOD_LNTUN, IF_REAL, "Length dependence of ntun"),
IOP( "lndiode", B3SOIPD_MOD_LNDIODE, IF_REAL, "Length dependence of ndiode"),
IOP( "lnrecf0", B3SOIPD_MOD_LNRECF0, IF_REAL, "Length dependence of nrecf0"),
IOP( "lnrecr0", B3SOIPD_MOD_LNRECR0, IF_REAL, "Length dependence of nrecr0"),
IOP( "lisbjt", B3SOIPD_MOD_LISBJT, IF_REAL, "Length dependence of isbjt"),
IOP( "lisdif", B3SOIPD_MOD_LISDIF, IF_REAL, "Length dependence of isdif"),
IOP( "lisrec", B3SOIPD_MOD_LISREC, IF_REAL, "Length dependence of isrec"),
IOP( "listun", B3SOIPD_MOD_LISTUN, IF_REAL, "Length dependence of istun"),
IOP( "lvrec0", B3SOIPD_MOD_LVREC0, IF_REAL, "Length dependence of vrec0"),
IOP( "lvtun0", B3SOIPD_MOD_LVTUN0, IF_REAL, "Length dependence of vtun0"),
IOP( "lnbjt", B3SOIPD_MOD_LNBJT, IF_REAL, "Length dependence of nbjt"),
IOP( "llbjt0", B3SOIPD_MOD_LLBJT0, IF_REAL, "Length dependence of lbjt0"),
IOP( "lvabjt", B3SOIPD_MOD_LVABJT, IF_REAL, "Length dependence of vabjt"),
IOP( "laely", B3SOIPD_MOD_LAELY, IF_REAL, "Length dependence of aely"),
IOP( "lahli", B3SOIPD_MOD_LAHLI, IF_REAL, "Length dependence of ahli"),
IOP( "lvsdfb", B3SOIPD_MOD_LVSDFB, IF_REAL, "Length dependence of vsdfb"),
IOP( "lvsdth", B3SOIPD_MOD_LVSDTH, IF_REAL, "Length dependence of vsdth"),
IOP( "ldelvt", B3SOIPD_MOD_LDELVT, IF_REAL, "Length dependence of delvt"),
IOP( "lacde", B3SOIPD_MOD_LACDE, IF_REAL, "Length dependence of acde"),
IOP( "lmoin", B3SOIPD_MOD_LMOIN, IF_REAL, "Length dependence of amoin"),
/* Width Dependence */
IOP( "wnch",  B3SOIPD_MOD_WNPEAK, IF_REAL, "Width dependence of nch"),
IOP( "wnsub", B3SOIPD_MOD_WNSUB, IF_REAL, "Width dependence of nsub"),
IOP( "wngate", B3SOIPD_MOD_WNGATE, IF_REAL, "Width dependence of ngate"),
IOP( "wvth0", B3SOIPD_MOD_WVTH0, IF_REAL,"Width dependence of vth0"),
IOP( "wk1",   B3SOIPD_MOD_WK1,  IF_REAL, "Width dependence of k1"),
IOP( "wk1w1",   B3SOIPD_MOD_WK1W1,  IF_REAL, "Width dependence of k1w1"),
IOP( "wk1w2",   B3SOIPD_MOD_WK1W2,  IF_REAL, "Width dependence of k1w2"),
IOP( "wk2",   B3SOIPD_MOD_WK2,  IF_REAL, "Width dependence of k2"),
IOP( "wk3",   B3SOIPD_MOD_WK3,  IF_REAL, "Width dependence of k3"),
IOP( "wk3b",  B3SOIPD_MOD_WK3B, IF_REAL, "Width dependence of k3b"),
IOP( "wkb1",  B3SOIPD_MOD_WKB1, IF_REAL, "Width dependence of kb1"),
IOP( "ww0",   B3SOIPD_MOD_WW0,  IF_REAL, "Width dependence of w0"),
IOP( "wnlx",  B3SOIPD_MOD_WNLX, IF_REAL, "Width dependence of nlx"),
IOP( "wdvt0", B3SOIPD_MOD_WDVT0, IF_REAL, "Width dependence of dvt0"),
IOP( "wdvt1", B3SOIPD_MOD_WDVT1, IF_REAL, "Width dependence of dvt1"),
IOP( "wdvt2", B3SOIPD_MOD_WDVT2, IF_REAL, "Width dependence of dvt2"),
IOP( "wdvt0w", B3SOIPD_MOD_WDVT0W, IF_REAL, "Width dependence of dvt0w"),
IOP( "wdvt1w", B3SOIPD_MOD_WDVT1W, IF_REAL, "Width dependence of dvt1w"),
IOP( "wdvt2w", B3SOIPD_MOD_WDVT2W, IF_REAL, "Width dependence of dvt2w"),
IOP( "wu0",  B3SOIPD_MOD_WU0, IF_REAL, "Width dependence of u0"),
IOP( "wua",  B3SOIPD_MOD_WUA, IF_REAL, "Width dependence of ua"),
IOP( "wub", B3SOIPD_MOD_WUB, IF_REAL, "Width dependence of ub"),
IOP( "wuc",  B3SOIPD_MOD_WUC, IF_REAL, "Width dependence of uc"),
IOP( "wvsat", B3SOIPD_MOD_WVSAT, IF_REAL, "Width dependence of vsat"),
IOP( "wa0", B3SOIPD_MOD_WA0, IF_REAL, "Width dependence of a0"),
IOP( "wags", B3SOIPD_MOD_WAGS, IF_REAL, "Width dependence of ags"),
IOP( "wb0",  B3SOIPD_MOD_WB0, IF_REAL, "Width dependence of b0"),
IOP( "wb1",  B3SOIPD_MOD_WB1, IF_REAL, "Width dependence of b1"),
IOP( "wketa", B3SOIPD_MOD_WKETA, IF_REAL, "Width dependence of keta"),
IOP( "wketas", B3SOIPD_MOD_WKETAS, IF_REAL, "Width dependence of ketas"),
IOP( "wa1", B3SOIPD_MOD_WA1, IF_REAL, "Width dependence of a1"),
IOP( "wa2", B3SOIPD_MOD_WA2, IF_REAL, "Width dependence of a2"),
IOP( "wrdsw", B3SOIPD_MOD_WRDSW,  IF_REAL, "Width dependence of rdsw "),
IOP( "wprwb", B3SOIPD_MOD_WPRWB,  IF_REAL, "Width dependence of prwb "),
IOP( "wprwg", B3SOIPD_MOD_WPRWG,  IF_REAL, "Width dependence of prwg "),
IOP( "wwr",  B3SOIPD_MOD_WWR, IF_REAL, "Width dependence of wr"),
IOP( "wnfactor", B3SOIPD_MOD_WNFACTOR, IF_REAL, "Width dependence of nfactor"),
IOP( "wdwg", B3SOIPD_MOD_WDWG, IF_REAL, "Width dependence of dwg"),
IOP( "wdwb", B3SOIPD_MOD_WDWB, IF_REAL, "Width dependence of dwb"),
IOP( "wvoff", B3SOIPD_MOD_WVOFF, IF_REAL, "Width dependence of voff"),
IOP( "weta0", B3SOIPD_MOD_WETA0, IF_REAL, "Width dependence of eta0"),
IOP( "wetab", B3SOIPD_MOD_WETAB, IF_REAL, "Width dependence of etab"),
IOP( "wdsub", B3SOIPD_MOD_WDSUB, IF_REAL, "Width dependence of dsub"),
IOP( "wcit",   B3SOIPD_MOD_WCIT,  IF_REAL, "Width dependence of cit"),
IOP( "wcdsc",  B3SOIPD_MOD_WCDSC, IF_REAL, "Width dependence of cdsc"),
IOP( "wcdscb", B3SOIPD_MOD_WCDSCB, IF_REAL, "Width dependence of cdscb"),
IOP( "wcdscd", B3SOIPD_MOD_WCDSCD, IF_REAL, "Width dependence of cdscd"),
IOP( "wpclm", B3SOIPD_MOD_WPCLM, IF_REAL, "Width dependence of pclm"),
IOP( "wpdiblc1", B3SOIPD_MOD_WPDIBL1, IF_REAL, "Width dependence of pdiblc1"),
IOP( "wpdiblc2", B3SOIPD_MOD_WPDIBL2, IF_REAL, "Width dependence of pdiblc2"),
IOP( "wpdiblcb", B3SOIPD_MOD_WPDIBLB, IF_REAL, "Width dependence of pdiblcb"),
IOP( "wdrout", B3SOIPD_MOD_WDROUT, IF_REAL, "Width dependence of drout"),
IOP( "wpvag", B3SOIPD_MOD_WPVAG, IF_REAL, "Width dependence of pvag"),
IOP( "wdelta", B3SOIPD_MOD_WDELTA, IF_REAL, "Width dependence of delta"),
IOP( "walpha0", B3SOIPD_MOD_WALPHA0, IF_REAL, "Width dependence of alpha0"),
IOP( "wfbjtii", B3SOIPD_MOD_WFBJTII, IF_REAL, "Width dependence of fbjtii"),
IOP( "wbeta0", B3SOIPD_MOD_WBETA0, IF_REAL, "Width dependence of beta0"),
IOP( "wbeta1", B3SOIPD_MOD_WBETA1, IF_REAL, "Width dependence of beta1"),
IOP( "wbeta2", B3SOIPD_MOD_WBETA2, IF_REAL, "Width dependence of beta2"),
IOP( "wvdsatii0", B3SOIPD_MOD_WVDSATII0, IF_REAL, "Width dependence of vdsatii0"),
IOP( "wlii", B3SOIPD_MOD_WLII, IF_REAL, "Width dependence of lii"),
IOP( "wesatii", B3SOIPD_MOD_WESATII, IF_REAL, "Width dependence of esatii"),
IOP( "wsii0", B3SOIPD_MOD_WSII0, IF_REAL, "Width dependence of sii0"),
IOP( "wsii1", B3SOIPD_MOD_WSII1, IF_REAL, "Width dependence of sii1"),
IOP( "wsii2", B3SOIPD_MOD_WSII2, IF_REAL, "Width dependence of sii2"),
IOP( "wsiid", B3SOIPD_MOD_WSIID, IF_REAL, "Width dependence of siid"),
IOP( "wagidl", B3SOIPD_MOD_WAGIDL, IF_REAL, "Width dependence of agidl"),
IOP( "wbgidl", B3SOIPD_MOD_WBGIDL, IF_REAL, "Width dependence of bgidl"),
IOP( "wngidl", B3SOIPD_MOD_WNGIDL, IF_REAL, "Width dependence of ngidl"),
IOP( "wntun", B3SOIPD_MOD_WNTUN, IF_REAL, "Width dependence of ntun"),
IOP( "wndiode", B3SOIPD_MOD_WNDIODE, IF_REAL, "Width dependence of ndiode"),
IOP( "wnrecf0", B3SOIPD_MOD_WNRECF0, IF_REAL, "Width dependence of nrecf0"),
IOP( "wnrecr0", B3SOIPD_MOD_WNRECR0, IF_REAL, "Width dependence of nrecr0"),
IOP( "wisbjt", B3SOIPD_MOD_WISBJT, IF_REAL, "Width dependence of isbjt"),
IOP( "wisdif", B3SOIPD_MOD_WISDIF, IF_REAL, "Width dependence of isdif"),
IOP( "wisrec", B3SOIPD_MOD_WISREC, IF_REAL, "Width dependence of isrec"),
IOP( "wistun", B3SOIPD_MOD_WISTUN, IF_REAL, "Width dependence of istun"),
IOP( "wvrec0", B3SOIPD_MOD_WVREC0, IF_REAL, "Width dependence of vrec0"),
IOP( "wvtun0", B3SOIPD_MOD_WVTUN0, IF_REAL, "Width dependence of vtun0"),
IOP( "wnbjt", B3SOIPD_MOD_WNBJT, IF_REAL, "Width dependence of nbjt"),
IOP( "wlbjt0", B3SOIPD_MOD_WLBJT0, IF_REAL, "Width dependence of lbjt0"),
IOP( "wvabjt", B3SOIPD_MOD_WVABJT, IF_REAL, "Width dependence of vabjt"),
IOP( "waely", B3SOIPD_MOD_WAELY, IF_REAL, "Width dependence of aely"),
IOP( "wahli", B3SOIPD_MOD_WAHLI, IF_REAL, "Width dependence of ahli"),
IOP( "wvsdfb", B3SOIPD_MOD_WVSDFB, IF_REAL, "Width dependence of vsdfb"),
IOP( "wvsdth", B3SOIPD_MOD_WVSDTH, IF_REAL, "Width dependence of vsdth"),
IOP( "wdelvt", B3SOIPD_MOD_WDELVT, IF_REAL, "Width dependence of delvt"),
IOP( "wacde", B3SOIPD_MOD_WACDE, IF_REAL, "Width dependence of acde"),
IOP( "wmoin", B3SOIPD_MOD_WMOIN, IF_REAL, "Width dependence of amoin"),
/* Cross-term Dependence */
IOP( "pnch",  B3SOIPD_MOD_PNPEAK, IF_REAL, "Cross-term dependence of nch"),
IOP( "pnsub", B3SOIPD_MOD_PNSUB, IF_REAL, "Cross-term dependence of nsub"),
IOP( "pngate", B3SOIPD_MOD_PNGATE, IF_REAL, "Cross-term dependence of ngate"),
IOP( "pvth0", B3SOIPD_MOD_PVTH0, IF_REAL,"Cross-term dependence of vth0"),
IOP( "pk1",   B3SOIPD_MOD_PK1,  IF_REAL, "Cross-term dependence of k1"),
IOP( "pk1w1",   B3SOIPD_MOD_PK1W1,  IF_REAL, "Cross-term dependence of k1w1"),
IOP( "pk1w2",   B3SOIPD_MOD_PK1W2,  IF_REAL, "Cross-term dependence of k1w2"),
IOP( "pk2",   B3SOIPD_MOD_PK2,  IF_REAL, "Cross-term dependence of k2"),
IOP( "pk3",   B3SOIPD_MOD_PK3,  IF_REAL, "Cross-term dependence of k3"),
IOP( "pk3b",  B3SOIPD_MOD_PK3B, IF_REAL, "Cross-term dependence of k3b"),
IOP( "pkb1",  B3SOIPD_MOD_PKB1, IF_REAL, "Cross-term dependence of kb1"),
IOP( "pw0",   B3SOIPD_MOD_PW0,  IF_REAL, "Cross-term dependence of w0"),
IOP( "pnlx",  B3SOIPD_MOD_PNLX, IF_REAL, "Cross-term dependence of nlx"),
IOP( "pdvt0", B3SOIPD_MOD_PDVT0, IF_REAL, "Cross-term dependence of dvt0"),
IOP( "pdvt1", B3SOIPD_MOD_PDVT1, IF_REAL, "Cross-term dependence of dvt1"),
IOP( "pdvt2", B3SOIPD_MOD_PDVT2, IF_REAL, "Cross-term dependence of dvt2"),
IOP( "pdvt0w", B3SOIPD_MOD_PDVT0W, IF_REAL, "Cross-term dependence of dvt0w"),
IOP( "pdvt1w", B3SOIPD_MOD_PDVT1W, IF_REAL, "Cross-term dependence of dvt1w"),
IOP( "pdvt2w", B3SOIPD_MOD_PDVT2W, IF_REAL, "Cross-term dependence of dvt2w"),
IOP( "pu0",  B3SOIPD_MOD_PU0, IF_REAL, "Cross-term dependence of u0"),
IOP( "pua",  B3SOIPD_MOD_PUA, IF_REAL, "Cross-term dependence of ua"),
IOP( "pub", B3SOIPD_MOD_PUB, IF_REAL, "Cross-term dependence of ub"),
IOP( "puc",  B3SOIPD_MOD_PUC, IF_REAL, "Cross-term dependence of uc"),
IOP( "pvsat", B3SOIPD_MOD_PVSAT, IF_REAL, "Cross-term dependence of vsat"),
IOP( "pa0", B3SOIPD_MOD_PA0, IF_REAL, "Cross-term dependence of a0"),
IOP( "pags", B3SOIPD_MOD_PAGS, IF_REAL, "Cross-term dependence of ags"),
IOP( "pb0",  B3SOIPD_MOD_PB0, IF_REAL, "Cross-term dependence of b0"),
IOP( "pb1",  B3SOIPD_MOD_PB1, IF_REAL, "Cross-term dependence of b1"),
IOP( "pketa", B3SOIPD_MOD_PKETA, IF_REAL, "Cross-term dependence of keta"),
IOP( "pketas", B3SOIPD_MOD_PKETAS, IF_REAL, "Cross-term dependence of ketas"),
IOP( "pa1", B3SOIPD_MOD_PA1, IF_REAL, "Cross-term dependence of a1"),
IOP( "pa2", B3SOIPD_MOD_PA2, IF_REAL, "Cross-term dependence of a2"),
IOP( "prdsw", B3SOIPD_MOD_PRDSW,  IF_REAL, "Cross-term dependence of rdsw "),
IOP( "pprwb", B3SOIPD_MOD_PPRWB,  IF_REAL, "Cross-term dependence of prwb "),
IOP( "pprwg", B3SOIPD_MOD_PPRWG,  IF_REAL, "Cross-term dependence of prwg "),
IOP( "pwr",  B3SOIPD_MOD_PWR, IF_REAL, "Cross-term dependence of wr"),
IOP( "pnfactor", B3SOIPD_MOD_PNFACTOR, IF_REAL, "Cross-term dependence of nfactor"),
IOP( "pdwg", B3SOIPD_MOD_PDWG, IF_REAL, "Cross-term dependence of dwg"),
IOP( "pdwb", B3SOIPD_MOD_PDWB, IF_REAL, "Cross-term dependence of dwb"),
IOP( "pvoff", B3SOIPD_MOD_PVOFF, IF_REAL, "Cross-term dependence of voff"),
IOP( "peta0", B3SOIPD_MOD_PETA0, IF_REAL, "Cross-term dependence of eta0"),
IOP( "petab", B3SOIPD_MOD_PETAB, IF_REAL, "Cross-term dependence of etab"),
IOP( "pdsub", B3SOIPD_MOD_PDSUB, IF_REAL, "Cross-term dependence of dsub"),
IOP( "pcit",   B3SOIPD_MOD_PCIT,  IF_REAL, "Cross-term dependence of cit"),
IOP( "pcdsc",  B3SOIPD_MOD_PCDSC, IF_REAL, "Cross-term dependence of cdsc"),
IOP( "pcdscb", B3SOIPD_MOD_PCDSCB, IF_REAL, "Cross-term dependence of cdscb"),
IOP( "pcdscd", B3SOIPD_MOD_PCDSCD, IF_REAL, "Cross-term dependence of cdscd"),
IOP( "ppclm", B3SOIPD_MOD_PPCLM, IF_REAL, "Cross-term dependence of pclm"),
IOP( "ppdiblc1", B3SOIPD_MOD_PPDIBL1, IF_REAL, "Cross-term dependence of pdiblc1"),
IOP( "ppdiblc2", B3SOIPD_MOD_PPDIBL2, IF_REAL, "Cross-term dependence of pdiblc2"),
IOP( "ppdiblcb", B3SOIPD_MOD_PPDIBLB, IF_REAL, "Cross-term dependence of pdiblcb"),
IOP( "pdrout", B3SOIPD_MOD_PDROUT, IF_REAL, "Cross-term dependence of drout"),
IOP( "ppvag", B3SOIPD_MOD_PPVAG, IF_REAL, "Cross-term dependence of pvag"),
IOP( "pdelta", B3SOIPD_MOD_PDELTA, IF_REAL, "Cross-term dependence of delta"),
IOP( "palpha0", B3SOIPD_MOD_PALPHA0, IF_REAL, "Cross-term dependence of alpha0"),
IOP( "pfbjtii", B3SOIPD_MOD_PFBJTII, IF_REAL, "Cross-term dependence of fbjtii"),
IOP( "pbeta0", B3SOIPD_MOD_PBETA0, IF_REAL, "Cross-term dependence of beta0"),
IOP( "pbeta1", B3SOIPD_MOD_PBETA1, IF_REAL, "Cross-term dependence of beta1"),
IOP( "pbeta2", B3SOIPD_MOD_PBETA2, IF_REAL, "Cross-term dependence of beta2"),
IOP( "pvdsatii0", B3SOIPD_MOD_PVDSATII0, IF_REAL, "Cross-term dependence of vdsatii0"),
IOP( "plii", B3SOIPD_MOD_PLII, IF_REAL, "Cross-term dependence of lii"),
IOP( "pesatii", B3SOIPD_MOD_PESATII, IF_REAL, "Cross-term dependence of esatii"),
IOP( "psii0", B3SOIPD_MOD_PSII0, IF_REAL, "Cross-term dependence of sii0"),
IOP( "psii1", B3SOIPD_MOD_PSII1, IF_REAL, "Cross-term dependence of sii1"),
IOP( "psii2", B3SOIPD_MOD_PSII2, IF_REAL, "Cross-term dependence of sii2"),
IOP( "psiid", B3SOIPD_MOD_PSIID, IF_REAL, "Cross-term dependence of siid"),
IOP( "pagidl", B3SOIPD_MOD_PAGIDL, IF_REAL, "Cross-term dependence of agidl"),
IOP( "pbgidl", B3SOIPD_MOD_PBGIDL, IF_REAL, "Cross-term dependence of bgidl"),
IOP( "pngidl", B3SOIPD_MOD_PNGIDL, IF_REAL, "Cross-term dependence of ngidl"),
IOP( "pntun", B3SOIPD_MOD_PNTUN, IF_REAL, "Cross-term dependence of ntun"),
IOP( "pndiode", B3SOIPD_MOD_PNDIODE, IF_REAL, "Cross-term dependence of ndiode"),
IOP( "pnrecf0", B3SOIPD_MOD_PNRECF0, IF_REAL, "Cross-term dependence of nrecf0"),
IOP( "pnrecr0", B3SOIPD_MOD_PNRECR0, IF_REAL, "Cross-term dependence of nrecr0"),
IOP( "pisbjt", B3SOIPD_MOD_PISBJT, IF_REAL, "Cross-term dependence of isbjt"),
IOP( "pisdif", B3SOIPD_MOD_PISDIF, IF_REAL, "Cross-term dependence of isdif"),
IOP( "pisrec", B3SOIPD_MOD_PISREC, IF_REAL, "Cross-term dependence of isrec"),
IOP( "pistun", B3SOIPD_MOD_PISTUN, IF_REAL, "Cross-term dependence of istun"),
IOP( "pvrec0", B3SOIPD_MOD_PVREC0, IF_REAL, "Cross-term dependence of vrec0"),
IOP( "pvtun0", B3SOIPD_MOD_PVTUN0, IF_REAL, "Cross-term dependence of vtun0"),
IOP( "pnbjt", B3SOIPD_MOD_PNBJT, IF_REAL, "Cross-term dependence of nbjt"),
IOP( "plbjt0", B3SOIPD_MOD_PLBJT0, IF_REAL, "Cross-term dependence of lbjt0"),
IOP( "pvabjt", B3SOIPD_MOD_PVABJT, IF_REAL, "Cross-term dependence of vabjt"),
IOP( "paely", B3SOIPD_MOD_PAELY, IF_REAL, "Cross-term dependence of aely"),
IOP( "pahli", B3SOIPD_MOD_PAHLI, IF_REAL, "Cross-term dependence of ahli"),
IOP( "pvsdfb", B3SOIPD_MOD_PVSDFB, IF_REAL, "Cross-term dependence of vsdfb"),
IOP( "pvsdth", B3SOIPD_MOD_PVSDTH, IF_REAL, "Cross-term dependence of vsdth"),
IOP( "pdelvt", B3SOIPD_MOD_PDELVT, IF_REAL, "Cross-term dependence of delvt"),
IOP( "pacde", B3SOIPD_MOD_PACDE, IF_REAL, "Cross-term dependence of acde"),
IOP( "pmoin", B3SOIPD_MOD_PMOIN, IF_REAL, "Cross-term dependence of amoin"),
/* Added for binning - END */

IP( "nmos", B3SOIPD_MOD_NMOS,  IF_FLAG, "Flag to indicate NMOS"),
IP( "pmos", B3SOIPD_MOD_PMOS,  IF_FLAG, "Flag to indicate PMOS"),
};

char *B3SOIPDnames[] = {
   "Drain",
   "Gate",
   "Source",
   "Backgate",
   "",
   "Body",
   "Temp",
   "Charge",
};

int	B3SOIPDnSize = NUMELEMS(B3SOIPDnames);
int	B3SOIPDpTSize = NUMELEMS(B3SOIPDpTable);
int	B3SOIPDmPTSize = NUMELEMS(B3SOIPDmPTable);
int	B3SOIPDiSize = sizeof(B3SOIPDinstance);
int	B3SOIPDmSize = sizeof(B3SOIPDmodel);


