/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.jsp.tags;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.turbine.modules.ScreenLoader;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.jsp.JspService;
import org.apache.turbine.services.template.TemplateService;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;

public class ScreenTag
extends TagSupport {
    private static final String FLAG = "_screen_executed_";
    static final String SECTION_KEY = "_layout_section_";
    static final String BODY = "body";
    static final String HEAD = "head";
    private String section;
    private boolean staticContent;

    public void setSection(String section) {
        this.pageContext.setAttribute(SECTION_KEY, (Object)section, 2);
        this.section = section;
    }

    public void setStaticContent(boolean staticContent) {
        this.staticContent = staticContent;
    }

    public int doStartTag() throws JspException {
        RunData data = (RunData)this.pageContext.getAttribute("rundata", 2);
        String module = null;
        String template = null;
        Boolean flag = (Boolean)this.pageContext.getAttribute(FLAG, 2);
        JspService jsp = (JspService)TurbineServices.getInstance().getService("JspService");
        try {
            this.pageContext.getOut().flush();
            template = data.getTemplateInfo().getScreenTemplate();
            if (this.staticContent || flag != null && flag.booleanValue()) {
                jsp.handleRequest(data, "/screens/" + template, false);
            } else {
                module = ((TemplateService)TurbineServices.getInstance().getService("TemplateService")).getScreenName(template);
                ScreenLoader.getInstance().exec(data, module);
                this.pageContext.setAttribute(FLAG, (Object)Boolean.TRUE, 2);
            }
        }
        catch (Exception e) {
            String message = "Error processing screen template:" + template + " using module: " + module;
            Log.error(message, e);
            try {
                data.getOut().print("Error processing screen template: " + template + " using module: " + module);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return 0;
    }
}

