# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1539-1 (mapserver)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60784);
 script_cve_id("CVE-2007-4542", "CVE-2007-4629");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1539-1 (mapserver)";
 script_name(name);

 desc = "The remote host is missing an update to mapserver
announced via advisory DSA 1539-1.

Chris Schmidt and Daniel Morissette discovered two vulnerabilities
in mapserver, a development environment for spatial and mapping
applications.  The Common Vulnerabilities and Exposures project
identifies the following two problems:

CVE-2007-4542

Lack of input sanitizing and output escaping in the CGI
mapserver's template handling and error reporting routines leads
to cross-site scripting vulnerabilities.

CVE-2007-4629

Missing bounds checking in mapserver's template handling leads to
a stack-based buffer overrun vulnerability, allowing a remote
attacker to execute arbitrary code with the privileges of the CGI
or httpd user.

For the stable distribution (etch), these problems have been fixed in
version 4.10.0-5.1+etch2.

For the unstable distribution (sid), these problems have been fixed in
version 4.10.3-1.

We recommend that you upgrade your mapserver (4.10.0-5.1+etch2) package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201539-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1539-1 (mapserver)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mapserver-doc", ver:"4.10.0-5.1+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cgi-mapserver", ver:"4.10.0-5.1+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-mapscript", ver:"4.10.0-5.1+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mapserver-bin", ver:"4.10.0-5.1+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-mapscript", ver:"4.10.0-5.1+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-mapscript", ver:"4.10.0-5.1+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-mapscript", ver:"4.10.0-5.1+etch2", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
