# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 167-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53424);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 167-1 (Konquerer)";
 script_name(name);

 desc = "The remote host is missing an update to Konquerer
announced via advisory DSA 167-1.

A cross site scripting problem has been discovered in Konquerer, a
famous browser for KDE and other programs using KHTML.  The KDE team
reports that Konqueror's cross site scripting protection fails to
initialize the domains on sub-(i)frames correctly.  As a result,
Javascript is able to access any foreign subframe which is defined in
the HTML source.  Users of Konqueror and other KDE software that uses
the KHTML rendering engine may become victim of a cookie stealing and
other cross site scripting attacks.

This problem has been fixed in version 2.2.2-13.woody.3 for the
current stable distribution (woody) and in version 2.2.2-14 for the
unstable distribution (sid).  The old stable distribution (potato) is
not affected since it didn't ship KDE.

We recommend that you upgrade your kdelibs package and restart


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20167-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 167-1 (Konquerer)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"kdelibs3-doc", ver:"2.2.2-13.woody.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs3", ver:"2.2.2-13.woody.3", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
