# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1919-1 (smarty)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66103);
 script_cve_id("CVE-2008-4810", "CVE-2009-1669");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 script_name("Debian Security Advisory DSA 1919-1 (smarty)");

 desc = "The remote host is missing an update to smarty
announced via advisory DSA 1919-1.

Several remote vulnerabilities have been discovered in Smarty, a PHP
templating engine. The Common Vulnerabilities and Exposures project
identifies the following problems:

CVE-2008-4810

The _expand_quoted_text function allows for certain restrictions in
templates, like function calling and PHP execution, to be bypassed.

CVE-2009-1669

The smarty_function_math function allows context-dependent attackers
to execute arbitrary commands via shell metacharacters in the equation
attribute of the math function.

For the old stable distribution (etch), these problems have been fixed
in version 2.6.14-1etch2.

For the stable distribution (lenny), these problems have been fixed in
version 2.6.20-1.2.

For the unstable distribution (sid), these problems will be fixed soon.

We recommend that you upgrade your smarty package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201919-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1919-1 (smarty)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"smarty", ver:"2.6.14-1etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"smarty", ver:"2.6.20-1.2", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
