# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 640-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53104);
 script_cve_id("CVE-2005-0016");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.2");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 640-1 (gatos)";
 script_name(name);

 desc = "The remote host is missing an update to gatos
announced via advisory DSA 640-1.

Erik Sjlund discovered a buffer overflow in xatitv, one of the
programs in the gatos package, that is used to display video with
certain ATI video cards.  xatitv is installed setuid root in order to
gain direct access to the video hardware.

For the stable distribution (woody) this problem has been fixed in
version 0.0.5-6woody3.

For the unstable distribution (sid) this problem has been fixed in
version 0.0.5-15.

We recommend that you upgrade your gatos package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20640-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 640-1 (gatos)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"gatos", ver:"0.0.5-6woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgatos-dev", ver:"0.0.5-6woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgatos0", ver:"0.0.5-6woody3", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
