###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for amarok FEDORA-2008-7719
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860776);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"3.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_xref(name: "FEDORA", value: "2008-7719");
  script_cve_id("CVE-2008-3699");
  script_name( "Fedora Update for amarok FEDORA-2008-7719");
  desc = "

  Vulnerability Insight:
  Amarok is a multimedia player with:
   - fresh playlist concept, very fast to use, with drag and drop
   - plays all formats supported by the various engines
   - audio effects, like reverb and compressor
   - compatible with the .m3u and .pls formats for playlists
   - nice GUI, integrates into the KDE look, but with a unique touch
  
  
  Amarok can use various engines to decode sound : helix and xine.
  To use the helix engine, you need to install either HelixPlayer
  or RealPlayer


  Affected Software/OS:
  amarok on Fedora 8

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-September/msg00097.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of amarok");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC8")
{

  if(isrpmvuln(pkg:"amarok", rpm:"amarok~1.4.10~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}