###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_opera_mult_url_spoof_vuln_sep09_lin.nasl 4477 2009-09-03 17:32:26Z sep $
#
# Opera Multiple URL Spoofing Vulnerabilities - Sep09 (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800888);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"6.8");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-3044", "CVE-2009-3045", "CVE-2009-3046",
                "CVE-2009-3047", "CVE-2009-3048", "CVE-2009-3049");
  script_name("Opera Multiple URL Spoofing Vulnerabilities - Sep09 (Linux)");
  desc = "
  Overview: This host is installed with Opera Web Browser and is prone to
  Multiple Spoof URL vulnerabilities.

  Vulnerability Insight:
  - Opera fails to handle a '\0' character or invalid wildcard character in a
    domain name in the subject's Common Name (CN) field of an X.509 certificate.
  - The Trusts root X.509 certificates signed with the MD2 algorithm, which
    makes it easier for man-in-the-middle attackers to spoof arbitrary SSL
    servers via a crafted server certificate.
  - Opera fails to check all intermediate X.509 certificates for revocation.
  - When a collapsed address bar is used, Opera does not properly update the
    domain name from the previously visited site to the currently visited site.
  - Opera fails to display all characters in Internationalized Domain Names
    (IDN) in the address bar.

  Impact:
  Successful exploitation will let the attackers to conduct URL spoofing, and
  can cause Security Bypass in the victim's system.

  Impact Level: Application

  Affected Software/OS:
  Opera version prior to 10.00 on Linux.

  Fix: Upgrade to Opera version 10.00
  http://www.opera.com/browser/download/

  References:
  http://www.opera.com/support/kb/view/934/
  http://www.opera.com/support/kb/view/933/
  http://www.opera.com/support/kb/view/929/
  http://www.opera.com/support/kb/view/930/
  http://www.opera.com/support/kb/view/932/
  http://www.opera.com/docs/changelogs/linux/1000/

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.0
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Opera Web Browser");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("secpod_opera_detection_linux_900037.nasl");
  script_require_keys("Opera/Linux/Version");
  exit(0);
}


include("version_func.inc");

operaVer = get_kb_item("Opera/Linux/Version");

if(isnull(operaVer))
{
  exit(0);
}

# Check for Opera Version < 10.00
if(version_is_less(version:operaVer, test_version:"10.00")){
  security_warning(0);
}
