###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_avast_av_aswrdr_bof_vuln.nasl 5883 2009-11-25 13:44:02Z nov $
#
# avast! 'aswRdr.sys' Buffer Overflow Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900985);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.2");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-4049");
  script_bugtraq_id(37031);
  script_name("avast! 'aswRdr.sys' Buffer Overflow Vulnerability");
  desc = "
  Overview: This host is installed with avast! AntiVirus and is prone to Buffer
  Overflow vulnerability.

  Vulnerability Insight:
  The vulnerability is caused due to an error in 'aswRdr.sys' when processing
  IOCTLs. This can be exploited to corrupt kernel memory via a specially crafted
  0x80002024 IOCTL.

  Impact:
  Successful exploitation could allow remote attackers to cause a Denial of
  Service or potentially gain escalated privileges.

  Impact Level: System/Application

  Affected Software/OS:
  avast! Home and Professional version 4.8.1356 and prior on Windows.

  Fix: Upgrade to avast! Home and Professional version 4.8.1367 or later
  For updates refer, http://www.avast.com/eng/download.html

  References:
  http://secunia.com/advisories/37368/
  http://en.securitylab.ru/nvd/388054.php
  http://www.vupen.com/english/advisories/2009/3266
  http://www.efblog.net/2009/11/avast-aswrdrsys-kernel-pool-corruption.html

  CVSS Score:
    CVSS Base Score     : 7.2 (AV:L/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.4
  Risk factor: High";

  script_description(desc);
  script_summary("Check  the version of avast ! Antivirus");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("gb_avast_av_detect_win.nasl");
  script_require_keys("Avast!/AV/Win/Ver");
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

avastVer = get_kb_item("Avast!/AV/Win/Ver");
if(isnull(avastVer)){
  exit(0);
}

# Check for avast! version 4.8.1356 and prior
if(version_is_less_equal(version:avastVer, test_version:"4.8.1356.0"))
{
  sysPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                            item:"Install Path");
  if(!sysPath){
    exit(0);
  }

  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:sysPath);
  file = ereg_replace(pattern:"[A-Z]:(.*)",  replace:"\1",  string:sysPath +
                                                     "\drivers\aswRdr.sys");
  # Get the version of aswRdr.sys
  sysVer = GetVer(share:share, file:file);
  if((sysVer != NULL) && version_is_equal(version:sysVer,
                                          test_version:"4.8.1356.0")){
   security_hole(0);
  }
}
