###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_google_chrome_pdf_js_rest_bypass_vuln.nasl 2252 2009-05-15 17:11:10Z may $
#
# Google Chrome PDF Javascript Security Bypass Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900707);
  script_version("$Revision: 7922 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-1598");
  script_name("Google Chrome PDF Javascript Security Bypass Vulnerability");
  desc = "

  Overview: The host is installed with Google Chrome and is prone to PDF
  Javascript Security Bypass Vulnerability.

  Vulnerability Insight:
  An error in Adobe Acrobat JavaScript protocol handler in the context of browser
  when a PDF file is opened in it via execute DOM calls in response to a
  javascript: URI.

  Impact:
  Successful exploitation will let attacker to execute arbitrary code result in
  spoof URLs, bypass the security restriction, XSS, Memory corruption, phishing
  attacks and steal generic information from website.

  Impact level: Application/Network

  Affected Software/OS:
  Google Chrome versions 1.0.154.65 and prior and 2.0.180.0 and prior.

  Fix: Upgrade to Google Chrome version 4.1.249.1064 or later.
  For updates refer, http://www.google.com/chrome

  References:
  http://www.securityfocus.com/archive/1/archive/1/503183/100/0/threaded
  http://secniche.org/papers/SNS_09_03_PDF_Silent_Form_Re_Purp_Attack.pdf

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of Google Chrome");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("gb_google_chrome_detect_win.nasl");
  script_require_keys("GoogleChrome/Win/Ver");
  exit(0);
}


include("version_func.inc");

chromeVer = get_kb_item("GoogleChrome/Win/Ver");
if(chromeVer == NULL){
  exit(0);
}

if(version_in_range(version:chromeVer, test_version:"2.0", test_version2:"2.0.180.0")||
   version_is_less_equal(version:chromeVer, test_version:"1.0.154.65")){
  security_hole(0);
}
