###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_google_chrome_rss_n_atom_xss_vuln.nasl 4892 2009-09-21 18:00:29Z sep $
#
# Google Chrome RSS Or Atom Feed Cross-Site Scripting Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900861);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-3263");
  script_bugtraq_id(36416);
  script_name("Google Chrome RSS Or Atom Feed Cross-Site Scripting Vulnerability");
  desc = "
  Overview: This host is installed with Google Chrome and is prone to Cross-Site
  Scripting vulnerability.

  Vulnerability Insight:
  An XSS vulnerability exists when the application fails to handle 'RSS' and 'Atom'
  feed, related to the rendering of the application/rss+xml content type as
  'scripted content.'.

  Impact:
  Successful exploitation will let the remote attackers to inject arbitrary web
  script or HTML on the victim's system.

  Impact Level: Application

  Affected Software/OS:
  Google Chrome version 2.x and 3.x before 3.0.195.21 on Windows.

  Fix: Upgrade to Google Chrom version 3.0.195.21 or later
  http://www.google.com/chrome

  References:
  http://secunia.com/advisories/36770
  http://www.securityfocus.com/archive/1/archive/1/506517/100/0/threaded
  http://googlechromereleases.blogspot.com/2009/09/stable-channel-update.html
  http://securethoughts.com/2009/09/exploiting-chrome-and-operas-inbuilt-atomrss-reader-with-script-execution-and-more/

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 3.2
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Google Chrome");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("gb_google_chrome_detect_win.nasl");
  script_require_keys("GoogleChrome/Win/Ver");
  exit(0);
}


include("version_func.inc");

chromeVer = get_kb_item("GoogleChrome/Win/Ver");
if(!chromeVer){
  exit(0);
}

# Check for Google Chrome version 2.x < 3.0.195.21
if(chromeVer =~ "^(2|3)\..*")
{
  if(version_is_less(version:chromeVer, test_version:"3.0.195.21")){
    security_warning(0);
  }
}
