/***************************************************************************
 *   Copyright (C) 2007-2010 by Vegeta          			   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef CORE_H
#define CORE_H
#include <QString>
#include <QDateTime>
#include <QFileInfo>

class Core{
public:
    Core();
    ~Core(){};

    QList<QString>allFiles;
    void resetVariables();
    QString FilenameWithoutPath(const int &Nummer);
    QString TimeUpdateString();
    void setStartTime(){m_Now = QDateTime::currentDateTime();}

    void addFinishedFiles() {
        ++m_finishedFiles;
        ++m_filesProcessed;
        ++m_filesGained;
    }
    int  finishedFiles() const {return m_finishedFiles;}

    void addSkippedFiles() {
        ++m_skippedFiles;
        --m_filesGained;
    }
    int  skippedFiles() const {return m_skippedFiles;}

    void addErrors() {
        ++m_Errors;
        --m_filesGained;
    }
    int  Errors() const {return m_Errors;}

    void setVolume(const int &val) {m_Volume = val;}
    int  Volume() const {return m_Volume;}

    void setTrackGain(const bool &val) {m_isTrackGain = val;}
    bool isTrackGain() const {return m_isTrackGain;}

    void setShowBrowserAtStatup(const bool &val) {m_isShowBrowser = val;}
    bool isShowBrowserAtStatup() const {return m_isShowBrowser;}

    void setOperationCanceled(const bool &val) {m_isCancel = val;}
    bool isOperationCanceled() const {return m_isCancel;}

    void addToErrorlog(const QString &Error) {m_Errorlog.append(Error);}
    QString ErrorLog() const {return m_Errorlog;}

    bool isLogSkippedFiles() const {return m_isLogSkippedFiles;}
    void setIsLogSkippedFiles(const bool &val) {m_isLogSkippedFiles = val;}

    void setCurrentFileName(const QString &val) {m_Filename = val;}
    QString currentFileName() const {return m_Filename;}

    bool isMP3GainFound() const {return m_isMP3Gain_found;}
    void setIsMP3GainFound(const bool &val) {m_isMP3Gain_found = val;}

    bool isMP4Gain_found() const {return m_isMP4Gain_found;}
    void setIsMP4GainFound(const bool &val) {m_isMP4Gain_found = val;}

    bool isVorbisGainFound() const {return m_isVorbisGain_found;}
    void setIsVorbisGainFound(const bool &val) {m_isVorbisGain_found = val;}

    bool isFlacGainFound() const {return m_isFlacGain_found;}
    void setIsFlacGainFound(const bool &val) {m_isFlacGain_found = val;}

    QString MP3GainBinaryPath() const {return m_MP3GainBinaryPath;}
    void setMP3GainBinaryPath(const QString &Pfad){m_MP3GainBinaryPath = Pfad;}

    QString MP4GainBinaryPath() const {return m_MP4GainBinaryPath;}
    void setMP4GainBinaryPath(const QString &Pfad){m_MP4GainBinaryPath = Pfad;}

    QString VorbisGainBinaryPath() const {return m_VorbisGainBinaryPath;}
    void setVorbisGainBinaryPath(const QString &Pfad){m_VorbisGainBinaryPath = Pfad;}

    QString FlacGainBinaryPath() const {return m_FlacGainBinaryPath;}
    void setFlacGainBinaryPath(const QString &Pfad){m_FlacGainBinaryPath = Pfad;}

    void Statistic(int &filesProcessed, int &filesGained, QDate &installDate) {
        filesProcessed = m_filesProcessed;
        filesGained    = m_filesGained;
        installDate    = m_installDate;
    }
    
    void setStatistic(const int &filesProcessed, const int &filesGained, const QDate installDate) {
        m_filesProcessed = filesProcessed;
        m_filesGained    = filesGained;
        m_installDate    = installDate;
    }

private:
    bool m_isTrackGain, m_isShowBrowser, m_isCancel, m_isMP3Gain_found, m_isMP4Gain_found, m_isVorbisGain_found, m_isFlacGain_found, m_isLogSkippedFiles;
    int m_finishedFiles, m_Errors, m_skippedFiles, m_Volume, m_filesProcessed, m_filesGained;
    QString m_MP3GainBinaryPath, m_VorbisGainBinaryPath, m_FlacGainBinaryPath, m_MP4GainBinaryPath;
    QString m_Errorlog, m_Filename;
    QDateTime m_Now;
    QDate m_installDate;
};

#endif // CORE_H
