% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities-checks.R
\name{check_device}
\alias{check_device}
\title{Check graphics device capabilities}
\usage{
check_device(
  feature,
  action = "warn",
  op = NULL,
  maybe = FALSE,
  call = caller_env()
)
}
\arguments{
\item{feature}{A string naming a graphics device feature. One of:
\code{"clippingPaths"}, \code{"alpha_masks"}, \code{"lumi_masks"}, \code{"compositing"},
\code{"blending"}, \code{"transformations"}, \code{"gradients"}, \code{"patterns"}, \code{"paths"}
or \code{"glyphs"}. See the 'Features' section below for an explanation
of these terms.}

\item{action}{A string for what action to take. One of:
\itemize{
\item \code{"test"} returns \code{TRUE} or \code{FALSE} indicating support of the feature.
\item \code{"warn"} also returns a logical, but throws an informative warning when
\code{FALSE}.
\item \code{"abort"} throws an error when the device is estimated to not support
the feature.
}}

\item{op}{A string for a specific operation to test for when \code{feature} is
either \code{"blending"} or \code{"compositing"}. If \code{NULL} (default), support for
all known blending or compositing operations is queried.}

\item{maybe}{A logical of length 1 determining what the return value should
be in case the device capabilities cannot be assessed. When the current
device is the 'null device', \code{maybe} is returned.}

\item{call}{The execution environment of a currently running function, e.g.
\code{\link[rlang:stack]{caller_env()}}. The function will be mentioned in
warnings and error messages as the source of the warning or error. See
the \code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}
}
\value{
\code{TRUE} when the feature is thought to be supported and \code{FALSE}
otherwise.
}
\description{
This function makes an attempt to estimate whether the graphics device is
able to render newer graphics features.
}
\details{
The procedure for testing is as follows:
\itemize{
\item First, the \R version is checked against the version wherein a feature was
introduced.
\item Next, the \link[grDevices:dev.capabilities]{dev.capabilities()} function is
queried for support of the feature.
\item If that check is ambiguous, the \pkg{svglite} and \pkg{ragg} devices are
checked for known support.
\item Lastly, if there is no answer yet, it is checked whether the device is one
of the 'known' devices that supports a feature.
}
}
\section{Features}{

\describe{
\item{\code{"clippingPaths"}}{While most devices support rectangular clipping
regions, this feature is about the support for clipping to arbitrary paths.
It can be used to only display a part of a drawing.}
\item{\code{"alpha_masks"}}{Like clipping regions and paths, alpha masks can also
be used to only display a part of a drawing. In particular a
semi-transparent mask can be used to display a drawing in the opaque parts
of the mask and hide a drawing in transparent part of a mask.}
\item{\verb{"lumi_masks}}{Similar to alpha masks, but using the mask's luminance
(greyscale value) to determine what is drawn. Light values are opaque and
dark values are transparent.}
\item{\code{"compositing"}}{Compositing allows one to control how to drawings
are drawn in relation to one another. By default, one drawing is drawn
'over' the previous one, but other operators are possible, like 'clear',
'in' and 'out'.}
\item{\code{"blending"}}{When placing one drawing atop of another, the blend
mode determines how the colours of the drawings relate to one another.}
\item{\code{"transformations"}}{Performing an affine transformation on a group
can be used to translate, rotate, scale, shear and flip the drawing.}
\item{\code{"gradients"}}{Gradients can be used to show a transition between
two or more colours as a fill in a drawing. The checks expects both linear
and radial gradients to be supported.}
\item{\code{"patterns"}}{Patterns can be used to display a repeated, tiled
drawing as a fill in another drawing.}
\item{\code{"paths"}}{Contrary to 'paths' as polyline or polygon drawings,
\code{"paths"} refers to the ability to fill and stroke collections of
drawings.}
\item{\code{"glyphs"}}{Refers to the advanced typesetting feature for
controlling the appearance of individual glyphs.}
}
}

\section{Limitations}{

\itemize{
\item On Windows machines, bitmap devices such as \code{png()} or \code{jpeg()} default
to \code{type = "windows"}. At the time of writing, these don't support any
new features, in contrast to \code{type = "cairo"}, which does. Prior to \R
version 4.2.0, the capabilities cannot be resolved and the value of the
\code{maybe} argument is returned.
\item With the exception of the \pkg{ragg} and \pkg{svglite} devices, if the
device doesn't report their capabilities via
\link[grDevices:dev.capabilities]{dev.capabilities()}, or the \R version is
below 4.2.0, the \code{maybe} value is returned.
\item Even though patterns and gradients where introduced in \R 4.1.0, they
are considered unsupported because providing vectorised patterns and
gradients was only introduced later in \R 4.2.0.
\item When using the RStudio graphics device, the back end is assumed to be the
next device on the list. This assumption is typically met by default,
unless the device list is purposefully rearranged.
}
}

\examples{
# Typically you'd run `check_device()` inside a function that might produce
# advanced graphics.
# The check is designed for use in control flow statements in the test mode
if (check_device("patterns", action = "test")) {
  print("Yay")
} else {
  print("Nay")
}

# Automatically throw a warning when unavailable
if (check_device("compositing", action = "warn")) {
  print("Yay")
} else {
  print("Nay")
}

# Possibly throw an error
try(check_device("glyphs", action = "abort"))
}
\keyword{internal}
