% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmer_anova.R
\name{anova.lmerModLmerTest}
\alias{anova.lmerModLmerTest}
\title{ANOVA Tables for Linear Mixed Models}
\usage{
\method{anova}{lmerModLmerTest}(object, ..., type = c("III", "II", "I",
  "3", "2", "1"), ddf = c("Satterthwaite", "Kenward-Roger", "lme4"))
}
\arguments{
\item{object}{an \code{lmerModLmerTest} object; the result of \code{lmer()}
after loading the \pkg{lmerTest}-package.}

\item{...}{potentially additional \code{lmer} or \code{lm} model objects for
comparison of models in which case \code{type} and \code{ddf} arguments are
ignored.}

\item{type}{the type of ANOVA table requested (using SAS terminology)
with Type I being the familiar sequential ANOVA table.}

\item{ddf}{the method for computing the denominator degrees of freedom and
F-statistics. \code{ddf="Satterthwaite"} (default) uses Satterthwaite's method;
\code{ddf="Kenward-Roger"} uses Kenward-Roger's method,
\code{ddf = "lme4"} returns the lme4-anova table, i.e., using the anova
method for \code{lmerMod} objects as defined in the \pkg{lme4}-package and
ignores the \code{type} argument. Partial matching is allowed.}
}
\value{
an ANOVA table
}
\description{
ANOVA table with F-tests and p-values using Satterthwaite's or
Kenward-Roger's method for denominator degrees-of-freedom and F-statistic.
Models should be fitted with
\code{\link{lmer}} from the \pkg{lmerTest}-package.
}
\details{
The \code{"Kenward-Roger"} method calls \code{pbkrtest::KRmodcomp} internally and
reports scaled F-statistics and associated denominator degrees-of-freedom.
}
\examples{

data("sleepstudy", package="lme4")
m <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy)
anova(m) # with p-values from F-tests using Satterthwaite's denominator df
anova(m, ddf="lme4") # no p-values

# Use the Kenward-Roger method
if(requireNamespace("pbkrtest", quietly = TRUE))
  anova(m, ddf="Kenward-Roger")

\dontshow{
  an1 <- anova(m) # with p-values from F-tests using Satterthwaite's denominator df
  an2 <- anova(m, ddf="lme4")
  stopifnot(
    all(colnames(an1) == c("Sum Sq", "Mean Sq", "NumDF", "DenDF", "F value", "Pr(>F)")),
    !"Pr(>F)" \%in\% colnames(an2),
    all(!is.na(an1)),
    all(!is.na(an2))
  )
}
}
\seealso{
\code{\link{contestMD}} for multi degree-of-freedom contrast tests
and \code{\link[pbkrtest]{KRmodcomp}} for the \code{"Kenward-Roger"} method.
}
\author{
Rune Haubo B. Christensen and Alexandra Kuznetsova
}
