% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list.parse.R
\name{list.parse}
\alias{list.parse}
\alias{list.parse.default}
\alias{list.parse.matrix}
\alias{list.parse.data.frame}
\alias{list.parse.character}
\title{Convert an object to list with identical structure}
\usage{
list.parse(x, ...)

\method{list.parse}{default}(x, ...)

\method{list.parse}{matrix}(x, ...)

\method{list.parse}{data.frame}(x, ...)

\method{list.parse}{character}(x, type, ...)
}
\arguments{
\item{x}{\code{An object}}

\item{...}{Additional parameters passed to converter function}

\item{type}{The type of data to parse. Currently json and yaml are supported.}
}
\value{
\code{list} object representing the data in \code{x}
}
\description{
This function converts an object representing data to
list that represents the same data. For example, a
\code{data.frame} stored tabular data column-wisely,
that is, each column represents a vector of a certain
type. \code{list.parse} converts a \code{data.frame} to
a list which represents the data row-wisely so that it
can be more convinient to perform other non-tabular data
manipulation methods.
}
\examples{
x <- data.frame(a=1:3,type=c('A','C','B'))
list.parse(x)

x <- matrix(rnorm(1000),ncol=5)
rownames(x) <- paste0('item',1:nrow(x))
colnames(x) <- c('a','b','c','d','e')
list.parse(x)

z <- '
a:
  type: x
  class: A
  registered: yes
'
list.parse(z, type='yaml')
}
