% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/m_range.R
\docType{data}
\name{st_m_range}
\alias{st_m_range}
\alias{is.na.m_range}
\alias{st_m_range.POINT}
\alias{st_m_range.MULTIPOINT}
\alias{st_m_range.LINESTRING}
\alias{st_m_range.POLYGON}
\alias{st_m_range.MULTILINESTRING}
\alias{st_m_range.MULTIPOLYGON}
\alias{st_m_range.GEOMETRYCOLLECTION}
\alias{st_m_range.MULTISURFACE}
\alias{st_m_range.MULTICURVE}
\alias{st_m_range.CURVEPOLYGON}
\alias{st_m_range.COMPOUNDCURVE}
\alias{st_m_range.POLYHEDRALSURFACE}
\alias{st_m_range.TIN}
\alias{st_m_range.TRIANGLE}
\alias{st_m_range.CIRCULARSTRING}
\alias{st_m_range.sfc}
\alias{st_m_range.sf}
\alias{st_m_range.numeric}
\alias{NA_m_range_}
\title{Return 'm' range of a simple feature or simple feature set}
\format{
An object of class \code{m_range} of length 2.
}
\usage{
\method{is.na}{m_range}(x)

st_m_range(obj, ...)

\method{st_m_range}{POINT}(obj, ...)

\method{st_m_range}{MULTIPOINT}(obj, ...)

\method{st_m_range}{LINESTRING}(obj, ...)

\method{st_m_range}{POLYGON}(obj, ...)

\method{st_m_range}{MULTILINESTRING}(obj, ...)

\method{st_m_range}{MULTIPOLYGON}(obj, ...)

\method{st_m_range}{GEOMETRYCOLLECTION}(obj, ...)

\method{st_m_range}{MULTISURFACE}(obj, ...)

\method{st_m_range}{MULTICURVE}(obj, ...)

\method{st_m_range}{CURVEPOLYGON}(obj, ...)

\method{st_m_range}{COMPOUNDCURVE}(obj, ...)

\method{st_m_range}{POLYHEDRALSURFACE}(obj, ...)

\method{st_m_range}{TIN}(obj, ...)

\method{st_m_range}{TRIANGLE}(obj, ...)

\method{st_m_range}{CIRCULARSTRING}(obj, ...)

\method{st_m_range}{sfc}(obj, ...)

\method{st_m_range}{sf}(obj, ...)

\method{st_m_range}{numeric}(obj, ..., crs = NA_crs_)

NA_m_range_
}
\arguments{
\item{x}{object of class \code{m_range}}

\item{obj}{object to compute the m range from}

\item{...}{ignored}

\item{crs}{object of class \code{crs}, or argument to \link{st_crs}, specifying the CRS of this bounding box.}
}
\value{
a numeric vector of length two, with \code{mmin} and \code{mmax} values;
if \code{obj} is of class \code{sf} or \code{sfc} the object
if \code{obj} is of class \code{sf} or \code{sfc} the object
returned has a class \code{m_range}
}
\description{
Return 'm' range of a simple feature or simple feature set
}
\details{
\code{NA_m_range_} represents the missing value for a \code{m_range} object
}
\examples{
a = st_sf(a = 1:2, geom = st_sfc(st_point(0:3), st_point(1:4)), crs = 4326)
st_m_range(a)
st_m_range(c(mmin = 16.1, mmax = 16.6), crs = st_crs(4326))
}
\keyword{datasets}
