# ###################################################
# Copyright (C) 2012 The Unknown Horizons Team
# team@unknown-horizons.org
# This file is part of Unknown Horizons.

# Unknown Horizons is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the
# Free Software Foundation, Inc.,
# 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
# ###################################################

import logging

from horizons.component import Component

class BuildableComponent(Component):
	"""
	"""
	log = logging.getLogger("component.buildable")

	# Store the name of this component
	NAME = 'buildable'

	def __init__(self, allow, deny, nearof):
		super(BuildableComponent, self).__init__()
		assert maxhealth is not None, "Can not add HealthComponent without maxhealth!"
		self.max_health = float(maxhealth) if maxhealth is not None else None

	def initialize(self):
		self.health = float(self.max_health)
		self._add_listeners()

	def save(self, db):
		db("INSERT INTO unit_health(owner_id, health) VALUES(?, ?)", self.instance.worldid, self.health)

	def load(self, db, worldid):
		self.health = db.get_health(worldid)


