/*******************************************************************************
 * Part of "Intel(R) Active Management Technology (Intel(R) AMT)
 *                   User Notification Service (UNS)"
 *
 * Copyright (c) 2007 Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce at minimum a disclaimer
 *    substantially similar to the "NO WARRANTY" disclaimer below
 *    ("Disclaimer") and any redistribution must be conditioned upon
 *    including a substantially similar Disclaimer requirement for further
 *    binary redistribution.
 * 3. Neither the names of the above-listed copyright holders nor the names
 *    of any contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 * NO WARRANTY
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *******************************************************************************/

#ifndef _BASE_WSMAN_CLIENT_H
#define _BASE_WSMAN_CLIENT_H

#include <string>
#include <openwsman/cpp/OpenWsmanClient.h>

#define FQDN_MAX_SIZE 256
#define OID_LOCAL  "2.16.840.1.113741.1.2.2"

using namespace WsmanClientNamespace;

// Constants for the common use
static const int TIMEOUT = 5;
static const int AMT_NON_SECURE_PORT = 16992;
static const int AMT_SECURE_PORT	 = 16993;


class UNSEventLogger;
struct Credentials;
struct CredentialsRegInfo;

class BaseWSManClient
{
public:

	// Contructors and Destructor.
	BaseWSManClient(const CredentialsRegInfo &CredRegInfo,
					const std::string &defaultUser, const std::string &defaultPass);

	virtual ~BaseWSManClient();

	void	SetLogger(UNSEventLogger *logger); // Set a pointer to an event logger.
	void	SetCredentials(const Credentials &creds);

	const std::string &GetIP() const {return m_ip;}
	void SetIP(const std::string &ip) {m_ip = ip;}

protected:
	int		SetEndpoint			(bool secure);		// Set endpoint for wsman request.

	// Data members
	std::string							endpoint;
	bool								m_endpoint;		// True iff endpoint is correct.
	UNSEventLogger	*m_Logger;						// Used for log events.

private:
	void Init();						// Initialize soap client.
	int		FindHostsFileFQDN	(char *fqdn);	// Find the LMS inserted FQDN in the hosts file
	int		GetNetworkFQDN		(char *fqdn);	// Use GetNetworkParams to get local FQDN

	static const std::string IP_LOCALHOST;

	// Data members
protected:
	OpenWsmanClient							*m_client;		// WSMan client.
	Credentials							*m_ClientCred;	// Credentials used for soap client
	std::string							m_fqdn;			// FQDN of the server.
	std::string							m_ip;
	const CredentialsRegInfo &m_CredRegInfo;
private:
	std::string							m_defaultUser;
	std::string							m_defaultPass;
};

#endif //_BASE_WSMAN_CLIENT_H
