/**
 * UserEventList.java
 *
 * Created on Jul 4, 2006
 * 
 * Copyright (c) 2006 Eureka Team
 */
package events;

import maths.CoordSyst;

/**
 * Cette interface represente un objet qui reoit les events utilisateur.
 * @see events.UserEventProd
 *
 * @author Nicolae
 */
public interface UserEventList {
	
	/**
	 * Appele quand le point cible a change dans <code>source</code>.
	 *
	 * @param source la source de l'evenement.
	 * @param re partie reele du point.
	 * @param im partie imaginaire du point.
	 */
	public void point(UserEventProd source, double re, double im);
		
	/**
	 * Appele quand le zoom a change dans <code>source</code>.
	 *
	 * @param source la source de l'evenement.
	 * @param coord les coordonees du nouveau zoom.
	 */
	public void zoom(UserEventProd source, CoordSyst coord);
}
