/*
 * Decompiled with CFR 0.152.
 */
package fr.ove.openmath.jome.model;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public abstract class Node
implements Serializable,
Cloneable {
    private Node father = null;
    private Vector children;
    private int rank = 0;
    private int nbStrahler = 1;
    private int depth = 0;

    public Node getFather() {
        return this.father;
    }

    public int getRank() {
        return this.rank;
    }

    public Node getChild(int n) {
        Node node = null;
        if (this.children != null) {
            try {
                node = (Node)this.children.elementAt(n);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return null;
            }
        }
        return node;
    }

    public int getNbChildren() {
        int n = 0;
        if (this.children != null) {
            n = this.children.size();
        }
        return n;
    }

    public Vector getChildren() {
        return this.children;
    }

    public void setFather(Node node) {
        this.father = node;
        this.depth = node.depth + 1;
        if (this.children != null) {
            this.adjustChildrenDepth();
        }
    }

    public void addChild(Node node) {
        if (this.children == null) {
            this.children = new Vector(0, 1);
        }
        this.children.addElement(node);
        node.setFather(this);
        this.adjustRank();
    }

    public void addChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Vector(0, 1);
        }
        this.children.insertElementAt(node, n);
        node.setFather(this);
        this.adjustRank();
    }

    public void removeChild(int n) {
        if (this.children != null) {
            this.children.removeElementAt(n);
            this.adjustRank();
        }
    }

    public void removeChild(Node node) {
        if (this.children != null) {
            this.children.removeElement(node);
            this.adjustRank();
        }
    }

    public void removeAll() {
        if (this.children != null) {
            int n = this.children.size();
            for (int i = 0; i < n; ++i) {
                ((Node)this.children.elementAt((int)this.rank)).father = null;
            }
            this.children.setSize(0);
            this.children.trimToSize();
        }
    }

    private void adjustRank() {
        int n = 0;
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            ((Node)enumeration.nextElement()).rank = n++;
        }
    }

    private void changeRank(int n) {
        int n2 = this.rank;
        if (n > this.father.getNbChildren()) {
            n = this.father.getNbChildren() + 1;
            this.father.addChild(this);
        } else {
            if (n < 0) {
                n = 0;
            }
            this.father.addChild(this, n);
        }
        if (n < n2) {
            this.father.removeChild(n2 + 1);
        } else {
            this.father.removeChild(n2);
        }
    }

    public void moveChildren(Vector vector, int n) {
        int n2 = this.children.size();
        Node node = null;
        Node node2 = null;
        for (int i = 0; i < vector.size(); ++i) {
            node = (Node)vector.elementAt(i);
            if (i == 0) {
                node2 = node;
            }
            if (n > n2) {
                node.changeRank(n + (i + 1));
                continue;
            }
            node.changeRank(n);
            n = node2.getRank() + (i + 1);
        }
    }

    public boolean hasChild(Node node) {
        boolean bl = false;
        if (this.children != null) {
            bl = this.children.contains(node);
        }
        return bl;
    }

    public synchronized Object clone() {
        Node node = null;
        try {
            node = (Node)super.clone();
            node.father = null;
            if (this.children != null) {
                Vector<Object> vector = new Vector<Object>();
                int n = this.children.size();
                for (int i = 0; i < n; ++i) {
                    vector.addElement(((Node)this.children.elementAt(i)).clone());
                }
                node.children = vector;
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("clone failed !!");
        }
        return node;
    }

    public synchronized Object duplicate() {
        Node node = null;
        try {
            node = (Node)super.clone();
            node.father = null;
            node.children = new Vector();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("duplicate failed !!");
        }
        return node;
    }

    public int getDepth() {
        return this.depth;
    }

    public void computeDepth() {
        int n = 0;
        Node node = this.father;
        while (node != null) {
            ++n;
            node = node.father;
        }
        this.depth = n;
        if (this.children != null) {
            this.adjustChildrenDepth();
        }
    }

    private void adjustChildrenDepth() {
        Node node = null;
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            node = (Node)this.children.elementAt(i);
            node.depth = this.depth + 1;
            if (node.children == null) continue;
            node.adjustChildrenDepth();
        }
    }

    public int getNbStrahler() {
        return this.nbStrahler;
    }

    public void setNbStrahler(int n) {
        this.nbStrahler = n;
    }

    private void computeNodeNbStrahler() {
        if (this.children != null) {
            int n = this.children.size();
            if (n == 0) {
                this.nbStrahler = 1;
            } else if (n == 1) {
                this.nbStrahler = ((Node)this.children.elementAt((int)0)).nbStrahler;
            } else {
                int n2;
                int n3;
                int n4;
                int n5 = 0;
                int n6 = Integer.MAX_VALUE;
                for (n4 = 0; n4 < n; ++n4) {
                    n3 = ((Node)this.children.elementAt((int)n4)).nbStrahler;
                    n6 = n6 < n3 ? n6 : n3;
                    n5 = n5 > n3 ? n5 : n3;
                }
                n4 = n5 - n6 + 1;
                int[] nArray = new int[n4];
                for (n2 = 0; n2 < n4; ++n2) {
                    nArray[n2] = 0;
                }
                for (n2 = 0; n2 < n; ++n2) {
                    int n7 = ((Node)this.children.elementAt((int)n2)).nbStrahler - n6;
                    nArray[n7] = nArray[n7] + 1;
                }
                n2 = n5 - 1;
                n3 = n5 + nArray[n4 - 1] - 1;
                for (int i = n4 - 2; i >= 0; --i) {
                    if (nArray[i] == 0) continue;
                    int n8 = i + n6 + nArray[i] - 1;
                    if (n2 > n8) {
                        n2 -= nArray[i];
                        continue;
                    }
                    n3 += n8 - n2;
                    n2 = i + n6 - 1;
                }
                this.nbStrahler = n3;
            }
        }
    }

    public void computeNbStrahler() {
        if (this.children != null) {
            int n = this.children.size();
            for (int i = 0; i < n; ++i) {
                ((Node)this.children.elementAt(i)).computeNbStrahler();
            }
            this.computeNodeNbStrahler();
        }
    }
}

