module type V1 = sig
  include Alcotest_engine.V1.Cli.S with type return = unit Async.Deferred.t

  val test_case :
    ?timeout:Time_unix.Span.t ->
    string ->
    Alcotest.speed_level ->
    ('a -> unit Async.Deferred.t) ->
    'a test_case

  val test_case_sync :
    string -> Alcotest.speed_level -> ('a -> unit) -> 'a test_case
end

module type Alcotest_async = sig
  include V1

  (** {1 Versioned APIs} *)

  module V1 : V1
  (** An alias of the above API that provides a stability guarantees over major
      version changes. *)
end
