// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _gp_Lin2d_HeaderFile
#define _gp_Lin2d_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _gp_Ax2d_HeaderFile
#include <gp_Ax2d.hxx>
#endif
#ifndef _Standard_Storable_HeaderFile
#include <Standard_Storable.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_PrimitiveTypes_HeaderFile
#include <Standard_PrimitiveTypes.hxx>
#endif
class Standard_ConstructionError;
class gp_Ax2d;
class gp_Pnt2d;
class gp_Dir2d;
class gp_Trsf2d;
class gp_Vec2d;


Standard_EXPORT const Handle(Standard_Type)& STANDARD_TYPE(gp_Lin2d);

//! Describes a line in 2D space. <br>
//! A line is positioned in the plane with an axis (a gp_Ax2d <br>
//! object) which gives the line its origin and unit vector. A <br>
//! line and an axis are similar objects, thus, we can convert <br>
//! one into the other. <br>
//! A line provides direct access to the majority of the edit <br>
//! and query functions available on its positioning axis. In <br>
//! addition, however, a line has specific functions for <br>
//! computing distances and positions. <br>
//! See Also <br>
//! GccAna and Geom2dGcc packages which provide <br>
//! functions for constructing lines defined by geometric <br>
//! constraints <br>
//! gce_MakeLin2d which provides functions for more <br>
//! complex line constructions <br>
//! Geom2d_Line which provides additional functions for <br>
//! constructing lines and works, in particular, with the <br>
//! parametric equations of lines <br>
class gp_Lin2d  {

public:

  DEFINE_STANDARD_ALLOC

  //! Creates a Line corresponding to X axis of the <br>
//!            reference coordinate system. <br>
      gp_Lin2d();
  //! Creates a line located with A. <br>
      gp_Lin2d(const gp_Ax2d& A);
  
//!  <P> is the location point (origin) of the line and <br>
//!  <V> is the direction of the line. <br>
      gp_Lin2d(const gp_Pnt2d& P,const gp_Dir2d& V);
  
//!  Creates the line from the equation A*X + B*Y + C = 0.0 Raises ConstructionError if Sqrt(A*A + B*B) <= Resolution from gp. <br>//! Raised if Sqrt(A*A + B*B) <= Resolution from gp. <br>
  Standard_EXPORT   gp_Lin2d(const Standard_Real A,const Standard_Real B,const Standard_Real C);
  
        void Reverse() ;
  
//! Reverses the positioning axis of this line. <br>
//! Note: <br>
//! -   Reverse assigns the result to this line, while <br>
//! -   Reversed creates a new one. <br>
        gp_Lin2d Reversed() const;
  //!  Changes the direction of the line. <br>
        void SetDirection(const gp_Dir2d& V) ;
  //! Changes the origin of the line. <br>
        void SetLocation(const gp_Pnt2d& P) ;
  
//!  Complete redefinition of the line. <br>
//!  The "Location" point of <A> is the origin of the line. <br>
//!  The "Direction" of <A> is  the direction of the line. <br>
        void SetPosition(const gp_Ax2d& A) ;
  
//!  Returns the normalized coefficients of the line : <br>
//!  A * X + B * Y + C = 0. <br>
        void Coefficients(Standard_Real& A,Standard_Real& B,Standard_Real& C) const;
  //! Returns the direction of the line. <br>
       const gp_Dir2d& Direction() const;
  //! Returns the location point (origin) of the line. <br>
       const gp_Pnt2d& Location() const;
  
//!  Returns the axis placement one axis whith the same <br>
//!  location and direction as <me>. <br>
       const gp_Ax2d& Position() const;
  //! Computes the angle between two lines in radians. <br>
        Standard_Real Angle(const gp_Lin2d& Other) const;
  //!  Returns true if this line contains the point P, that is, if the <br>
//! distance between point P and this line is less than or <br>
//! equal to LinearTolerance. <br>
        Standard_Boolean Contains(const gp_Pnt2d& P,const Standard_Real LinearTolerance) const;
  
//!  Computes the distance between <me> and the point <P>. <br>
        Standard_Real Distance(const gp_Pnt2d& P) const;
  //! Computes the distance between two lines. <br>
        Standard_Real Distance(const gp_Lin2d& Other) const;
  
//!  Computes the square distance between <me> and the point <br>
//!  <P>. <br>
        Standard_Real SquareDistance(const gp_Pnt2d& P) const;
  //! Computes the square distance between two lines. <br>
        Standard_Real SquareDistance(const gp_Lin2d& Other) const;
  
//!  Computes the line normal to the direction of <me>, <br>
//!  passing through the point <P>. <br>
        gp_Lin2d Normal(const gp_Pnt2d& P) const;
  
  Standard_EXPORT     void Mirror(const gp_Pnt2d& P) ;
  
//!  Performs the symmetrical transformation of a line <br>
//!  with respect to the point <P> which is the center <br>
//!  of the symmetry <br>
  Standard_EXPORT     gp_Lin2d Mirrored(const gp_Pnt2d& P) const;
  
  Standard_EXPORT     void Mirror(const gp_Ax2d& A) ;
  
//!  Performs the symmetrical transformation of a line <br>
//!  with respect to an axis placement which is the axis <br>
//!  of the symmetry. <br>
  Standard_EXPORT     gp_Lin2d Mirrored(const gp_Ax2d& A) const;
  
        void Rotate(const gp_Pnt2d& P,const Standard_Real Ang) ;
  
//!  Rotates a line. P is the center of the rotation. <br>
//!  Ang is the angular value of the rotation in radians. <br>
        gp_Lin2d Rotated(const gp_Pnt2d& P,const Standard_Real Ang) const;
  
  Standard_EXPORT     void Scale(const gp_Pnt2d& P,const Standard_Real S) ;
  
//!  Scales a line. S is the scaling value. Only the <br>
//!  origin of the line is modified. <br>
        gp_Lin2d Scaled(const gp_Pnt2d& P,const Standard_Real S) const;
  
        void Transform(const gp_Trsf2d& T) ;
  
//!  Transforms a line with the transformation T from class Trsf2d. <br>
        gp_Lin2d Transformed(const gp_Trsf2d& T) const;
  
        void Translate(const gp_Vec2d& V) ;
  
//!  Translates a line in the direction of the vector V. <br>
//!  The magnitude of the translation is the vector's magnitude. <br>
        gp_Lin2d Translated(const gp_Vec2d& V) const;
  
        void Translate(const gp_Pnt2d& P1,const gp_Pnt2d& P2) ;
  
//!  Translates a line from the point P1 to the point P2. <br>
        gp_Lin2d Translated(const gp_Pnt2d& P1,const gp_Pnt2d& P2) const;
    const gp_Ax2d& _CSFDB_Getgp_Lin2dpos() const { return pos; }



protected:




private: 


gp_Ax2d pos;


};


#include <gp_Lin2d.lxx>



// other Inline functions and methods (like "C++: function call" methods)


#endif
