// Copyright (c) 1995-1999 Matra Datavision
// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and / or modify it
// under the terms of the GNU Lesser General Public version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

/*============================================================================*/
/*==== Titre: Graphic3d_CBitFields16.hxx				      */
/*==== Role : The header file of primitive type "CBitFields16" from Graphic3d */
/*====									      */
/*==== Implementation:  This is a primitive type implemented with typedef     */
/*============================================================================*/

#ifndef _Graphic3d_CBitFields16_HeaderFile
#define _Graphic3d_CBitFields16_HeaderFile

typedef struct {

	unsigned bool1	:1;
	unsigned bool2	:1;
	unsigned bool3	:1;
	unsigned bool4	:1;

	unsigned bool5	:1;
	unsigned bool6	:1;
	unsigned bool7	:1;
	unsigned bool8	:1;

	unsigned bool9	:1;
	unsigned bool10	:1;
	unsigned bool11	:1;
	unsigned bool12	:1;

	unsigned bool13	:1;
	unsigned bool14	:1;
	unsigned bool15	:1;
	unsigned bool16	:1;

} Graphic3d_CBitFields16;

#if defined(__cplusplus) || defined(c_plusplus)
/*==== Definition de Type ====================================================*/
#include <Standard_Type.hxx> 
const Handle(Standard_Type)&  STANDARD_TYPE(Graphic3d_CBitFields16);
/*============================================================================*/

#endif
#endif /*Graphic3d_CBitFields16_HeaderFile*/
