#
#VID d7cd5015-08c9-11da-bc08-0001020eed82
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55024);
 script_cve_id("CVE-2005-2430", "CVE-2005-2431");
 script_bugtraq_id(14405);
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "FreeBSD Ports: gforge";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: gforge

CVE-2005-2430
Multiple cross-site scripting (XSS) vulnerabilities in GForge 4.5
allow remote attackers to inject arbitrary web script or HTML via the
(1) forum_id or (2) group_id parameter to forum.php, (3)
project_task_id parameter to task.php, (4) id parameter to detail.php,
(5) the text field on the search page, (6) group_id parameter to
qrs.php, (7) form, (8) rows, (9) cols or (10) wrap parameter to
notepad.php, or the login field on the login form.

CVE-2005-2431
The (1) lost password and (2) account pending features in GForge 4.5
do not properly set a limit on the number of e-mails sent to an e-mail
address, which allows remote attackers to send a large number of
messages to arbitrary e-mail addresses (aka mail bomb).

Solution:
Update your system with the appropriate patches or
software upgrades.

http://marc.theaimsgroup.com/?l=bugtraq&m=112259845904350
http://www.vuxml.org/freebsd/d7cd5015-08c9-11da-bc08-0001020eed82.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: gforge";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"gforge");
if(!isnull(bver) && revcomp(a:bver, b:"0")>0) {
    security_note(0, data:"Package gforge version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
