#
#VID 192609c8-0c51-11df-82a0-00248c9b4be7
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 192609c8-0c51-11df-82a0-00248c9b4be7
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66819);
 script_cve_id("CVE-2009-4016", "CVE-2010-0300");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"6.8");
 script_tag(name:"risk_factor", value:"High");
 script_name("FreeBSD Ports: ircd-ratbox");

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   ircd-ratbox
   ircd-ratbox-devel

CVE-2009-4016
Integer underflow in the clean_string function in irc_string.c in (1)
IRCD-hybrid 7.2.2 and 7.2.3, (2) ircd-ratbox before 2.2.9, and (3)
oftc-hybrid before 1.6.8, when flatten_links is disabled, allows
remote attackers to execute arbitrary code or cause a denial of
service (daemon crash) via a LINKS command.

CVE-2010-0300
cache.c in ircd-ratbox before 2.2.9 allows remote attackers to cause a
denial of service (NULL pointer dereference and daemon crash) via a
HELP command.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.debian.org/security/2010/dsa-1980
http://lists.ratbox.org/pipermail/ircd-ratbox/2010-January/000890.html
http://lists.ratbox.org/pipermail/ircd-ratbox/2010-January/000891.html
http://www.vuxml.org/freebsd/192609c8-0c51-11df-82a0-00248c9b4be7.html

Risk factor : High";

 script_description(desc);

 script_summary("FreeBSD Ports: ircd-ratbox");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com");
 script_family("FreeBSD Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"ircd-ratbox");
if(!isnull(bver) && revcomp(a:bver, b:"2.2.9")<0) {
    security_note(0, data:"Package ircd-ratbox version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"ircd-ratbox-devel");
if(!isnull(bver) && revcomp(a:bver, b:"3.0.6")<0) {
    security_note(0, data:"Package ircd-ratbox-devel version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
