###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_adobe_acrobat_unspecified_vuln.nasl 5388 2009-10-21 14:02:58Z oct $
#
# Adobe Acrobat Unspecified vulnerability
#
# Authors:
# Nikta MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800959);
  script_version("$Revision: 1.0$");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-3461");
  script_bugtraq_id(36638);
  script_name("Adobe Acrobat Unspecified vulnerability");
  desc = "
  Overview : This host has Adobe Acrobat installed which is prone to unspecified
  vulnerability.

  Vulnerability Insight:
  An unspecified error in Adobe Acrobat can be exploited to bypass intended
  file-extension restrictions via unknown vectors.

  Impact:
  Successful exploitation allows remote attackers to execute arbitrary code
  on the affected system via malicious files.

  Impact Level: Application/System

  Affected Software/OS:
  Adobe Acrobat version 9.x before 9.2 on Windows.

  Fix:
  Upgrade to Adobe Acrobat version 9.2
  For Updates Refer, http://www.adobe.com/downloads/

  References:
  http://www.cve.mitre.org/cgi-bin/cvename.cgi?name=2009-3461
  http://www.adobe.com/support/security/bulletins/apsb09-15.html

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Adobe Acrobat");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("secpod_adobe_prdts_detect_win.nasl");
  script_require_keys("Adobe/Acrobat/Win/Ver");
  exit(0);
}


include("version_func.inc");

# Check for Adobe Reader version 9.x prior to 9.2
acrobatVer = get_kb_item("Adobe/Acrobat/Win/Ver");
if(acrobatVer)
{
  if(version_in_range(version:acrobatVer, test_version:"9.0", test_version2:"9.1.3")){
    security_hole(0);
  }
}
