###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_foxit_reader_detect.nasl 889 2009-03-11 16:22:01Z mar $
#
# Foxit Reader Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800536);
  script_version("Revision: 1.0 ");
  script_tag(name:"risk_factor", value:"None");
  script_name("Foxit Reader Version Detection");
  desc = "
  Overview: This script finds the Foxit Reader version and saves
  the result in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Set the Version of Foxit Reader in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright(C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

foxitVer = registry_get_sz(key:"SOFTWARE\Foxit Software\Foxit Reader",
                           item:"Version");
if(foxitVer == NULL)
{
  foxitPath = registry_get_sz(key:"SOFTWARE\Foxit Software\Foxit Reader",
                              item:"InstallLocation");
  if(foxitPath == NULL){
    exit(0);
  }

  foxitPath = foxitPath + "Foxit Reader.exe";
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:foxitPath);
  file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:foxitPath);
  foxitVer = GetVer(share:share, file:file);
  if(foxitVer == NULL){
    exit(0);
  }
}
set_kb_item(name:"Foxit/Reader/Ver", value:foxitVer);
security_note(data:"Foxit Reader version " + foxitVer + " was detected on the host"); 
