###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for dbus vulnerability USN-401-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840115);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"1.7");
  script_tag(name:"risk_factor", value:"Low");
  script_xref(name: "USN", value: "401-1");
  script_cve_id("CVE-2006-6107");
  script_name( "Ubuntu Update for dbus vulnerability USN-401-1");
  desc = "

  Vulnerability Insight:

  Kimmo H&#228;m&#228;l&#228;inen discovered that local users could delete other users'
  D-Bus match rules.  Applications would stop receiving D-Bus messages,
  resulting in a local denial of service, and potential data loss for
  applications that depended on D-Bus for storing information.

  Affected Software/OS:
  dbus vulnerability on Ubuntu 5.10 ,
  Ubuntu 6.06 LTS ,
  Ubuntu 6.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-January/000459.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of dbus vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"dbus-1-utils", ver:"0.60-6ubuntu8.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dbus", ver:"0.60-6ubuntu8.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdbus-1-2", ver:"0.60-6ubuntu8.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdbus-1-dev", ver:"0.60-6ubuntu8.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdbus-glib-1-2", ver:"0.60-6ubuntu8.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdbus-glib-1-dev", ver:"0.60-6ubuntu8.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdbus-qt-1-1c2", ver:"0.60-6ubuntu8.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdbus-qt-1-dev", ver:"0.60-6ubuntu8.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.4-dbus", ver:"0.60-6ubuntu8.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dbus-1-doc", ver:"0.60-6ubuntu8.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdbus-1-cil", ver:"0.60-6ubuntu8.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"monodoc-dbus-1-manual", ver:"0.60-6ubuntu8.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"dbus-1-utils", ver:"0.93-0ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dbus", ver:"0.93-0ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdbus-1-3", ver:"0.93-0ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdbus-1-dev", ver:"0.93-0ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dbus-1-doc", ver:"0.93-0ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU5.10")
{

  if(isdpkgvuln(pkg:"dbus-1-utils", ver:"0.36.2-0ubuntu7.1", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dbus", ver:"0.36.2-0ubuntu7.1", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdbus-1-1", ver:"0.36.2-0ubuntu7.1", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdbus-1-cil", ver:"0.36.2-0ubuntu7.1", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdbus-1-dev", ver:"0.36.2-0ubuntu7.1", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdbus-glib-1-1", ver:"0.36.2-0ubuntu7.1", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdbus-glib-1-dev", ver:"0.36.2-0ubuntu7.1", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdbus-qt-1-1c2", ver:"0.36.2-0ubuntu7.1", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdbus-qt-1-dev", ver:"0.36.2-0ubuntu7.1", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.4-dbus", ver:"0.36.2-0ubuntu7.1", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dbus-1-doc", ver:"0.36.2-0ubuntu7.1", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}