###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for openvpn regression USN-612-10
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840341);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "USN", value: "612-10");
  script_name( "Ubuntu Update for openvpn regression USN-612-10");
  desc = "

  Vulnerability Insight:

  USN-612-3 addressed a weakness in OpenSSL certificate and key
  generation in OpenVPN by adding checks for vulnerable certificates
  and keys to OpenVPN. A regression was introduced in OpenVPN when
  using TLS with password protected certificates which caused OpenVPN
  to not start when used with applications such as NetworkManager.
  
  Original advisory details:
  A weakness has been discovered in the random number generator used
  by OpenSSL on Debian and Ubuntu systems. As a result of this
  weakness, certain encryption keys are much more common than they
  should be, such that an attacker could guess the key through a
  brute-force attack given minimal knowledge of the system. This
  particularly affects the use of encryption keys in OpenSSH, OpenVPN
  and SSL certificates.

  Affected Software/OS:
  openvpn regression on Ubuntu 7.04 ,
  Ubuntu 7.10 ,
  Ubuntu 8.04 LTS

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-June/000717.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of openvpn regression");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"openvpn", ver:"2.0.9-5ubuntu0.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"openvpn", ver:"2.1~rc7-1ubuntu3.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"openvpn", ver:"2.0.9-8ubuntu0.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}