##################################################################################
#  Written by K-Otik.com <ReYn0@k-otik.com>
#
#  Mambo Site Server 4.0.10 XSS attack
#
# Updated: 04/07/2009
# Antu Sanadi <santu@secpod.com>
#
#  Message-ID: <1642444765.20030319015935@olympos.org>
#  From: Ertan Kurt <ertank@olympos.org>
#  To: <bugtraq@securityfocus.com>
#  Subject: Some XSS vulns </archive/1/315554/2003-03-19/2003-03-25/1>
##################################################################################
if(description)
{
  script_id(11441);
  script_cve_id("CVE-2003-1203");
  script_bugtraq_id(7135);
  script_version ("$Revision: 7517 $");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_name("Mambo Site Server 4.0.10 XSS");
  desc = "
  An attacker may use the installed version of Mambo Site Server to
  perform a cross site scripting attack on this host.
  Solution: Upgrade to a newer version.

  Risk factor : Medium";

  script_description(desc);
  script_summary("Determine if Mambo Site Server is vulnerable to xss attack");
  script_category(ACT_GATHER_INFO);
  script_family("Web application abuses");
  script_copyright("This script is Copyright (C) 2003 k-otik.com");
  script_dependencie("mambo_detect.nasl", "cross_site_scripting.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}



include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port)){
  exit(0);
}

version=get_kb_item(string("www/", port, "/mambo_mos"));
if(!version){
   exit(0);
}

matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$");
if(!imatches){
  exit(0);
}

dir = matches[2];
url = string(dir, "/index.php?option=search&searchword=<script>alert(document.cookie);</script>");
req = http_get(item:url, port:port);
resp = http_keepalive_send_recv(port:port, data:req, bodyonly:1);
if(!resp){
  exit(0);
}

if( "<script>alert(document.cookie);</script>" >< resp)
  security_warning(port);

