###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_torrentvolve_detect.nasl 3007 2009-06-25 10:35:24Z jun $
#
# TorrentVolve Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900576);
  script_version("Revision: 1.0 ");
  script_tag(name:"risk_factor", value:"None");
  script_name("TorrentVolve Version Detection");
  desc = "
  Overview: This script detects the installed version of TorrentVolve and
  sets the version in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Sets the KB for the version of TorrentVolve");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

tvPort = get_http_port(default:80);
if(!tvPort){
  tvPort = 80;
}
if(!get_port_state(tvPort)){
  exit(0);
}

foreach dir (make_list("/torrentvolve", "/", "/volve", "/torrent", cgi_dirs()))
{
  sndReq = http_get(item:string(dir, "/site/login.php"), port:tvPort);
  rcvRes = http_send_recv(port:tvPort, data:sndReq);
  if(egrep(pattern:"<title>TorrentVolve", string:rcvRes))
  {
    sndReq = http_get(item:string(dir, "/VERSION"), port:tvPort);
    rcvRes = http_send_recv(port:tvPort, data:sndReq);
    if(rcvRes != NULL)
    {
      ver = egrep(pattern:"^((Beta\ )?([0-9.]+\.[0-9]+))", string:rcvRes);
      tvVer = eregmatch(pattern:"([0-9.]+\.[0-9])", string:ver);
      if(tvVer[1] != NULL)
      {
        set_kb_item(name:"www/"+ tvPort + "/TorrentVolve",
                    value:tvVer[1] + " under " + dir);
        security_note(data:"TorrentVolve version " + tvVer[1] + " running at "+
                           "location " + dir +  " was detected on the host");
      }
    }
  }
}
