///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __FREEZE_SELECTION_MODIFIER_H
#define __FREEZE_SELECTION_MODIFIER_H

#include <core/Core.h>

#include <atomviz/AtomViz.h>
#include "../AtomsObjectModifierBase.h"

namespace AtomViz {

/******************************************************************************
* Preserves an atom selection over time.
******************************************************************************/
class ATOMVIZ_DLLEXPORT FreezeSelectionModifier : public AtomsObjectModifierBase
{
public:

	/// Default constructor.
	FreezeSelectionModifier(bool isLoading = false) : AtomsObjectModifierBase(isLoading) {
		INIT_PROPERTY_FIELD(FreezeSelectionModifier, _selectionChannel);
	}

	/// Asks the modifier for its validity interval at the given time.
	virtual TimeInterval modifierValidity(TimeTicks time) { return TimeForever; }

protected:

	/// Modifies the atoms object. The time interval passed
	/// to the function is reduced to the interval where the modified object is valid/constant.
	virtual EvaluationStatus modifyAtomsObject(TimeTicks time, TimeInterval& validityInterval);

private:

	/// This stores the saved selection channel.
	ReferenceField<DataChannel> _selectionChannel;

	Q_OBJECT
	DECLARE_SERIALIZABLE_PLUGIN_CLASS(FreezeSelectionModifier)
	DECLARE_REFERENCE_FIELD(_selectionChannel)
};


/******************************************************************************
* A properties editor for the FreezeSelectionModifier class.
******************************************************************************/
class ATOMVIZ_DLLEXPORT FreezeSelectionModifierEditor : public AtomsObjectModifierEditorBase
{
protected:

	/// Creates the user interface controls for the editor.
	virtual void createUI(const RolloutInsertionParameters& rolloutParams);

protected Q_SLOTS:

	/// Is called when the user presses the Acquire Selection button.
	void onAcquireSelection();

private:

	Q_OBJECT
	DECLARE_PLUGIN_CLASS(FreezeSelectionModifierEditor)
};

};	// End of namespace AtomViz

#endif // __FREEZE_SELECTION_MODIFIER_H
