///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#include <scripting/Scripting.h>

#include <core/data/DataSetManager.h>
#include <core/data/DataSet.h>
#include <core/data/importexport/ImporterExporter.h>
#include <core/scene/SelectionSet.h>
#include <core/scene/SceneRoot.h>
#include <core/scene/SelectionSet.h>
#include <core/rendering/RenderSettings.h>

namespace Scripting {

using namespace boost::python;

void ExportData()
{
	class_<DataSet, bases<RefTarget>, intrusive_ptr<DataSet>, noncopyable>("DataSet")
		.add_property("HasBeenChanged", &DataSet::hasBeenChanged, &DataSet::setDirty)
		.add_property("FilePath", make_function(&DataSet::filePath, return_value_policy<copy_const_reference>()), &DataSet::setFilePath)
		.add_property("SceneRoot", make_function(&DataSet::sceneRoot, return_internal_reference<>()))
		.add_property("Selection", make_function(&DataSet::selection, return_internal_reference<>()))
		.add_property("RenderSettings", make_function(&DataSet::renderSettings, return_internal_reference<>()))
	;

	class_<DataSetManager, noncopyable>("DataSetManager", no_init)
		.add_static_property("Instance", make_function(&DataSetManager::getSingletonInstance, return_value_policy<reference_existing_object>()))
		.def("FileReset", &DataSetManager::fileReset)
		.def("FileSave", &DataSetManager::fileSave)
		.def("FileSaveAs", &DataSetManager::fileSaveAs)
		.def("FileLoad", &DataSetManager::fileLoad)
		.def("AskForSaveChanges", &DataSetManager::askForSaveChanges)
		.add_property("CurrentSet", make_function(&DataSetManager::currentSet, return_internal_reference<>()), &DataSetManager::setCurrentSet)
	;

	class_<ImporterExporter, bases<RefTarget>, intrusive_ptr<ImporterExporter>, noncopyable>("ImporterExporter", no_init)
		.def("ImportFile", pure_virtual(&ImporterExporter::importFile))
		.def("ExportToFile", pure_virtual(&ImporterExporter::exportToFile))
	;
}

};
