% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{saveObject}
\alias{saveObject}
\alias{stageObject}
\alias{stageObject,ANY-method}
\alias{searchForMethods}
\alias{.searchForMethods}
\title{Save objects to disk}
\usage{
saveObject(x, path, ...)
}
\arguments{
\item{x}{A Bioconductor object of the specified class.}

\item{path}{String containing the path to a directory in which to save \code{x}.}

\item{...}{Additional named arguments to pass to specific methods.}
}
\value{
\code{dir} is created and populated with files containing the contents of \code{x}.
\code{NULL} should be invisibly returned.
}
\description{
Generic to save assorted R objects into appropriate on-disk representations.
More methods may be defined by other packages to extend the \pkg{alabaster.base} framework to new classes.
}
\section{Comments for extension developers}{

Methods for the \code{saveObject} generic should create a directory at \code{path} in which the contents of \code{x} are to be saved.
The files may consist of any format, though language-agnostic formats like HDF5, CSV, JSON are preferred.
For more complex objects, multiple files and subdirectories may be created within \code{path}. 
The only strict requirements are:
\itemize{
\item There must be an \code{OBJECT} file inside \code{path}, 
containing a JSON object with a \code{"type"} string property that specifies the class of the object, e.g., \code{"data_frame"}, \code{"summarized_experiment"}.
This will be used by loading functions to determine how to load the files into memory.
\item The names of files and subdirectories should not start with \code{_} or \code{.}.
These are reserved for applications, e.g., to build manifests or to store additional metadata.
}

Callers can pass optional parameters to specific \code{saveObject} methods via \code{...}.
Any options recognized by a method should be prefixed by the name of the class used in the method's signature,
e.g., any options for \code{\link{saveObject,DataFrame-method}} should start with \code{DataFrame.}.
This scoping avoids conflicts between otherwise identically-named options of different methods.

When developing \code{saveObject} methods of complex objects, a simple approach is to decompose \code{x} into its \dQuote{child} components.
Each component can then be saved into a subdirectory of \code{path}, levering the existing \code{saveObject} methods for the component classes.
In such cases, extension developers should actually call \code{\link{altSaveObject}} on each child component, rather than calling \link{saveObject} directly.
This ensures that any application-level overrides of the loading functions are respected. 
It is expected that each method will forward \code{...} (possibly after modification) to any internal \code{\link{altSaveObject}} calls.
}

\section{Comments for application developers}{

Application developers can override \code{saveObject} by specifying a custom function in \code{\link{altSaveObject}}.
This can be used to point to a different function to handle the saving process for each class.
The custom function can be as simple as a wrapper around \code{saveObject} with some additional actions (e.g., to save more metadata),
or may be as complex as a full-fledged generic with its own methods for class-specific customizations.
}

\examples{
library(S4Vectors)
X <- DataFrame(X=LETTERS, Y=sample(3, 26, replace=TRUE))

tmp <- tempfile()
saveObject(X, tmp)
list.files(tmp, recursive=TRUE)

}
\author{
Aaron Lun
}
