% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci.R
\name{ci}
\alias{ci}
\alias{ci.numeric}
\alias{ci.data.frame}
\alias{ci.sim.merMod}
\alias{ci.sim}
\alias{ci.stanreg}
\alias{ci.brmsfit}
\alias{ci.BFBayesFactor}
\alias{ci.MCMCglmm}
\title{Confidence/Credible/Compatibility Interval (CI)}
\usage{
ci(x, ...)

\method{ci}{numeric}(x, ci = 0.95, method = "ETI", verbose = TRUE, BF = 1, ...)

\method{ci}{data.frame}(x, ci = 0.95, method = "ETI", verbose = TRUE, BF = 1, ...)

\method{ci}{sim.merMod}(
  x,
  ci = 0.95,
  method = "ETI",
  effects = c("fixed", "random", "all"),
  parameters = NULL,
  verbose = TRUE,
  ...
)

\method{ci}{sim}(x, ci = 0.95, method = "ETI", parameters = NULL, verbose = TRUE, ...)

\method{ci}{stanreg}(
  x,
  ci = 0.95,
  method = "ETI",
  effects = c("fixed", "random", "all"),
  component = c("location", "all", "conditional", "smooth_terms", "sigma",
    "distributional", "auxiliary"),
  parameters = NULL,
  verbose = TRUE,
  BF = 1,
  ...
)

\method{ci}{brmsfit}(
  x,
  ci = 0.95,
  method = "ETI",
  effects = c("fixed", "random", "all"),
  component = c("conditional", "zi", "zero_inflated", "all"),
  parameters = NULL,
  verbose = TRUE,
  BF = 1,
  ...
)

\method{ci}{BFBayesFactor}(x, ci = 0.95, method = "ETI", verbose = TRUE, BF = 1, ...)

\method{ci}{MCMCglmm}(x, ci = 0.95, method = "ETI", verbose = TRUE, ...)
}
\arguments{
\item{x}{A \code{stanreg} or \code{brmsfit} model, or a vector representing a posterior distribution.}

\item{...}{Currently not used.}

\item{ci}{Value or vector of probability of the CI (between 0 and 1)
to be estimated. Default to \code{.95} (\verb{95\%}).}

\item{method}{Can be \link[=eti]{'ETI'} (default), \link[=hdi]{'HDI'}, \link[=bci]{'BCI'}, \link[=spi]{'SPI'} or \link[=si]{'SI'}.}

\item{verbose}{Toggle off warnings.}

\item{BF}{The amount of support required to be included in the support interval.}

\item{effects}{Should results for fixed effects, random effects or both be
returned? Only applies to mixed models. May be abbreviated.}

\item{parameters}{Regular expression pattern that describes the parameters
that should be returned. Meta-parameters (like \code{lp__} or \code{prior_}) are
filtered by default, so only parameters that typically appear in the
\code{summary()} are returned. Use \code{parameters} to select specific parameters
for the output.}

\item{component}{Should results for all parameters, parameters for the
conditional model or the zero-inflated part of the model be returned? May
be abbreviated. Only applies to \pkg{brms}-models.}
}
\value{
A data frame with following columns:
\itemize{
\item \code{Parameter} The model parameter(s), if \code{x} is a model-object. If \code{x} is a vector, this column is missing.
\item \code{CI} The probability of the credible interval.
\item \code{CI_low}, \code{CI_high} The lower and upper credible interval limits for the parameters.
}
}
\description{
Compute Confidence/Credible/Compatibility Intervals (CI) or Support Intervals
(SI) for Bayesian and frequentist models. The Documentation is accessible
for:
}
\details{
\itemize{
\item \href{https://easystats.github.io/bayestestR/articles/credible_interval.html}{Bayesian models}
\item \href{https://easystats.github.io/parameters/reference/ci.default.html}{Frequentist models}
}
}
\note{
When it comes to interpretation, we recommend thinking of the CI in terms of
an "uncertainty" or "compatibility" interval, the latter being defined as
\dQuote{Given any value in the interval and the background assumptions,
the data should not seem very surprising} (\cite{Gelman & Greenland 2019}).
\cr \cr
There is also a \href{https://easystats.github.io/see/articles/bayestestR.html}{\code{plot()}-method} implemented in the \href{https://easystats.github.io/see/}{\pkg{see}-package}.
}
\examples{
\dontshow{if (require("rstanarm", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(bayestestR)

posterior <- rnorm(1000)
ci(posterior, method = "ETI")
ci(posterior, method = "HDI")

df <- data.frame(replicate(4, rnorm(100)))
ci(df, method = "ETI", ci = c(0.80, 0.89, 0.95))
ci(df, method = "HDI", ci = c(0.80, 0.89, 0.95))

model <- suppressWarnings(
  stan_glm(mpg ~ wt, data = mtcars, chains = 2, iter = 200, refresh = 0)
)
ci(model, method = "ETI", ci = c(0.80, 0.89))
ci(model, method = "HDI", ci = c(0.80, 0.89))
\dontshow{\}) # examplesIf}
\dontshow{if (require("BayesFactor", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bf <- ttestBF(x = rnorm(100, 1, 1))
ci(bf, method = "ETI")
ci(bf, method = "HDI")
\dontshow{\}) # examplesIf}
\dontshow{if (require("emmeans", quietly = TRUE) && require("rstanarm", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
model <- emtrends(model, ~1, "wt")
ci(model, method = "ETI")
ci(model, method = "HDI")
\dontshow{\}) # examplesIf}
}
\references{
Gelman A, Greenland S. Are confidence intervals better termed "uncertainty intervals"? BMJ 2019;l5381. 10.1136/bmj.l5381
}
\seealso{
Other ci: 
\code{\link{bci}()},
\code{\link{cwi}()},
\code{\link{eti}()},
\code{\link{hdi}()},
\code{\link{si}()},
\code{\link{spi}()}
}
\concept{ci}
