% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_GUESS.R
\name{predict_GUESS}
\alias{predict_GUESS}
\title{predict_GUESS}
\usage{
predict_GUESS(build_guess_object, new, density_evaluation = 2,
  return_class_density = FALSE)
}
\arguments{
\item{build_guess_object}{output from the \code{\link{build_GUESS}} method}

\item{new}{vector of uncalibrated probabilities}

\item{density_evaluation}{which density evaluation method should be used to infer calculate probabilities, Default: 2}

\item{return_class_density}{if set to TRUE, class densities p(x|class) are returned, Default: FALSE}
}
\value{
a list object containing the following components:
\item{predictions}{contains a vector of calibrated predictions}
\item{pred_idx}{which density evaluation method was used}
\item{significance_test_set}{the percentage of \code{new} instances that was evaluated using significant prediction estimates}
\item{dens_case}{a vector containing the p(x|case) values}
\item{dens_control}{a vector containing the p(x|control) values}
}
\description{
returns calibrated predictions for the instances \code{new} using the trained GUESS calibration model \code{build_guess_object}.
Two different evaluation methods are available.
Method 1: returns the p-value for the score \code{new} under the distribution that is handed over in the \code{build_guess_object}
Method 2: returns the probability density value for the score \code{new} under the distribution that is handed over in the \code{build_guess_object}
}
\details{
\code{dens_case} and \code{dens_control} are only returned when \code{return_class_density} is set to TRUE
}
